<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Slidereleventhkaveh extends Widget_Base{

  public function get_name(){
    return 'slidereleventhkaveh';
  }

  public function get_title(){
    return esc_html__( 'اسلایدر سبک یازده', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  } 

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    $this->start_controls_section(
        'contentslidereleventhkaveh',
        [
          'label' => esc_html__( 'اسلایدر', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      ); 
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'titleslidereleventhkaveh',
        [
            'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'فروش انواع', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'tagheading1slidereleventhkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H6',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'title2slidereleventhkaveh',
      [
          'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'صنایع دستی فلزی', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'tagheading2slidereleventhkaveh',
    [
      'label' => esc_html__( 'تگ عنوان اصلی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'H3',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
        'span' => esc_html__( 'span', 'kaveh-core' ),
      ],
    ]
  );
      $repeater->add_control(
        'buttonslidereleventhkaveh',
        [
            'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'محصولات', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'iconbuttslidereleventhkaveh',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'isax isax-arrow-left4',
        ],
      ]
    );
    $repeater->add_control(
      'linkbuttonslidereleventhkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'backslidereleventhkaveh',
    [
      'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
    ]
  );
      
      $this->add_control(
        'slidesslidereleventhkaveh',
        [
          'label' => esc_html__( 'اسلاید ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::REPEATER,
          'default' => [
            [
              'titleslidereleventhkaveh' => esc_html__( 'فروش انواع', 'kaveh-core' ),
              'title2slidereleventhkaveh' => esc_html__( 'صنایع دستی فلزی', 'kaveh-core' ),
              'buttonslidereleventhkaveh' => esc_html__( 'محصولات', 'kaveh-core' ),
              'linkbuttonslidereleventhkaveh' => esc_html__( '#', 'kaveh-core' ),
            ],
          ],
          'fields' => $repeater->get_controls()
          ],
      );
      $this->add_control(
        'backjslidereleventhkaveh',
        [
          'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,     
          'selectors' => [
            '{{WRAPPER}} .carousel-dress-wrapper' => 'background: url({{URL}}) center center no-repeat',
        ],       
        ]
      );
      $this->add_control(
        'showarrowslidereleventhkaveh',
        [
          'label' => esc_html__( 'نمایش نقطه ها؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
        );
       $this->end_controls_section();
             $this->start_controls_section(
               'style2_slidereleventhkaveh',
               [
                 'label' => esc_html__( 'استایل اسلاید ها', 'kaveh-core' ),
                 'tab' => \Elementor\Controls_Manager::TAB_STYLE, 
               ]
              );
              $this->add_control(
                'titlestnvrslidereleventhkaveh',
                [
                  'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
                  'type' => \Elementor\Controls_Manager::COLOR,
                  'selectors' => [
                    '{{WRAPPER}} .carousel-dress-item .detail .sup-title' => 'color: {{VALUE}} !important;',
                  ],
                ]
               );
               $this->add_group_control(
                \Elementor\Group_Control_Typography::get_type(),
                [
                  'name' => 'title_nvrslidereleventhkaveh',
                  'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
                  'selector' => '{{WRAPPER}} .carousel-dress-item .detail .sup-title .fesli',
                ]
               );
               $this->add_control(
                'titlepstnvrslidereleventhkaveh',
                [
                  'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
                  'type' => \Elementor\Controls_Manager::COLOR,
                  'selectors' => [
                    '{{WRAPPER}} .carousel-dress-item .detail .title' => 'color: {{VALUE}} !important',
                  ],
                ]
               );
               $this->add_group_control(
                \Elementor\Group_Control_Typography::get_type(),
                [
                  'name' => 'p_nvrslidereleventhkaveh',
                  'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
                  'selector' => '{{WRAPPER}} .carousel-dress-item .detail .title .aesli',
                ]
               );
              $this->add_group_control(
               \Elementor\Group_Control_Typography::get_type(),
               [
                 'name' => 'button_slidereleventhkaveh',
                 'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
                 'selector' => '{{WRAPPER}} .carousel-dress-item .detail .btn',
               ]
             );
             $this->add_control(
               'iconsizeslidereleventhkaveh',
               [
                 'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::SLIDER,
                 'size_units' => [ 'px' ],
                 'range' => [
                   'px' => [
                     'min' => 0,
                     'max' => 200,
                     'step' => 1,
                   ],
                 ],
                 'selectors' => [
                   '{{WRAPPER}} .carousel-dress-item .detail .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
                 ],
               ]
             );
             $this->add_group_control(
               \Elementor\Group_Control_Text_Shadow::get_type(),
               [
                 'name' => 'text_shadowslidereleventhkaveh',
                 'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
                 'selector' => '{{WRAPPER}} .carousel-dress-item .detail .btn',
               ]
             );
             $this->start_controls_tabs(
               'style_tabsslidereleventhkaveh'
             );
             
             $this->start_controls_tab(
               'style_normal_tabslidereleventhkaveh',
               [
                 'label' => esc_html__( 'عادی', 'kaveh-core' ),
               ]
             );
             $this->add_control(
               'textbuttoncolorslidereleventhkaveh',
               [
                 'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
                   '{{WRAPPER}} .carousel-dress-item .detail .btn' => 'color: {{VALUE}}',
                 ],
               ]
             ); 
             $this->add_control(
               'iconcolorslidereleventhkaveh',
               [
                 'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
                   '{{WRAPPER}} .carousel-dress-item .detail .btn i' => 'color: {{VALUE}}',
                 ],
               ]
             ); 
             $this->add_control(
               'buttoncolorslidereleventhkaveh',
               [
                 'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
                   '{{WRAPPER}} .carousel-dress-item .detail .btn' => 'background-color: {{VALUE}}',
                 ],
               ]
             ); 
             $this->add_control(
               'buttonradiusslidereleventhkaveh',
               [
                 'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::DIMENSIONS,
                 'size_units' => [ 'px' ],
                 'selectors' => [
                   '{{WRAPPER}} .carousel-dress-item .detail .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                 ],
               ]
             );
             $this->add_group_control(
               \Elementor\Group_Control_Border::get_type(),
               [
                 'name' => 'borderslidereleventhkaveh',
                 'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
                 'selector' => '{{WRAPPER}} .carousel-dress-item .detail .btn',
               ]
             );
             $this->add_control(
               'buttonbordersslidereleventhkaveh',
               [
                 'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::DIMENSIONS,
                 'size_units' => [ 'px' ],
                 'condition' => [
                   'borderslidereleventhkaveh!' => '',
                 ],
                 'selectors' => [
                   '{{WRAPPER}} .carousel-dress-item .detail .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                 ],
               ]
             );
             $this->end_controls_tab();
             $this->start_controls_tab(
               'style_hove_tabslidereleventhkaveh',
               [
                 'label' => esc_html__( 'هاور', 'kaveh-core' ),
               ]
             );
             $this->add_control(
               'textbuttoncolorhoverslidereleventhkaveh',
               [
                 'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
                   '{{WRAPPER}} .carousel-dress-item .detail .btn:hover' => 'color: {{VALUE}}',
                 ],
               ]
             ); 
             $this->add_control(
               'iconcolorhoverslidereleventhkaveh',
               [
                 'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
                   '{{WRAPPER}} .carousel-dress-item .detail .btn:hover i' => 'color: {{VALUE}}',
                 ],
               ]
             ); 
             $this->add_control(
               'buttoncolorhoverslidereleventhkaveh',
               [
                 'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
                   '{{WRAPPER}} .carousel-dress-item .detail .btn:hover' => 'background-color: {{VALUE}}',
                 ],
               ]
             ); 
             $this->add_control(
               'buttonradiushoverslidereleventhkaveh',
               [
                 'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::DIMENSIONS,
                 'size_units' => [ 'px' ],
                 'selectors' => [
                   '{{WRAPPER}} .carousel-dress-item .detail .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                 ],
               ]
             );
             $this->add_group_control(
               \Elementor\Group_Control_Border::get_type(),
               [
                 'name' => 'borderhoverslidereleventhkaveh',
                 'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
                 'selector' => '{{WRAPPER}} .carousel-dress-item .detail .btn:hover',
               ]
             );
             $this->add_control(
               'buttonbordershoverslidereleventhkaveh',
               [
                 'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::DIMENSIONS,
                 'size_units' => [ 'px' ],
                 'condition' => [
                   'borderhoverslidereleventhkaveh!' => '',
                 ],
                 'selectors' => [
                   '{{WRAPPER}} .carousel-dress-item .detail .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                 ],
               ]
             );
             $this->end_controls_tab();
             $this->end_controls_tabs();
             $this->add_control(
               'hr1slidereleventhkaveh',
               [
                 'type' => \Elementor\Controls_Manager::DIVIDER,
               ]
             );
             $this->add_group_control(
               \Elementor\Group_Control_Box_Shadow::get_type(),
               [
                 'name' => 'box_shadowslidereleventhkavehh',
                 'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
                 'selector' => '{{WRAPPER}} .carousel-dress-item .detail .btn',
               ]
             );
             $this->add_control(
               'buttonpaddingslidereleventhkaveh',
               [
                 'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::DIMENSIONS,
                 'size_units' => [ 'px' ],
                 'selectors' => [
                   '{{WRAPPER}} .carousel-dress-item .detail .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                 ],
               ]
             );
              $this->end_controls_section();
             
             
             
              $this->start_controls_section(
               'style3_slidereleventhkaveh',
               [
                 'label' => esc_html__( 'استایل تصویر', 'kaveh-core' ),
                 'tab' => \Elementor\Controls_Manager::TAB_STYLE, 
               ]
              );
             $this->add_control(
               'widthmainslidereleventhkaveh',
               [
                 'label' => esc_html__( 'عرض تصویر اسلایدر', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::SLIDER,
                 'size_units' => [ 'px' ],
                 'range' => [
                   'px' => [
                     'min' => 0,
                     'max' => 2000,
                     'step' => 5,
                   ],
                 ],
                 'selectors' => [
                   '{{WRAPPER}} .carousel-dress-item .image img' => 'width: {{SIZE}}{{UNIT}};',
                 ],
               ]
             );
             $this->add_control(
              'heightmainslidereleventhkaveh',
              [
                'label' => esc_html__( 'ارتفاع تصویر اسلایدر', 'kaveh-core' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                  'px' => [
                    'min' => 0,
                    'max' => 2000,
                    'step' => 5,
                  ],
                ],
                'selectors' => [
                  '{{WRAPPER}} .carousel-dress-item .image img' => 'height: {{SIZE}}{{UNIT}};',
                ],
              ]
            );
              $this->end_controls_section();
              $this->start_controls_section(
               'style4_slidereleventhkaveh',
               [
                 'label' => esc_html__( 'استایل عمومی', 'kaveh-core' ),
                 'tab' => \Elementor\Controls_Manager::TAB_STYLE,
               ]
              );
              $this->add_control(
                'bgcolorslidereleventhkaveh',
                [
                  'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
                  'type' => \Elementor\Controls_Manager::COLOR,
                  'selectors' => [
                    '{{WRAPPER}} .carousel-dress-wrapper' => 'background-color: {{VALUE}} !important;',
        
                  ],
                ]
              );
             $this->add_control(
               'heightmainslidereleventhkaveh',
               [
                 'label' => esc_html__( 'ارتفاع اسلایدر', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::SLIDER,
                 'size_units' => [ 'px' ],
                 'range' => [
                   'px' => [
                     'min' => 0,
                     'max' => 2000,
                     'step' => 1,
                   ],
                 ],
                 'selectors' => [
                   '{{WRAPPER}} .carousel-dress-wrapper' => 'max-height: {{SIZE}}{{UNIT}};',
                 ],
               ]
             );
             $this->add_control(
              'boxsliderradiushoverslidereleventhkaveh',
              [
                'label' => esc_html__( 'گوشه خمیده اسلایدر', 'kaveh-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                  '{{WRAPPER}} .carousel-dress-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
              ]
            );
            $this->add_control(
              'bgcolordotslidereleventhkaveh',
              [
                'label' => esc_html__( 'رنگ پس زمینه نقطه ها', 'kaveh-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                  '{{WRAPPER}} .carousel-dress .swiper-pagination::before' => 'background-color: {{VALUE}} !important;',
      
                ],
              ]
            );
            $this->add_group_control(
              \Elementor\Group_Control_Border::get_type(),
              [
                'name' => 'borderdotslidereleventhkaveh',
                'label' => esc_html__( 'حاشیه نقطه ها', 'kaveh-core' ),
                'selector' => '{{WRAPPER}} .carousel-dress .swiper-pagination::before',
              ]
            );
            $this->add_control(
              'buttonbordersdotrslidereleventhkaveh',
              [
                'label' => esc_html__( 'عرض حاشیه نقطه ها', 'kaveh-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'condition' => [
                  'borderdotslidereleventhkaveh!' => '',
                ],
                'selectors' => [
                  '{{WRAPPER}} .carousel-dress .swiper-pagination::before' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
              ]
            );
            $this->add_control(
              'bgcolorddotslidereleventhkaveh',
              [
                'label' => esc_html__( 'رنگ نقطه ها', 'kaveh-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                  '{{WRAPPER}} .carousel-dress .swiper-pagination-bullet' => 'background-color: {{VALUE}} !important;',
      
                ],
              ]
            );
              $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="carousel-dress">
      <div class="container">
        <div class="carousel-dress-wrapper w-100 mx-sm-auto">
          <!-- Start Carousel -->
          <div class="swiper swiper-dress position-relative" data-swiper='{"slidesPerView":1,"spaceBetween":0,"autoplay":{"delay":5000},"effect":"fade","fadeEffect":{"crossFade":true},"loop":true,"pagination":{"el":".swiper-pagination","type":"bullets","clickable":true}}'>
            <div class="swiper-wrapper">
               <?php
                if ( $settings['slidesslidereleventhkaveh'] ) {
                foreach (  $settings['slidesslidereleventhkaveh'] as $item ) {
                ?>
              <!-- Start Slide -->
              <div class="swiper-slide">
                <div class="carousel-dress-item d-flex align-items-md-center flex-column flex-md-row">
                  <div class="image position-relative">
                    <img src="<?php echo esc_url($item['backslidereleventhkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['backslidereleventhkaveh'] )); ?>" width="255" height="322">
                  </div>
                  <div class="detail text-center text-md-start">
                    <div class="sup-title overflow-hidden text-white">
                      <<?php echo esc_html($item['tagheading1slidereleventhkaveh']); ?> class="d-block fesli"><?php echo esc_html($item['titleslidereleventhkaveh']); ?></<?php echo esc_html($item['tagheading1slidereleventhkaveh']); ?>>
                    </div>
                    <div class="title overflow-hidden text-white">
                      <<?php echo esc_html($item['tagheading2slidereleventhkaveh']); ?> class="title text-white aesli"><?php echo esc_html($item['title2slidereleventhkaveh']); ?></<?php echo esc_html($item['tagheading2slidereleventhkaveh']); ?>>
                    </div>
                    <a href="<?php echo esc_url($item['linkbuttonslidereleventhkaveh']); ?>" class="btn btn-light d-flex align-items-center">
                    <?php echo esc_html($item['buttonslidereleventhkaveh']); ?>
                      <i class="<?php echo esc_html($item['iconbuttslidereleventhkaveh']['value']); ?>"></i>
                    </a>
                  </div>
                </div>
              </div>
              <!-- End Slide -->
              <?php
                  }
                }
                ?>
            </div>
            <?php if("yes"===$settings['showarrowslidereleventhkaveh']){?>
            <div class="swiper-pagination rounded-pill position-relative start-0 end-0 mx-auto"></div>
            <?php } ?>
          </div>
          <!-- End Carousel -->
        </div>
      </div>
    </section>
    <?php do_action('kelementor_inline_scripts'); ?>           

    <?php  
  }


}
