<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Searchkaveh extends Widget_Base{

  public function get_name(){
    return 'searchkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان سرچ', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['headerfooterkavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentsearchkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'styleboxsearchkaveh',
        [
          'label' => esc_html__( 'طرح بندی المان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
            'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
            'four'  => esc_html__( 'طرح بندی چهار', 'kaveh-core' ),
            'five'  => esc_html__( 'طرح بندی پنج', 'kaveh-core' ),
            'six'  => esc_html__( 'طرح بندی شش', 'kaveh-core' ),
          ],
        ]
        );
      $this->add_control(
          'titlesearchkaveh',
          [
              'label' => esc_html__( 'متن نگهدارنده فرم', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'جستجوی محصول', 'kaveh-core' ),

      
          ]
      );
      $this->add_control(
        'iconsearchkaveh',
        [
          'label' => esc_html__( 'آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::ICONS,
          'skin' => 'inline',
          'exclude_inline_options' => [ 'svg' ],
          'default' => [
            'value' => 'isax isax-search-normal-1',
          ],
        ]
      );
       $this->end_controls_section();

       $this->start_controls_section(
        'styleupsearchkaveh',
        [
          'label' => esc_html__( 'استایل دکمه سرچ', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'iconsizesearchkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxsearchkaveh!' =>['five','six'],
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 18,
          ],
          'selectors' => [
            '{{WRAPPER}} .btsearch' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconsize2searchkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxsearchkaveh' =>'five',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 18,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-four-btn-search' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconsize3searchkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxsearchkaveh' =>'six',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 18,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eleven-search button' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'ticon1colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh!' => ['five','six'],
          ],
          'selectors' => [
            '{{WRAPPER}} .btsearch' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'ticon2colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' => 'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-four-btn-search' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'ticon4colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' => 'six',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eleven-search button' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        't2colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>['one','two','four'],
          ],
          'selectors' => [
            '{{WRAPPER}} .btsearch' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        't3colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-three-search, .btse3' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        't5colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-four-btn-search' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        't4colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-four-btn-search' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'button1iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'one',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .btsearch' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'button2iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'two',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-two-search .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'button3iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'three',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-three-search' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'button4iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'four',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-four-btn-search' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'button5iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'five',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            '{{WRAPPER}} .top-header-fourteen .top-header-four-btn-search' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      ); 
      $this->add_control(
        'width4iconsearchkaveh',
        [
          'label' => esc_html__( 'عرض', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'condition' => [
            'styleboxsearchkaveh' =>'four',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 50,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-four-btn-search' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'height4iconsearchkaveh',
        [
          'label' => esc_html__( 'ارتفاع', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'condition' => [
            'styleboxsearchkaveh' =>'four',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 50,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-four-btn-search' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'width5iconsearchkaveh',
        [
          'label' => esc_html__( 'عرض', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'condition' => [
            'styleboxsearchkaveh' =>'five',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 50,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a' => 'width: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .top-header-fourteen .top-header-four-btn-search' => 'width: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'height5iconsearchkaveh',
        [
          'label' => esc_html__( 'ارتفاع', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'condition' => [
            'styleboxsearchkaveh' =>'five',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 68,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a,' => 'height: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .top-header-fourteen .top-header-four-btn-search' => 'height: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2upsearchkaveh',
        [
          'label' => esc_html__( 'استایل نگهدارنده متن', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'backcolor1iconsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-search .form-control' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'backcolor21iconsearchkaveh',
        [
          'label' => esc_html__( 'رنگ اول پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'two',
          ],
        ]
      );
      $this->add_control(
        'backcolor22iconsearchkaveh',
        [
          'label' => esc_html__( 'رنگ دوم پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'two',
          ],
        ]
      );
      $this->add_control(
        'backcolor3iconsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-three-search .form-control' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'backcolor45iconsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>['four','five'],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-four-search form .form-control' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'backcolor6colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'six',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eleven-search' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'backcolor62colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه فیلد ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'six',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eleven-search .form-control' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradiu1iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده فیلد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'one',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-search .form-control' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'buttonradiu2iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده فیلد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'two',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-two-search .form-control' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'buttonradiu3iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده فیلد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'three',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-three-search .form-control' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'buttonradiu4iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده فیلد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>['four','five'],
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-four-search form .form-control' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'buttonradiu6iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'six',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 25,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eleven-search' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiu61iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده فیلد ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'six',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 25,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eleven-search .form-control' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'formwidth1iconsearchkaveh',
        [
          'label' => esc_html__( 'عرض فرم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'condition' => [
            'styleboxsearchkaveh' =>'one',
          ],
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 405,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-search' => 'max-width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'formwidth2iconsearchkaveh',
        [
          'label' => esc_html__( 'عرض فرم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'condition' => [
            'styleboxsearchkaveh' =>'two',
          ],
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 420,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-two-search' => 'max-width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'formwidth3iconsearchkaveh',
        [
          'label' => esc_html__( 'عرض فرم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'condition' => [
            'styleboxsearchkaveh' =>'three',
          ],
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 350,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-three-search' => 'max-width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'formwidth6iconsearchkaveh',
        [
          'label' => esc_html__( 'عرض فرم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'condition' => [
            'styleboxsearchkaveh' =>'six',
          ],
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 487,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eleven-search' => 'max-width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <?php if('one'===$settings['styleboxsearchkaveh']){ ?>
      <form action="/" method="get" autocomplete="off" class="top-header-search position-relative d-lg-block">
          <div class="input-group">
            <input id="maninpu"  type="text" name="q" class="maninpu form-control" placeholder="<?php echo  esc_attr($settings['titlesearchkaveh']); ?>" />
            <button id="butno" type="submit" class="btn btn-primary btsearch">
              <i class="<?php echo  esc_attr($settings['iconsearchkaveh']['value']); ?>"></i>
            </button>
          </div>
        </form>
    <?php }elseif('two'===$settings['styleboxsearchkaveh']){ ?>
      <form action="/" method="get" autocomplete="off"
          class="top-header-two-search ms-auto d-lg-flex align-items-center position-relative">
          <input id="maninpu"  type="text" name="search" class="maninpu form-control" placeholder="<?php echo  esc_attr($settings['titlesearchkaveh']); ?>" />
          <button id="butno" type="submit" class="btn btn-primary btsearch">
            <i class="<?php echo  esc_attr($settings['iconsearchkaveh']['value']); ?>"></i>
          </button>
     </form>
     <style>
      <?php echo '.elementor-element-' . $clsid . ''; ?> .top-header-two-search .form-control {
      background-image: -webkit-linear-gradient(right, <?php echo  esc_attr($settings['backcolor21iconsearchkaveh']); ?>, <?php echo  esc_attr($settings['backcolor22iconsearchkaveh']); ?>);
      background-image: -moz-linear-gradient(right, <?php echo  esc_attr($settings['backcolor21iconsearchkaveh']); ?>, <?php echo  esc_attr($settings['backcolor22iconsearchkaveh']); ?>);
      background-image: -o-linear-gradient(right, <?php echo  esc_attr($settings['backcolor21iconsearchkaveh']); ?>, <?php echo  esc_attr($settings['backcolor22iconsearchkaveh']); ?>);
      background-image: linear-gradient(to left, <?php echo  esc_attr($settings['backcolor21iconsearchkaveh']); ?>, <?php echo  esc_attr($settings['backcolor22iconsearchkaveh']); ?>);
      }
     </style>
    <?php }elseif('three'===$settings['styleboxsearchkaveh']){ ?>
      <form action="/" method="get" autocomplete="off"
          class="top-header-three-search d-lg-flex align-items-lg-center d-flex">
          <input id="maninpu"  type="text" name="search" class="maninpu form-control" placeholder="<?php echo  esc_attr($settings['titlesearchkaveh']); ?>" />
          <button id="butno" type="submit" class="btn btn-primary p-0 btsearch btse3">
            <i class="<?php echo  esc_attr($settings['iconsearchkaveh']['value']); ?>"></i>
          </button>
        </form>
        <style>
          <?php echo '.elementor-element-' . $clsid . ''; ?> .top-header-three-search, .btse3{
            background-color: <?php echo  esc_attr($settings['t3colorupsearchkaveh']); ?>;
          }
        </style>
    <?php }elseif('four'===$settings['styleboxsearchkaveh']){ ?>
      <button type="button" class="top-header-four-btn-search d-lg-block btsearch">
          <i class="<?php echo  esc_attr($settings['iconsearchkaveh']['value']); ?>"></i>
        </button>
        <div class="top-header-four-search">
          <div class="backdrop"></div>
          <form action="/" method="get" autocomplete="off" class="position-relative">
            <input id="maninpu" type="text" name="search" class="maninpu form-control" placeholder="<?php echo  esc_attr($settings['titlesearchkaveh']); ?>" />
            <button id="butno" type="submit">
              <i class="<?php echo  esc_attr($settings['iconsearchkaveh']['value']); ?>"></i>
            </button>
          </form>
        </div>
    <?php }elseif('five'===$settings['styleboxsearchkaveh']){ ?>
      <div class="top-header-fourteen">
      <button type="button" class="top-header-four-btn-search  btsearchs">
          <i class="<?php echo  esc_attr($settings['iconsearchkaveh']['value']); ?>"></i>
      </button>
        <div class="top-header-four-search">
          <div class="backdrop"></div>
          <form action="/" method="get" autocomplete="off" class="position-relative">
            <input id="maninpu"   type="text" name="search" class="maninpu form-control" placeholder="<?php echo  esc_attr($settings['titlesearchkaveh']); ?>">
            <button id="butno" type="submit">
              <i class="<?php echo  esc_attr($settings['iconsearchkaveh']['value']); ?>"></i>
            </button>
          </form>
        </div>
        </div>
    <?php }elseif('six'===$settings['styleboxsearchkaveh']){ ?>
      <form id="searchForm<?php echo $clsid; ?>" action="<?php echo site_url().'/?post_type=product$?s='; ?>" method="get" autocomplete="off"
          class="top-header-eleven-search d-flex align-items-center position-relative ms-lg-auto w-100 order-5 order-lg-3">
          <select id="categorySelect<?php echo $clsid; ?>" name="category" class="form-control border-none">
            <?php $categories = get_categories( array(
                'taxonomy' => 'product_cat',
            ) ); ?>
            <?php foreach($categories as $category) : ?>
            <option value="<?php echo $category->name; ?>"> <?php echo $category->name; ?> </option>
            <?php endforeach; ?> 
          </select>
          <input id="searchInput<?php echo $clsid; ?>" type="text" name="search" class="form-control border-none"
          placeholder="<?php echo  esc_attr($settings['titlesearchkaveh']); ?>" />
          <button type="submit" class="position-absolute top-50 translate-middle-y">
            <i class="<?php echo  esc_attr($settings['iconsearchkaveh']['value']); ?>"></i>
          </button>
          <div id="searchResults<?php echo $clsid; ?>"></div>
      </form>
      <script>
        // Function to make AJAX request and display search results
        const searchProducts<?php echo $clsid; ?> = (category, query) => {
          const url = `<?php echo home_url() ?>/wp-json/wp/v2/product?per_page=5&search=${query}&category=${encodeURIComponent(category)}`;
          fetch(url)
            .then(response => response.json())
            .then(data => {
              const resultsContainer<?php echo $clsid; ?> = document.getElementById("searchResults<?php echo $clsid; ?>");
              resultsContainer<?php echo $clsid; ?>.innerHTML = ""; // Clear previous results
              if (data.length === 0) {
                resultsContainer<?php echo $clsid; ?>.innerHTML = "هیچ نتیجه ای یافت نشد";
                return;
              }
              // Create and append result elements
              data.forEach(product => {
                const resultElement = document.createElement("div");
                resultElement.classList.add("result-item");
                const titleElement = document.createElement("h3");
                const titleLink = document.createElement("a"); // Create an <a> element
                titleLink.href = product.link; // Replace with the actual product URL
                titleLink.textContent = product.title.rendered;
                titleElement.appendChild(titleLink); // Append the <a> tag to the <h3>
                resultElement.appendChild(titleElement);
                resultsContainer<?php echo $clsid; ?>.appendChild(resultElement);
              });
              // Add "View More Results" link
              const viewMoreLink<?php echo $clsid; ?> = document.createElement("a");
              viewMoreLink<?php echo $clsid; ?>.classList.add("viewmore");
              viewMoreLink<?php echo $clsid; ?>.href = `<?php echo home_url(); ?>/?post_type=product&category=${encodeURIComponent(category)}&search=${encodeURIComponent(query)}`;
              viewMoreLink<?php echo $clsid; ?>.textContent = "مشاهده نتایج بیشتر";
              resultsContainer<?php echo $clsid; ?>.appendChild(viewMoreLink<?php echo $clsid; ?>);

              // Add "Close" button
              const closeButton<?php echo $clsid; ?> = document.createElement("button");
              closeButton<?php echo $clsid; ?>.classList.add("closesearch");
              closeButton<?php echo $clsid; ?>.textContent = "بستن جستجو";
              closeButton<?php echo $clsid; ?>.addEventListener("click", () => {
                resultsContainer<?php echo $clsid; ?>.style.display = "none"; // Hide the search results
                document.getElementById("searchInput<?php echo $clsid; ?>").value = '';
              });
              resultsContainer<?php echo $clsid; ?>.appendChild(closeButton<?php echo $clsid; ?>);
              resultsContainer<?php echo $clsid; ?>.style.display = "block"; // Display the search results
            })
            .catch(error => console.error("Error:", error));
        };
         // Event listener for input change
         document.getElementById("searchInput<?php echo $clsid; ?>").addEventListener("input", event => {
          const category = document.getElementById("categorySelect<?php echo $clsid; ?>").value;
          const query = event.target.value; // Use event.target.value to get the input value
          searchProducts<?php echo $clsid; ?>(category, query);
        });
        // Event listener for form submission
        document.getElementById("searchForm<?php echo $clsid; ?>").addEventListener("submit", event => {
          event.preventDefault(); // Prevent form submission
          const category = document.getElementById("categorySelect<?php echo $clsid; ?>").value;
          const query = document.getElementById("searchInput<?php echo $clsid; ?>").value;
          if (query.trim().length > 0) {
            searchProducts<?php echo $clsid; ?>(category, query);
          }
        });
    </script>
      <style>
        button.closesearch {
            background: #ff000033;
            color: red;
            margin-right: 10px;
            padding: 6px 20px;
            border-radius: 1500px;
            font-size: 14px;
        }
        a.viewmore {
            background: #000;
            color: #fff;
            padding: 6px 15px;
            border-radius: 50px;
            position: relative;
        }
        div#searchResults<?php echo $clsid; ?> {
          position: absolute;
          z-index: 999;
          top: 50px;
          display:none;
          background: #fff;
          width: 100%;
          padding: 20px;
          border-radius: 15px;
          -webkit-box-shadow: 0 10px 50px rgba(0, 0, 0, 0.08);
          -moz-box-shadow: 0 10px 50px rgba(0, 0, 0, 0.08);
          box-shadow: 0 10px 50px rgba(0, 0, 0, 0.08);
      }
      .result-item:hover {
          background: #eee;
          border-radius: 10px;
          cursor: pointer;
      }
      .result-item {
          padding-right: 5px;
          padding-left: 5px;
      }
      .result-item h3 {
          font-size: 15px;
          line-height: 35px;
      }
      </style>
    <?php } ?>
    <?php
  }


}
