<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly


class Productsvertistkaveh extends Widget_Base
{

  public function get_name()
  {
    return 'productsvertistkaveh';
  }

  public function get_title()
  {
    return esc_html__('محصولات عمودی', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['kavehelements'];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'contentproductsvertistkaveh',
      [
        'label' => esc_html__('تنظیمات عنوان', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'titleproductsvertistkaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('پرفروش ترین محصولات', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'tagheadingproductsvertistkaveh',
      [
        'label' => esc_html__('تگ عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1' => esc_html__('H1', 'kaveh-core'),
          'H2' => esc_html__('H2', 'kaveh-core'),
          'H3' => esc_html__('H3', 'kaveh-core'),
          'H4' => esc_html__('H4', 'kaveh-core'),
          'H5' => esc_html__('H5', 'kaveh-core'),
          'H6' => esc_html__('H6', 'kaveh-core'),
          'p' => esc_html__('p', 'kaveh-core'),
          'div' => esc_html__('div', 'kaveh-core'),
          'span' => esc_html__('span', 'kaveh-core'),
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'content2productsvertistkaveh',
      [
        'label' => esc_html__('تنظیمات محصولات', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'pproductsvertistkaveh',
      [
        'label' => esc_html__('نمایش محصولات', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'all',
        'options' => [
          'all' => esc_html__('همه', 'kaveh-core'),
          'cat' => esc_html__('دسته بندی', 'kaveh-core'),

        ],
      ]
    );
    $this->add_control(
      'psortproductsvertistkaveh',
      [
        'label' => esc_html__('مرتب سازی محصولات براساس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'date',
        'options' => [
          'date' => esc_html__('تاریخ', 'kaveh-core'),
          '_price' => esc_html__('قیمت', 'kaveh-core'),
          '_wc_average_rating' => esc_html__('محبوب ترین', 'kaveh-core'),
          'total_sales' => esc_html__('میزان فروش', 'kaveh-core'),

        ],
      ]
    );
    $this->add_control(
      'psortiproductsvertistkaveh',
      [
        'label' => esc_html__('نوع مرتب سازی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'desc',
        'options' => [
          'asc' => esc_html__('صعودی', 'kaveh-core'),
          'desc' => esc_html__('نزولی', 'kaveh-core'),
        ],
      ]
    );
    $options2 = array();
    $orderby = 'name';
    $order = 'asc';
    $hide_empty = false;
    $cat_args = array(
      'orderby' => $orderby,
      'order' => $order,
      'hide_empty' => $hide_empty,
    );

    $product_categories = get_terms('product_cat', $cat_args);

    foreach ($product_categories as $key => $category) {
      $options2[$category->term_id] = $category->name;
    }
    $this->add_control(
      'catproductsvertistkaveh',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => true,
        'options' => $options2,
        'condition' => [
          'pproductsvertistkaveh' => 'cat',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'content3productsvertistkaveh',
      [
        'label' => esc_html__('تنظیمات نمایش', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'productnumberproductsvertistkaveh',
      [
        'label' => esc_html__('تعداد محصولات نمایش داده شده', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 50,
        'step' => 1,
        'default' => 5,
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'style_productsvertistkaveh',
      [
        'label' => esc_html__('استایل عناوین', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'textcolor2productsvertistkaveh',
      [
        'label' => esc_html__('رنگ عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-products-seven-box-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titleproductsvertistkaveh',
        'label' => esc_html__('تایپوگرافی عنوان', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .top-products-seven-box-title',
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style3_productsvertistkaveh',
      [
        'label' => esc_html__('استایل عمومی', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'bgcolorproductsvertistkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-products-seven-box' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'boxradiusproductsvertistkaveh',
      [
        'label' => esc_html__('گوشه خمیده باکس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .top-products-seven-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadownproductsvertistkaveh',
        'label' => esc_html__('سایه باکس', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .top-products-seven-box',
      ]
    );
    $this->add_control(
      'scrolbartabboxes1productsvertistkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه اسکرولبار', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-products-seven-box ul::-webkit-scrollbar' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'scrolbarthumbtabboxes1hrproductsvertistkaveh',
      [
        'label' => esc_html__('رنگ اسکرولبار', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-products-seven-box ul::-webkit-scrollbar-thumb' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
  }


  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <?php $woo_currency = get_woocommerce_currency_symbol(); ?>

    <div class="top-products-seven-box position-relative">
      <<?php echo esc_attr($settings['tagheadingproductsvertistkaveh']); ?> class="top-products-seven-box-title text-center
        mb-4"><?php echo esc_html($settings['titleproductsvertistkaveh']); ?></<?php echo esc_attr($settings['tagheadingproductsvertistkaveh']); ?>>
      <ul class="position-relative">

        <?php if ('cat' === $settings['pproductsvertistkaveh']) { ?>
          <?php
          // Define your custom query arguments
          $query_args = array(
            'post_type' => array('product'),
'post_status' => array('publish'),
            'posts_per_page' => $settings['productnumberproductsvertistkaveh'],
            'orderby' => $settings['psortproductsvertistkaveh'],
            'order' => $settings['psortiproductsvertistkaveh'],
            'tax_query' => array(
              array(
                'taxonomy' => 'product_cat',
                'field' => 'term_id',
                'terms' => $settings['catproductsvertistkaveh'],
              ),
            ),
          );
          // Get the cached query results
          $cached_query = KavehCustomQuery::get_cached_query($query_args);
          if ($cached_query->have_posts()):
            while ($cached_query->have_posts()):
              $cached_query->the_post();
              $post_id = get_the_ID();
              $product = wc_get_product($post_id);
              ?>
              <li class="top-products-seven-item position-relative d-flex align-items-center">
                <a href="<?php the_permalink(); ?>" class="stretched-link" aria-label="<?php the_title(); ?>"></a>
                <img src="<?php if (get_the_post_thumbnail_url()): ?>
                <?php the_post_thumbnail_url('full'); ?>
                <?php else: ?>
                <?php echo wc_placeholder_img_src(); ?>
                <?php endif; ?>" alt="<?php the_title(); ?>" width="90" height="88" class="d-block">
                <div class="detail">
                  <h2 class="title mb-1 text-truncate"><?php the_title(); ?></h2>
                  <div class="price">
                    <div>
                      <?php
                      if ($product->is_type('variable')) {
                        echo $product->get_variation_regular_price('min');
                      } else {
                        echo $product->get_regular_price();
                      }
                      ?>
                      <?php echo $woo_currency; ?>
                    </div>
                  </div>
                  <?php if ($product->get_stock_status() === 'outofstock'): ?>
                    <div class="status">
                      ناموجود
                    </div>
                  <?php endif; ?>
                </div>
              </li>
              <?php
            endwhile;
            wp_reset_postdata();
          else:
            echo 'No posts found.';
          endif;
          ?>


        <?php } elseif ('all' === $settings['pproductsvertistkaveh']) {
          // Define your custom query arguments
          $query_args = array(
            'post_type' => array('product'),
'post_status' => array('publish'),
            'posts_per_page' => $settings['productnumberproductsvertistkaveh'],
            'orderby' => $settings['psortproductsvertistkaveh'],
            'order' => $settings['psortiproductsvertistkaveh'],
          );
          // Get the cached query results
          $cached_query = KavehCustomQuery::get_cached_query($query_args);
          if ($cached_query->have_posts()):
            while ($cached_query->have_posts()):
              $cached_query->the_post();
              $post_id = get_the_ID();
              $product = wc_get_product($post_id);
              ?>
              <li class="top-products-seven-item position-relative d-flex align-items-center">
                <a href="<?php the_permalink(); ?>" class="stretched-link" aria-label="<?php the_title(); ?>"></a>
                <img src="<?php if (get_the_post_thumbnail_url()): ?>
                <?php the_post_thumbnail_url('full'); ?>
                <?php else: ?>
                <?php echo wc_placeholder_img_src(); ?>
                <?php endif; ?>" alt="<?php the_title(); ?>" width="90" height="88" class="d-block">
                <div class="detail">
                  <h2 class="title mb-1 text-truncate"><?php the_title(); ?></h2>
                  <div class="price">
                    <div>
                      <?php
                      if ($product->is_type('variable')) {
                        echo $product->get_variation_regular_price('min');
                      } else {
                        echo $product->get_regular_price();
                      }
                      ?>
                      <?php echo $woo_currency; ?>
                    </div>
                  </div>
                  <?php if ($product->get_stock_status() === 'outofstock'): ?>
                    <div class="status">
                      ناموجود
                    </div>
                  <?php endif; ?>
                </div>
              </li>
              <?php
            endwhile;
            wp_reset_postdata();
          else:
            echo 'No posts found.';
          endif;
          ?>
        <?php } ?>

      </ul>
    </div>
    <style>
      @media only screen and (max-width: 575px) {
        .top-products-seven-item img {
          width: 90px !important;
        }
      }
    </style>

    <?php
  }


}
