<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly


class Productstabthirdstkaveh extends Widget_Base
{

  public function get_name()
  {
    return 'productstabthirdstkaveh';
  }

  public function get_title()
  {
    return esc_html__('تب محصولات کاروسل سبک سوم', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['kavehelements'];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'content2productstabthirdstkaveh',
      [
        'label' => esc_html__('عناوین', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'showtitlesproductstabthirdstkaveh',
      [
        'label' => esc_html__('نمایش عنوان ها؟', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__('بله', 'kaveh-core'),
        'no' => esc_html__('خیر', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'title1productstabthirdstkaveh',
      [
        'label' => esc_html__('عنوان فرعی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'showtitlesproductstabthirdstkaveh' => 'yes',
        ],
        'default' => esc_html__('Special sale of our Eid clothes', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'tagheading1productstabthirdstkaveh',
      [
        'label' => esc_html__('تگ عنوان فرعی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'div',
        'condition' => [
          'showtitlesproductstabthirdstkaveh' => 'yes',
        ],
        'options' => [
          'H1' => esc_html__('H1', 'kaveh-core'),
          'H2' => esc_html__('H2', 'kaveh-core'),
          'H3' => esc_html__('H3', 'kaveh-core'),
          'H4' => esc_html__('H4', 'kaveh-core'),
          'H5' => esc_html__('H5', 'kaveh-core'),
          'H6' => esc_html__('H6', 'kaveh-core'),
          'p' => esc_html__('p', 'kaveh-core'),
          'div' => esc_html__('div', 'kaveh-core'),
          'span' => esc_html__('span', 'kaveh-core'),
        ],
      ]
    );
    $this->add_control(
      'title2productstabthirdstkaveh',
      [
        'label' => esc_html__('عنوان بولد', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'showtitlesproductstabthirdstkaveh' => 'yes',
        ],
        'default' => esc_html__('فروش ویژه', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'title21productstabthirdstkaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'showtitlesproductstabthirdstkaveh' => 'yes',
        ],
        'default' => esc_html__(' لباس های شب عید ما', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'tagheading2productstabthirdstkaveh',
      [
        'label' => esc_html__('تگ عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'condition' => [
          'showtitlesproductstabthirdstkaveh' => 'yes',
        ],
        'options' => [
          'H1' => esc_html__('H1', 'kaveh-core'),
          'H2' => esc_html__('H2', 'kaveh-core'),
          'H3' => esc_html__('H3', 'kaveh-core'),
          'H4' => esc_html__('H4', 'kaveh-core'),
          'H5' => esc_html__('H5', 'kaveh-core'),
          'H6' => esc_html__('H6', 'kaveh-core'),
          'p' => esc_html__('p', 'kaveh-core'),
          'div' => esc_html__('div', 'kaveh-core'),
          'span' => esc_html__('span', 'kaveh-core'),
        ],
      ]
    );
    $this->add_control(
      'showbuttonproductstabthirdstkaveh',
      [
        'label' => esc_html__('نمایش دکمه؟', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__('بله', 'kaveh-core'),
        'no' => esc_html__('خیر', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'icon1productstabthirdstkaveh',
      [
        'label' => esc_html__('آیکون', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'condition' => [
          'showbuttonproductstabthirdstkaveh' => 'yes',
        ],
        'exclude_inline_options' => ['svg'],
        'default' => [
          'value' => 'icon-eye-2',
        ],
      ]
    );
    $this->add_control(
      'buttonproductstabthirdstkaveh',
      [
        'label' => esc_html__('متن دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'showbuttonproductstabthirdstkaveh' => 'yes',
        ],
        'default' => esc_html__('مشاهده بیشتر', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'linkproductstabthirdstkaveh',
      [
        'label' => esc_html__('لینک دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'showbuttonproductstabthirdstkaveh' => 'yes',
        ],
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'content3productstabthirdstkaveh',
      [
        'label' => esc_html__('تب ها', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'tabtitle1productstabthirdstkaveh',
      [
        'label' => esc_html__('عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $repeater->add_control(
      'kaveh_exclude_out_of_stock',
      [
        'label' => esc_html__('عدم نمایش محصولات ناموجود', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__('بله', 'kaveh-core'),
        'no' => esc_html__('خیر', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $repeater->add_control(
      'pproductstabthirdstkaveh',
      [
        'label' => esc_html__('نمایش محصولات', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'all',
        'options' => [
          'all' => esc_html__('همه', 'kaveh-core'),
          'cat' => esc_html__('دسته بندی', 'kaveh-core'),

        ],
      ]
    );
    $repeater->add_control(
      'psortproductstabthirdstkaveh',
      [
        'label' => esc_html__('مرتب سازی محصولات براساس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'date',
        'options' => [
          'date' => esc_html__('تاریخ', 'kaveh-core'),
          '_price' => esc_html__('قیمت', 'kaveh-core'),
          '_wc_average_rating' => esc_html__('محبوب ترین', 'kaveh-core'),
          'total_sales' => esc_html__('بیشترین فروش', 'kaveh-core'),

        ],
      ]
    );
    $repeater->add_control(
      'psortiproductstabthirdstkaveh',
      [
        'label' => esc_html__('نوع مرتب سازی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'desc',
        'options' => [
          'asc' => esc_html__('صعودی', 'kaveh-core'),
          'desc' => esc_html__('نزولی', 'kaveh-core'),
        ],
      ]
    );
    $taboption = array();
    $orderby = 'name';
    $order = 'asc';
    $hide_empty = false;
    $cat_args = array(
      'orderby' => $orderby,
      'order' => $order,
      'hide_empty' => $hide_empty,
    );
    $product_categories = get_terms('product_cat', $cat_args);

    foreach ($product_categories as $key => $category) {
      $taboption[$category->term_id] = $category->name;
    }
    $repeater->add_control(
      'cat2productstabthirdstkaveh',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => true,
        'options' => $taboption,
        'condition' => [
          'pproductstabthirdstkaveh' => 'cat',
        ],
      ]
    );
    $repeater->add_control(
      'productnumberproductstabthirdstkaveh',
      [
        'label' => esc_html__('تعداد محصولات', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 50,
        'step' => 1,
        'default' => 8,
      ]
    );
    $this->add_control(
      'listproductstabthirdstkaveh',
      [
        'label' => esc_html__('تب ها', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tabtitle1productstabthirdstkaveh' => esc_html__('دسته بندی', 'kaveh-core'),
          ],
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'content4productstabthirdstkaveh',
      [
        'label' => esc_html__('تنظیمات نمایش', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'showarrowsproductstabthirdstkaveh',
      [
        'label' => esc_html__('نمایش فلش ها؟', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__('بله', 'kaveh-core'),
        'no' => esc_html__('خیر', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'styleproductstabthirdstkaveh',
      [
        'label' => esc_html__('طرح بندی باکس محصول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'one',
        'options' => [
          'one' => esc_html__('طرح بندی اول', 'kaveh-core'),
          'two' => esc_html__('طرح بندی دوم', 'kaveh-core'),
          'three' => esc_html__('طرح بندی سوم', 'kaveh-core'),
          'four' => esc_html__('طرح بندی چهارم', 'kaveh-core'),
          'five' => esc_html__('طرح بندی پنجم', 'kaveh-core'),
          'six' => esc_html__('طرح بندی ششم', 'kaveh-core'),
          'seven' => esc_html__('طرح بندی هفتم', 'kaveh-core'),
          'eight' => esc_html__('طرح بندی هشتم', 'kaveh-core'),
          'nine' => esc_html__('طرح بندی نهم', 'kaveh-core'),
          'ten' => esc_html__('طرح بندی دهم', 'kaveh-core'),
          'eleven' => esc_html__('طرح بندی یازدهم', 'kaveh-core'),
          'twelve' => esc_html__('طرح بندی دوازدهم', 'kaveh-core'),
          'thirteen' => esc_html__('طرح بندی سیزدهم', 'kaveh-core'),
          'fourteen' => esc_html__('طرح بندی چهاردهم', 'kaveh-core'),
          'fifteen' => esc_html__('طرح بندی پانزدهم', 'kaveh-core'),
          'sixteen' => esc_html__('طرح بندی شانزدهم', 'kaveh-core'),
          'seventeen' => esc_html__('طرح بندی هفدهم', 'kaveh-core'),

        ],
      ]
    );
    $this->add_control(
      'productcolumnproductstabthirdstkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در دسکتاپ', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 4,

      ]
    );
    $this->add_control(
      'productcolumn2productstabthirdstkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در تبلت', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 3,

      ]
    );
    $this->add_control(
      'productcolumn3productstabthirdstkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در موبایل', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 1,

      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style0_productstabthirdstkaveh',
      [
        'label' => esc_html__('استایل عناوین', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'showtitlesproductstabthirdstkaveh' => 'yes',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titletype1_productstabthirdstkaveh',
        'label' => esc_html__('تایپوگرافی عنوان فرعی', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .specials-sale-heading-title-en',

      ]
    );
    $this->add_control(
      'titlecolor1productstabthirdstkaveh',
      [
        'label' => esc_html__('رنگ عنوان فرعی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .specials-sale-heading-title-en' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titletype22_productstabthirdstkaveh',
        'label' => esc_html__('تایپوگرافی عنوان بولد', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .specials-sale-heading-title span',

      ]
    );
    $this->add_control(
      'titlecolor22productstabthirdstkaveh',
      [
        'label' => esc_html__('رنگ عنوان بولد', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .specials-sale-heading-title span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titletype2_productstabthirdstkaveh',
        'label' => esc_html__('تایپوگرافی عنوان', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .specials-sale-heading-title',

      ]
    );
    $this->add_control(
      'titlecolor2productstabthirdstkaveh',
      [
        'label' => esc_html__('رنگ عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .specials-sale-heading-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style1_productstabthirdstkaveh',
      [
        'label' => esc_html__('استایل تب ها', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'button_productstabthirdstkaveh',
        'label' => esc_html__('تایپوگرافی متن', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .specials-sale-heading-sort li ,{{WRAPPER}} .specials-sale-heading-sort li.active ',
      ]
    );
    $this->add_control(
      'buttontextcolorproductstabthirdstkaveh',
      [
        'label' => esc_html__('رنگ متن', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .specials-sale-heading-sort li' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttoncoloractiveproductstabthirdstkaveh',
      [
        'label' => esc_html__('رنگ تب فعال', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,

        'selectors' => [
          '{{WRAPPER}} .specials-sale-heading-sort li.active' => 'color: {{VALUE}}',
          '{{WRAPPER}} .specials-sale-heading-sort li:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style2_productstabthirdstkaveh',
      [
        'label' => esc_html__('استایل دکمه', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'button1_productstabthirdstkaveh',
        'label' => esc_html__('تایپوگرافی متن دکمه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .specials-sale-heading .btn',

      ]
    );
    $this->add_control(
      'iconsizebutton1productstabthirdstkaveh',
      [
        'label' => esc_html__('سایز آیکون', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 300,
            'step' => 1,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .specials-sale-heading .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Text_Shadow::get_type(),
      [
        'name' => 'text1_shadowproductstabthirdstkaveh',
        'label' => esc_html__('سایه متن', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .specials-sale-heading .btn',

      ]
    );
    $this->start_controls_tabs(
      'style1_tabsproductstabthirdstkaveh'
    );

    $this->start_controls_tab(
      'style1_normal_tabproductstabthirdstkaveh',
      [
        'label' => esc_html__('عادی', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'textbutton1colorproductstabthirdstkaveh',
      [
        'label' => esc_html__('رنگ نوشته دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .specials-sale-heading .btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonc1colorproductstabthirdstkaveh',
      [
        'label' => esc_html__('رنگ آیکون', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .specials-sale-heading .btn i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'button1colorproductstabthirdstkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .specials-sale-heading .btn' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'button1radiusproductstabthirdstkaveh',
      [
        'label' => esc_html__('گوشه خمیده دکمه بیشتر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .specials-sale-heading .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'border1productstabthirdstkaveh',
        'label' => esc_html__('حاشیه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .specials-sale-heading .btn',
      ]
    );
    $this->add_control(
      'button1bordersproductstabthirdstkaveh',
      [
        'label' => esc_html__('عرض حاشیه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'border1productstabthirdstkaveh!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .specials-sale-heading .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hover1_tabproductstabthirdstkaveh',
      [
        'label' => esc_html__('هاور', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'textbutton1colorhoverproductstabthirdstkaveh',
      [
        'label' => esc_html__('رنگ نوشته دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .specials-sale-heading .btn:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonc1colorhoverproductstabthirdstkaveh',
      [
        'label' => esc_html__('رنگ آیکون', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .specials-sale-heading .btn:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'button1colorhoverproductstabthirdstkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .specials-sale-heading .btn:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'button1radiushoverproductstabthirdstkaveh',
      [
        'label' => esc_html__('گوشه خمیده دکمه بیشتر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .specials-sale-heading .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'border1hoverproductstabthirdstkaveh',
        'label' => esc_html__('حاشیه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .specials-sale-heading .btn:hover',
      ]
    );
    $this->add_control(
      'button1bordershoverproductstabthirdstkaveh',
      [
        'label' => esc_html__('عرض حاشیه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'border1hoverproductstabthirdstkaveh!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .specials-sale-heading .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_control(
      'hr11productstabthirdstkaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadow1productstabthirdstkavehh',
        'label' => esc_html__('سایه دکمه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .specials-sale-heading .btn',
      ]
    );
    $this->add_control(
      'button1paddingproductstabthirdstkaveh',
      [
        'label' => esc_html__('فاصله داخلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .specials-sale-heading .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'stylear_productstabthirdstkaveh',
      [
        'label' => esc_html__('استایل فلش', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'showarrowsproductstabthirdstkaveh' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'arrow1colorhoverproductstabthirdstkaveh',
      [
        'label' => esc_html__('رنگ فلش ها', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .specials-sale .swiper-button-next::after' => 'color: {{VALUE}}',
          '{{WRAPPER}} .specials-sale .swiper-button-prev::after' => 'color: {{VALUE}}',

        ],
      ]
    );

    $this->end_controls_section();

  }


  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="specials-sale">
      <div class="container position-relative">
        <!-- Start Heading -->
        <div class="specials-sale-heading d-flex align-items-center flex-wrap flex-lg-nowrap gap-4 gap-lg-0">
          <?php if ('yes' === $settings['showtitlesproductstabthirdstkaveh']) { ?>
            <!-- Start Title -->
            <div class="specials-sale-heading-right">
              <<?php echo esc_attr($settings['tagheading1productstabthirdstkaveh']); ?> class="specials-sale-heading-title-en">
                <?php echo esc_html($settings['title1productstabthirdstkaveh']); ?> </<?php echo esc_attr($settings['tagheading1productstabthirdstkaveh']); ?>>
              <<?php echo esc_attr($settings['tagheading2productstabthirdstkaveh']); ?> class="specials-sale-heading-title
                position-relative">
                <span> <?php echo esc_html($settings['title2productstabthirdstkaveh']); ?></span>
                <?php echo esc_html($settings['title21productstabthirdstkaveh']); ?>
              </<?php echo esc_attr($settings['tagheading2productstabthirdstkaveh']); ?>>
            </div>
            <!-- End Title -->
          <?php } ?>
          <!-- Start Sort -->
          <ul class="nav nav-tabs specials-sale-heading-sort d-flex align-items-center border-0">
            <?php
            $q = 1;
            if ($settings['listproductstabthirdstkaveh']) {
              foreach ($settings['listproductstabthirdstkaveh'] as $item) {
                ?>
                <li data-bs-toggle="tab" data-bs-target="#tab-<?php echo $clsid . $q; ?>"
                  class="<?php if (1 === $q) { ?>active <?php } ?>">
                  <?php echo esc_html($item['tabtitle1productstabthirdstkaveh']); ?>
                </li>
                <?php
                $q++;
              }
            }
            ?>
          </ul>
          <?php if ('yes' === $settings['showbuttonproductstabthirdstkaveh']) { ?>
            <!-- End Sort -->
            <a href="<?php echo esc_url($settings['linkproductstabthirdstkaveh']); ?>"
              class="btn btn-dark-4 d-flex align-items-center justify-content-center ms-md-auto">
              <?php echo esc_html($settings['buttonproductstabthirdstkaveh']); ?>
              <i class="<?php echo esc_html($settings['icon1productstabthirdstkaveh']['value']); ?>"></i>
            </a>
          <?php } ?>
        </div>
        <!-- End Heading -->
        <!-- Start Tab Contents -->
        <div class="tab-content">
          <?php
          $k = 1;
          if ($settings['listproductstabthirdstkaveh']) {
            foreach ($settings['listproductstabthirdstkaveh'] as $item) {
              ?>
              <!-- Start Tab Content -->
              <div id="tab-<?php echo $clsid . $k; ?>" class="tab-pane fade <?php if (1 === $k) { ?>active show<?php } ?>">
                <!-- Start Carousel -->
                <div class="swiper swiper-specials-sale swiper-visible swiper-button-arrow"
                  data-swiper='{"watchSlidesProgress":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabthirdstkaveh']); ?>,"spaceBetween":4},"576":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productstabthirdstkaveh']); ?>,"spaceBetween":12},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productstabthirdstkaveh']); ?>,"spaceBetween":20},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabthirdstkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabthirdstkaveh']); ?>,"spaceBetween":31}}}'>
                  <div class="swiper-wrapper">
                    <?php
                    if ('cat' === $item['pproductstabthirdstkaveh']) {
                      // Define your custom query arguments
                      $query_args = array(
                        'post_type' => array('product'),
'post_status' => array('publish'),
                        'posts_per_page' => $item['productnumberproductstabthirdstkaveh'],
                        'orderby' => $item['psortproductstabthirdstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                        'order' => $item['psortiproductstabthirdstkaveh'],
                        'tax_query' => array(
                          'relation' => 'AND',
                          array(
                            'taxonomy' => 'product_cat',
                            'field' => 'term_id',
                            'terms' => $item['cat2productstabthirdstkaveh'],
                          ),
                        ),
                      );
                      // Handle specific orderby values
                      switch ($item['psortproductstabthirdstkaveh']) {
                        case '_price':
                          $query_args['meta_key'] = '_price';
                          $query_args['orderby'] = 'meta_value_num';
                          break;

                        case '_wc_average_rating':
                          $query_args['meta_key'] = '_wc_average_rating';
                          $query_args['orderby'] = 'meta_value_num';
                          break;

                        case 'total_sales':
                          $query_args['meta_key'] = 'total_sales';
                          $query_args['orderby'] = 'meta_value_num';
                          break;
                      }

                      if ("yes" === $item['kaveh_exclude_out_of_stock']) {
                        $query_args['tax_query'][] = array(
                          'taxonomy' => 'product_visibility',
                          'field' => 'name',
                          'terms' => array('outofstock'),
                          'operator' => 'NOT IN'
                        );
                      }

                      // Get the cached query results
                      $cached_query = KavehCustomQuery::get_cached_query($query_args);

                      if ($cached_query->have_posts()):
                        while ($cached_query->have_posts()):
                          $cached_query->the_post();
                          ?>
                          <div class="swiper-slide h-auto">
                            <?php $styleproduct2 = $settings['styleproductstabthirdstkaveh']; ?>
                            <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                          </div>
                          <?php
                        endwhile;
                        wp_reset_postdata();
                      else:
                        echo 'No posts found.';
                      endif;

                    } else {
                      // Define your custom query arguments
                      $query_args = array(
                        'post_type' => array('product'),
'post_status' => array('publish'),
                        'posts_per_page' => $item['productnumberproductstabthirdstkaveh'],
                        'orderby' => $item['psortproductstabthirdstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                        'order' => $item['psortiproductstabthirdstkaveh'],
                        'tax_query' => array(
                          'relation' => 'AND',
                        ),
                      );
                      // Handle specific orderby values
                      switch ($item['psortproductstabthirdstkaveh']) {
                        case '_price':
                          $query_args['meta_key'] = '_price';
                          $query_args['orderby'] = 'meta_value_num';
                          break;

                        case '_wc_average_rating':
                          $query_args['meta_key'] = '_wc_average_rating';
                          $query_args['orderby'] = 'meta_value_num';
                          break;

                        case 'total_sales':
                          $query_args['meta_key'] = 'total_sales';
                          $query_args['orderby'] = 'meta_value_num';
                          break;
                      }

                      if ("yes" === $item['kaveh_exclude_out_of_stock']) {
                        $query_args['tax_query'][] = array(
                          'taxonomy' => 'product_visibility',
                          'field' => 'name',
                          'terms' => array('outofstock'),
                          'operator' => 'NOT IN'
                        );
                      }

                      // Get the cached query results
                      $cached_query = KavehCustomQuery::get_cached_query($query_args);

                      if ($cached_query->have_posts()):
                        while ($cached_query->have_posts()):
                          $cached_query->the_post();
                          ?>
                          <div class="swiper-slide h-auto">
                            <?php $styleproduct2 = $settings['styleproductstabthirdstkaveh']; ?>
                            <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                          </div>
                          <?php
                        endwhile;
                        wp_reset_postdata();
                      else:
                        echo 'No posts found.';
                      endif;
                      $k++;
                    }
                    ?>
                  </div>
                  <?php if ('yes' === $settings['showarrowsproductstabthirdstkaveh']) { ?>
                    <!-- Start Button -->
                    <div class="swiper-button-next w-auto h-auto"></div>
                    <div class="swiper-button-prev w-auto h-auto"></div>
                    <!-- End Button -->
                  <?php } ?>
                </div>
                <!-- End Carousel -->
              </div>
              <!-- End Tab Content -->
              <?php
              $k++;
            }
          }
          ?>
        </div>
        <!-- End Tab Contents -->
      </div>
    </section>
    <?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }
}