<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly

class Productstabsecondstkaveh extends Widget_Base
{

  public function get_name()
  {
    return 'productstabsecondstkaveh';
  }

  public function get_title()
  {
    return esc_html__('تب محصولات کاروسل سبک دو', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['kavehelements'];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'contentproductstabsecondstkaveh',
      [
        'label' => esc_html__('استایل تب ها', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tabstyproductstabsecondstkaveh',
      [
        'label' => esc_html__('استایل تب ها', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1style',
        'options' => [
          '1style' => esc_html__('طرح بندی اول', 'kaveh-core'),
          '2style' => esc_html__('طرح بندی دوم', 'kaveh-core'),

        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'content2productstabsecondstkaveh',
      [
        'label' => esc_html__('عناوین', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'showtitlesproductstabsecondstkaveh',
      [
        'label' => esc_html__('نمایش عنوان ها؟', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__('بله', 'kaveh-core'),
        'no' => esc_html__('خیر', 'kaveh-core'),
        'condition' => [
          'tabstyproductstabsecondstkaveh' => '1style',
        ],
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'showimagebeforeproductstabsecondstkaveh',
      [
        'label' => esc_html__('نمایش تصویر قبل عنوان؟', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__('بله', 'kaveh-core'),
        'no' => esc_html__('خیر', 'kaveh-core'),
        'condition' => [
          'tabstyproductstabsecondstkaveh' => '1style',
        ],
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'imgbeforetitleproductstabsecondstkaveh',
      [
        'label' => esc_html__('تصویر قبل عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .text::before' =>
            'background: url({{URL}}) 0 0 no-repeat',
        ],
        'condition' => [
          'showimagebeforeproductstabsecondstkaveh' => 'yes',
          'tabstyproductstabsecondstkaveh' => '1style',
        ],
      ]
    );
    $this->add_control(
      'title1productstabsecondstkaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'showtitlesproductstabsecondstkaveh' => 'yes',
          'tabstyproductstabsecondstkaveh' => '1style',
        ],
        'default' => esc_html__('فروشگاه', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'tagheading1productstabsecondstkaveh',
      [
        'label' => esc_html__('تگ عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H6',
        'condition' => [
          'showtitlesproductstabsecondstkaveh' => 'yes',
          'tabstyproductstabsecondstkaveh' => '1style',
        ],
        'options' => [
          'H1' => esc_html__('H1', 'kaveh-core'),
          'H2' => esc_html__('H2', 'kaveh-core'),
          'H3' => esc_html__('H3', 'kaveh-core'),
          'H4' => esc_html__('H4', 'kaveh-core'),
          'H5' => esc_html__('H5', 'kaveh-core'),
          'H6' => esc_html__('H6', 'kaveh-core'),
          'p' => esc_html__('p', 'kaveh-core'),
          'div' => esc_html__('div', 'kaveh-core'),
          'span' => esc_html__('span', 'kaveh-core'),
        ],
      ]
    );
    $this->add_control(
      'title2productstabsecondstkaveh',
      [
        'label' => esc_html__('عنوان فرعی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'showtitlesproductstabsecondstkaveh' => 'yes',
          'tabstyproductstabsecondstkaveh' => '1style',
        ],
        'default' => esc_html__('دیجی کالا', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'tagheading2productstabsecondstkaveh',
      [
        'label' => esc_html__('تگ عنوان فرعی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'condition' => [
          'showtitlesproductstabsecondstkaveh' => 'yes',
          'tabstyproductstabsecondstkaveh' => '1style',
        ],
        'options' => [
          'H1' => esc_html__('H1', 'kaveh-core'),
          'H2' => esc_html__('H2', 'kaveh-core'),
          'H3' => esc_html__('H3', 'kaveh-core'),
          'H4' => esc_html__('H4', 'kaveh-core'),
          'H5' => esc_html__('H5', 'kaveh-core'),
          'H6' => esc_html__('H6', 'kaveh-core'),
          'p' => esc_html__('p', 'kaveh-core'),
          'div' => esc_html__('div', 'kaveh-core'),
          'span' => esc_html__('span', 'kaveh-core'),
        ],
      ]
    );
    $this->add_control(
      'showbuttonproductstabsecondstkaveh',
      [
        'label' => esc_html__('نمایش دکمه؟', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__('بله', 'kaveh-core'),
        'no' => esc_html__('خیر', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'icon1productstabsecondstkaveh',
      [
        'label' => esc_html__('آیکون', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'condition' => [
          'showbuttonproductstabsecondstkaveh' => 'yes',
        ],
        'exclude_inline_options' => ['svg'],
        'default' => [
          'value' => 'icon-eye-2',
        ],
      ]
    );
    $this->add_control(
      'buttonproductstabsecondstkaveh',
      [
        'label' => esc_html__('متن دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'showbuttonproductstabsecondstkaveh' => 'yes',
        ],
        'default' => esc_html__('مشاهده بیشتر', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'linkproductstabsecondstkaveh',
      [
        'label' => esc_html__('لینک دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'showbuttonproductstabsecondstkaveh' => 'yes',
        ],
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'content3productstabsecondstkaveh',
      [
        'label' => esc_html__('تب ها', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'tabtitle1productstabsecondstkaveh',
      [
        'label' => esc_html__('عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $repeater->add_control(
      'kaveh_exclude_out_of_stock',
      [
        'label' => esc_html__('عدم نمایش محصولات ناموجود', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__('بله', 'kaveh-core'),
        'no' => esc_html__('خیر', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $repeater->add_control(
      'pproductstabsecondstkaveh',
      [
        'label' => esc_html__('نمایش محصولات', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'all',
        'options' => [
          'all' => esc_html__('همه', 'kaveh-core'),
          'cat' => esc_html__('دسته بندی', 'kaveh-core'),

        ],
      ]
    );
    $repeater->add_control(
      'psortproductstabsecondstkaveh',
      [
        'label' => esc_html__('مرتب سازی محصولات براساس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'date',
        'options' => [
          'date' => esc_html__('تاریخ', 'kaveh-core'),
          '_price' => esc_html__('قیمت', 'kaveh-core'),
          '_wc_average_rating' => esc_html__('محبوب ترین', 'kaveh-core'),
          'total_sales' => esc_html__('میزان فروش', 'kaveh-core'),

        ],
      ]
    );
    $repeater->add_control(
      'psortiproductstabsecondstkaveh',
      [
        'label' => esc_html__('نوع مرتب سازی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'desc',
        'options' => [
          'asc' => esc_html__('صعودی', 'kaveh-core'),
          'desc' => esc_html__('نزولی', 'kaveh-core'),
        ],
      ]
    );
    $taboption = array();
    $orderby = 'name';
    $order = 'asc';
    $hide_empty = false;
    $cat_args = array(
      'orderby' => $orderby,
      'order' => $order,
      'hide_empty' => $hide_empty,
    );
    $product_categories = get_terms('product_cat', $cat_args);

    foreach ($product_categories as $key => $category) {
      $taboption[$category->term_id] = $category->name;
    }
    $repeater->add_control(
      'cat2productstabsecondstkaveh',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => true,
        'options' => $taboption,
        'condition' => [
          'pproductstabsecondstkaveh' => 'cat',
        ],
      ]
    );
    $repeater->add_control(
      'productnumberproductstabsecondstkaveh',
      [
        'label' => esc_html__('تعداد محصولات', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 50,
        'step' => 1,
        'default' => 8,
      ]
    );
    $this->add_control(
      'listproductstabsecondstkaveh',
      [
        'label' => esc_html__('تب ها', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tabtitle1productstabsecondstkaveh' => esc_html__('دسته بندی', 'kaveh-core'),
          ],
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'content4productstabsecondstkaveh',
      [
        'label' => esc_html__('تنظیمات نمایش', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'showarrowsproductstabsecondstkaveh',
      [
        'label' => esc_html__('نمایش فلش ها؟', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__('بله', 'kaveh-core'),
        'no' => esc_html__('خیر', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'styleproductstabsecondstkaveh',
      [
        'label' => esc_html__('طرح بندی باکس محصول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'one',
        'options' => [
          'one' => esc_html__('طرح بندی اول', 'kaveh-core'),
          'two' => esc_html__('طرح بندی دوم', 'kaveh-core'),
          'three' => esc_html__('طرح بندی سوم', 'kaveh-core'),
          'four' => esc_html__('طرح بندی چهارم', 'kaveh-core'),
          'five' => esc_html__('طرح بندی پنجم', 'kaveh-core'),
          'six' => esc_html__('طرح بندی ششم', 'kaveh-core'),
          'seven' => esc_html__('طرح بندی هفتم', 'kaveh-core'),
          'eight' => esc_html__('طرح بندی هشتم', 'kaveh-core'),
          'nine' => esc_html__('طرح بندی نهم', 'kaveh-core'),
          'ten' => esc_html__('طرح بندی دهم', 'kaveh-core'),
          'eleven' => esc_html__('طرح بندی یازدهم', 'kaveh-core'),
          'twelve' => esc_html__('طرح بندی دوازدهم', 'kaveh-core'),
          'thirteen' => esc_html__('طرح بندی سیزدهم', 'kaveh-core'),
          'fourteen' => esc_html__('طرح بندی چهاردهم', 'kaveh-core'),
          'fifteen' => esc_html__('طرح بندی پانزدهم', 'kaveh-core'),
          'sixteen' => esc_html__('طرح بندی شانزدهم', 'kaveh-core'),
          'seventeen' => esc_html__('طرح بندی هفدهم', 'kaveh-core'),

        ],
      ]
    );
    $this->add_control(
      'productcolumnproductstabsecondstkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در دسکتاپ', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 4,

      ]
    );
    $this->add_control(
      'productcolumn2productstabsecondstkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در تبلت', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 3,

      ]
    );
    $this->add_control(
      'productcolumn3productstabsecondstkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در موبایل', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 1,

      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style0_productstabsecondstkaveh',
      [
        'label' => esc_html__('استایل عناوین', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'showtitlesproductstabsecondstkaveh' => 'yes',
          'tabstyproductstabsecondstkaveh' => '1style',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titletype1_productstabsecondstkaveh',
        'label' => esc_html__('تایپوگرافی عنوان فرعی', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .top-selling-products-heading .text .title',

      ]
    );
    $this->add_control(
      'titlecolor1productstabsecondstkaveh',
      [
        'label' => esc_html__('رنگ عنوان فرعی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .text .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titletype2_productstabsecondstkaveh',
        'label' => esc_html__('تایپوگرافی عنوان فرعی', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .top-selling-products-heading .text .sub-title',

      ]
    );
    $this->add_control(
      'titlecolor2productstabsecondstkaveh',
      [
        'label' => esc_html__('رنگ عنوان فرعی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .text .sub-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style1_productstabsecondstkaveh',
      [
        'label' => esc_html__('استایل تب ها', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'button_productstabsecondstkaveh',
        'label' => esc_html__('تایپوگرافی متن', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .top-selling-products-heading .nav-item',
        'selector' => '{{WRAPPER}} .new-products-offer-heading .nav-item',
        'condition' => [
          'tabstyproductstabsecondstkaveh' => '1style',
        ],
      ]
    );
    $this->add_control(
      'buttontextcolorproductstabsecondstkaveh',
      [
        'label' => esc_html__('رنگ متن', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .nav-item' => 'color: {{VALUE}}',
          '{{WRAPPER}} .top-products-two-tabs .nav-item .nav-link' => 'color: {{VALUE}}',
          '{{WRAPPER}} .top-seller-products-two-tabs li' => 'color: {{VALUE}}',
          '{{WRAPPER}} .new-products-offer-heading .nav-item' => 'color: {{VALUE}}',

        ],
      ]
    );
    $this->add_control(
      'buttoncoloractiveproductstabsecondstkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه تب فعال', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'tabstyproductstabsecondstkaveh' => '1style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .nav-item.active' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .top-selling-products-heading .nav-item:hover' => 'background-color: {{VALUE}}',


        ],
      ]
    );
    $this->add_control(
      'buttontextactivecolorproductstabsecondstkaveh',
      [
        'label' => esc_html__('رنگ متن در حالت فعال', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .nav-item.active' => 'color: {{VALUE}}',
          '{{WRAPPER}} .top-selling-products-heading .nav-item:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .new-products-offer-heading .nav-item.active' => 'color: {{VALUE}}',
          '{{WRAPPER}} .new-products-offer-heading .nav-item:hover' => 'color: {{VALUE}}',



        ],
      ]
    );

    $this->add_control(
      'buttonradius1productstabsecondstkaveh',
      [
        'label' => esc_html__('گوشه خمیده در حالت فعال', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'tabstyproductstabsecondstkaveh' => '1style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .nav-item.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .top-selling-products-heading .nav-item:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

        ],
      ]
    );
    $this->add_control(
      'buttonpadding2productstabsecondstkaveh',
      [
        'label' => esc_html__('فاصله داخلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'condition' => [
          'tabstyproductstabsecondstkaveh' => '1style',
        ],
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .nav-item:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .top-selling-products-heading .nav-item.active' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'buttonshadowproductstabkave',
        'label' => esc_html__('سایه دکمه در حالت فعال', 'kaveh-core'),
        'condition' => [
          'tabstyproductstabsecondstkaveh' => '1style',
        ],
        'selector' => '{{WRAPPER}} .top-selling-products-heading .nav-item.active ,{{WRAPPER}} .top-selling-products-heading .nav-item:hover',

      ]
    );
    $this->add_control(
      'bgcolorproductstabsecondstkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه نوار تب ها', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'tabstyproductstabsecondstkaveh' => '1style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .nav' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'bgradius1productstabsecondstkaveh',
      [
        'label' => esc_html__('گوشه خمیده در حالت فعال', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'tabstyproductstabsecondstkaveh' => '1style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .nav' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'bgpadding1productstabsecondstkaveh',
      [
        'label' => esc_html__('فاصله داخلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'condition' => [
          'tabstyproductstabsecondstkaveh' => '1style',
        ],
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .nav' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style2_productstabsecondstkaveh',
      [
        'label' => esc_html__('استایل دکمه', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'tabstyproductstabsecondstkaveh' => ['1style', '2style'],
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'button1_productstabsecondstkaveh',
        'label' => esc_html__('تایپوگرافی متن دکمه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .top-selling-products-heading .btn',
        'selector' => '{{WRAPPER}} .new-products-offer-heading .btn',

      ]
    );
    $this->add_control(
      'iconsizebutton1productstabsecondstkaveh',
      [
        'label' => esc_html__('سایز آیکون', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 300,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 15,
        ],
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .new-products-offer-heading .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Text_Shadow::get_type(),
      [
        'name' => 'text1_shadowproductstabsecondstkaveh',
        'label' => esc_html__('سایه متن', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .top-selling-products-heading .btn ,{{WRAPPER}} .new-products-offer-heading .btn',

      ]
    );
    $this->start_controls_tabs(
      'style1_tabsproductstabsecondstkaveh'
    );

    $this->start_controls_tab(
      'style1_normal_tabproductstabsecondstkaveh',
      [
        'label' => esc_html__('عادی', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'textbutton1colorproductstabsecondstkaveh',
      [
        'label' => esc_html__('رنگ نوشته دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .new-products-offer-heading .btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonc1colorproductstabsecondstkaveh',
      [
        'label' => esc_html__('رنگ آیکون', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .btn i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .new-products-offer-heading .btn i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'button1colorproductstabsecondstkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .btn' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .new-products-offer-heading .btn' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'button1radiusproductstabsecondstkaveh',
      [
        'label' => esc_html__('گوشه خمیده دکمه بیشتر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .new-products-offer-heading .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'border1productstabsecondstkaveh',
        'label' => esc_html__('حاشیه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .top-selling-products-heading .btn, {{WRAPPER}} .new-products-offer-heading .btn',
      ]
    );
    $this->add_control(
      'button1bordersproductstabsecondstkaveh',
      [
        'label' => esc_html__('عرض حاشیه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'border1productstabsecondstkaveh!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          '{{WRAPPER}} .new-products-offer-heading .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hover1_tabproductstabsecondstkaveh',
      [
        'label' => esc_html__('هاور', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'textbutton1colorhoverproductstabsecondstkaveh',
      [
        'label' => esc_html__('رنگ نوشته دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .new-products-offer-heading .btn:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonc1colorhoverproductstabsecondstkaveh',
      [
        'label' => esc_html__('رنگ آیکون', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .btn:hover i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .new-products-offer-heading .btn:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'button1colorhoverproductstabsecondstkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .btn:hover' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .new-products-offer-heading .btn:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'button1radiushoverproductstabsecondstkaveh',
      [
        'label' => esc_html__('گوشه خمیده دکمه بیشتر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .new-products-offer-heading .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'border1hoverproductstabsecondstkaveh',
        'label' => esc_html__('حاشیه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .top-selling-products-heading .btn:hover, {{WRAPPER}} .new-products-offer-heading .btn:hover',
      ]
    );
    $this->add_control(
      'button1bordershoverproductstabsecondstkaveh',
      [
        'label' => esc_html__('عرض حاشیه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'border1hoverproductstabsecondstkaveh!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          '{{WRAPPER}} .new-products-offer-heading .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_control(
      'hr11productstabsecondstkaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadow1productstabsecondstkavehh',
        'label' => esc_html__('سایه دکمه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .top-selling-products-heading .btn, {{WRAPPER}} .new-products-offer-heading .btn',
      ]
    );
    $this->add_control(
      'button1paddingproductstabsecondstkaveh',
      [
        'label' => esc_html__('فاصله داخلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .new-products-offer-heading .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style3_productstabsecondstkaveh',
      [
        'label' => esc_html__('استایل باکس بالا', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'tabstyproductstabsecondstkaveh' => '1style',
        ],
      ]
    );
    $this->add_control(
      'top1paddingproductstabsecondstkaveh',
      [
        'label' => esc_html__('فاصله داخلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'bordertopbox1colorhoverproductstabsecondstkaveh',
      [
        'label' => esc_html__('رنگ حاشیه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading' => 'border: 1px solid {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'topbox1radiushoverproductstabsecondstkaveh',
      [
        'label' => esc_html__('گوشه خمیده باکس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .top-selling-products-heading' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'stylear_productstabsecondstkaveh',
      [
        'label' => esc_html__('استایل فلش', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'tabstyproductstabsecondstkaveh' => '2style',
          'showarrowsproductstabsecondstkaveh' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'arrow1colorhoverproductstabsecondstkaveh',
      [
        'label' => esc_html__('رنگ فلش ها', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .new-products-offer .swiper-button-next::after' => 'color: {{VALUE}}',
          '{{WRAPPER}} .new-products-offer .swiper-button-prev::after' => 'color: {{VALUE}}',

        ],
      ]
    );

    $this->end_controls_section();

  }


  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <?php if ('1style' === $settings['tabstyproductstabsecondstkaveh']) { ?>
      <section class="top-selling-products">
        <div class="container position-relative">
          <!-- Start Heading -->
          <div class="top-selling-products-heading d-flex align-items-center flex-wrap flex-lg-nowrap">
            <div class="text position-relative order-1 mb-3 mb-sm-0">
              <?php if ('yes' === $settings['showtitlesproductstabsecondstkaveh']) { ?>
                <<?php echo esc_attr($settings['tagheading1productstabsecondstkaveh']); ?> class="title mb-2">
                  <?php echo esc_html($settings['title1productstabsecondstkaveh']); ?></<?php echo esc_attr($settings['tagheading1productstabsecondstkaveh']); ?>>
                <<?php echo esc_attr($settings['tagheading2productstabsecondstkaveh']); ?> class="sub-title
                  mb-0"><?php echo esc_html($settings['title2productstabsecondstkaveh']); ?></<?php echo esc_attr($settings['tagheading2productstabsecondstkaveh']); ?>>
              <?php } ?>
            </div>
            <ul class="nav nav-pills order-3 order-lg-2 mt-4 mt-lg-0 justify-content-sm-center">
              <?php
              $q = 1;
              if ($settings['listproductstabsecondstkaveh']) {
                foreach ($settings['listproductstabsecondstkaveh'] as $item) {
                  ?>
                  <li class="nav-item <?php if (1 === $q) { ?>active <?php } else {
                  } ?>" data-bs-toggle="tab"
                    data-bs-target="#products-<?php echo $clsid . $q; ?>" data-tab-swiper="true">
                    <?php echo esc_html($item['tabtitle1productstabsecondstkaveh']); ?></li>
                  <?php
                  $q++;
                }
              }
              ?>
            </ul>
            <?php if ('yes' === $settings['showbuttonproductstabsecondstkaveh']) { ?>
              <a href="<?php echo esc_url($settings['linkproductstabsecondstkaveh']); ?>"
                class="btn-show-more btn d-flex align-items-center justify-content-center ms-auto order-2 order-lg-3">
                <i class="<?php echo esc_html($settings['icon1productstabsecondstkaveh']['value']); ?> me-1"></i>
                <?php echo esc_html($settings['buttonproductstabsecondstkaveh']); ?>
              </a>
            <?php } ?>
          </div>
          <!-- End Heading -->
          <!-- Start Tab Contents -->
          <div class="tab-content">
            <?php
            $k = 1;
            if ($settings['listproductstabsecondstkaveh']) {
              foreach ($settings['listproductstabsecondstkaveh'] as $item) {
                ?>
                <!-- Start Tab Content -->
                <div id="products-<?php echo $clsid . $k; ?>" class="tab-pane fade <?php if (1 === $k) { ?>active show<?php } else {
                   } ?>">
                  <!-- Start Carousel -->
                  <div class="swiper swiper-top-selling-products swiper-button-fill"
                    data-swiper='{"watchSlidesProgress":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabsecondstkaveh']); ?>,"spaceBetween":8},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productstabsecondstkaveh']); ?>,"spaceBetween":12},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productstabsecondstkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabsecondstkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabsecondstkaveh']); ?>,"spaceBetween":30}}}'>
                    <div class="swiper-wrapper">
                      <?php
                      if ('cat' === $item['pproductstabsecondstkaveh']) {
                        ?>
                         <?php
                        // Define your custom query arguments
                        $query_args = array(
                          'post_type' => 'product',
                          'posts_per_page' => $item['productnumberproductstabsecondstkaveh'],
                          'orderby' => $item['psortproductstabsecondstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                          'order' => $item['psortiproductstabsecondstkaveh'],
                          'tax_query' => array(
                            'relation' => 'AND',
                            array(
                              'taxonomy' => 'product_cat',
                              'field' => 'term_id',
                              'terms' => $item['cat2productstabsecondstkaveh'],
                            ),
                          ),
                        );
                        // Handle specific orderby values
                        switch ($item['psortproductstabsecondstkaveh']) {
                          case '_price':
                            $query_args['meta_key'] = '_price';
                            $query_args['orderby'] = 'meta_value_num';
                            break;

                          case '_wc_average_rating':
                            $query_args['meta_key'] = '_wc_average_rating';
                            $query_args['orderby'] = 'meta_value_num';
                            break;

                          case 'total_sales':
                            $query_args['meta_key'] = 'total_sales';
                            $query_args['orderby'] = 'meta_value_num';
                            break;
                        }

                        if ("yes" === $item['kaveh_exclude_out_of_stock']) {
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                        }
                        // Get the cached query results
                        $cached_query = KavehCustomQuery::get_cached_query($query_args);
                        if ($cached_query->have_posts()):
                          while ($cached_query->have_posts()):
                            $cached_query->the_post();
                            ?>
                            <div class="swiper-slide h-auto">
                              <?php $styleproduct2 = $settings['styleproductstabsecondstkaveh']; ?>
                              <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                            </div>
                            <?php
                          endwhile;
                          wp_reset_postdata();
                        else:
                          echo 'No posts found.';
                        endif;
                        ?>
                        <?php
                        $k++;
                      } else {
                        ?>
                         <?php
                        // Define your custom query arguments
                        $query_args = array(
                          'post_type' => 'product',
                          'posts_per_page' => $item['productnumberproductstabsecondstkaveh'],
                          'orderby' => $item['psortproductstabsecondstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                          'order' => $item['psortiproductstabsecondstkaveh'],
                          'tax_query' => array(
                            'relation' => 'AND',
                          ),
                        );
                        // Handle specific orderby values
                        switch ($item['psortproductstabsecondstkaveh']) {
                          case '_price':
                            $query_args['meta_key'] = '_price';
                            $query_args['orderby'] = 'meta_value_num';
                            break;

                          case '_wc_average_rating':
                            $query_args['meta_key'] = '_wc_average_rating';
                            $query_args['orderby'] = 'meta_value_num';
                            break;

                          case 'total_sales':
                            $query_args['meta_key'] = 'total_sales';
                            $query_args['orderby'] = 'meta_value_num';
                            break;
                        }

                        if ("yes" === $item['kaveh_exclude_out_of_stock']) {
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                        }
                        // Get the cached query results
                        $cached_query = KavehCustomQuery::get_cached_query($query_args);
                        if ($cached_query->have_posts()):
                          while ($cached_query->have_posts()):
                            $cached_query->the_post();
                            ?>
                            <div class="swiper-slide h-auto">
                              <?php $styleproduct2 = $settings['styleproductstabsecondstkaveh']; ?>
                              <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                            </div>
                            <?php
                          endwhile;
                          wp_reset_postdata();
                        else:
                          echo 'No posts found.';
                        endif;
                        ?>

                        <?php
                        $k++;
                      }
                      ?>
                    </div>
                    <?php if ('yes' === $settings['showarrowsproductstabsecondstkaveh']) { ?>
                      <div class="swiper-button-next"></div>
                      <div class="swiper-button-prev"></div>
                    <?php } ?>
                  </div>
                  <!-- End Carousel -->
                </div>
                <!-- End Tab Content -->
              <?php
              }
            }
            ?>
          </div>
          <!-- End Tab Contents -->
        </div>
      </section>


    <?php } elseif ('2style' === $settings['tabstyproductstabsecondstkaveh']) { ?>
      <section class="new-products-offer">
        <div class="container">
          <div
            class="new-products-offer-heading d-flex align-items-md-center justify-content-md-between flex-column flex-md-row">
            <!-- Start Tabs -->
            <ul class="nav nav-tabs mb-0 border-0 flex-nowrap flex-md-wrap">
              <?php
              $q = 1;
              if ($settings['listproductstabsecondstkaveh']) {
                foreach ($settings['listproductstabsecondstkaveh'] as $item) {
                  ?>
                  <li class="nav-item <?php if (1 === $q) {
                    echo 'active';
                  } ?>" data-bs-toggle="tab"
                    data-bs-target="#products-<?php echo $clsid . $q; ?>" data-tab-swiper="true">
                    <?php echo esc_html($item['tabtitle1productstabsecondstkaveh']); ?></li>
                  <?php
                  $q++;
                }
              }
              ?>
            </ul>
            <!-- End Tabs -->
            <?php if ('yes' === $settings['showbuttonproductstabsecondstkaveh']) { ?>
              <a href="<?php echo esc_url($settings['linkproductstabsecondstkaveh']); ?>"
                class="btn btn-outline-dark-2 d-flex align-items-center justify-content-center mt-4 mt-md-0">
                <?php echo esc_html($settings['buttonproductstabsecondstkaveh']); ?>
                <i class="<?php echo esc_html($settings['icon1productstabsecondstkaveh']['value']); ?>"></i>
              </a>
            <?php } ?>
          </div>
          <!-- Start Tab Contents -->
          <div class="tab-content position-relative">
            <?php
            $k = 1;
            if ($settings['listproductstabsecondstkaveh']) {
              foreach ($settings['listproductstabsecondstkaveh'] as $item) {
                ?>
                <div id="products-<?php echo $clsid . $k; ?>" class="tab-pane fade <?php if (1 === $k) {
                     echo 'active show';
                   } ?>">
                  <!-- Start Products -->
                  <div class="swiper swiper-new-products-offer overflow-hidden"
                    data-swiper='{"watchSlidesProgress":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabsecondstkaveh']); ?>,"spaceBetween":8},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productstabsecondstkaveh']); ?>,"spaceBetween":12},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productstabsecondstkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabsecondstkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabsecondstkaveh']); ?>,"spaceBetween":30}}}'>
                    <div class="swiper-wrapper">
                      <?php
                      if ('cat' === $item['pproductstabsecondstkaveh']) {
                          ?>
                         <?php
                        // Define your custom query arguments
                        $query_args = array(
                          'post_type' => 'product',
                          'posts_per_page' => $item['productnumberproductstabsecondstkaveh'],
                          'orderby' => $item['psortproductstabsecondstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                          'order' => $item['psortiproductstabsecondstkaveh'],
                          'tax_query' => array(
                            'relation' => 'AND',
                            array(
                              'taxonomy' => 'product_cat',
                              'field' => 'term_id',
                              'terms' => $item['cat2productstabsecondstkaveh'],
                            ),
                          ),
                        );
                        // Handle specific orderby values
                        switch ($item['psortproductstabsecondstkaveh']) {
                          case '_price':
                            $query_args['meta_key'] = '_price';
                            $query_args['orderby'] = 'meta_value_num';
                            break;

                          case '_wc_average_rating':
                            $query_args['meta_key'] = '_wc_average_rating';
                            $query_args['orderby'] = 'meta_value_num';
                            break;

                          case 'total_sales':
                            $query_args['meta_key'] = 'total_sales';
                            $query_args['orderby'] = 'meta_value_num';
                            break;
                        }

                        if ("yes" === $item['kaveh_exclude_out_of_stock']) {
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                        }
                        // Get the cached query results
                        $cached_query = KavehCustomQuery::get_cached_query($query_args);
                        if ($cached_query->have_posts()):
                          while ($cached_query->have_posts()):
                            $cached_query->the_post();
                            ?>
                            <div class="swiper-slide h-auto">
                              <?php $styleproduct2 = $settings['styleproductstabsecondstkaveh']; ?>
                              <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                            </div>
                            <?php
                          endwhile;
                          wp_reset_postdata();
                        else:
                          echo 'No posts found.';
                        endif;
                        ?>
                      <?php
                      } else {
                        ?>
                         <?php
                        // Define your custom query arguments
                        $query_args = array(
                          'post_type' => 'product',
                          'posts_per_page' => $item['productnumberproductstabsecondstkaveh'],
                          'orderby' => $item['psortproductstabsecondstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                          'order' => $item['psortiproductstabsecondstkaveh'],
                          'tax_query' => array(
                            'relation' => 'AND',
                          ),
                        );
                        // Handle specific orderby values
                        switch ($item['psortproductstabsecondstkaveh']) {
                          case '_price':
                            $query_args['meta_key'] = '_price';
                            $query_args['orderby'] = 'meta_value_num';
                            break;

                          case '_wc_average_rating':
                            $query_args['meta_key'] = '_wc_average_rating';
                            $query_args['orderby'] = 'meta_value_num';
                            break;

                          case 'total_sales':
                            $query_args['meta_key'] = 'total_sales';
                            $query_args['orderby'] = 'meta_value_num';
                            break;
                        }

                        if ("yes" === $item['kaveh_exclude_out_of_stock']) {
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                        }
                        // Get the cached query results
                        $cached_query = KavehCustomQuery::get_cached_query($query_args);
                        if ($cached_query->have_posts()):
                          while ($cached_query->have_posts()):
                            $cached_query->the_post();
                            ?>
                            <div class="swiper-slide h-auto">
                              <?php $styleproduct2 = $settings['styleproductstabsecondstkaveh']; ?>
                              <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                            </div>
                            <?php
                          endwhile;
                          wp_reset_postdata();
                        else:
                          echo 'No posts found.';
                        endif;
                        ?>

                        <?php
                      }
                      ?>
                    </div>
                    <?php if ('yes' === $settings['showarrowsproductstabsecondstkaveh']) { ?>
                      <div class="swiper-button-next"></div>
                      <div class="swiper-button-prev"></div>
                    <?php } ?>
                  </div>
                  <!-- End Products -->
                </div>
                <?php
                $k++;

              }
            }

            ?>
            <!-- End Carousel -->
          </div>
          <!-- End Tab Contents -->
        </div>
      </section>
    <?php } ?>
    <?php
    if ('yes' !== $settings['showimagebeforeproductstabsecondstkaveh']) { ?>
      <style>
        .top-selling-products-heading .text::before {
          background: unset !important;
        }

        .top-selling-products-heading {
          padding: 17px 59px 23px 59px;
        }
      </style>
      <?php
    } ?>
    <style>
      .top-selling-products-heading .text::before {
        -webkit-background-size: contain !important;
        -moz-background-size: contain !important;
        -o-background-size: contain !important;
        background-size: contain !important;
      }
    </style>
	
    <?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }

}
