<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly


class Productstabkaveh extends Widget_Base
{

  public function get_name()
  {
    return 'productstabkaveh';
  }

  public function get_title()
  {
    return esc_html__('تب محصولات کاروسل', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['kavehelements'];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'contentproductstabkaveh',
      [
        'label' => esc_html__('تب ها', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tabstyproductstabkaveh',
      [
        'label' => esc_html__('استایل تب ها', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1style',
        'options' => [
          '1style' => esc_html__('طرح بندی اول', 'kaveh-core'),
          '2style' => esc_html__('طرح بندی دوم', 'kaveh-core'),
          '3style' => esc_html__('طرح بندی سه', 'kaveh-core'),
          '4style' => esc_html__('طرح بندی چهار', 'kaveh-core'),

        ],
      ]
    );
    $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'tabtitle1productstabkaveh',
      [
        'label' => esc_html__('عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $repeater->add_control(
      'pproductstabkaveh',
      [
        'label' => esc_html__('نمایش محصولات', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'all',
        'options' => [
          'all' => esc_html__('همه', 'kaveh-core'),
          'cat' => esc_html__('دسته بندی', 'kaveh-core'),

        ],
      ]
    );
    $repeater->add_control(
      'psortproductstabkaveh',
      [
        'label' => esc_html__('مرتب سازی محصولات براساس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'date',
        'options' => [
          'date' => esc_html__('تاریخ', 'kaveh-core'),
          '_price' => esc_html__('قیمت', 'kaveh-core'),
          '_wc_average_rating' => esc_html__('محبوب ترین', 'kaveh-core'),
          'total_sales' => esc_html__('میزان فروش', 'kaveh-core'),

        ],
      ]
    );
    $repeater->add_control(
      'psortiproductstabkaveh',
      [
        'label' => esc_html__('نوع مرتب سازی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'desc',
        'options' => [
          'asc' => esc_html__('صعودی', 'kaveh-core'),
          'desc' => esc_html__('نزولی', 'kaveh-core'),
        ],
      ]
    );
    $taboption = array();
    $orderby = 'name';
    $order = 'asc';
    $hide_empty = false;
    $cat_args = array(
      'orderby' => $orderby,
      'order' => $order,
      'hide_empty' => $hide_empty,
    );
    $product_categories = get_terms('product_cat', $cat_args);

    foreach ($product_categories as $key => $category) {
      $taboption[$category->term_id] = $category->name;
    }
    $repeater->add_control(
      'cat2productstabkaveh',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => true,
        'options' => $taboption,
        'condition' => [
          'pproductstabkaveh' => 'cat',
        ],
      ]
    );
    $repeater->add_control(
      'productnumberproductstabkaveh',
      [
        'label' => esc_html__('تعداد محصولات', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 50,
        'step' => 1,
        'default' => 8,
      ]
    );
    $this->add_control(
      'listproductstabkaveh',
      [
        'label' => esc_html__('تب ها', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tabtitle1productstabkaveh' => esc_html__('دسته بندی', 'kaveh-core'),
          ],
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'content2productstabkaveh',
      [
        'label' => esc_html__('تنظیمات نمایش', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'styleproductstabkaveh',
      [
        'label' => esc_html__('طرح بندی باکس محصول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'one',
        'options' => [
          'one' => esc_html__('طرح بندی اول', 'kaveh-core'),
          'two' => esc_html__('طرح بندی دوم', 'kaveh-core'),
          'three' => esc_html__('طرح بندی سوم', 'kaveh-core'),
          'four' => esc_html__('طرح بندی چهارم', 'kaveh-core'),
          'five' => esc_html__('طرح بندی پنجم', 'kaveh-core'),
          'six' => esc_html__('طرح بندی ششم', 'kaveh-core'),
          'seven' => esc_html__('طرح بندی هفتم', 'kaveh-core'),
          'eight' => esc_html__('طرح بندی هشتم', 'kaveh-core'),
          'nine' => esc_html__('طرح بندی نهم', 'kaveh-core'),
          'ten' => esc_html__('طرح بندی دهم', 'kaveh-core'),
          'eleven' => esc_html__('طرح بندی یازدهم', 'kaveh-core'),
          'twelve' => esc_html__('طرح بندی دوازدهم', 'kaveh-core'),
          'thirteen' => esc_html__('طرح بندی سیزدهم', 'kaveh-core'),
          'fourteen' => esc_html__('طرح بندی چهاردهم', 'kaveh-core'),
          'fifteen' => esc_html__('طرح بندی پانزدهم', 'kaveh-core'),
          'sixteen' => esc_html__('طرح بندی شانزدهم', 'kaveh-core'),

        ],
      ]
    );
    $this->add_control(
      'productcolumnproductstabkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در دسکتاپ', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 4,

      ]
    );
    $this->add_control(
      'productcolumn2productstabkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در تبلت', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 3,

      ]
    );
    $this->add_control(
      'productcolumn3productstabkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در موبایل', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 1,

      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'style1_productstabkaveh',
      [
        'label' => esc_html__('استایل تب ها', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'button_productstabkaveh',
        'label' => esc_html__('تایپوگرافی متن', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .top-products-tabs .nav-item .nav-link',
        'condition' => [
          'tabstyproductstabkaveh' => '1style',
        ],
      ]
    );
    $this->add_control(
      'buttontextcolorproductstabkaveh',
      [
        'label' => esc_html__('رنگ متن', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'tabstyproductstabkaveh' => ['1style', '2style', '3style'],
        ],
        'selectors' => [
          '{{WRAPPER}} .top-products-tabs .nav-item .nav-link' => 'color: {{VALUE}}',
          '{{WRAPPER}} .top-products-two-tabs .nav-item .nav-link' => 'color: {{VALUE}}',
          '{{WRAPPER}} .top-seller-products-two-tabs li' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttoncoloractiveproductstabkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه تب فعال', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'tabstyproductstabkaveh' => '1style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-products-tabs .nav-item .nav-link.active' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .top-products-tabs .nav-item .nav-link:hover' => 'background-color: {{VALUE}}',


        ],
      ]
    );
    $this->add_control(
      'buttontextactivecolorproductstabkaveh',
      [
        'label' => esc_html__('رنگ متن در حالت فعال', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'tabstyproductstabkaveh' => ['1style', '2style', '3style'],
        ],
        'selectors' => [
          '{{WRAPPER}} .top-products-tabs .nav-item .nav-link.active, .top-products-tabs .nav-item .nav-link:hover, .top-products-two-tabs .nav-item .nav-link.active, .top-products-two-tabs .nav-item .nav-link:hover, .top-seller-products-two-tabs li.active, .top-seller-products-two-tabs li:hover' => 'color: {{VALUE}}',

        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'buttonst2_productstabkaveh',
        'label' => esc_html__('تایپوگرافی متن', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .top-products-two-tabs .nav-item .nav-link',
        'condition' => [
          'tabstyproductstabkaveh' => '2style',
        ],
      ]
    );

    $this->add_control(
      'buttoncoloractivest2productstabkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه تب فعال', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'tabstyproductstabkaveh' => '2style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-products-two-tabs .nav-item .nav-link.active' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .top-products-two-tabs .nav-item .nav-link:hover' => 'background-color: {{VALUE}}',


        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'buttonst3_productstabkaveh',
        'label' => esc_html__('تایپوگرافی متن', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .top-seller-products-two-tabs li',
        'condition' => [
          'tabstyproductstabkaveh' => '3style',
        ],
      ]
    );

    $this->add_control(
      'buttoncoloractivest3productstabkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه تب فعال', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'tabstyproductstabkaveh' => '3style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-seller-products-two-tabs li.active, .top-seller-products-two-tabs li:hover' => 'background-color: {{VALUE}}',

        ],
      ]
    );
    $this->add_control(
      'buttonpaddingproductstabkaveh',
      [
        'label' => esc_html__('فاصله داخلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'condition' => [
          'tabstyproductstabkaveh' => '1style',
        ],
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .top-products-tabs .nav-item .nav-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'buttonradius1productstabkaveh',
      [
        'label' => esc_html__('گوشه خمیده', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'tabstyproductstabkaveh' => '1style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-products-tabs .nav-item .nav-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'buttonpadding2productstabkaveh',
      [
        'label' => esc_html__('فاصله داخلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'condition' => [
          'tabstyproductstabkaveh' => '3style',
        ],
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .top-seller-products-two-tabs li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'buttonradius2productstabkaveh',
      [
        'label' => esc_html__('گوشه خمیده', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'tabstyproductstabkaveh' => '3style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-seller-products-two-tabs li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'buttonshadowproductstabkave',
        'label' => esc_html__('سایه دکمه در حالت فعال', 'kaveh-core'),
        'condition' => [
          'tabstyproductstabkaveh' => '1style',
        ],
        'selector' => '{{WRAPPER}} .top-products-tabs .nav-item .nav-link.active,{{WRAPPER}}  .top-products-tabs .nav-item .nav-link:hover',

      ]
    );
    $this->add_control(
      'buttontextcolor4productstabkaveh',
      [
        'label' => esc_html__('رنگ متن', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'tabstyproductstabkaveh' => '4style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-products-six .nav-pills .nav-item' => 'color: {{VALUE}}',

        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'buttonst4_productstabkaveh',
        'label' => esc_html__('تایپوگرافی متن', 'kaveh-core'),
        'condition' => [
          'tabstyproductstabkaveh' => '4style',
        ],
        'selector' => '{{WRAPPER}} .top-products-six .nav-pills .nav-item',
      ]
    );
    $this->add_control(
      'buttontextactive4colorproductstabkaveh',
      [
        'label' => esc_html__('رنگ متن در حالت فعال', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'tabstyproductstabkaveh' => '4style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-products-six .nav-pills .nav-item.active' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'buttoncoloractivest4productstabkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه و تب فعال', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'tabstyproductstabkaveh' => '4style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-products-six .nav-pills .nav-item.active' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .top-products-six .nav-pills .nav-item::before' => 'background: {{VALUE}}',
          '{{WRAPPER}} .top-products-six .nav-pills .nav-item::after' => 'background: {{VALUE}}',
          '{{WRAPPER}} .top-products-six-wrapper::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();


  }


  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <?php if (\Elementor\Plugin::$instance->editor->is_edit_mode()): ?>

      <?php if ('1style' === $settings['tabstyproductstabkaveh']) { ?>
        <section class="top-products position-relative">
          <div class="container position-relative">
            <!-- Start Tabs -->
            <ul class="nav nav-tabs top-products-tabs d-flex align-items-center position-relative border-0">
              <?php
              $q = 1;
              if ($settings['listproductstabkaveh']) {
                foreach ($settings['listproductstabkaveh'] as $item) {
                  ?>
                  <li class="nav-item">
                    <a href="#pro-<?php echo $clsid . $q; ?>" class="nav-link <?php if (1 === $q) {
                           echo 'active';
                         } ?>" data-bs-toggle="tab"> <?php echo esc_html($item['tabtitle1productstabkaveh']); ?></a>
                  </li>
                  <?php
                  $q++;
                }
              }
              ?>
            </ul>
            <!-- End Tabs -->
            <!-- Start Tab Content -->
            <div class="tab-content">
              <?php
              $k = 1;
              if ($settings['listproductstabkaveh']) {
                foreach ($settings['listproductstabkaveh'] as $item) {
                  ?>
                  <div id="pro-<?php echo $clsid . $k; ?>" class="tab-pane fade <?php if (1 === $k) {
                         echo 'active show';
                       } ?>">
                    <!-- Start Products -->
                    <div class="swiper swiper-products"
                      data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabkaveh']); ?>,"spaceBetween":4},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabkaveh']); ?>,"spaceBetween":14},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productstabkaveh']); ?>,"spaceBetween":14},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabkaveh']); ?>,"spaceBetween":31}}}'>
                      <div class="swiper-wrapper">
                        <?php
                        if ('cat' === $item['pproductstabkaveh']) {
                          ?>
                          <?php
                          // Define your custom query arguments
                          $query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $item['productnumberproductstabkaveh'],
                            'orderby' => $item['psortproductstabkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                            'order' => $item['psortiproductstabkaveh'],
                            'tax_query' => array(
                              'relation' => 'AND',
                              array(
                                'taxonomy' => 'product_cat',
                                'field' => 'term_id',
                                'terms' => $item['cat2productstabkaveh'],
                              ),
                            ),
                          );
                          // Handle specific orderby values
                          switch ($item['psortproductstabkaveh']) {
                            case '_price':
                              $query_args['meta_key'] = '_price';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case '_wc_average_rating':
                              $query_args['meta_key'] = '_wc_average_rating';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case 'total_sales':
                              $query_args['meta_key'] = 'total_sales';
                              $query_args['orderby'] = 'meta_value_num';
                              break;
                          }
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                          // Get the cached query results
                          $cached_query = KavehCustomQuery::get_cached_query($query_args);
                          if ($cached_query->have_posts()):
                            while ($cached_query->have_posts()):
                              $cached_query->the_post();
                              ?>
                              <div class="swiper-slide h-auto">
                                <?php $styleproduct2 = $settings['styleproductstabkaveh']; ?>
                                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                              </div>
                              <?php
                            endwhile;
                            wp_reset_postdata();
                          else:
                            echo 'No posts found.';
                          endif;
                          ?>

                        </div>
                        <div class="swiper-button-next d-none"></div>
                        <div class="swiper-button-prev d-none"></div>
                      </div>
                      <!-- End Products -->
                    </div>
                    <?php
                        } else {
                         ?>
                         <?php
                          // Define your custom query arguments
                          $query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $item['productnumberproductstabkaveh'],
                            'orderby' => $item['psortproductstabkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                            'order' => $item['psortiproductstabkaveh'],
                            'tax_query' => array(
                              'relation' => 'AND',
                            ),
                          );
                          // Handle specific orderby values
                          switch ($item['psortproductstabkaveh']) {
                            case '_price':
                              $query_args['meta_key'] = '_price';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case '_wc_average_rating':
                              $query_args['meta_key'] = '_wc_average_rating';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case 'total_sales':
                              $query_args['meta_key'] = 'total_sales';
                              $query_args['orderby'] = 'meta_value_num';
                              break;
                          }
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                          // Get the cached query results
                          $cached_query = KavehCustomQuery::get_cached_query($query_args);
                          if ($cached_query->have_posts()):
                            while ($cached_query->have_posts()):
                              $cached_query->the_post();
                              ?>
                              <div class="swiper-slide h-auto">
                                <?php $styleproduct2 = $settings['styleproductstabkaveh']; ?>
                                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                              </div>
                              <?php
                            endwhile;
                            wp_reset_postdata();
                          else:
                            echo 'No posts found.';
                          endif;
                          ?>
                  </div>
                  <div class="swiper-button-next d-none"></div>
                  <div class="swiper-button-prev d-none"></div>
                </div>
                <!-- End Products -->
                </div>
                <?php

                        }
                        $k++;
                }
              }

              ?>
          </div>
          <!-- End Tab Content -->
          </div>
        </section>
      <?php } elseif ('2style' === $settings['tabstyproductstabkaveh']) { ?>
        <section class="top-products-two">
          <div class="container">
            <!-- Start Tabs -->
            <ul class="nav nav-tab top-products-two-tabs d-flex border-bottom-0">
              <?php
              $q = 1;
              if ($settings['listproductstabkaveh']) {
                foreach ($settings['listproductstabkaveh'] as $item) {
                  ?>
                  <li class="nav-item">
                    <a href="#pro-<?php echo $clsid . $q; ?>" class="nav-link <?php if (1 === $q) { ?>active <?php } ?>"
                      data-bs-toggle="tab"> <?php echo esc_html($item['tabtitle1productstabkaveh']); ?></a>
                  </li>
                  <?php
                  $q++;
                }
              }
              ?>
            </ul>
            <!-- End Tabs -->
            <!-- Start Tab Content -->
            <div class="top-products-two-wrapper position-relative">
              <div class="tab-content">
                <?php
                $s = 1;
                if ($settings['listproductstabkaveh']) {
                  foreach ($settings['listproductstabkaveh'] as $item) {
                    ?>
                    <div id="pro-<?php echo $clsid . $s; ?>" class="tab-pane fade <?php if (1 == $s) { ?>active show<?php } ?>">
                      <div class="swiper swiper-top-products-two overflow-hidden"
                        data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabkaveh']); ?>,"spaceBetween":4},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabkaveh']); ?>,"spaceBetween":14},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productstabkaveh']); ?>,"spaceBetween":14},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabkaveh']); ?>,"spaceBetween":31}}}'>
                        <div class="swiper-wrapper">
                          <?php
                          if ('cat' === $item['pproductstabkaveh']) {
                            ?>
                            <?php
                          // Define your custom query arguments
                          $query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $item['productnumberproductstabkaveh'],
                            'orderby' => $item['psortproductstabkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                            'order' => $item['psortiproductstabkaveh'],
                            'tax_query' => array(
                              'relation' => 'AND',
                              array(
                                'taxonomy' => 'product_cat',
                                'field' => 'term_id',
                                'terms' => $item['cat2productstabkaveh'],
                              ),
                            ),
                          );
                          // Handle specific orderby values
                          switch ($item['psortproductstabkaveh']) {
                            case '_price':
                              $query_args['meta_key'] = '_price';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case '_wc_average_rating':
                              $query_args['meta_key'] = '_wc_average_rating';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case 'total_sales':
                              $query_args['meta_key'] = 'total_sales';
                              $query_args['orderby'] = 'meta_value_num';
                              break;
                          }
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                          // Get the cached query results
                          $cached_query = KavehCustomQuery::get_cached_query($query_args);
                          if ($cached_query->have_posts()):
                            while ($cached_query->have_posts()):
                              $cached_query->the_post();
                              ?>
                              <div class="swiper-slide h-auto">
                                <?php $styleproduct2 = $settings['styleproductstabkaveh']; ?>
                                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                              </div>
                              <?php
                            endwhile;
                            wp_reset_postdata();
                          else:
                            echo 'No posts found.';
                          endif;
                          ?>
                            <?php
                          } else {
                            ?>
                            <?php
                          // Define your custom query arguments
                          $query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $item['productnumberproductstabkaveh'],
                            'orderby' => $item['psortproductstabkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                            'order' => $item['psortiproductstabkaveh'],
                            'tax_query' => array(
                              'relation' => 'AND',
                            ),
                          );
                          // Handle specific orderby values
                          switch ($item['psortproductstabkaveh']) {
                            case '_price':
                              $query_args['meta_key'] = '_price';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case '_wc_average_rating':
                              $query_args['meta_key'] = '_wc_average_rating';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case 'total_sales':
                              $query_args['meta_key'] = 'total_sales';
                              $query_args['orderby'] = 'meta_value_num';
                              break;
                          }
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                          // Get the cached query results
                          $cached_query = KavehCustomQuery::get_cached_query($query_args);
                          if ($cached_query->have_posts()):
                            while ($cached_query->have_posts()):
                              $cached_query->the_post();
                              ?>
                              <div class="swiper-slide h-auto">
                                <?php $styleproduct2 = $settings['styleproductstabkaveh']; ?>
                                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                              </div>
                              <?php
                            endwhile;
                            wp_reset_postdata();
                          else:
                            echo 'No posts found.';
                          endif;
                          ?>
                            <!-- End Tab Content -->
                            <?php
                          }
                          ?>
                        </div>
                      </div>
                    </div>
                    <?php
                    $s++;
                  }
                }

                ?>
              </div>
            </div>
          </div>
        </section>
      <?php } elseif ('3style' === $settings['tabstyproductstabkaveh']) { ?>
        <section class="top-seller-products-two">
          <div class="container">
            <!-- Strat Tabs -->
            <ul class="top-seller-products-two-tabs nav nav-pills justify-content-center">
              <?php
              $q = 1;
              if ($settings['listproductstabkaveh']) {
                foreach ($settings['listproductstabkaveh'] as $item) {
                  ?>
                  <li data-bs-toggle="pill" data-bs-target="#top-seller-products-two-<?php echo $clsid . $q; ?>"
                    class="<?php if (1 === $q) { ?>active <?php } ?>"> <?php echo esc_html($item['tabtitle1productstabkaveh']); ?>
                  </li>
                  <?php
                  $q++;
                }
              }
              ?>
            </ul>
            <!-- End Tabs -->
            <!-- Start Tab Content -->
            <div class="tab-content">
              <?php
              $k = 1;
              if ($settings['listproductstabkaveh']) {
                foreach ($settings['listproductstabkaveh'] as $item) {
                  ?>
                  <div id="top-seller-products-two-<?php echo $clsid . $k; ?>"
                    class="tab-pane fade <?php if (1 === $k) { ?>active show<?php } ?>">
                    <div class="swiper swiper-products swiper-shadow overflow-hidden"
                      data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabkaveh']); ?>,"spaceBetween":4},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabkaveh']); ?>,"spaceBetween":14},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productstabkaveh']); ?>,"spaceBetween":14},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabkaveh']); ?>,"spaceBetween":31}}}'>
                      <div class="swiper-wrapper">
                        <?php
                        if ('cat' === $item['pproductstabkaveh']) {
                          ?>
                         <?php
                          // Define your custom query arguments
                          $query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $item['productnumberproductstabkaveh'],
                            'orderby' => $item['psortproductstabkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                            'order' => $item['psortiproductstabkaveh'],
                            'tax_query' => array(
                              'relation' => 'AND',
                              array(
                                'taxonomy' => 'product_cat',
                                'field' => 'term_id',
                                'terms' => $item['cat2productstabkaveh'],
                              ),
                            ),
                          );
                          // Handle specific orderby values
                          switch ($item['psortproductstabkaveh']) {
                            case '_price':
                              $query_args['meta_key'] = '_price';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case '_wc_average_rating':
                              $query_args['meta_key'] = '_wc_average_rating';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case 'total_sales':
                              $query_args['meta_key'] = 'total_sales';
                              $query_args['orderby'] = 'meta_value_num';
                              break;
                          }
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                          // Get the cached query results
                          $cached_query = KavehCustomQuery::get_cached_query($query_args);
                          if ($cached_query->have_posts()):
                            while ($cached_query->have_posts()):
                              $cached_query->the_post();
                              ?>
                              <div class="swiper-slide h-auto">
                                <?php $styleproduct2 = $settings['styleproductstabkaveh']; ?>
                                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                              </div>
                              <?php
                            endwhile;
                            wp_reset_postdata();
                          else:
                            echo 'No posts found.';
                          endif;
                          ?>
                          <?php
                        } else {
                        
                          ?>
                          <?php
                          // Define your custom query arguments
                          $query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $item['productnumberproductstabkaveh'],
                            'orderby' => $item['psortproductstabkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                            'order' => $item['psortiproductstabkaveh'],
                            'tax_query' => array(
                              'relation' => 'AND',
                            ),
                          );
                          // Handle specific orderby values
                          switch ($item['psortproductstabkaveh']) {
                            case '_price':
                              $query_args['meta_key'] = '_price';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case '_wc_average_rating':
                              $query_args['meta_key'] = '_wc_average_rating';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case 'total_sales':
                              $query_args['meta_key'] = 'total_sales';
                              $query_args['orderby'] = 'meta_value_num';
                              break;
                          }
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                          // Get the cached query results
                          $cached_query = KavehCustomQuery::get_cached_query($query_args);
                          if ($cached_query->have_posts()):
                            while ($cached_query->have_posts()):
                              $cached_query->the_post();
                              ?>
                              <div class="swiper-slide h-auto">
                                <?php $styleproduct2 = $settings['styleproductstabkaveh']; ?>
                                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                              </div>
                              <?php
                            endwhile;
                            wp_reset_postdata();
                          else:
                            echo 'No posts found.';
                          endif;
                          ?>
                          <?php
                        }
                        ?>
                      </div>
                      <div class="swiper-button-next d-none"></div>
                      <div class="swiper-button-prev d-none"></div>
                    </div>
                  </div>
                  <?php
                  $k++;
                }
              }

              ?>
            </div>
            <!-- End Tab Content -->
          </div>
        </section>
      <?php } elseif ('4style' === $settings['tabstyproductstabkaveh']) { ?>
        <section class="top-products-six <?php if ('gray' === $settings['tabcolorproductstabkaveh']) { ?>gray<?php } ?>">
          <div class="container">
            <!-- Start Tabs -->
            <ul class="nav nav-pills justify-content-center">
              <?php
              $q = 1;
              if ($settings['listproductstabkaveh']) {
                foreach ($settings['listproductstabkaveh'] as $item) {
                  ?>
                  <li class="nav-item <?php if (1 === $q) { ?>active <?php } ?>" data-bs-toggle="pill" data-bs-target="#top-products-six-<?php if ('gray' === $settings['tabcolorproductstabkaveh']) { ?>gray-<?php }
                         echo $clsid . $q; ?>">
                    <?php echo esc_html($item['tabtitle1productstabkaveh']); ?>
                  </li>
                  <?php
                  $q++;
                }
              }
              ?>
            </ul>
            <!-- End Tabs -->
            <div class="top-products-six-wrapper position-relative">
              <!-- Start Tab Content -->
              <div class="tab-content">
                <?php
                $k = 1;
                if ($settings['listproductstabkaveh']) {
                  foreach ($settings['listproductstabkaveh'] as $item) {
                    ?>
                    <div
                      id="top-products-six-<?php if ('gray' === $settings['tabcolorproductstabkaveh']) { ?>gray-<?php } ?><?php echo $clsid . $k; ?>"
                      class="tab-pane fade <?php if (1 === $k) { ?>active show<?php } ?>">
                      <div class="swiper swiper-products"
                        data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabkaveh']); ?>,"spaceBetween":4},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabkaveh']); ?>,"spaceBetween":14},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productstabkaveh']); ?>,"spaceBetween":14},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabkaveh']); ?>,"spaceBetween":31}}}'>
                        <div class="swiper-wrapper">
                          <?php
                          if ('cat' === $item['pproductstabkaveh']) {
                            ?>
                              <?php
                          // Define your custom query arguments
                          $query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $item['productnumberproductstabkaveh'],
                            'orderby' => $item['psortproductstabkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                            'order' => $item['psortiproductstabkaveh'],
                            'tax_query' => array(
                              'relation' => 'AND',
                              array(
                                'taxonomy' => 'product_cat',
                                'field' => 'term_id',
                                'terms' => $item['cat2productstabkaveh'],
                              ),
                            ),
                          );
                          // Handle specific orderby values
                          switch ($item['psortproductstabkaveh']) {
                            case '_price':
                              $query_args['meta_key'] = '_price';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case '_wc_average_rating':
                              $query_args['meta_key'] = '_wc_average_rating';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case 'total_sales':
                              $query_args['meta_key'] = 'total_sales';
                              $query_args['orderby'] = 'meta_value_num';
                              break;
                          }
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                          // Get the cached query results
                          $cached_query = KavehCustomQuery::get_cached_query($query_args);
                          if ($cached_query->have_posts()):
                            while ($cached_query->have_posts()):
                              $cached_query->the_post();
                              ?>
                              <div class="swiper-slide h-auto">
                                <?php $styleproduct2 = $settings['styleproductstabkaveh']; ?>
                                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                              </div>
                              <?php
                            endwhile;
                            wp_reset_postdata();
                          else:
                            echo 'No posts found.';
                          endif;
                          ?>

                            <?php
                          } else {
                            ?>
                            <?php
                          // Define your custom query arguments
                          $query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $item['productnumberproductstabkaveh'],
                            'orderby' => $item['psortproductstabkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                            'order' => $item['psortiproductstabkaveh'],
                            'tax_query' => array(
                              'relation' => 'AND',
                            ),
                          );
                          // Handle specific orderby values
                          switch ($item['psortproductstabkaveh']) {
                            case '_price':
                              $query_args['meta_key'] = '_price';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case '_wc_average_rating':
                              $query_args['meta_key'] = '_wc_average_rating';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case 'total_sales':
                              $query_args['meta_key'] = 'total_sales';
                              $query_args['orderby'] = 'meta_value_num';
                              break;
                          }
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                          // Get the cached query results
                          $cached_query = KavehCustomQuery::get_cached_query($query_args);
                          if ($cached_query->have_posts()):
                            while ($cached_query->have_posts()):
                              $cached_query->the_post();
                              ?>
                              <div class="swiper-slide h-auto">
                                <?php $styleproduct2 = $settings['styleproductstabkaveh']; ?>
                                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                              </div>
                              <?php
                            endwhile;
                            wp_reset_postdata();
                          else:
                            echo 'No posts found.';
                          endif;
                          ?>
                            <?php
                          }
                          ?>
                        </div>
                        <div class="swiper-button-next d-none"></div>
                        <div class="swiper-button-prev d-none"></div>
                      </div>
                    </div>
                    <?php
                    $k++;
                  }
                }

                ?>
              </div>
              <!-- End Tab Content -->
            </div>
          </div>
        </section>
      <?php } ?>
      <?php do_action('kelementor_inline_scripts'); ?>

    <?php else: ?>

      <div class="kel-widget">

        <div class="skeleton-display">
          <?php if ('1style' === $settings['tabstyproductstabkaveh']) { ?>
            <section class="top-products position-relative">
              <div class="container position-relative">
                <!-- Start Tabs -->
                <ul class="nav nav-tabs top-products-tabs d-flex align-items-center position-relative border-0">
                  <?php
                  $q = 1;
                  if ($settings['listproductstabkaveh']) {
                    foreach ($settings['listproductstabkaveh'] as $item) {
                      ?>
                      <li class="nav-item">
                        <a href="#pro-<?php echo $clsid . $q; ?>" class="nav-link <?php if (1 === $q) {
                               echo 'active';
                             } ?>" data-bs-toggle="tab">
                          <?php echo esc_html($item['tabtitle1productstabkaveh']); ?></a>
                      </li>
                      <?php
                      $q++;
                    }
                  }
                  ?>
                </ul>
                <!-- End Tabs -->
                <!-- Start Tab Content -->
                <div class="tab-content">
                  <?php if (wp_is_mobile()): ?>
                    <div class="skeleton-loader">
                      <div class="skeleton-header"></div>
                      <div class="skeleton-content"></div>
                      <div class="skeleton-p"></div>
                      <div class="skeleton-p"></div>
                      <div class="skeleton-footer"></div>
                    </div>
                  <?php else: ?>
                    <div class="row">
                      <div class="col">
                        <div class="skeleton-loader">
                          <div class="skeleton-header"></div>
                          <div class="skeleton-content"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-footer"></div>
                        </div>
                      </div>
                      <div class="col">
                        <div class="skeleton-loader">
                          <div class="skeleton-header"></div>
                          <div class="skeleton-content"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-footer"></div>
                        </div>
                      </div>
                      <div class="col">
                        <div class="skeleton-loader">
                          <div class="skeleton-header"></div>
                          <div class="skeleton-content"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-footer"></div>
                        </div>
                      </div>
                      <div class="col">
                        <div class="skeleton-loader">
                          <div class="skeleton-header"></div>
                          <div class="skeleton-content"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-footer"></div>
                        </div>
                      </div>

                    </div>
                  <?php endif; ?>
                </div>
                <!-- End Tab Content -->
              </div>
            </section>
          <?php } elseif ('2style' === $settings['tabstyproductstabkaveh']) { ?>
            <section class="top-products-two">
              <div class="container">
                <!-- Start Tabs -->
                <ul class="nav nav-tab top-products-two-tabs d-flex border-bottom-0">
                  <?php
                  $q = 1;
                  if ($settings['listproductstabkaveh']) {
                    foreach ($settings['listproductstabkaveh'] as $item) {
                      ?>
                      <li class="nav-item">
                        <a href="#pro-<?php echo $clsid . $q; ?>" class="nav-link <?php if (1 === $q) { ?>active <?php } ?>"
                          data-bs-toggle="tab"> <?php echo esc_html($item['tabtitle1productstabkaveh']); ?></a>
                      </li>
                      <?php
                      $q++;
                    }
                  }
                  ?>
                </ul>
                <!-- End Tabs -->
                <!-- Start Tab Content -->
                <div class="top-products-two-wrapper position-relative">
                  <?php if (wp_is_mobile()): ?>
                    <div class="skeleton-loader">
                      <div class="skeleton-header"></div>
                      <div class="skeleton-content"></div>
                      <div class="skeleton-p"></div>
                      <div class="skeleton-p"></div>
                      <div class="skeleton-footer"></div>
                    </div>
                  <?php else: ?>
                    <div class="row">
                      <div class="col">
                        <div class="skeleton-loader">
                          <div class="skeleton-header"></div>
                          <div class="skeleton-content"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-footer"></div>
                        </div>
                      </div>
                      <div class="col">
                        <div class="skeleton-loader">
                          <div class="skeleton-header"></div>
                          <div class="skeleton-content"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-footer"></div>
                        </div>
                      </div>
                      <div class="col">
                        <div class="skeleton-loader">
                          <div class="skeleton-header"></div>
                          <div class="skeleton-content"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-footer"></div>
                        </div>
                      </div>
                      <div class="col">
                        <div class="skeleton-loader">
                          <div class="skeleton-header"></div>
                          <div class="skeleton-content"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-footer"></div>
                        </div>
                      </div>

                    </div>
                  <?php endif; ?>
                </div>
              </div>
            </section>
          <?php } elseif ('3style' === $settings['tabstyproductstabkaveh']) { ?>
            <section class="top-seller-products-two">
              <div class="container">
                <!-- Strat Tabs -->
                <ul class="top-seller-products-two-tabs nav nav-pills justify-content-center">
                  <?php
                  $q = 1;
                  if ($settings['listproductstabkaveh']) {
                    foreach ($settings['listproductstabkaveh'] as $item) {
                      ?>
                      <li data-bs-toggle="pill" data-bs-target="#top-seller-products-two-<?php echo $clsid . $q; ?>"
                        class="<?php if (1 === $q) { ?>active <?php } ?>">
                        <?php echo esc_html($item['tabtitle1productstabkaveh']); ?>
                      </li>
                      <?php
                      $q++;
                    }
                  }
                  ?>
                </ul>
                <!-- End Tabs -->
                <!-- Start Tab Content -->
                <?php if (wp_is_mobile()): ?>
                  <div class="skeleton-loader">
                    <div class="skeleton-header"></div>
                    <div class="skeleton-content"></div>
                    <div class="skeleton-p"></div>
                    <div class="skeleton-p"></div>
                    <div class="skeleton-footer"></div>
                  </div>
                <?php else: ?>
                  <div class="row">
                    <div class="col">
                      <div class="skeleton-loader">
                        <div class="skeleton-header"></div>
                        <div class="skeleton-content"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-footer"></div>
                      </div>
                    </div>
                    <div class="col">
                      <div class="skeleton-loader">
                        <div class="skeleton-header"></div>
                        <div class="skeleton-content"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-footer"></div>
                      </div>
                    </div>
                    <div class="col">
                      <div class="skeleton-loader">
                        <div class="skeleton-header"></div>
                        <div class="skeleton-content"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-footer"></div>
                      </div>
                    </div>
                    <div class="col">
                      <div class="skeleton-loader">
                        <div class="skeleton-header"></div>
                        <div class="skeleton-content"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-p"></div>
                        <div class="skeleton-footer"></div>
                      </div>
                    </div>

                  </div>
                <?php endif; ?>
                <!-- End Tab Content -->
              </div>
            </section>
          <?php } elseif ('4style' === $settings['tabstyproductstabkaveh']) { ?>
            <section class="top-products-six <?php if ('gray' === $settings['tabcolorproductstabkaveh']) { ?>gray<?php } ?>">
              <div class="container">
                <!-- Start Tabs -->
                <ul class="nav nav-pills justify-content-center">
                  <?php
                  $q = 1;
                  if ($settings['listproductstabkaveh']) {
                    foreach ($settings['listproductstabkaveh'] as $item) {
                      ?>
                      <li class="nav-item <?php if (1 === $q) { ?>active <?php } ?>" data-bs-toggle="pill" data-bs-target="#top-products-six-<?php if ('gray' === $settings['tabcolorproductstabkaveh']) { ?>gray-<?php }
                             echo $clsid . $q; ?>">
                        <?php echo esc_html($item['tabtitle1productstabkaveh']); ?>
                      </li>
                      <?php
                      $q++;
                    }
                  }
                  ?>
                </ul>
                <!-- End Tabs -->
                <div class="top-products-six-wrapper position-relative">
                  <!-- Start Tab Content -->
                  <?php if (wp_is_mobile()): ?>
                    <div class="row bg-white position-relative rounded p-4">
                      <div class="col">
                        <div class="skeleton-loader">
                          <div class="skeleton-header"></div>
                          <div class="skeleton-content"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-footer"></div>
                        </div>
                      </div>
                    </div>
                  <?php else: ?>
                    <div class="row bg-white position-relative rounded p-4">
                      <div class="col">
                        <div class="skeleton-loader">
                          <div class="skeleton-header"></div>
                          <div class="skeleton-content"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-footer"></div>
                        </div>
                      </div>
                      <div class="col">
                        <div class="skeleton-loader">
                          <div class="skeleton-header"></div>
                          <div class="skeleton-content"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-footer"></div>
                        </div>
                      </div>
                      <div class="col">
                        <div class="skeleton-loader">
                          <div class="skeleton-header"></div>
                          <div class="skeleton-content"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-footer"></div>
                        </div>
                      </div>
                      <div class="col">
                        <div class="skeleton-loader">
                          <div class="skeleton-header"></div>
                          <div class="skeleton-content"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-p"></div>
                          <div class="skeleton-footer"></div>
                        </div>
                      </div>

                    </div>
                  <?php endif; ?>
                  <!-- End Tab Content -->
                </div>
              </div>
            </section>
          <?php } ?>

        </div>


        <div class="kel-content" style="display:none">
          <?php if ('1style' === $settings['tabstyproductstabkaveh']) { ?>
            <section class="top-products position-relative">
              <div class="container position-relative">
                <!-- Start Tabs -->
                <ul class="nav nav-tabs top-products-tabs d-flex align-items-center position-relative border-0">
                  <?php
                  $q = 1;
                  if ($settings['listproductstabkaveh']) {
                    foreach ($settings['listproductstabkaveh'] as $item) {
                      ?>
                      <li class="nav-item">
                        <a href="#pro-<?php echo $clsid . $q; ?>" class="nav-link <?php if (1 === $q) {
                               echo 'active';
                             } ?>" data-bs-toggle="tab">
                          <?php echo esc_html($item['tabtitle1productstabkaveh']); ?></a>
                      </li>
                      <?php
                      $q++;
                    }
                  }
                  ?>
                </ul>
                <!-- End Tabs -->
                <!-- Start Tab Content -->
                <div class="tab-content">
                  <?php
                  $k = 1;
                  if ($settings['listproductstabkaveh']) {
                    foreach ($settings['listproductstabkaveh'] as $item) {
                      ?>
                      <div id="pro-<?php echo $clsid . $k; ?>" class="tab-pane fade <?php if (1 === $k) {
                             echo 'active show';
                           } ?>">
                        <!-- Start Products -->
                        <div class="swiper swiper-products"
                          data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabkaveh']); ?>,"spaceBetween":4},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabkaveh']); ?>,"spaceBetween":14},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productstabkaveh']); ?>,"spaceBetween":14},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabkaveh']); ?>,"spaceBetween":31}}}'>
                          <div class="swiper-wrapper">
                            <?php
                            if ('cat' === $item['pproductstabkaveh']) {
                              ?>
                          <?php
                          // Define your custom query arguments
                          $query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $item['productnumberproductstabkaveh'],
                            'orderby' => $item['psortproductstabkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                            'order' => $item['psortiproductstabkaveh'],
                            'tax_query' => array(
                              'relation' => 'AND',
                              array(
                                'taxonomy' => 'product_cat',
                                'field' => 'term_id',
                                'terms' => $item['cat2productstabkaveh'],
                              ),
                            ),
                          );
                          // Handle specific orderby values
                          switch ($item['psortproductstabkaveh']) {
                            case '_price':
                              $query_args['meta_key'] = '_price';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case '_wc_average_rating':
                              $query_args['meta_key'] = '_wc_average_rating';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case 'total_sales':
                              $query_args['meta_key'] = 'total_sales';
                              $query_args['orderby'] = 'meta_value_num';
                              break;
                          }
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                          // Get the cached query results
                          $cached_query = KavehCustomQuery::get_cached_query($query_args);
                          if ($cached_query->have_posts()):
                            while ($cached_query->have_posts()):
                              $cached_query->the_post();
                              ?>
                              <div class="swiper-slide h-auto">
                                <?php $styleproduct2 = $settings['styleproductstabkaveh']; ?>
                                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                              </div>
                              <?php
                            endwhile;
                            wp_reset_postdata();
                          else:
                            echo 'No posts found.';
                          endif;
                          ?>
                            </div>
                            <div class="swiper-button-next d-none"></div>
                            <div class="swiper-button-prev d-none"></div>
                          </div>
                          <!-- End Products -->
                        </div>
                        <?php
                            } else {

                              ?>
                              <?php
                          // Define your custom query arguments
                          $query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $item['productnumberproductstabkaveh'],
                            'orderby' => $item['psortproductstabkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                            'order' => $item['psortiproductstabkaveh'],
                            'tax_query' => array(
                              'relation' => 'AND',
                            ),
                          );
                          // Handle specific orderby values
                          switch ($item['psortproductstabkaveh']) {
                            case '_price':
                              $query_args['meta_key'] = '_price';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case '_wc_average_rating':
                              $query_args['meta_key'] = '_wc_average_rating';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case 'total_sales':
                              $query_args['meta_key'] = 'total_sales';
                              $query_args['orderby'] = 'meta_value_num';
                              break;
                          }
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                          // Get the cached query results
                          $cached_query = KavehCustomQuery::get_cached_query($query_args);
                          if ($cached_query->have_posts()):
                            while ($cached_query->have_posts()):
                              $cached_query->the_post();
                              ?>
                              <div class="swiper-slide h-auto">
                                <?php $styleproduct2 = $settings['styleproductstabkaveh']; ?>
                                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                              </div>
                              <?php
                            endwhile;
                            wp_reset_postdata();
                          else:
                            echo 'No posts found.';
                          endif;
                          ?>
                      </div>
                      <div class="swiper-button-next d-none"></div>
                      <div class="swiper-button-prev d-none"></div>
                    </div>
                    <!-- End Products -->
                </div>
                <?php

                            }
                            $k++;
                    }
                  }

                  ?>
        </div>
        <!-- End Tab Content -->
        </div>
        </section>
      <?php } elseif ('2style' === $settings['tabstyproductstabkaveh']) { ?>
        <section class="top-products-two">
          <div class="container">
            <!-- Start Tabs -->
            <ul class="nav nav-tab top-products-two-tabs d-flex border-bottom-0">
              <?php
              $q = 1;
              if ($settings['listproductstabkaveh']) {
                foreach ($settings['listproductstabkaveh'] as $item) {
                  ?>
                  <li class="nav-item">
                    <a href="#pro-<?php echo $clsid . $q; ?>" class="nav-link <?php if (1 === $q) { ?>active <?php } ?>"
                      data-bs-toggle="tab"> <?php echo esc_html($item['tabtitle1productstabkaveh']); ?></a>
                  </li>
                  <?php
                  $q++;
                }
              }
              ?>
            </ul>
            <!-- End Tabs -->
            <!-- Start Tab Content -->
            <div class="top-products-two-wrapper position-relative">
              <div class="tab-content">
                <?php
                $s = 1;
                if ($settings['listproductstabkaveh']) {
                  foreach ($settings['listproductstabkaveh'] as $item) {
                    ?>
                    <div id="pro-<?php echo $clsid . $s; ?>" class="tab-pane fade <?php if (1 == $s) { ?>active show<?php } ?>">
                      <div class="swiper swiper-top-products-two overflow-hidden"
                        data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabkaveh']); ?>,"spaceBetween":4},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabkaveh']); ?>,"spaceBetween":14},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productstabkaveh']); ?>,"spaceBetween":14},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabkaveh']); ?>,"spaceBetween":31}}}'>
                        <div class="swiper-wrapper">
                          <?php
                          if ('cat' === $item['pproductstabkaveh']) {
                            ?>
                            <?php
                          // Define your custom query arguments
                          $query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $item['productnumberproductstabkaveh'],
                            'orderby' => $item['psortproductstabkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                            'order' => $item['psortiproductstabkaveh'],
                            'tax_query' => array(
                              'relation' => 'AND',
                              array(
                                'taxonomy' => 'product_cat',
                                'field' => 'term_id',
                                'terms' => $item['cat2productstabkaveh'],
                              ),
                            ),
                          );
                          // Handle specific orderby values
                          switch ($item['psortproductstabkaveh']) {
                            case '_price':
                              $query_args['meta_key'] = '_price';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case '_wc_average_rating':
                              $query_args['meta_key'] = '_wc_average_rating';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case 'total_sales':
                              $query_args['meta_key'] = 'total_sales';
                              $query_args['orderby'] = 'meta_value_num';
                              break;
                          }
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                          // Get the cached query results
                          $cached_query = KavehCustomQuery::get_cached_query($query_args);
                          if ($cached_query->have_posts()):
                            while ($cached_query->have_posts()):
                              $cached_query->the_post();
                              ?>
                              <div class="swiper-slide h-auto">
                                <?php $styleproduct2 = $settings['styleproductstabkaveh']; ?>
                                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                              </div>
                              <?php
                            endwhile;
                            wp_reset_postdata();
                          else:
                            echo 'No posts found.';
                          endif;
                          ?>
                            <?php
                          } else {

                            ?>
                            <?php
                          // Define your custom query arguments
                          $query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $item['productnumberproductstabkaveh'],
                            'orderby' => $item['psortproductstabkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                            'order' => $item['psortiproductstabkaveh'],
                            'tax_query' => array(
                              'relation' => 'AND',
                            ),
                          );
                          // Handle specific orderby values
                          switch ($item['psortproductstabkaveh']) {
                            case '_price':
                              $query_args['meta_key'] = '_price';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case '_wc_average_rating':
                              $query_args['meta_key'] = '_wc_average_rating';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case 'total_sales':
                              $query_args['meta_key'] = 'total_sales';
                              $query_args['orderby'] = 'meta_value_num';
                              break;
                          }
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                          // Get the cached query results
                          $cached_query = KavehCustomQuery::get_cached_query($query_args);
                          if ($cached_query->have_posts()):
                            while ($cached_query->have_posts()):
                              $cached_query->the_post();
                              ?>
                              <div class="swiper-slide h-auto">
                                <?php $styleproduct2 = $settings['styleproductstabkaveh']; ?>
                                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                              </div>
                              <?php
                            endwhile;
                            wp_reset_postdata();
                          else:
                            echo 'No posts found.';
                          endif;
                          ?>
                            <!-- End Tab Content -->
                            <?php
                          }
                          ?>
                        </div>
                      </div>
                    </div>
                    <?php
                    $s++;
                  }
                }

                ?>
              </div>
            </div>
          </div>
        </section>
      <?php } elseif ('3style' === $settings['tabstyproductstabkaveh']) { ?>
        <section class="top-seller-products-two">
          <div class="container">
            <!-- Strat Tabs -->
            <ul class="top-seller-products-two-tabs nav nav-pills justify-content-center">
              <?php
              $q = 1;
              if ($settings['listproductstabkaveh']) {
                foreach ($settings['listproductstabkaveh'] as $item) {
                  ?>
                  <li data-bs-toggle="pill" data-bs-target="#top-seller-products-two-<?php echo $clsid . $q; ?>"
                    class="<?php if (1 === $q) { ?>active <?php } ?>"> <?php echo esc_html($item['tabtitle1productstabkaveh']); ?>
                  </li>
                  <?php
                  $q++;
                }
              }
              ?>
            </ul>
            <!-- End Tabs -->
            <!-- Start Tab Content -->
            <div class="tab-content">
              <?php
              $k = 1;
              if ($settings['listproductstabkaveh']) {
                foreach ($settings['listproductstabkaveh'] as $item) {
                  ?>
                  <div id="top-seller-products-two-<?php echo $clsid . $k; ?>"
                    class="tab-pane fade <?php if (1 === $k) { ?>active show<?php } ?>">
                    <div class="swiper swiper-products swiper-shadow overflow-hidden"
                      data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabkaveh']); ?>,"spaceBetween":4},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabkaveh']); ?>,"spaceBetween":14},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productstabkaveh']); ?>,"spaceBetween":14},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabkaveh']); ?>,"spaceBetween":31}}}'>
                      <div class="swiper-wrapper">
                        <?php
                        if ('cat' === $item['pproductstabkaveh']) {
                          // Define your custom query arguments
                          $query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $item['productnumberproductstabkaveh'],
                            'orderby' => $item['psortproductstabkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                            'order' => $item['psortiproductstabkaveh'],
                            'tax_query' => array(
                              'relation' => 'AND',
                              array(
                                'taxonomy' => 'product_cat',
                                'field' => 'term_id',
                                'terms' => $item['cat2productstabkaveh'],
                              ),
                            ),
                          );
                          // Handle specific orderby values
                          switch ($item['psortproductstabkaveh']) {
                            case '_price':
                              $query_args['meta_key'] = '_price';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case '_wc_average_rating':
                              $query_args['meta_key'] = '_wc_average_rating';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case 'total_sales':
                              $query_args['meta_key'] = 'total_sales';
                              $query_args['orderby'] = 'meta_value_num';
                              break;
                          }
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                          // Get the cached query results
                          $cached_query = KavehCustomQuery::get_cached_query($query_args);
                          if ($cached_query->have_posts()):
                            while ($cached_query->have_posts()):
                              $cached_query->the_post();
                              ?>
                              <div class="swiper-slide h-auto">
                                <?php $styleproduct2 = $settings['styleproductstabkaveh']; ?>
                                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                              </div>
                              <?php
                            endwhile;
                            wp_reset_postdata();
                          else:
                            echo 'No posts found.';
                          endif;
                          ?>
                          <?php
                        } else {
                          // Define your custom query arguments
                          $query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $item['productnumberproductstabkaveh'],
                            'orderby' => $item['psortproductstabkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                            'order' => $item['psortiproductstabkaveh'],
                            'tax_query' => array(
                              'relation' => 'AND',
                            ),
                          );
                          // Handle specific orderby values
                          switch ($item['psortproductstabkaveh']) {
                            case '_price':
                              $query_args['meta_key'] = '_price';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case '_wc_average_rating':
                              $query_args['meta_key'] = '_wc_average_rating';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case 'total_sales':
                              $query_args['meta_key'] = 'total_sales';
                              $query_args['orderby'] = 'meta_value_num';
                              break;
                          }
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                          // Get the cached query results
                          $cached_query = KavehCustomQuery::get_cached_query($query_args);
                          if ($cached_query->have_posts()):
                            while ($cached_query->have_posts()):
                              $cached_query->the_post();
                              ?>
                              <div class="swiper-slide h-auto">
                                <?php $styleproduct2 = $settings['styleproductstabkaveh']; ?>
                                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                              </div>
                              <?php
                            endwhile;
                            wp_reset_postdata();
                          else:
                            echo 'No posts found.';
                          endif;
                          ?>
                          <?php
                        }
                        ?>
                      </div>
                      <div class="swiper-button-next d-none"></div>
                      <div class="swiper-button-prev d-none"></div>
                    </div>
                  </div>
                  <?php
                  $k++;
                }
              }

              ?>
            </div>
            <!-- End Tab Content -->
          </div>
        </section>
      <?php } elseif ('4style' === $settings['tabstyproductstabkaveh']) { ?>
        <section class="top-products-six <?php if ('gray' === $settings['tabcolorproductstabkaveh']) { ?>gray<?php } ?>">
          <div class="container">
            <!-- Start Tabs -->
            <ul class="nav nav-pills justify-content-center">
              <?php
              $q = 1;
              if ($settings['listproductstabkaveh']) {
                foreach ($settings['listproductstabkaveh'] as $item) {
                  ?>
                  <li class="nav-item <?php if (1 === $q) { ?>active <?php } ?>" data-bs-toggle="pill" data-bs-target="#top-products-six-<?php if ('gray' === $settings['tabcolorproductstabkaveh']) { ?>gray-<?php }
                         echo $clsid . $q; ?>">
                    <?php echo esc_html($item['tabtitle1productstabkaveh']); ?>
                  </li>
                  <?php
                  $q++;
                }
              }
              ?>
            </ul>
            <!-- End Tabs -->
            <div class="top-products-six-wrapper position-relative">
              <!-- Start Tab Content -->
              <div class="tab-content">
                <?php
                $k = 1;
                if ($settings['listproductstabkaveh']) {
                  foreach ($settings['listproductstabkaveh'] as $item) {
                    ?>
                    <div
                      id="top-products-six-<?php if ('gray' === $settings['tabcolorproductstabkaveh']) { ?>gray-<?php } ?><?php echo $clsid . $k; ?>"
                      class="tab-pane fade <?php if (1 === $k) { ?>active show<?php } ?>">
                      <div class="swiper swiper-products"
                        data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabkaveh']); ?>,"spaceBetween":4},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productstabkaveh']); ?>,"spaceBetween":14},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productstabkaveh']); ?>,"spaceBetween":14},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductstabkaveh']); ?>,"spaceBetween":31}}}'>
                        <div class="swiper-wrapper">
                          <?php
                          if ('cat' === $item['pproductstabkaveh']) {

                            // Define your custom query arguments
                          $query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $item['productnumberproductstabkaveh'],
                            'orderby' => $item['psortproductstabkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                            'order' => $item['psortiproductstabkaveh'],
                            'tax_query' => array(
                              'relation' => 'AND',
                              array(
                                'taxonomy' => 'product_cat',
                                'field' => 'term_id',
                                'terms' => $item['cat2productstabkaveh'],
                              ),
                            ),
                          );
                          // Handle specific orderby values
                          switch ($item['psortproductstabkaveh']) {
                            case '_price':
                              $query_args['meta_key'] = '_price';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case '_wc_average_rating':
                              $query_args['meta_key'] = '_wc_average_rating';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case 'total_sales':
                              $query_args['meta_key'] = 'total_sales';
                              $query_args['orderby'] = 'meta_value_num';
                              break;
                          }
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                          // Get the cached query results
                          $cached_query = KavehCustomQuery::get_cached_query($query_args);
                          if ($cached_query->have_posts()):
                            while ($cached_query->have_posts()):
                              $cached_query->the_post();
                              ?>
                              <div class="swiper-slide h-auto">
                                <?php $styleproduct2 = $settings['styleproductstabkaveh']; ?>
                                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                              </div>
                              <?php
                            endwhile;
                            wp_reset_postdata();
                          else:
                            echo 'No posts found.';
                          endif;
                          ?>
                            <?php
                          } else {
                            // Define your custom query arguments
                          $query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $item['productnumberproductstabkaveh'],
                            'orderby' => $item['psortproductstabkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                            'order' => $item['psortiproductstabkaveh'],
                            'tax_query' => array(
                              'relation' => 'AND',
                            ),
                          );
                          // Handle specific orderby values
                          switch ($item['psortproductstabkaveh']) {
                            case '_price':
                              $query_args['meta_key'] = '_price';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case '_wc_average_rating':
                              $query_args['meta_key'] = '_wc_average_rating';
                              $query_args['orderby'] = 'meta_value_num';
                              break;

                            case 'total_sales':
                              $query_args['meta_key'] = 'total_sales';
                              $query_args['orderby'] = 'meta_value_num';
                              break;
                          }
                          $query_args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'name',
                            'terms' => array('outofstock'),
                            'operator' => 'NOT IN'
                          );
                          // Get the cached query results
                          $cached_query = KavehCustomQuery::get_cached_query($query_args);
                          if ($cached_query->have_posts()):
                            while ($cached_query->have_posts()):
                              $cached_query->the_post();
                              ?>
                              <div class="swiper-slide h-auto">
                                <?php $styleproduct2 = $settings['styleproductstabkaveh']; ?>
                                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                              </div>
                              <?php
                            endwhile;
                            wp_reset_postdata();
                          else:
                            echo 'No posts found.';
                          endif;
                          ?>
                            <?php
                          }
                          ?>
                        </div>
                        <div class="swiper-button-next d-none"></div>
                        <div class="swiper-button-prev d-none"></div>
                      </div>
                    </div>
                    <?php
                    $k++;
                  }
                }

                ?>
              </div>
              <!-- End Tab Content -->
            </div>
          </div>
        </section>
      <?php } ?>
      <?php do_action('kelementor_inline_scripts'); ?>

      </div>
      </div>

    <?php endif; ?>


    <?php
  }
}
