<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly


class Productstabgridkaveh extends Widget_Base
{

  public function get_name()
  {
    return 'productstabgridkaveh';
  }

  public function get_title()
  {
    return esc_html__('تب محصولات شبکه ای', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['kavehelements'];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'contentproductstabgridkaveh',
      [
        'label' => esc_html__('محتوای المان', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'tabtitle1productstabgridkaveh',
      [
        'label' => esc_html__('عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $repeater->add_control(
      'pproductstabgridkaveh',
      [
        'label' => esc_html__('نمایش محصولات', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'all',
        'options' => [
          'all' => esc_html__('همه', 'kaveh-core'),
          'cat' => esc_html__('دسته بندی', 'kaveh-core'),

        ],
      ]
    );
    $this->add_control(
      'kaveh_exclude_out_of_stock',
      [
        'label' => esc_html__('عدم نمایش محصولات ناموجود', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__('بله', 'kaveh-core'),
        'no' => esc_html__('خیر', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'kaveh_only_sales',
      [
        'label' => esc_html__('نمایش فقط تخفیف دار ها', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__('بله', 'kaveh-core'),
        'no' => esc_html__('خیر', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $repeater->add_control(
      'psortproductstabgridkaveh',
      [
        'label' => esc_html__('مرتب سازی محصولات براساس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'date',
        'options' => [
          'date' => esc_html__('تاریخ', 'kaveh-core'),
          '_price' => esc_html__('قیمت', 'kaveh-core'),
          '_wc_average_rating' => esc_html__('محبوب ترین', 'kaveh-core'),
          'total_sales' => esc_html__('میزان فروش', 'kaveh-core'),

        ],
      ]
    );
    $repeater->add_control(
      'psortiproductstabgridkaveh',
      [
        'label' => esc_html__('نوع مرتب سازی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'desc',
        'options' => [
          'asc' => esc_html__('صعودی', 'kaveh-core'),
          'desc' => esc_html__('نزولی', 'kaveh-core'),
        ],
      ]
    );
    $taboptiongrid = array();
    $orderby = 'name';
    $order = 'asc';
    $hide_empty = false;
    $cat_args = array(
      'orderby' => $orderby,
      'order' => $order,
      'hide_empty' => $hide_empty,
    );
    $product_categories = get_terms('product_cat', $cat_args);

    foreach ($product_categories as $key => $category) {
      $taboptiongrid[$category->term_id] = $category->name;
    }
    $repeater->add_control(
      'cat2productstabgridkaveh',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => true,
        'options' => $taboptiongrid,
        'condition' => [
          'pproductstabgridkaveh' => 'cat',
        ],
      ]
    );
    $repeater->add_control(
      'productnumberproductstabgridkaveh',
      [
        'label' => esc_html__('تعداد محصولات', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 100,
        'step' => 1,
        'default' => 8,
      ]
    );
    $this->add_control(
      'listproductstabgridkaveh',
      [
        'label' => esc_html__('تب ها', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tabtitle1productstabgridkaveh' => esc_html__('دسته بندی', 'kaveh-core'),
          ],
        ],
      ]
    );

    $this->add_control(
      'styleproductstabgridkaveh',
      [
        'label' => esc_html__('طرح بندی باکس محصول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'one',
        'options' => [
          'one' => esc_html__('طرح بندی اول', 'kaveh-core'),
          'two' => esc_html__('طرح بندی دوم', 'kaveh-core'),
          'three' => esc_html__('طرح بندی سوم', 'kaveh-core'),
          'four' => esc_html__('طرح بندی چهارم', 'kaveh-core'),
          'five' => esc_html__('طرح بندی پنجم', 'kaveh-core'),
          'six' => esc_html__('طرح بندی ششم', 'kaveh-core'),
          'seven' => esc_html__('طرح بندی هفتم', 'kaveh-core'),
          'eight' => esc_html__('طرح بندی هشتم', 'kaveh-core'),
          'nine' => esc_html__('طرح بندی نهم', 'kaveh-core'),
          'ten' => esc_html__('طرح بندی دهم', 'kaveh-core'),
          'eleven' => esc_html__('طرح بندی یازدهم', 'kaveh-core'),
          'twelve' => esc_html__('طرح بندی دوازدهم', 'kaveh-core'),
          'thirteen' => esc_html__('طرح بندی سیزدهم', 'kaveh-core'),
          'fourteen' => esc_html__('طرح بندی چهاردهم', 'kaveh-core'),
          'fifteen' => esc_html__('طرح بندی پانزدهم', 'kaveh-core'),
          'sixteen' => esc_html__('طرح بندی شانزدهم', 'kaveh-core'),
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'style1_productstabgridkaveh',
      [
        'label' => esc_html__('استایل تب ها', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'buttontextcolorproductstabgridkaveh',
      [
        'label' => esc_html__('رنگ متن', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-products-three-tabs .nav-item .nav-link' => 'color: {{VALUE}}',

        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'buttonst3_productstabgridkaveh',
        'label' => esc_html__('تایپوگرافی متن', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .top-products-three-tabs .nav-item .nav-link',
      ]
    );
    $this->add_control(
      'buttoncoloractivest3productstabgridkaveh',
      [
        'label' => esc_html__('رنگ پس زمینه تب فعال', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-products-three-tabs .nav-item .nav-link.active' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .top-products-three-tabs .nav-item .nav-link:hover' => 'background-color: {{VALUE}}',

        ],
      ]
    );
    $this->add_control(
      'buttontextactivecolorproductstabgridkaveh',
      [
        'label' => esc_html__('رنگ متن در حالت فعال', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .top-products-three-tabs .nav-item .nav-link.active' => 'color: {{VALUE}}',
          '{{WRAPPER}} .top-products-three-tabs .nav-item .nav-link:hover' => 'color: {{VALUE}}',


        ],
      ]
    );
    $this->add_control(
      'buttonpaddingproductstabgridkaveh',
      [
        'label' => esc_html__('فاصله داخلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .top-products-three-tabs .nav-item .nav-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'buttonradius1productstabgridkaveh',
      [
        'label' => esc_html__('گوشه خمیده', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .top-products-three-tabs .nav-item .nav-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();

  }


  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="top-products-three">
      <div class="container position-relative">
        <!-- Start Tabs -->
        <ul class="nav nav-tabs top-products-three-tabs d-flex align-items-center">
          <?php
          $q = 1;
          if ($settings['listproductstabgridkaveh']) {
            foreach ($settings['listproductstabgridkaveh'] as $item) {
              ?>
              <li class="nav-item">
                <a href="#pro-<?php echo $clsid . $q; ?>" class="nav-link <?php if (1 === $q) { ?>active <?php } else {
                     } ?>" data-bs-toggle="tab"> <?php echo esc_html($item['tabtitle1productstabgridkaveh']); ?> </a>
              </li>
              <?php
              $q++;
            }
          }
          ?>
        </ul>
        <!-- End Tabs -->
        <div class="tab-content">
          <?php
          $s = 1;
          if ($settings['listproductstabgridkaveh']) {
            foreach ($settings['listproductstabgridkaveh'] as $item) {
              ?>
              <div id="pro-<?php echo $clsid . $s; ?>" class="tab-pane fade <?php if (1 == $s) { ?>active show<?php } else {
                   } ?>">
                <!-- Start Products -->
                <div class="row row-mobile">
                  <?php
                  if ('cat' === $item['pproductstabgridkaveh']) {
                    $query_args = array(
                      'post_type' => array('product'),
'post_status' => array('publish'),
                      'posts_per_page' => $item['productnumberproductstabgridkaveh'],
                      'orderby' => $item['psortproductstabgridkaveh'] === 'date' ? 'date' : 'meta_value_num',
                      'order' => $item['psortiproductstabgridkaveh'],
                      'tax_query' => array(
                          'relation' => 'AND',
                          array(
                            'taxonomy' => 'product_cat',
                            'field' => 'term_id',
                            'terms' => $item['cat2productstabgridkaveh'],
                          ),
                      ),
                      'meta_query' => array(),  // Initialize meta_query to avoid undefined index error
                  );
                  
                  // Handle specific orderby values
                  switch ($item['psortproductstabgridkaveh']) {
                      case '_price':
                          $query_args['meta_key'] = '_price';
                          $query_args['orderby'] = 'meta_value_num';
                          break;
                  
                      case '_wc_average_rating':
                          $query_args['meta_key'] = '_wc_average_rating';
                          $query_args['orderby'] = 'meta_value_num';
                          break;
                  
                      case 'total_sales':
                          $query_args['meta_key'] = 'total_sales';
                          $query_args['orderby'] = 'meta_value_num';
                          break;
                  }
                  
                  if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                      $query_args['tax_query'][] = array(
                          'taxonomy' => 'product_visibility',
                          'field' => 'name',
                          'terms' => array('outofstock'),
                          'operator' => 'NOT IN'
                      );
                  }
                  
                  if ("yes" === $settings['kaveh_only_sales']) {
                      $query_args['meta_query'][] = WC()->query->get_meta_query();  // Ensure meta_query is an array
                      $query_args['post__in'] = array_merge(array(0), wc_get_product_ids_on_sale());
                  }

                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="col-6 col-md-4 col-lg-3 tbgrid">
                      <?php $styleproduct21 = $settings['styleproductstabgridkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct21"); ?>
                    </div>
                        <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>

                    <?php
                  } else {
                    $query_args = array(
                      'post_type' => array('product'),
'post_status' => array('publish'),
                      'posts_per_page' => $item['productnumberproductstabgridkaveh'],
                      'orderby' => $item['psortproductstabgridkaveh'] === 'date' ? 'date' : 'meta_value_num',
                      'order' => $item['psortiproductstabgridkaveh'],
                      'tax_query' => array(
                          'relation' => 'AND',
                      ),
                      'meta_query' => array(),  // Initialize meta_query to avoid undefined index error
                  );
                  
                  // Handle specific orderby values
                  switch ($item['psortproductstabgridkaveh']) {
                      case '_price':
                          $query_args['meta_key'] = '_price';
                          $query_args['orderby'] = 'meta_value_num';
                          break;
                  
                      case '_wc_average_rating':
                          $query_args['meta_key'] = '_wc_average_rating';
                          $query_args['orderby'] = 'meta_value_num';
                          break;
                  
                      case 'total_sales':
                          $query_args['meta_key'] = 'total_sales';
                          $query_args['orderby'] = 'meta_value_num';
                          break;
                  }
                  
                  if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                      $query_args['tax_query'][] = array(
                          'taxonomy' => 'product_visibility',
                          'field' => 'name',
                          'terms' => array('outofstock'),
                          'operator' => 'NOT IN'
                      );
                  }
                  
                  if ("yes" === $settings['kaveh_only_sales']) {
                      $query_args['meta_query'][] = WC()->query->get_meta_query();  // Ensure meta_query is an array
                      $query_args['post__in'] = array_merge(array(0), wc_get_product_ids_on_sale());
                  }

                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="col-6 col-md-4 col-lg-3 tbgrid">
                      <?php $styleproduct21 = $settings['styleproductstabgridkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct21"); ?>
                    </div>
                        <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                  }
                  ?>
                </div>
                <!-- End Products -->
              </div>
              <?php
              $s++;
            }
          }
          ?>
        </div>
      </div>
    </section>
    <style>
      .top-products-three-tabs .nav-item .nav-link {
        white-space: nowrap;
      }
    </style>
    <?php
  }


}
