<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productsdigistylecarouselsecondstkaveh extends Widget_Base{

  public function get_name(){
    return 'productsdigistylecarouselsecondstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل محصولات دیجی استایل سبک دو', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'عنوان المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
        $this->add_control(
          'buttonti1productsdigistylecarouselsecondstkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'پرفـــروش تریـن‌های اخــیــــــــر ', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'tagheading1productsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H2',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
    $this->add_control(
      'buttonti2productsdigistylecarouselsecondstkaveh',
      [
          'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'مشاهده همه', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'buttontilink2productsdigistylecarouselsecondstkaveh',
    [
        'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
$this->add_control(
  'showticol1productsdigistylecarouselsecondstkaveh',
  [
    'label' => esc_html__( 'نمایش ستون اول ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'yes' => esc_html__( 'بله', 'kaveh-core' ),
    'no' => esc_html__( 'خیر', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);
    $this->end_controls_section();   

      $this->start_controls_section(
        'content4productsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تنظیمات محصولات', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'kaveh_exclude_out_of_stock',
        [
          'label' => esc_html__( 'عدم نمایش محصولات ناموجود', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
  $this->add_control(
    'pproductsdigistylecarouselsecondstkaveh',
    [
      'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'all',
      'options' => [
        'all'  => esc_html__( 'همه', 'kaveh-core' ),
        'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),

      ],
    ]
    );
    $this->add_control(
      'psortproductsdigistylecarouselsecondstkaveh',
      [
        'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'date',
        'options' => [
          'date'  => esc_html__( 'تاریخ', 'kaveh-core' ),
          '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
          '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
          'total_sales'  => esc_html__( 'میزان فروش', 'kaveh-core' ),
  
        ],
      ]
      );
      $this->add_control(
        'psortiproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'desc',
          'options' => [
            'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
            'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
          ],
        ]
        );
  $options5 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $options5[$category->term_id] = $category->name;
}
$this->add_control(
    'catproductsdigistylecarouselsecondstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $options5,
      'condition' => [
        'pproductsdigistylecarouselsecondstkaveh' => 'cat',
      ],
    ]
);
$this->end_controls_section();   
$this->start_controls_section(
  'content5productsdigistylecarouselsecondstkaveh',
  [
    'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'showarrowsproductsdigistylecarouselsecondstkaveh',
  [
    'label' => esc_html__( 'نمایش جهت ها؟', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'yes' => esc_html__( 'بله', 'kaveh-core' ),
    'no' => esc_html__( 'خیر', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);
$this->add_control(
  'productnumberproductsdigistylecarouselsecondstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 50,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnproductsdigistylecarouselsecondstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.2,
    'default' => 3.2,

  ]
); 
$this->add_control(
  'productcolumn2productsdigistylecarouselsecondstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.2,
    'default' => 2.2,

  ]
);
$this->add_control(
  'productcolumn3productsdigistylecarouselsecondstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.2,
    'default' => 1.2,

  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'stylea_productsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'buttona_productsdigistylecarouselsecondstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-products-digi-right .title',
        ]
      );
      $this->add_control(
        'textabuttoncolorproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-digi-right .title' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_section();
      $this->start_controls_section(
        'styleb_productsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_productsdigistylecarouselsecondstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-products-digi .btn-more',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowproductsdigistylecarouselsecondstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-products-digi .btn-more',
        ]
      );
      $this->start_controls_tabs(
        'style_tabsproductsdigistylecarouselsecondstkaveh'
      );
    
      $this->start_controls_tab(
        'style_normal_tabproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-digi .btn-more' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-digi .btn-more' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-digi .btn-more' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderproductsdigistylecarouselsecondstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-products-digi .btn-more',
        ]
      );
      $this->add_control(
        'buttonbordersproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderproductsdigistylecarouselsecondstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-digi .btn-more' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoverproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-digi .btn-more:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-digi .btn-more:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoverproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-digi .btn-more:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverproductsdigistylecarouselsecondstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-products-digi .btn-more:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoverproductsdigistylecarouselsecondstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-digi .btn-more:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowproductsdigistylecarouselsecondstkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-products-digi .btn-more',
        ]
      );
      $this->add_control(
        'hr2productsdigistylecarouselsecondstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-digi .btn-more' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style5_productsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'استایل جهت های کاروسل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showarrowsproductsdigistylecarouselsecondstkaveh' => 'yes',

          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabsarrowproductsdigistylecarouselsecondstkaveh'
      );
    
      $this->start_controls_tab(
        'style_normal_tabarrowproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbutton1colorarrowproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-digi-left .swiper-button-next::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .top-selling-products-digi-left .swiper-button-prev::after' => 'color: {{VALUE}}',

          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorarrowproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-digi-left .swiper-button-next' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .top-selling-products-digi-left .swiper-button-prev' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 

      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabarrowproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbutton1hovercolorarrowproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-digi-left .swiper-button-next:hover::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .top-selling-products-digi-left .swiper-button-prev:hover::after' => 'color: {{VALUE}}',          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverarrowproductsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-digi-left .swiper-button-next:hover' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .top-selling-products-digi-left .swiper-button-prev:hover' => 'background-color: {{VALUE}}',

          ],
        ]
      ); 
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->end_controls_section();
      $this->start_controls_section(
        'stylebox_2productsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'استایل باکس محصولات', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'boxradi2productsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .product-fifteen' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'boxbghov2productsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه تصویر محصول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .product-fifteen .image' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'boxradi2productsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه تصویر محصول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .product-fifteen .image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'boxpercentage2productsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه درصد تخفیف', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .product-fifteen .image .offer' => 'background-color: {{VALUE}}',

          ],
        ]
      ); 
      $this->add_control(
        'boxbgpercentage2productsdigistylecarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ متن درصد تخفیف', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .product-fifteen .image .offer' => 'color: {{VALUE}} !important',

          ],
        ]
      ); 
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="top-selling-products-digi">
      <div class="container d-flex flex-column flex-md-row">
      <?php if("yes"===$settings['showticol1productsdigistylecarouselsecondstkaveh']){?>
        <!-- Start Title -->
        <div
          class="top-selling-products-digi-right d-flex flex-column align-items-center align-items-md-end w-100 mb-4 mb-md-0">
          <<?php echo  esc_attr($settings['tagheading1productsdigistylecarouselsecondstkaveh']); ?> class="title mb-0"><?php echo esc_html($settings['buttonti1productsdigistylecarouselsecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheading1productsdigistylecarouselsecondstkaveh']); ?>>
          <a href="<?php echo  esc_url($settings['buttontilink2productsdigistylecarouselsecondstkaveh']); ?>" class="btn btn-outline-dark-3 btn-more d-none d-md-block"> <?php echo  esc_html($settings['buttonti2productsdigistylecarouselsecondstkaveh']); ?></a>
        </div>
        <!-- End Title -->
        <?php }else{ ?>
        <style>
          .digi-amazing-left, .top-selling-products-digi-left {
            max-width: 100% !important;
        }
        </style>
          <?php } ?>
        <!-- Start Products -->
        <div class="top-selling-products-digi-left w-100">
          <!-- Start Carousel -->
          <div class="swiper swiper-top-selling-products-digi position-relative overflow-hidden" data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productsdigistylecarouselsecondstkaveh']); ?>,"spaceBetween":12,"slidesPerGroup":1,"centeredSlides":true},"576":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productsdigistylecarouselsecondstkaveh']); ?>,"spaceBetween":12,"slidesPerGroup":2,"centeredSlides":false},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productsdigistylecarouselsecondstkaveh']); ?>,"spaceBetween":12,"slidesPerGroup":2},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductsdigistylecarouselsecondstkaveh']); ?>,"spaceBetween":16,"slidesPerGroup":3},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductsdigistylecarouselsecondstkaveh']); ?>,"spaceBetween":20,"slidesPerGroup":3},"1400":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductsdigistylecarouselsecondstkaveh']); ?>,"spaceBetween":24,"slidesPerGroup":3}}}'>
            <div class="swiper-wrapper">

            <?php if('cat'===$settings['pproductsdigistylecarouselsecondstkaveh']){ ?>
              <?php 
                  
                  // WP_Query args
                  $q_pc2_query_args = array(
                    'post_type' => array('product'),
'post_status' => array('publish'),
                    'posts_per_page' => $settings['productnumberproductsdigistylecarouselsecondstkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $settings['catproductsdigistylecarouselsecondstkaveh'],
                      ),
                    ),
                     
                    
                  );
                  if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                    $q_pc2_query_args['meta_query'] = array(
                        array(
                            'key' => '_stock_status',
                            'value' => 'outofstock',
                            'compare' => 'NOT IN',
                        ),
                    );
                  }

                  // The Query
                  $pc2_query = new \WP_Query($q_pc2_query_args);
                  
                  // The Loop
                  if ( $pc2_query->have_posts() ) {
                    while ( $pc2_query->have_posts() ) {
                      $pc2_query->the_post(); ?>
                    <?php 
                    global $product;
                    $product = wc_get_product();
                    $product_id = $product->get_id();
                    $product_type = $product->get_type();
                    $sale_price_dates_from = $sale_price_dates_to = '';
                    $sale_price = $product->get_sale_price();
                    $normal_price = $product->get_regular_price();
                    $pr_id = get_the_ID();
                    $stocka = $product->get_stock_status();
                    ?>
              <!-- Start Slide -->
              <div class="swiper-slide h-auto">
                <div class="product-fifteen bg-white h-100">
                  <div class="image position-relative d-flex align-items-center justify-content-center overflow-hidden">
                  <?php
                    $categories = wp_get_post_terms( $product->get_id(), 'product_cat' );
                    foreach ($categories as $category) {
                    $category_link = get_term_link( $category );
                    $category_name = $category->name;
                    
                    echo '<a href="' . esc_url( $category_link ) . '" class="category position-absolute top-0 start-0 bg-white d-flex align-items-center justify-content-center">';
                    echo  esc_html( $category_name );
                    echo '</a>';
                    }
                    ?>
                    <a href="<?php the_permalink(); ?>">
                      <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title(); ?>" width="290" height="290">
                    </a>
                    <?php if (!empty($normal_price)) {
                            if ("instock" == $stocka) {
                              if (!empty($sale_price)) { ?>
                    <span
                      class="offer position-absolute bottom-0 end-0 text-white d-flex align-items-center justify-content-center">
                      <?php if (class_exists('kavehWoo')) { $offer_percentage = kavehWoo::showofferpercentage($product); echo $offer_percentage; } ?> </span>
                      <?php }
                         } 
                     }
                     $terms = get_the_terms( $pr_id , 'pa_size' );
                     // Loop through the terms
                     if(!empty($terms)){ ?>
                    <ul class="sizes d-flex align-items-center position-absolute bottom-0 end-0 w-100 bg-white">
                    <?php
                      foreach ( $terms as $term ) {
                      $tooltip = get_term_meta( $term->term_id, 'wpcvs_tooltip', true ) ?: $term->name;
                      ?>
                      <li>
                        <a href="<?php the_permalink(); ?>" class="d-block"> <?php echo esc_attr( $tooltip ) ?> </a>
                      </li>
                      <?php
                      }
                      ?>
                    </ul>
                    <?php }else{ ?>
                      <style>
                      .product-fifteen:hover .image .offer {
                        -webkit-transform: translateY(0);
                        -moz-transform: translateY(0);
                        -ms-transform: translateY(0);
                        -o-transform: translateY(0);
                        transform: translateY(0);
                    }
                    </style>
                  <?php  } ?>
                  </div>
                  <div class="d-flex align-items-center justify-content-between">
                    <h2 class="title mb-0">
                      <a href="<?php the_permalink(); ?>"><?php the_title(); ?>  </a>
                    </h2>
                  </div>
                  <div class="price d-flex align-items-center justify-content-end">
                  <?php if("instock"==$stocka){ 
                          if ( !$product->is_type( 'variable' ) ) { 
                              if(empty($sale_price) && empty($normal_price)) { 
                                  $price_v = $product->get_price_html(); ?>
                                  <?php
                                  echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v); ?>
                                  <?php
                                  ?>
                                  <?php }else{ ?>
                                  <?php if(!empty($sale_price) ) { ?>
                                  
                                  <del class="me-2">
                                  <?php if (!empty($normal_price)) {
                                  echo number_format($normal_price, 0, '.', ',');
                                  } ?>
                                  </del>
                                  <?php echo number_format($sale_price, 0, '.', ','); ?>
                                  <span class="currency-fifteen">
                                  <?php echo get_woocommerce_currency_symbol(); ?>
                                  </span>
                                  <?php }else{ ?>
                                  <?php if (!empty($normal_price)) { ?>
                                  <?php
                                  echo number_format($normal_price, 0, '.', ',');
                                  } ?>
                                  <span class="currency-fifteen">
                                  <?php echo get_woocommerce_currency_symbol(); ?>
                                  </span>
                                  <?php } ?>
                                  <?php } }else{ 
                                  $price_v = $product->get_price_html(); ?>
                                  <?php
                                  echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v); ?>
                                  <?php
                                  } 
                                  }else{ ?>
                                    <span class="outstock">
                                    ناموجود 
                                    </span>
                                  <?php
                                  }
                                  ?>
                  </div>
                </div>
              </div>
              <!-- End Slide -->
            <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
              <?php }elseif('all'===$settings['pproductsdigistylecarouselsecondstkaveh']){
                // WP_Query args
            $ordvalue = $settings['psortproductsdigistylecarouselsecondstkaveh'];
            $ordi = $settings['psortiproductsdigistylecarouselsecondstkaveh'];
            $q_pc2_query_args = array(
              'post_type' => array('product'),
'post_status' => array('publish'),
              'posts_per_page' => $settings['productnumberproductsdigistylecarouselsecondstkaveh'],
              'order' => $ordi,
              'orderby' => 'meta_value_num',
              'meta_key'       => $ordvalue,

             
            );
            if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
              $q_pc2_query_args['meta_query'] = array(
                  array(
                      'key' => '_stock_status',
                      'value' => 'outofstock',
                      'compare' => 'NOT IN',
                  ),
              );
            }

            // The Query
            $pc2_query = new \WP_Query($q_pc2_query_args);

            // The Loop
            if ( $pc2_query->have_posts() ) {
              while ( $pc2_query->have_posts() ) {
                $pc2_query->the_post(); ?>
                <?php 
                global $product;
                $product = wc_get_product();
                $product_id = $product->get_id();
                $product_type = $product->get_type();
                $sale_price_dates_from = $sale_price_dates_to = '';
                $sale_price = $product->get_sale_price();
                $normal_price = $product->get_regular_price();
                $pr_id = get_the_ID();
                $stocka = $product->get_stock_status();
                ?>
              <!-- Start Slide -->
              <div class="swiper-slide h-auto">
                <div class="product-fifteen bg-white h-100">
                  <div class="image position-relative d-flex align-items-center justify-content-center overflow-hidden">
                  <?php
                    $categories = wp_get_post_terms( $product->get_id(), 'product_cat' );
                    foreach ($categories as $category) {
                    $category_link = get_term_link( $category );
                    $category_name = $category->name;
                    
                    echo '<a href="' . esc_url( $category_link ) . '" class="category position-absolute top-0 start-0 bg-white d-flex align-items-center justify-content-center">';
                    echo  esc_html( $category_name );
                    echo '</a>';
                    }
                    ?>
                    <a href="<?php the_permalink(); ?>">
                      <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title(); ?>" width="290" height="290">
                    </a>
                    <?php if (!empty($normal_price)) {
                            if ("instock" == $stocka) {
                              if (!empty($sale_price)) { ?>
                    <span
                      class="offer position-absolute bottom-0 end-0 text-white d-flex align-items-center justify-content-center">
                      <?php if (class_exists('kavehWoo')) { $offer_percentage = kavehWoo::showofferpercentage($product); echo $offer_percentage; } ?> </span>
                      <?php }
                         } 
                     }
                     $terms = get_the_terms( $pr_id , 'pa_size' );
                     // Loop through the terms
                     if(!empty($terms)){ ?>
                    <ul class="sizes d-flex align-items-center position-absolute bottom-0 end-0 w-100 bg-white">
                    <?php
                      foreach ( $terms as $term ) {
                      $tooltip = get_term_meta( $term->term_id, 'wpcvs_tooltip', true ) ?: $term->name;
                      ?>
                      <li>
                        <a href="<?php the_permalink(); ?>" class="d-block"> <?php echo esc_attr( $tooltip ) ?> </a>
                      </li>
                      <?php
                      }
                      ?>
                    </ul>
                    <?php }else{ ?>
                      <style>
                      .product-fifteen:hover .image .offer {
                        -webkit-transform: translateY(0);
                        -moz-transform: translateY(0);
                        -ms-transform: translateY(0);
                        -o-transform: translateY(0);
                        transform: translateY(0);
                    }
                    </style>
                  <?php  } ?>
                  </div>
                  <div class="d-flex align-items-center justify-content-between">
                    <h2 class="title mb-0">
                      <a href="<?php the_permalink(); ?>"><?php the_title(); ?>  </a>
                    </h2>
                  </div>
                  <div class="price d-flex align-items-center justify-content-end">
                  <?php if("instock"==$stocka){ 
                          if ( !$product->is_type( 'variable' ) ) { 
                              if(empty($sale_price) && empty($normal_price)) { 
                                  $price_v = $product->get_price_html(); ?>
                                  <?php
                                  echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v); ?>
                                  <?php
                                  ?>
                                  <?php }else{ ?>
                                  <?php if(!empty($sale_price) ) { ?>
                                  
                                  <del class="me-2">
                                  <?php if (!empty($normal_price)) {
                                  echo number_format($normal_price, 0, '.', ',');
                                  } ?>
                                  </del>
                                  <?php echo number_format($sale_price, 0, '.', ','); ?>
                                  <span class="currency-fifteen">
                                  <?php echo get_woocommerce_currency_symbol(); ?>
                                  </span>
                                  <?php }else{ ?>
                                  <?php if (!empty($normal_price)) { ?>
                                  <?php
                                  echo number_format($normal_price, 0, '.', ',');
                                  } ?>
                                  <span class="currency-fifteen">
                                  <?php echo get_woocommerce_currency_symbol(); ?>
                                  </span>
                                  <?php } ?>
                                  <?php } }else{ 
                                  $price_v = $product->get_price_html(); ?>
                                  <?php
                                  echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v); ?>
                                  <?php
                                  } 
                                  }else{ ?>
                                    <span class="outstock">
                                    ناموجود 
                                    </span>
                                  <?php
                                  }
                                  ?>
                  </div>
                </div>
              </div>
              <!-- End Slide -->
                <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
                <?php } ?>            
            </div>
            <?php if('yes'===$settings['showarrowsproductsdigistylecarouselsecondstkaveh']){ ?>
            <!-- Start Button -->
            <div class="swiper-button-next d-none d-md-flex align-items-md-center justify-content-md-center"></div>
            <div class="swiper-button-prev d-none d-md-flex align-items-md-center justify-content-md-center"></div>
            <!-- End Button -->
            <?php } ?>
          </div>
          <!-- End Carousel -->
        </div>
        <!-- End Products -->
        <a href="<?php echo  esc_url($settings['buttontilink2productsdigistylecarouselsecondstkaveh']); ?>" class="btn btn-outline-dark-3 btn-more mt-4 d-md-none d-block mx-auto"> <?php echo  esc_html($settings['buttonti2productsdigistylecarouselsecondstkaveh']); ?></a>
      </div>
    </section>
    <style>
.product-fifteen .image img {
    mix-blend-mode: darken;
    max-height: 200px;
    object-fit: contain;
}
.currency-fifteen{
  font-size:13px;
  margin-right:3px;
}
.product-fifteen .image {
    height: 350px;
}
.top-selling-products-digi-left .product-fifteen {
border:none;
}
    </style>
  <?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
