<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productscarouseltwelvethstkaveh extends Widget_Base{

  public function get_name(){
    return 'productscarouseltwelvethstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل محصولات سبک دوازده', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'عنوان المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'showtiproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'نمایش ستون سمت راست', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'title2productscarouseltwelvethstkaveh',
        [
            'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'showtiproductscarouseltwelvethstkaveh' => 'yes',
            ],
            'default' => esc_html__( 'محبوب ترین', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheadingproductscarouseltwelvethstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'condition' => [
          'showtiproductscarouseltwelvethstkaveh' => 'yes',
        ],
        'default' => 'div',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
        ],
      ]
    );
      $this->add_control(
          'titleproductscarouseltwelvethstkaveh',
          [
              'label' => esc_html__( 'عنوان اصلی بولد', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'condition' => [
                'showtiproductscarouseltwelvethstkaveh' => 'yes',
              ],
              'default' => esc_html__( 'محصولات', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'titleproducts2carouseleleventhstkaveh',
        [
            'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'showtiproductscarouseltwelvethstkaveh' => 'yes',
            ],
            'default' => esc_html__( 'ویژه ما', 'kaveh-core' ),
    
        ]
    );
      $this->add_control(
        'tagheadingfproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'condition' => [
            'showtiproductscarouseltwelvethstkaveh' => 'yes',
          ],
          'default' => 'H4',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'wigp2pproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXTAREA,
          'condition' => [
            'showtiproductscarouseltwelvethstkaveh' => 'yes',
          ],
          'default' => 'همواره، قرار گرفتن در شرایطی که برای اولین بار تجربه‌اش می‌کنیم، در ما ایجاد استرس و اضطرابدر ',
  
        ]
      );
    $this->add_control(
      'buttonti2productscarouseltwelvethstkaveh',
      [
          'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showtiproductscarouseltwelvethstkaveh' => 'yes',
          ],
          'default' => esc_html__( 'مشاهده پیشنهاد ویژه', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'iconbuttproductscarouseltwelvethstkaveh',
    [
      'label' => esc_html__( 'آیکون', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::ICONS,
      'skin' => 'inline',
      'condition' => [
        'showtiproductscarouseltwelvethstkaveh' => 'yes',
      ],
      'exclude_inline_options' => [ 'svg' ],
      'default' => [
        'value' => 'icon-arrow-left-3',
      ],
    ]
  );
  $this->add_control(
    'buttontilink2productscarouseltwelvethstkaveh',
    [
        'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'showtiproductscarouseltwelvethstkaveh' => 'yes',
        ],
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
    $this->end_controls_section();   
  
      $this->start_controls_section(
        'content4productscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'تنظیمات محصولات', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'kaveh_exclude_out_of_stock',
        [
          'label' => esc_html__( 'عدم نمایش محصولات ناموجود', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
  $this->add_control(
    'pproductscarouseltwelvethstkaveh',
    [
      'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'all',
      'options' => [
        'all'  => esc_html__( 'همه', 'kaveh-core' ),
        'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),

      ],
    ]
    );
    $this->add_control(
      'psortproductscarouseltwelvethstkaveh',
      [
        'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'date',
        'options' => [
          'date'  => esc_html__( 'تاریخ', 'kaveh-core' ),
          '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
          '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
          'total_sales'  => esc_html__( 'میزان فروش', 'kaveh-core' ),
  
        ],
      ]
      );
      $this->add_control(
        'psortiproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'desc',
          'options' => [
            'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
            'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
          ],
        ]
        );
  $this->add_control(
    'stylecartproductscarouseltwelvethstkaveh',
    [
      'label' => esc_html__( 'طرح بندی باکس محصول', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'one',
      'options' => [
        'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
        'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
        'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
        'four'  => esc_html__( 'طرح بندی چهارم', 'kaveh-core' ),
        'five'  => esc_html__( 'طرح بندی پنجم', 'kaveh-core' ),
        'six'  => esc_html__( 'طرح بندی ششم', 'kaveh-core' ),
        'seven'  => esc_html__( 'طرح بندی هفتم', 'kaveh-core' ),
        'eight'  => esc_html__( 'طرح بندی هشتم', 'kaveh-core' ),
        'nine'  => esc_html__( 'طرح بندی نهم', 'kaveh-core' ),
        'ten'  => esc_html__( 'طرح بندی دهم', 'kaveh-core' ),
        'eleven'  => esc_html__( 'طرح بندی یازدهم', 'kaveh-core' ),
        'twelve'  => esc_html__( 'طرح بندی دوازدهم', 'kaveh-core' ),
        'thirteen'  => esc_html__( 'طرح بندی سیزدهم', 'kaveh-core' ),
        'fourteen'  => esc_html__( 'طرح بندی چهاردهم', 'kaveh-core' ),
        'fifteen'  => esc_html__( 'طرح بندی پانزدهم', 'kaveh-core' ),
        'sixteen'  => esc_html__( 'طرح بندی شانزدهم', 'kaveh-core' ),

      ],
    ]
    );
  $options5 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $options5[$category->term_id] = $category->name;
}
$this->add_control(
    'catproductscarouseltwelvethstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $options5,
      'condition' => [
        'pproductscarouseltwelvethstkaveh' => 'cat',
      ],
    ]
);
$this->end_controls_section();   
$this->start_controls_section(
  'content5productscarouseltwelvethstkaveh',
  [
    'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'showarrowsproductscarouseltwelvethstkaveh',
  [
    'label' => esc_html__( 'نمایش جهت ها؟', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'yes' => esc_html__( 'بله', 'kaveh-core' ),
    'no' => esc_html__( 'خیر', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);
$this->add_control(
  'productnumberproductscarouseltwelvethstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 50,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnproductscarouseltwelvethstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 3,

  ]
); 
$this->add_control(
  'productcolumn2productscarouseltwelvethstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 2,

  ]
);
$this->add_control(
  'productcolumn3productscarouseltwelvethstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 1.5,

  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'style_productscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showtiproductscarouseltwelvethstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'textcolor3productscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-right .title-en' => 'color: {{VALUE}} !important;',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_productscarouseltwelvethstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-products-category-two-right .title-en',
        ]
      );
      $this->add_control(
        'textcolor2productscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-right .title b' => 'color: {{VALUE}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title1_productscarouseltwelvethstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی بولد', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-products-category-two-right .title b',
        ]
      );
      $this->add_control(
        'bgcolorboldbolproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-right .title::before' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcolor21productscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-right .title' => 'color: {{VALUE}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_productscarouseltwelvethstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-products-category-two-right .title',
        ]
      );
      $this->add_control(
        'pcolor21productscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'رنگ متن', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-right p' => 'color: {{VALUE}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'p_productscarouseltwelvethstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-products-category-two-right p',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleb_productscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showtiproductscarouseltwelvethstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_productscarouseltwelvethstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-products-category-two-right .btn',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowproductscarouseltwelvethstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-products-category-two-right .btn',
        ]
      );
      $this->add_control(
        'iconsizenchbproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-right .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabsproductscarouseltwelvethstkaveh'
      );
    
      $this->start_controls_tab(
        'style_normal_tabproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-right .btn' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbutton1colorproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-right .btn i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-right .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-right .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderproductscarouseltwelvethstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-products-category-two-right .btn',
        ]
      );
      $this->add_control(
        'buttonbordersproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderproductscarouseltwelvethstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-right .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoverproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-right .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbutton1hovercolorproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-right .btn:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-right .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoverproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-right .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverproductscarouseltwelvethstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-products-category-two-right .btn:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoverproductscarouseltwelvethstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-right .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowproductscarouseltwelvethstkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-products-category-two-right .btn',
        ]
      );
      $this->add_control(
        'hr2productscarouseltwelvethstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-right .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style5_productscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'استایل جهت های کاروسل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showarrowsproductscarouseltwelvethstkaveh' => 'yes',
            'showtiproductscarouseltwelvethstkaveh' => 'yes',

          ],
        ]
      );
      $this->add_control(
        'arrowscolorproductscarouseltwelvethstkaveh',
        [
          'label' => esc_html__( 'رنگ جهت های کاروسل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-products-category-two-left .swiper-button-next::after' => 'color: {{VALUE}} !important;',
            '{{WRAPPER}} .new-products-category-two-left .swiper-button-prev::after' => 'color: {{VALUE}} !important;',
          ],
        ]
      ); 
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="new-products-category-two">
      <div class="container d-flex align-items-center position-relative flex-column flex-sm-row gap-4 gap-sm-0">
      <?php if('yes'===$settings['showtiproductscarouseltwelvethstkaveh']){ ?>
        <!-- Start Title -->
        <div class="new-products-category-two-right w-100 position-relative">
          <<?php echo  esc_attr($settings['tagheadingproductscarouseltwelvethstkaveh']); ?> class="title-en"><?php echo  esc_html($settings['title2productscarouseltwelvethstkaveh']); ?> </<?php echo  esc_attr($settings['tagheadingproductscarouseltwelvethstkaveh']); ?>>
          <<?php echo  esc_attr($settings['tagheadingfproductscarouseltwelvethstkaveh']); ?> class="title position-relative">
            <b> <?php echo  esc_html($settings['titleproductscarouseltwelvethstkaveh']); ?></b> <?php echo  esc_html($settings['titleproducts2carouseleleventhstkaveh']); ?>
          </<?php echo  esc_attr($settings['tagheadingfproductscarouseltwelvethstkaveh']); ?>>
          <p> <?php echo  esc_html($settings['wigp2pproductscarouseltwelvethstkaveh']); ?></p>
          <a href="<?php echo  esc_url($settings['buttontilink2productscarouseltwelvethstkaveh']); ?>" class="btn btn-dark-5 d-flex align-items-center justify-content-center">
            <?php echo  esc_html($settings['buttonti2productscarouseltwelvethstkaveh']); ?>
            <i class="<?php echo  esc_html($settings['iconbuttproductscarouseltwelvethstkaveh']['value']); ?>"></i>
          </a>
        </div>
        <!-- Start Title -->
        <?php } ?>
        <!-- Start Products -->
        <div class="new-products-category-two-left w-100">
          <!-- Start Carousel -->
          <div class="swiper swiper-products-elemans swiper-button-arrow" data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productscarouseltwelvethstkaveh']); ?>,"spaceBetween":12},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productscarouseltwelvethstkaveh']); ?>,"spaceBetween":12},"576":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productscarouseltwelvethstkaveh']); ?>,"spaceBetween":12},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productscarouseltwelvethstkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductscarouseltwelvethstkaveh']); ?>,"spaceBetween":20},"1400":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductscarouseltwelvethstkaveh']); ?>,"spaceBetween":41}}}'>
            <div class="swiper-wrapper">
            <?php if('cat'===$settings['pproductscarouseltwelvethstkaveh']){ ?>
                <?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouseltwelvethstkaveh'],
                  'orderby' => $settings['psortproductscarouseltwelvethstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouseltwelvethstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                    array(
                      'taxonomy' => 'product_cat',
                      'field' => 'term_id',
                      'terms' => $settings['catproductscarouseltwelvethstkaveh'],
                    ),
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouseltwelvethstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="swiper-slide h-auto">
                      <?php $styleproduct2 = $settings['stylecartproductscarouseltwelvethstkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>


              <?php }elseif('all'===$settings['pproductscarouseltwelvethstkaveh']){
              ?>
                              <?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouseltwelvethstkaveh'],
                  'orderby' => $settings['psortproductscarouseltwelvethstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouseltwelvethstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouseltwelvethstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="swiper-slide h-auto">
                      <?php $styleproduct2 = $settings['stylecartproductscarouseltwelvethstkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>
         
                <?php } ?>
            </div>
            <?php if('yes'===$settings['showarrowsproductscarouseltwelvethstkaveh']){ ?>
            <!-- Start Button -->
            <?php if('yes'===$settings['showtiproductscarouseltwelvethstkaveh']){ ?>
            <!-- Start Button -->
            <div class="swiper-button-next w-auto h-auto"></div>
            <div class="swiper-button-prev w-auto h-auto"></div>
            <!-- End Button -->
            <?php } 
            }?>
          </div>
          <!-- End Carousel -->
        </div>
        <!-- End Products -->
      </div>
    </section>
    <?php if('yes'!==$settings['showtiproductscarouseltwelvethstkaveh']){ ?>
    <style>
     .new-products-category-two-left {
        max-width: 100% !important;
    }
    </style>
    <?php } ?>
    <?php do_action('kelementor_inline_scripts'); ?>  
    <?php
  }


}
