<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productscarouselthirteenthstkaveh extends Widget_Base{

  public function get_name(){
    return 'productscarouselthirteenthstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل محصولات سبک سیزده', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'عنوان المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'showtiproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'نمایش ستون سمت راست', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'title2productscarouselthirteenthstkaveh',
        [
            'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'showtiproductscarouselthirteenthstkaveh' => 'yes',
            ],
            'default' => esc_html__( 'محبوب ترین', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheadingproductscarouselthirteenthstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'condition' => [
          'showtiproductscarouselthirteenthstkaveh' => 'yes',
        ],
        'default' => 'div',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
        ],
      ]
    );
      $this->add_control(
          'titleproductscarouselthirteenthstkaveh',
          [
              'label' => esc_html__( 'عنوان اصلی بولد', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'condition' => [
                'showtiproductscarouselthirteenthstkaveh' => 'yes',
              ],
              'default' => esc_html__( 'محصولات', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'titleproducts2carouseleleventhstkaveh',
        [
            'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'showtiproductscarouselthirteenthstkaveh' => 'yes',
            ],
            'default' => esc_html__( 'ویژه ما', 'kaveh-core' ),
    
        ]
    );
      $this->add_control(
        'tagheadingfproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'condition' => [
            'showtiproductscarouselthirteenthstkaveh' => 'yes',
          ],
          'default' => 'H4',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'imgproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'تصویر اول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'condition' => [
            'showtiproductscarouselthirteenthstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'imgproducts2carouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'تصویر دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .image::before' =>
                'background: url({{URL}}) 0 0 no-repeat',
        ],
          'condition' => [
            'showtiproductscarouselthirteenthstkaveh' => 'yes',
          ],
        ]
      );
    $this->add_control(
      'buttonti2productscarouselthirteenthstkaveh',
      [
          'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showtiproductscarouselthirteenthstkaveh' => 'yes',
          ],
          'default' => esc_html__( 'مشاهده پیشنهاد ویژه', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'iconbuttproductscarouselthirteenthstkaveh',
    [
      'label' => esc_html__( 'آیکون', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::ICONS,
      'skin' => 'inline',
      'condition' => [
        'showtiproductscarouselthirteenthstkaveh' => 'yes',
      ],
      'exclude_inline_options' => [ 'svg' ],
      'default' => [
        'value' => 'icon-arrow-left-3',
      ],
    ]
  );
  $this->add_control(
    'buttontilink2productscarouselthirteenthstkaveh',
    [
        'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'showtiproductscarouselthirteenthstkaveh' => 'yes',
        ],
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
    $this->end_controls_section();   
  
      $this->start_controls_section(
        'content4productscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'تنظیمات محصولات', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'kaveh_exclude_out_of_stock',
        [
          'label' => esc_html__( 'عدم نمایش محصولات ناموجود', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
  $this->add_control(
    'pproductscarouselthirteenthstkaveh',
    [
      'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'all',
      'options' => [
        'all'  => esc_html__( 'همه', 'kaveh-core' ),
        'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),

      ],
    ]
    );
    $this->add_control(
      'psortproductscarouselthirteenthstkaveh',
      [
        'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'date',
        'options' => [
          'date'  => esc_html__( 'تاریخ', 'kaveh-core' ),
          '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
          '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
          'total_sales'  => esc_html__( 'میزان فروش', 'kaveh-core' ),
  
        ],
      ]
      );
      $this->add_control(
        'psortiproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'desc',
          'options' => [
            'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
            'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
          ],
        ]
        );
  $this->add_control(
    'stylecartproductscarouselthirteenthstkaveh',
    [
      'label' => esc_html__( 'طرح بندی باکس محصول', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'one',
      'options' => [
        'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
        'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
        'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
        'four'  => esc_html__( 'طرح بندی چهارم', 'kaveh-core' ),
        'five'  => esc_html__( 'طرح بندی پنجم', 'kaveh-core' ),
        'six'  => esc_html__( 'طرح بندی ششم', 'kaveh-core' ),
        'seven'  => esc_html__( 'طرح بندی هفتم', 'kaveh-core' ),
        'eight'  => esc_html__( 'طرح بندی هشتم', 'kaveh-core' ),
        'nine'  => esc_html__( 'طرح بندی نهم', 'kaveh-core' ),
        'ten'  => esc_html__( 'طرح بندی دهم', 'kaveh-core' ),
        'eleven'  => esc_html__( 'طرح بندی یازدهم', 'kaveh-core' ),
        'twelve'  => esc_html__( 'طرح بندی دوازدهم', 'kaveh-core' ),
        'thirteen'  => esc_html__( 'طرح بندی سیزدهم', 'kaveh-core' ),
        'fourteen'  => esc_html__( 'طرح بندی چهاردهم', 'kaveh-core' ),
        'fifteen'  => esc_html__( 'طرح بندی پانزدهم', 'kaveh-core' ),
        'sixteen'  => esc_html__( 'طرح بندی شانزدهم', 'kaveh-core' ),

      ],
    ]
    );
  $options5 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $options5[$category->term_id] = $category->name;
}
$this->add_control(
    'catproductscarouselthirteenthstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $options5,
      'condition' => [
        'pproductscarouselthirteenthstkaveh' => 'cat',
      ],
    ]
);
$this->end_controls_section();   
$this->start_controls_section(
  'content5productscarouselthirteenthstkaveh',
  [
    'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'bgimgproductscarouselthirteenthstkaveh',
  [
    'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'selectors' => [
      '{{WRAPPER}} .selling-specials::before' =>
          'background: url({{URL}}) 0 0 no-repeat',
  ],
  ]
);
$this->add_control(
  'productnumberproductscarouselthirteenthstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 50,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnproductscarouselthirteenthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 3,

  ]
); 
$this->add_control(
  'productcolumn2productscarouselthirteenthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 2,

  ]
);
$this->add_control(
  'productcolumn3productscarouselthirteenthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 1.5,

  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'style_productscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showtiproductscarouselthirteenthstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'textcolor3productscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .title-en' => 'color: {{VALUE}} !important;',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_productscarouselthirteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .selling-specials-right .title-en',
        ]
      );
      $this->add_control(
        'textcolor2productscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .title span' => 'color: {{VALUE}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title1_productscarouselthirteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی بولد', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .selling-specials-right .title span',
        ]
      );
      $this->add_control(
        'bgcolorboldbolproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .title::before' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcolor21productscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .title' => 'color: {{VALUE}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_productscarouselthirteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .selling-specials-right .title',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleb_productscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showtiproductscarouselthirteenthstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_productscarouselthirteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .selling-specials-right .btn',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowproductscarouselthirteenthstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .selling-specials-right .btn',
        ]
      );
      $this->add_control(
        'iconsizenchbproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabsproductscarouselthirteenthstkaveh'
      );
    
      $this->start_controls_tab(
        'style_normal_tabproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .btn' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbutton1colorproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .btn i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderproductscarouselthirteenthstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .selling-specials-right .btn',
        ]
      );
      $this->add_control(
        'buttonbordersproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderproductscarouselthirteenthstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoverproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbutton1hovercolorproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .btn:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoverproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverproductscarouselthirteenthstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .selling-specials-right .btn:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoverproductscarouselthirteenthstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowproductscarouselthirteenthstkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .selling-specials-right .btn',
        ]
      );
      $this->add_control(
        'hr2productscarouselthirteenthstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_productscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'استایل تصاویر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'imagewidth3productscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر اول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 5,
            ],

          ],
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .image img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'imageheight3amazingoffersecondstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر اول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 5,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .image img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'imagewidth32productscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 5,
            ],

          ],
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .image::before' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'imageheight32amazingoffersecondstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 5,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .image::before' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'imageright32productscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'فاصله از راست تصویر دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 5,
            ],

          ],
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .image::before' => 'right: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'imagetop32amazingoffersecondstkaveh',
        [
          'label' => esc_html__( 'فاصله از بالا تصویر دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 5,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .selling-specials-right .image::before' => 'top: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      
      $this->end_controls_section();
      $this->start_controls_section(
        'style5_productscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'استایل جهت های کاروسل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showarrowsproductscarouselthirteenthstkaveh' => 'yes',
            'showtiproductscarouselthirteenthstkaveh' => 'yes',

          ],
        ]
      );
      $this->add_control(
        'arrowscolorproductscarouselthirteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ جهت های کاروسل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-specials-left .swiper-button-next::after' => 'color: {{VALUE}} !important;',
            '{{WRAPPER}}  .products-specials-left .swiper-button-prev::after' => 'color: {{VALUE}} !important;',
          ],
        ]
      ); 
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="selling-specials position-relative">
      <div class="container d-flex align-items-sm-end position-relative flex-column flex-sm-row gap-5 gap-sm-0">
      <?php if('yes'===$settings['showtiproductscarouselthirteenthstkaveh']){ ?>
        <!-- Start Title -->
        <div class="selling-specials-right w-100">
          <<?php echo  esc_attr($settings['tagheadingproductscarouselthirteenthstkaveh']); ?> class="title-en text-center text-sm-start"><?php echo  esc_html($settings['title2productscarouselthirteenthstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingproductscarouselthirteenthstkaveh']); ?>>
          <<?php echo  esc_attr($settings['tagheadingfproductscarouselthirteenthstkaveh']); ?> class="title position-relative mx-auto mx-sm-0">
            <span> <?php echo  esc_html($settings['titleproductscarouselthirteenthstkaveh']); ?></span> <?php echo  esc_html($settings['titleproducts2carouseleleventhstkaveh']); ?>
          </<?php echo  esc_attr($settings['tagheadingfproductscarouselthirteenthstkaveh']); ?>>
          <div class="image position-relative">
            <img src="<?php echo esc_url($settings['imgproductscarouselthirteenthstkaveh']['url']); ?>" alt="" >
            <img src="<?php echo esc_url($settings['imgproductscarouselthirteenthstkaveh']['url']); ?>" alt="" class="position-absolute top-0 end-0 w-100 h-100">
          </div>
          <a href="<?php echo  esc_url($settings['buttontilink2productscarouselthirteenthstkaveh']); ?>" class="btn btn-dark-5 d-flex align-items-center justify-content-center mx-auto position-relative">
            <?php echo  esc_html($settings['buttonti2productscarouselthirteenthstkaveh']); ?>
            <i class="<?php echo  esc_html($settings['iconbuttproductscarouselthirteenthstkaveh']['value']); ?>"></i>
          </a>
        </div>
        <!-- End Title -->
        <?php } ?>

        <!-- Start Products -->
        <div class="selling-specials-left w-100">
          <!-- Start Carousel -->
          <div class="swiper swiper-products-elemans swiper-button-arrow" data-swiper='{"watchSlidesProgress":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productscarouselthirteenthstkaveh']); ?>,"spaceBetween":12},"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productscarouselthirteenthstkaveh']); ?>,"spaceBetween":12},"576":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productscarouselthirteenthstkaveh']); ?>,"spaceBetween":12},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productscarouselthirteenthstkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductscarouselthirteenthstkaveh']); ?>,"spaceBetween":20},"1400":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductscarouselthirteenthstkaveh']); ?>,"spaceBetween":41}}}'>
            <div class="swiper-wrapper">
            <?php if('cat'===$settings['pproductscarouselthirteenthstkaveh']){ ?>
               <?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouselthirteenthstkaveh'],
                  'orderby' => $settings['psortproductscarouselthirteenthstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouselthirteenthstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                    array(
                      'taxonomy' => 'product_cat',
                      'field' => 'term_id',
                      'terms' => $settings['catproductscarouselthirteenthstkaveh'],
                    ),
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouselthirteenthstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="swiper-slide h-auto">
                      <?php $styleproduct2 = $settings['stylecartproductscarouselthirteenthstkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>
              
              <?php }elseif('all'===$settings['pproductscarouselthirteenthstkaveh']){

                ?>
                               <?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouselthirteenthstkaveh'],
                  'orderby' => $settings['psortproductscarouselthirteenthstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouselthirteenthstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouselthirteenthstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="swiper-slide h-auto">
                      <?php $styleproduct2 = $settings['stylecartproductscarouselthirteenthstkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>

                <?php } ?>
            </div>
            <!-- Start Button -->
            <div class="swiper-button-next w-auto h-auto d-none"></div>
            <div class="swiper-button-prev w-auto h-auto d-none"></div>
            <!-- End Button -->
          </div>
          <!-- End Carousel -->
        </div>
        <!-- End Products -->
      </div>
    </section>
    <?php if('yes'!==$settings['showtiproductscarouselthirteenthstkaveh']){ ?>
    <style>
      .selling-specials-left {
        max-width: 100% !important;
    }
    </style>
    <?php } ?>
    <style>
      .selling-specials-right .image img{
        object-fit : contain;
      }
      .selling-specials-right .image img:last-child{
        object-fit : contain;
      }
      .selling-specials-right .image::before{
    -webkit-background-size: contain !important;
    -moz-background-size: contain !important;
    -o-background-size: contain !important;

      }
      .selling-specials::before {
    -webkit-background-size: cover !important;
    -moz-background-size: cover !important;
    -o-background-size: cover !important;
    background-size: cover !important;
}
    </style>
    <?php do_action('kelementor_inline_scripts'); ?>  
    <?php
  }


}
