<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productscarouseltenthstkaveh extends Widget_Base{

  public function get_name(){
    return 'productscarouseltenthstkaveh';
  }
 
  public function get_title(){
    return esc_html__( 'کاروسل محصولات سبک ده', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }
 
  protected function register_controls(){
    $this->start_controls_section(
      'content0productscarouseltenthstkaveh',
      [
        'label' => esc_html__( 'تنظیمات محصولات تخفیف لحظه ای', 'kaveh-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
      $this->add_control(
        'pproductslahzecarouseltenthstkaveh',
        [
          'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'all',
          'options' => [
            'all'  => esc_html__( 'همه', 'kaveh-core' ),
            'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),
    
          ],
        ]
        );
        $this->add_control(
          'psortproductslahzecarouseltenthstkaveh',
          [
            'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'date',
            'options' => [
              'date'  => esc_html__( 'تاریخ', 'kaveh-core' ),
              '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
              '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
              'total_sales'  => esc_html__( 'میزان فروش', 'kaveh-core' ),
      
            ],
          ]
          );
          $this->add_control(
            'psortiproductslahzecarouseltenthstkaveh',
            [
              'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::SELECT,
              'default' => 'desc',
              'options' => [
                'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
                'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
              ],
            ]
            );
    $options2 = array();
  $orderby = 'name';
  $order = 'asc';
  $hide_empty = false ;
  $cat_args = array(
      'orderby'    => $orderby,
      'order'      => $order,
      'hide_empty' => $hide_empty,
  );
  
  $product_categories = get_terms( 'product_cat', $cat_args );
  
  foreach ( $product_categories as $key => $category ) {
      $options2[$category->term_id] = $category->name;
  }
  $this->add_control(
      'catproductslahzecarouseltenthstkaveh',
      [
        'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT2, 
        'multiple' => true,
        'options' => $options2,
        'condition' => [
          'pproductslahzecarouseltenthstkaveh' => 'cat',
        ],
      ]
  );
  $this->add_control(
    'backnvchjlahzecarouseltenthstkaveh',
    [
      'label' => esc_html__( 'تصویر پایین باکس', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,     
      'selectors' => [
        '{{WRAPPER}} .discount-products-right::after' => 'background: url({{URL}}) 0 0 no-repeat',
    ],       
    ]
  );
    $this->end_controls_section();

  $this->start_controls_section(
    'content2productscarouseltenthstkaveh',
    [
      'label' => esc_html__( 'تنظیمات محصولات سمت چپ', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );
  $this->add_control(
    'kaveh_exclude_out_of_stock',
    [
      'label' => esc_html__( 'عدم نمایش محصولات ناموجود', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'yes' => esc_html__( 'بله', 'kaveh-core' ),
      'no' => esc_html__( 'خیر', 'kaveh-core' ),
      'return_value' => 'yes',
      'default' => 'yes',
    ]
  );
    $this->add_control(
      'pproductscarouseltenthstkaveh',
      [
        'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'all',
        'options' => [
          'all'  => esc_html__( 'همه', 'kaveh-core' ),
          'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),
  
        ],
      ]
      );
      $this->add_control(
        'psortproductscarouseltenthstkaveh',
        [
          'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'date',
          'options' => [
            'date'  => esc_html__( 'تاریخ', 'kaveh-core' ),
            '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
            '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
            'total_sales'  => esc_html__( 'میزان فروش', 'kaveh-core' ),
    
          ],
        ]
        );
        $this->add_control(
          'psortiproductscarouseltenthstkaveh',
          [
            'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'desc',
            'options' => [
              'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
              'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
            ],
          ]
          );
  $options2 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $options2[$category->term_id] = $category->name;
}
$this->add_control(
    'catproductscarouseltenthstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $options2,
      'condition' => [
        'pproductscarouseltenthstkaveh' => 'cat',
      ],
    ]
);
$this->end_controls_section();
$this->start_controls_section(
  'content3productscarouseltenthstkaveh',
  [
    'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'stylecartproductscarouseltenthstkaveh',
  [
    'label' => esc_html__( 'طرح بندی باکس محصول', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SELECT,
    'default' => 'one',
    'options' => [
      'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
      'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
      'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
      'four'  => esc_html__( 'طرح بندی چهارم', 'kaveh-core' ),
      'five'  => esc_html__( 'طرح بندی پنجم', 'kaveh-core' ),
      'six'  => esc_html__( 'طرح بندی ششم', 'kaveh-core' ),
      'seven'  => esc_html__( 'طرح بندی هفتم', 'kaveh-core' ),
      'eight'  => esc_html__( 'طرح بندی هشتم', 'kaveh-core' ),
      'nine'  => esc_html__( 'طرح بندی نهم', 'kaveh-core' ),
      'ten'  => esc_html__( 'طرح بندی دهم', 'kaveh-core' ),
      'eleven'  => esc_html__( 'طرح بندی یازدهم', 'kaveh-core' ),
      'twelve'  => esc_html__( 'طرح بندی دوازدهم', 'kaveh-core' ),
      'thirteen'  => esc_html__( 'طرح بندی سیزدهم', 'kaveh-core' ),
      'fourteen'  => esc_html__( 'طرح بندی چهاردهم', 'kaveh-core' ),
      'fifteen'  => esc_html__( 'طرح بندی پانزدهم', 'kaveh-core' ),
      'sixteen'  => esc_html__( 'طرح بندی شانزدهم', 'kaveh-core' ),

    ],
  ]
  );
$this->add_control(
  'showarrowproductscarouseltenthstkaveh',
  [
    'label' => esc_html__( 'نمایش فلش ها؟', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'yes' => esc_html__( 'بله', 'kaveh-core' ),
    'no' => esc_html__( 'خیر', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
  );
$this->add_control(
  'productnumberproductscarouseltenthstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 50,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnproductscarouseltenthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 3,

  ]
);
$this->add_control(
  'productcolumn2productscarouseltenthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 2,

  ]
);
$this->add_control(
  'productcolumn3productscarouseltenthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 1,

  ]
); 
       $this->end_controls_section();

      $this->start_controls_section(
        'style3_productscarouseltenthstkaveh',
        [
          'label' => esc_html__( 'استایل عمومی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'bgcolorproductscarouseltenthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه باکس راست', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .discount-products-right::before' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 

      $this->add_control(
        'bgcoloriconproductscarouseltenthstkaveh',
        [
          'label' => esc_html__( 'رنگ فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'showarrowproductscarouseltenthstkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .discount-products-left .swiper-button-next::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .discount-products-left .swiper-button-prev::after' => 'color: {{VALUE}}',

          ],
        ]
      ); 
      $this->add_control(
        'boxradiusproductscarouseltenthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس راست', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .discount-products-right::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style4_productscarouseltenthstkaveh',
        [
          'label' => esc_html__( 'استایل تصویر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE, 
        ]
       );
      $this->add_control(
        'width2bgproductscarouseltenthstkaveh',
        [
          'label' => esc_html__( 'سایز تصویر پایین باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .discount-products-right::after' => 'width: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .discount-products-right::after' => 'height: {{SIZE}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'top2bgproductscarouseltenthstkaveh',
        [
          'label' => esc_html__( 'فاصله تصویر از بالا', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .discount-products-right::after' => 'top: {{SIZE}}{{UNIT}};',

          ],
        ]
      );
       $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
<section class="discount-products my-100">
      <div class="container d-flex flex-column flex-sm-row">
        <div class="discount-products-right w-100 position-relative">
          <!-- Start Carousel -->
          <div class="swiper swiper-discount-products overflow-hidden">
            <div class="swiper-wrapper">
            <?php if('cat'===$settings['pproductscarouseltenthstkaveh']){ ?>
              <?php 
                  
                  // WP_Query args
                  $q_pc2_query_args = array(
                    'post_type' => array('product'),
'post_status' => array('publish'),
                    'posts_per_page' => $settings['productnumberproductscarouseltenthstkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $settings['catproductscarouseltenthstkaveh'],
                      ),
                    ),
                    'meta_query' => WC()->query->get_meta_query(),
                    'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())
                    
                  );

                  // The Query
                  $pc2_query = new \WP_Query($q_pc2_query_args);
                  
                  // The Loop
                  if ( $pc2_query->have_posts() ) {
                    while ( $pc2_query->have_posts() ) {
                      $pc2_query->the_post(); 
                      global $product;
                      $product_id = $product->get_id();
                      $product_type = $product->get_type();
                      $sale_price_dates_from = $sale_price_dates_to = '';

                      $sale_price = $product->get_sale_price();
                      $normal_price = $product->get_regular_price();

                      $pr_id = get_the_ID();
                      $stocka = $product->get_stock_status();?>
            <div class="swiper-slide h-auto">
              <div class="product-two product-two-new">
                 <?php
                    if ($date_from = get_post_meta($product_id, '_sale_price_dates_from', true)){
                        $sale_price_dates_from = date('Y-m-d 00:00:00', $date_from);
                    }
                    if ($date_to = get_post_meta($product_id, '_sale_price_dates_to', true)){
                        $sale_price_dates_to = date('Y-m-d 23:59:59', $date_to);
                    }
                    $deal_start_date = $sale_price_dates_from;
                    $deal_start_time = strtotime($deal_start_date);
                    $deal_end_date = $sale_price_dates_to;
                    $deal_end_time = strtotime($deal_end_date, current_time('timestamp'));
                    //$current_date = current_time( 'Y-m-d H:i:s', true );
                    $current_time = strtotime('NOW', current_time('timestamp'));
                    $time_diff = ($deal_end_time - $current_time); ?>
                  <div class="cs-height_10 cs-height_lg_10"></div>
                  <?php if("instock"==$stocka){ ?>
                  <?php if (!empty($deal_end_date)){ ?>
                  <ul class="timear position-absolute top-50 start-0" data-time="<?php  echo $deal_end_date; ?>">
                    <li>
                      <span class="hour d-flex align-items-center justify-content-center rounded-circle"> 00 </span>
                      ساعت
                    </li>
                    <li>
                      <span class="minute d-flex align-items-center justify-content-center rounded-circle"> 00 </span>
                      دقیقه
                    </li>
                    <li>
                      <span class="second d-flex align-items-center justify-content-center rounded-circle"> 00 </span>
                      ثانیه
                    </li>
                  </ul>
                  <?php }else{} }?> 
                  <?php  $styleproduct2=$settings['stylecartproductscarouseltenthstkaveh']; ?>
                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                </div>
               <!-- End Slide -->
            <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
              <?php }elseif('all'===$settings['pproductscarouseltenthstkaveh']){
                // WP_Query args
            $ordvalue = $settings['psortproductscarouseltenthstkaveh'];
            $ordi = $settings['psortiproductscarouseltenthstkaveh'];
            $q_pc2_query_args = array(
              'post_type' => array('product'),
'post_status' => array('publish'),
              'posts_per_page' => $settings['productnumberproductscarouseltenthstkaveh'],
              'order' => $ordi,
              'orderby' => 'meta_value_num',
              'meta_key'       => $ordvalue,
              'meta_query' => WC()->query->get_meta_query(),
              'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())

             
            );
            if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
              $q_pc2_query_args['meta_query'] = array(
                  array(
                      'key' => '_stock_status',
                      'value' => 'outofstock',
                      'compare' => '!=',
                  ),
              );
            } 

            // The Query
            $pc2_query = new \WP_Query($q_pc2_query_args);

            // The Loop
            if ( $pc2_query->have_posts() ) {
              while ( $pc2_query->have_posts() ) {
                $pc2_query->the_post();
                global $product;
                $product_id = $product->get_id();
                $product_type = $product->get_type();
                $sale_price_dates_from = $sale_price_dates_to = '';

                $sale_price = $product->get_sale_price();
                $normal_price = $product->get_regular_price();

                $pr_id = get_the_ID();
                $stocka = $product->get_stock_status(); ?>
            <div class="swiper-slide h-auto">
            <?php
                    if ($date_from = get_post_meta($product_id, '_sale_price_dates_from', true)){
                        $sale_price_dates_from = date('Y-m-d 00:00:00', $date_from);
                    }
                    if ($date_to = get_post_meta($product_id, '_sale_price_dates_to', true)){
                        $sale_price_dates_to = date('Y-m-d 23:59:59', $date_to);
                    }
                    $deal_start_date = $sale_price_dates_from;
                    $deal_start_time = strtotime($deal_start_date);
                    $deal_end_date = $sale_price_dates_to;
                    $deal_end_time = strtotime($deal_end_date, current_time('timestamp'));
                    //$current_date = current_time( 'Y-m-d H:i:s', true );
                    $current_time = strtotime('NOW', current_time('timestamp'));
                    $time_diff = ($deal_end_time - $current_time); ?>
                  <div class="cs-height_10 cs-height_lg_10"></div>
                  <?php if("instock"==$stocka){ ?>
                  <?php if (!empty($deal_end_date)){ ?>
                  <ul class="timear position-absolute top-50 start-0" data-time="<?php  echo $deal_end_date; ?>">
                     <li>
                        <span class="day d-flex align-items-center justify-content-center rounded-circle"> 00 </span>
                        روز
                    </li>
                    <li>
                      <span class="hour d-flex align-items-center justify-content-center rounded-circle"> 00 </span>
                      ساعت
                    </li>
                    <li>
                      <span class="minute d-flex align-items-center justify-content-center rounded-circle"> 00 </span>
                      دقیقه
                    </li>
                    <li>
                      <span class="second d-flex align-items-center justify-content-center rounded-circle"> 00 </span>
                      ثانیه
                    </li>
                  </ul>
                  <?php }else{} }?> 
                  <?php  $styleproduct2=$settings['stylecartproductscarouseltenthstkaveh']; ?>
                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                </div>
                <!-- End Slide -->
                <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
                <?php } ?>

            </div>
          </div>
          <!-- End Carousel -->
        </div>
        <div class="discount-products-left w-100 position-relative mt-4 mt-sm-0">
          <!-- Start Carousel -->
          <div class="swiper swiper-discount-products-two overflow-hidden" data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo  esc_html($settings['productcolumn3productscarouseltenthstkaveh']); ?>,"spaceBetween":4},"768":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2productscarouseltenthstkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo  esc_html($settings['productcolumnproductscarouseltenthstkaveh']); ?>,"spaceBetween":12},"1200":{"slidesPerView":<?php echo  esc_html($settings['productcolumnproductscarouseltenthstkaveh']); ?>,"spaceBetween":20}}}'>
          <div class="swiper-wrapper">
            <?php if('cat'===$settings['pproductscarouseltenthstkaveh']){ ?>
              <?php 
                  
                  // WP_Query args
                  $q_pc2_query_args = array(
                    'post_type' => array('product'),
'post_status' => array('publish'),
                    'posts_per_page' => $settings['productnumberproductscarouseltenthstkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $settings['catproductscarouseltenthstkaveh'],
                      ),
                    ),
                     
                    
                  );
                  if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                    $q_pc2_query_args['meta_query'] = array(
                        array(
                            'key' => '_stock_status',
                            'value' => 'outofstock',
                            'compare' => '!=',
                        ),
                    );
                  }

                  // The Query
                  $pc2_query = new \WP_Query($q_pc2_query_args);
                  
                  // The Loop
                  if ( $pc2_query->have_posts() ) {
                    while ( $pc2_query->have_posts() ) {
                      $pc2_query->the_post(); ?>
            <div class="swiper-slide h-auto">
             <?php  $styleproduct=$settings['stylecartproductscarouseltenthstkaveh']; ?>
            <?php get_template_part("template-part/product-cart-$styleproduct"); ?>
            </div>
            <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
              <?php }elseif('all'===$settings['pproductscarouseltenthstkaveh']){
                // WP_Query args
            $ordvalue = $settings['psortproductscarouseltenthstkaveh'];
            $ordi = $settings['psortiproductscarouseltenthstkaveh'];
            $q_pc2_query_args = array(
              'post_type' => array('product'),
'post_status' => array('publish'),
              'posts_per_page' => $settings['productnumberproductscarouseltenthstkaveh'],
              'order' => $ordi,
              'orderby' => 'meta_value_num',
              'meta_key'       => $ordvalue,

             
            ); 

            // The Query
            $pc2_query = new \WP_Query($q_pc2_query_args);

            // The Loop
            if ( $pc2_query->have_posts() ) {
              while ( $pc2_query->have_posts() ) {
                $pc2_query->the_post(); ?>
                <div class="swiper-slide h-auto">
                <?php  $styleproduct2=$settings['stylecartproductscarouseltenthstkaveh']; ?>
                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                </div>
                <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
                <?php } ?>
            </div>
            <?php if("yes"===$settings['showarrowproductscarouseltenthstkaveh']){?>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
            <?php } ?>
          </div>
          <!-- End Carousel -->
        </div>
      </div>
    </section>
    <?php if( \Elementor\Plugin::$instance->editor->is_edit_mode() ) : ?> 
    <script>
      function init<?php echo $clsid; ?>() {
        new Swiper(".swiper-discount-products-two", {
          navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
          },
          breakpoints: {
            320: {
              slidesPerView: <?php echo  esc_html($settings['productcolumn3productscarouseltenthstkaveh']); ?>,
              spaceBetween: 4,
            },
            768: {
              slidesPerView: <?php echo  esc_html($settings['productcolumn2productscarouseltenthstkaveh']); ?>,
              spaceBetween: 12,
            },
            992: {
              slidesPerView: <?php echo  esc_html($settings['productcolumnproductscarouseltenthstkaveh']); ?>,
              spaceBetween: 12,
            },
            1200: {
              slidesPerView: <?php echo  esc_html($settings['productcolumnproductscarouseltenthstkaveh']); ?>,
              spaceBetween: 20,
            },
          },
        });
        new Swiper(".swiper-discount-products", {
            slidesPerView: 1,
            spaceBetween: 0,
            loop: true,
            autoplay: {
              delay: 5000,
              disableOnInteraction: false,
            },
            effect: "fade",
            fadeEffect: {
              crossFade: true,
            },
            on: {
              progress: () => {
                move();
              },
            },
          });
        }
        if (window.Swiper) {
          // Swiper library already loaded, initialize Swiper instance
          init<?php echo $clsid; ?>();
        } else {
          // Swiper library not yet loaded, wait for it to load
          window.addEventListener("load", function() {
            init<?php echo $clsid; ?>();
          });
        }
    </script>
    <?php endif; ?>
    <?php
  }


}
