<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productscarouselsecondstkaveh extends Widget_Base{

  public function get_name(){
    return 'productscarouselsecondstkaveh';
  }
 
  public function get_title(){
    return esc_html__( 'کاروسل محصولات سبک دو', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }
 
  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تنظیمات عنوان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
   
      $this->add_control(
          'titleproductscarouselsecondstkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'پرفروش ترین محصولات', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'tagheadingproductscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H3',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
  $this->end_controls_section();
  $this->start_controls_section(
    'content2productscarouselsecondstkaveh',
    [
      'label' => esc_html__( 'تنظیمات محصولات', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );
  $this->add_control(
    'stylecartproductscarouselsecondstkaveh',
    [
      'label' => esc_html__( 'طرح بندی باکس محصول', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'one',
      'options' => [
        'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
        'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
        'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
        'four'  => esc_html__( 'طرح بندی چهارم', 'kaveh-core' ),
        'five'  => esc_html__( 'طرح بندی پنجم', 'kaveh-core' ),
        'six'  => esc_html__( 'طرح بندی ششم', 'kaveh-core' ),
        'seven'  => esc_html__( 'طرح بندی هفتم', 'kaveh-core' ),
        'eight'  => esc_html__( 'طرح بندی هشتم', 'kaveh-core' ),
        'nine'  => esc_html__( 'طرح بندی نهم', 'kaveh-core' ),
        'ten'  => esc_html__( 'طرح بندی دهم', 'kaveh-core' ),
        'eleven'  => esc_html__( 'طرح بندی یازدهم', 'kaveh-core' ),
        'twelve'  => esc_html__( 'طرح بندی دوازدهم', 'kaveh-core' ),
        'thirteen'  => esc_html__( 'طرح بندی سیزدهم', 'kaveh-core' ),
        'fourteen'  => esc_html__( 'طرح بندی چهاردهم', 'kaveh-core' ),
        'fifteen'  => esc_html__( 'طرح بندی پانزدهم', 'kaveh-core' ),
        'sixteen'  => esc_html__( 'طرح بندی شانزدهم', 'kaveh-core' ),

      ],
    ]
    );

    $this->add_control(
      'pproductscarouselsecondstkaveh',
      [
        'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'all',
        'options' => [
          'all'  => esc_html__( 'همه', 'kaveh-core' ),
          'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),
  
        ],
      ]
      );
      $this->add_control(
        'kaveh_exclude_out_of_stock',
        [
          'label' => esc_html__( 'عدم نمایش محصولات ناموجود', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'psortproductscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'date',
          'options' => [
            'date'  => esc_html__( 'تاریخ', 'kaveh-core' ),
            '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
            '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
            'total_sales'  => esc_html__( 'میزان فروش', 'kaveh-core' ),
    
          ],
        ]
        );
        $this->add_control(
          'psortiproductscarouselsecondstkaveh',
          [
            'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'desc',
            'options' => [
              'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
              'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
            ],
          ]
          );
  $options2 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $options2[$category->term_id] = $category->name;
}
$this->add_control(
    'catproductscarouselsecondstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $options2,
      'condition' => [
        'pproductscarouselsecondstkaveh' => 'cat',
      ],
    ]
);
$this->end_controls_section();
$this->start_controls_section(
  'content3productscarouselsecondstkaveh',
  [
    'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'productnumberproductscarouselsecondstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 50,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnproductscarouselsecondstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 4,

  ]
);
$this->add_control(
  'productcolumn2productscarouselsecondstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 3,

  ]
);
$this->add_control(
  'productcolumn3productscarouselsecondstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 1,

  ]
); 
       $this->end_controls_section();
       $this->start_controls_section(
        'style_productscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor2productscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-selling-products-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titleproductscarouselsecondstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-selling-products-title',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_productscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'استایل پس زمینه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'bgcolorproductscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-selling-products::before' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

    <section class="best-selling-products position-relative">
      <div class="container">
        <<?php echo  esc_attr($settings['tagheadingproductscarouselsecondstkaveh']); ?> class="best-selling-products-title text-center"><?php echo  esc_html($settings['titleproductscarouselsecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingproductscarouselsecondstkaveh']); ?>>
        <div class="swiper swiper-products swiper-shadow overflow-hidden" data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo  esc_html($settings['productcolumn3productscarouselsecondstkaveh']); ?>,"spaceBetween":4},"500":{"slidesPerView":<?php echo  esc_html($settings['productcolumn3productscarouselsecondstkaveh']); ?>,"spaceBetween":14},"768":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2productscarouselsecondstkaveh']); ?>,"spaceBetween":14},"992":{"slidesPerView":<?php echo  esc_html($settings['productcolumnproductscarouselsecondstkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo  esc_html($settings['productcolumnproductscarouselsecondstkaveh']); ?>,"spaceBetween":31}}}'>
          <div class="swiper-wrapper">
            <?php if('cat'===$settings['pproductscarouselsecondstkaveh']){ ?>

                <?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouselsecondstkaveh'],
                  'orderby' => $settings['psortproductscarouselsecondstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouselsecondstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                    array(
                      'taxonomy' => 'product_cat',
                      'field' => 'term_id',
                      'terms' => $settings['catproductscarouselsecondstkaveh'],
                    ),
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouselsecondstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="swiper-slide h-auto">
                      <?php $styleproduct2 = $settings['stylecartproductscarouselsecondstkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>


                <?php }elseif('all'===$settings['pproductscarouselsecondstkaveh']){
                ?>
                <?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouselsecondstkaveh'],
                  'orderby' => $settings['psortproductscarouselsecondstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouselsecondstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouselsecondstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="swiper-slide h-auto">
                      <?php $styleproduct2 = $settings['stylecartproductscarouselsecondstkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>
                <?php } ?>
            </div>
          <div class="swiper-button-next d-none"></div>
          <div class="swiper-button-prev d-none"></div>
        </div>
      </div>
    </section>
    <?php do_action('kelementor_inline_scripts'); ?>
    <style>
      <?php echo '.elementor-element-' . $clsid . ''; ?> .top-sellers-two .swiper::before {
    content: "";
    right: 0;
    bottom: 190px;
    left: 0;
    width: 80%;
    -webkit-border-radius: 50px;
    -moz-border-radius: 50px;
    border-radius: 50px;
    background-color: #ee273a;
    height: 50px;
    margin: 0 auto;
}
    </style>
    <?php
  }


}
