<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productscarouselninthstkaveh extends Widget_Base{

  public function get_name(){
    return 'productscarouselninthstkaveh';
  }
 
  public function get_title(){
    return esc_html__( 'کاروسل محصولات سبک نه', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }
 
  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductscarouselninthstkaveh',
        [
          'label' => esc_html__( 'تنظیمات عنوان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
    
      $this->add_control(
          'titleproductscarouselninthstkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'پرفروش ترین محصولات', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'tagheadingproductscarouselninthstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H2',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'title3productscarouselninthstkaveh',
        [
            'label' => esc_html__( 'عنوان فرعی بولد', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'فروش ویژه', 'kaveh-core' ),
    
        ]
    );
      $this->add_control(
        'title2productscarouselninthstkaveh',
        [
            'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'شب عید', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tag2headingproductscarouselninthstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H4',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $this->add_control(
      'showbutton1productscarouselninthstkaveh',
      [
        'label' => esc_html__( 'نمایش دکمه؟', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__( 'بله', 'kaveh-core' ),
        'no' => esc_html__( 'خیر', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
      );
      $this->add_control(
        'buttons2productscarouselninthstkaveh',
        [
            'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'محصولات', 'kaveh-core' ),
            'condition' => [
              'showbutton1productscarouselninthstkaveh' => 'yes',
            ],
        ]
    );
    $this->add_control(
      'iconbutts2productscarouselninthstkaveh',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'condition' => [
          'showbutton1productscarouselninthstkaveh' => 'yes',
        ],
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-eye-2',
        ],
      ]
    );
    $this->add_control(
      'linkbuttons2productscarouselninthstkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
              'showbutton1productscarouselninthstkaveh' => 'yes',
            ],
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'content2productscarouselninthstkaveh',
    [
      'label' => esc_html__( 'تنظیمات محصولات', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );
  $this->add_control(
    'stylecartproductscarouselninthstkaveh',
    [
      'label' => esc_html__( 'طرح بندی باکس محصول', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'one',
      'options' => [
        'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
        'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
        'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
        'four'  => esc_html__( 'طرح بندی چهارم', 'kaveh-core' ),
        'five'  => esc_html__( 'طرح بندی پنجم', 'kaveh-core' ),
        'six'  => esc_html__( 'طرح بندی ششم', 'kaveh-core' ),
        'seven'  => esc_html__( 'طرح بندی هفتم', 'kaveh-core' ),
        'eight'  => esc_html__( 'طرح بندی هشتم', 'kaveh-core' ),
        'nine'  => esc_html__( 'طرح بندی نهم', 'kaveh-core' ),
        'ten'  => esc_html__( 'طرح بندی دهم', 'kaveh-core' ),
        'eleven'  => esc_html__( 'طرح بندی یازدهم', 'kaveh-core' ),
        'twelve'  => esc_html__( 'طرح بندی دوازدهم', 'kaveh-core' ),
        'thirteen'  => esc_html__( 'طرح بندی سیزدهم', 'kaveh-core' ),
        'fourteen'  => esc_html__( 'طرح بندی چهاردهم', 'kaveh-core' ),
        'fifteen'  => esc_html__( 'طرح بندی پانزدهم', 'kaveh-core' ),
        'sixteen'  => esc_html__( 'طرح بندی شانزدهم', 'kaveh-core' ),

      ],
    ]
    );
    $this->add_control(
      'kaveh_exclude_out_of_stock',
      [
        'label' => esc_html__( 'عدم نمایش محصولات ناموجود', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__( 'بله', 'kaveh-core' ),
        'no' => esc_html__( 'خیر', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'pproductscarouselninthstkaveh',
      [
        'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'all',
        'options' => [
          'all'  => esc_html__( 'همه', 'kaveh-core' ),
          'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),
  
        ],
      ]
      );
      $this->add_control(
        'psortproductscarouselninthstkaveh',
        [
          'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'date',
          'options' => [
            'date'  => esc_html__( 'تاریخ', 'kaveh-core' ),
            '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
            '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
            'total_sales'  => esc_html__( 'میزان فروش', 'kaveh-core' ),
    
          ],
        ]
        );
        $this->add_control(
          'psortiproductscarouselninthstkaveh',
          [
            'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'desc',
            'options' => [
              'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
              'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
            ],
          ]
          );
  $options2 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $options2[$category->term_id] = $category->name;
}
$this->add_control(
    'catproductscarouselninthstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $options2,
      'condition' => [
        'pproductscarouselninthstkaveh' => 'cat',
      ],
    ]
);
$this->end_controls_section();
$this->start_controls_section(
  'content3productscarouselninthstkaveh',
  [
    'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'showarrowproductscarouselninthstkaveh',
  [
    'label' => esc_html__( 'نمایش فلش ها؟', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'yes' => esc_html__( 'بله', 'kaveh-core' ),
    'no' => esc_html__( 'خیر', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
  );
$this->add_control(
  'productnumberproductscarouselninthstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 50,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnproductscarouselninthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 4,

  ]
);
$this->add_control(
  'productcolumn2productscarouselninthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 3,

  ]
);
$this->add_control(
  'productcolumn3productscarouselninthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 2,

  ]
); 
       $this->end_controls_section();
       $this->start_controls_section(
        'style_productscarouselninthstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor2productscarouselninthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-nine .title-en' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titleproductscarouselninthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-nine .title-en',
        ]
      );
      $this->add_control(
        'textcolor3productscarouselninthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-nine .title b' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcolor22productscarouselninthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-nine .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2productscarouselninthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-nine .title',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleb_productscarouselninthstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showbutton1productscarouselninthstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_nchbproductscarouselninthstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-nine a',
        ]
      );
      $this->add_control(
        'iconsizenchbproductscarouselninthstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-nine a i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadownchbproductscarouselninthstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-nine a',
        ]
      );
      $this->start_controls_tabs(
        'style_tabsnchbproductscarouselninthstkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabnchbproductscarouselninthstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolornchbproductscarouselninthstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-nine a' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconcolornchbproductscarouselninthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-nine a i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolornchbproductscarouselninthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-nine a::before' => 'background-color: {{VALUE}}',

          ],
        ]
      ); 
      
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabnchbproductscarouselninthstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhovernchbproductscarouselninthstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-nine a:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconcolorhovernchbproductscarouselninthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-nine a:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhovernchbproductscarouselninthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-nine a::before:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hr1nchbproductscarouselninthstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingnchbproductscarouselninthstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-nine a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );

      $this->end_controls_section();
      $this->start_controls_section(
        'style3_productscarouselninthstkaveh',
        [
          'label' => esc_html__( 'استایل عمومی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'bgcolorproductscarouselninthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-wrapper' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 

      $this->add_control(
        'bgcoloriconproductscarouselninthstkaveh',
        [
          'label' => esc_html__( 'رنگ فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'showarrowproductscarouselninthstkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .swiper-button-next::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .swiper-button-prev::after' => 'color: {{VALUE}}',

          ],
        ]
      ); 
      $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

<section class="selling-specials-two">
      <div class="container position-relative">
        <!-- Start Heading -->
        <div class="section-heading-nine mx-auto w-100 text-center mb-5">
          <<?php echo  esc_attr($settings['tagheadingproductscarouselninthstkaveh']); ?> class="title-en"><?php echo esc_html($settings['titleproductscarouselninthstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingproductscarouselninthstkaveh']); ?>>
          <<?php echo  esc_attr($settings['tag2headingproductscarouselninthstkaveh']); ?> class="title">
            <b><?php echo esc_html($settings['title3productscarouselninthstkaveh']); ?></b>
            <?php echo esc_html($settings['title2productscarouselninthstkaveh']); ?>
          </<?php echo  esc_attr($settings['tag2headingproductscarouselninthstkaveh']); ?>>
          <?php if("yes"===$settings['showbutton1productscarouselninthstkaveh']){?>
          <a href="<?php echo esc_url($settings['linkbuttons2productscarouselninthstkaveh']); ?>" class="position-relative d-flex align-items-center">
          <?php echo esc_html($settings['buttons2productscarouselninthstkaveh']); ?>
            <i class="<?php echo esc_attr($settings['iconbutts2productscarouselninthstkaveh']['value']); ?> ms-2"></i>
          </a>
          <?php } ?>
        </div>
        <!-- End Heading -->
        <!-- Start Carousel -->
        <div class="swiper swiper-selling-specials-two swiper-button-arrow swiper-visible" data-swiper='{"watchSlidesProgress":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"pagination":{"el":".swiper-pagination","type":"bullets","clickable":true},"breakpoints":{"320":{"slidesPerView":<?php echo  esc_html($settings['productcolumn3productscarouselninthstkaveh']); ?>,"spaceBetween":4},"500":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2productscarouselninthstkaveh']); ?>,"spaceBetween":12},"768":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2productscarouselninthstkaveh']); ?>,"spaceBetween":20},"992":{"slidesPerView":<?php echo  esc_html($settings['productcolumnproductscarouselninthstkaveh']); ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo  esc_html($settings['productcolumnproductscarouselninthstkaveh']); ?>,"spaceBetween":30}}}'>
        <div class="swiper-wrapper">
            <?php if('cat'===$settings['pproductscarouselninthstkaveh']){ ?>
                <?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouselninthstkaveh'],
                  'orderby' => $settings['psortproductscarouselninthstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouselninthstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                    array(
                      'taxonomy' => 'product_cat',
                      'field' => 'term_id',
                      'terms' => $settings['catproductscarouselninthstkaveh'],
                    ),
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouselninthstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="swiper-slide h-auto">
                      <?php $styleproduct2 = $settings['stylecartproductscarouselninthstkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>


         
              <?php }elseif('all'===$settings['pproductscarouselninthstkaveh']){
                ?>
<?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouselninthstkaveh'],
                  'orderby' => $settings['psortproductscarouselninthstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouselninthstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouselninthstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="swiper-slide h-auto">
                      <?php $styleproduct2 = $settings['stylecartproductscarouselninthstkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>

                <?php } ?>
            </div>
            <?php if("yes"===$settings['showarrowproductscarouselninthstkaveh']){?>
          <div class="swiper-bottom d-flex align-items-center justify-content-center position-absolute top-0 w-100">
            <div class="swiper-pagination position-relative w-auto h-auto top-0 start-0 bottom-0 end-0 m-0 me-3"></div>
            <div class="swiper-button-prev position-relative w-auto h-auto top-0 start-0 bottom-0 end-0 m-0 me-3"></div>
            <div class="swiper-button-next position-relative w-auto h-auto top-0 start-0 bottom-0 end-0 m-0"></div>
          </div>
          <?php } ?>
            <!-- Start Button -->
            <!-- End Button -->
          </div>
        <!-- End Carousel -->
      </div>
    </section>
    <?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
