<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly


class Productscarouselfourthstkaveh extends Widget_Base
{

  public function get_name()
  {
    return 'productscarouselfourthstkaveh';
  }

  public function get_title()
  {
    return esc_html__('کاروسل محصولات سبک چهار', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['kavehelements'];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'contentproductscarouselfourthstkaveh',
      [
        'label' => esc_html__('عنوان المان', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'titleproductscarouselfourthstkaveh',
      [
        'label' => esc_html__('عنوان فرعی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('پرفروش ترین محصولات', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'title2productscarouselfourthstkaveh',
      [
        'label' => esc_html__('عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('پوشاک ورزشی', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'tagheadingproductscarouselfourthstkaveh',
      [
        'label' => esc_html__('تگ عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1' => esc_html__('H1', 'kaveh-core'),
          'H2' => esc_html__('H2', 'kaveh-core'),
          'H3' => esc_html__('H3', 'kaveh-core'),
          'H4' => esc_html__('H4', 'kaveh-core'),
          'H5' => esc_html__('H5', 'kaveh-core'),
          'H6' => esc_html__('H6', 'kaveh-core'),
          'p' => esc_html__('p', 'kaveh-core'),
          'div' => esc_html__('div', 'kaveh-core'),
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'content2productscarouselfourthstkaveh',
      [
        'label' => esc_html__('تصاویر', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'imgproductscarouselfourthstkaveh',
      [
        'label' => esc_html__('تصویر خود را انتخاب کنید', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .new-products-category-title::after' =>
            'background: url({{URL}})',
          '{{WRAPPER}} .new-products-category-title::before' =>
            'background: url({{URL}})',
        ],
      ]
    );

    $this->add_control(
      'imgbgproductscarouselfourthstkaveh',
      [
        'label' => esc_html__('تصویر پس زمینه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .new-products-category-title' =>
            'background: url({{URL}})',
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'content3productscarouselfourthstkaveh',
      [
        'label' => esc_html__('تنظیمات محصولات', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'kaveh_exclude_out_of_stock',
      [
        'label' => esc_html__('عدم نمایش محصولات ناموجود', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__('بله', 'kaveh-core'),
        'no' => esc_html__('خیر', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'pproductscarouselfourthstkaveh',
      [
        'label' => esc_html__('نمایش محصولات', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'all',
        'options' => [
          'all' => esc_html__('همه', 'kaveh-core'),
          'cat' => esc_html__('دسته بندی', 'kaveh-core'),

        ],
      ]
    );
    $this->add_control(
      'psortproductscarouselfourthstkaveh',
      [
        'label' => esc_html__('مرتب سازی محصولات براساس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'date',
        'options' => [
          'date' => esc_html__('تاریخ', 'kaveh-core'),
          '_price' => esc_html__('قیمت', 'kaveh-core'),
          '_wc_average_rating' => esc_html__('محبوب ترین', 'kaveh-core'),
          'total_sales' => esc_html__('میزان فروش', 'kaveh-core'),

        ],
      ]
    );
    $this->add_control(
      'psortiproductscarouselfourthstkaveh',
      [
        'label' => esc_html__('نوع مرتب سازی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'desc',
        'options' => [
          'asc' => esc_html__('صعودی', 'kaveh-core'),
          'desc' => esc_html__('نزولی', 'kaveh-core'),
        ],
      ]
    );
    $options4 = array();
    $orderby = 'name';
    $order = 'asc';
    $hide_empty = false;
    $cat_args = array(
      'orderby' => $orderby,
      'order' => $order,
      'hide_empty' => $hide_empty,
    );

    $product_categories = get_terms('product_cat', $cat_args);

    foreach ($product_categories as $key => $category) {
      $options4[$category->term_id] = $category->name;
    }
    $this->add_control(
      'catproductscarouselfourthstkaveh',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => true,
        'options' => $options4,
        'condition' => [
          'pproductscarouselfourthstkaveh' => 'cat',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'content4productscarouselfourthstkaveh',
      [
        'label' => esc_html__('تنظیمات کاروسل', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'showarrowsproductscarouselfourthstkaveh',
      [
        'label' => esc_html__('نمایش جهت ها؟', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__('بله', 'kaveh-core'),
        'no' => esc_html__('خیر', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'productnumberproductscarouselfourthstkaveh',
      [
        'label' => esc_html__('تعداد محصولات نمایش داده شده', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 50,
        'step' => 1,
        'default' => 5,
      ]
    );
    $this->add_control(
      'productcolumnproductscarouselfourthstkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در دسکتاپ', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 0.5,
        'default' => 3,

      ]
    );
    $this->add_control(
      'productcolumn2productscarouselfourthstkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در تبلت', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 0.5,
        'default' => 2,

      ]
    );
    $this->add_control(
      'productcolumn3productscarouselfourthstkaveh',
      [
        'label' => esc_html__('تعداد ستون محصولات در موبایل', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 0.5,
        'default' => 1.5,

      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_productscarouselfourthstkaveh',
      [
        'label' => esc_html__('استایل عناوین', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'textcolor3productscarouselfourthstkaveh',
      [
        'label' => esc_html__('رنگ عنوان فرعی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}}  .new-products-category-title .prcr4 span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title2_productscarouselfourthstkaveh',
        'label' => esc_html__('تایپوگرافی عنوان فرعی', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .new-products-category-title .prcr4 span',
      ]
    );
    $this->add_control(
      'textcolor2productscarouselfourthstkaveh',
      [
        'label' => esc_html__('رنگ عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}}  .new-products-category-title .prcr4' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title_productscarouselfourthstkaveh',
        'label' => esc_html__('تایپوگرافی عنوان اصلی', 'kaveh-core'),
        'selector' => '{{WRAPPER}}  .new-products-category-title .prcr4',
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style2_productscarouselfourthstkaveh',
      [
        'label' => esc_html__('استایل تصاویر', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'widthbgproductscarouselfourthstkaveh',
      [
        'label' => esc_html__('عرض تصویر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'selectors' => [
          '{{WRAPPER}} .new-products-category-title::after' => 'width: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .new-products-category-title::before' => 'width: {{SIZE}}{{UNIT}};',
        ],
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 2000,
            'step' => 5,
          ],
        ],
      ]
    );
    $this->add_control(
      'rightbgproductscarouselfourthstkaveh',
      [
        'label' => esc_html__('فاصله از راست', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'range' => [
          'px' => [
            'min' => -500,
            'max' => 500,
            'step' => 5,
          ],
          '%' => [
            'min' => -100,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .new-products-category-title::after, .new-products-category-title::before' => 'right: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style3_productscarouselfourthstkaveh',
      [
        'label' => esc_html__('استایل باکس', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'borderradiusproductscarouselfourthstkaveh',
      [
        'label' => esc_html__('گوشه خمیده باکس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .new-products-category-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style5_productscarouselfourthstkaveh',
      [
        'label' => esc_html__('استایل جهت های کاروسل', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'showarrowsproductscarouselfourthstkaveh' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'arrowscolorproductscarouselfourthstkaveh',
      [
        'label' => esc_html__('رنگ جهت های کاروسل', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .new-products-category .swiper-button-next' => 'border : 2px solid  {{VALUE}}',
          '{{WRAPPER}} .new-products-category .swiper-button-prev' => 'border : 2px solid  {{VALUE}}',
          '{{WRAPPER}} .new-products-category .swiper-button-next::after' => 'color: {{VALUE}}',
          '{{WRAPPER}} .new-products-category .swiper-button-prev::after' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
  }

  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();

    ?>
    <?php $options = get_option('kaveh_frame'); ?>
    <?php $woo_currency = get_woocommerce_currency_symbol(); ?>


    <section class="new-products-category">
      <div class="container d-flex position-relative flex-column flex-sm-row">
        <div class="new-products-category-title position-relative d-none d-md-block">
          <<?php echo esc_attr($settings['tagheadingproductscarouselfourthstkaveh']); ?> class="text-white position-absolute
            prcr4">
            <span class="d-block fw-light"> <?php echo esc_html($settings['titleproductscarouselfourthstkaveh']); ?></span>
            <?php echo esc_html($settings['title2productscarouselfourthstkaveh']); ?>
          </<?php echo esc_attr($settings['tagheadingproductscarouselfourthstkaveh']); ?>>
        </div>
        <div class="swiper swiper-new-products-category overflow-hidden"
          data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productscarouselfourthstkaveh']); ?>,"spaceBetween":0},"576":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productscarouselfourthstkaveh']); ?>,"spaceBetween":0},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productscarouselfourthstkaveh']); ?>,"spaceBetween":0},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductscarouselfourthstkaveh']); ?>,"spaceBetween":0}}}'>

          <div class="swiper-wrapper">
            <div class="swiper-slide d-md-none">
              <div class="new-products-category-title position-relative buy-vip-right">
                <<?php echo esc_attr($settings['tagheadingproductscarouselfourthstkaveh']); ?> class="position-absolute
                  prcr4">
                  <span class="d-block"> <?php echo esc_html($settings['titleproductscarouselfourthstkaveh']); ?> </span>
                  <?php echo esc_html($settings['title2productscarouselfourthstkaveh']); ?>
                </<?php echo esc_attr($settings['tagheadingproductscarouselfourthstkaveh']); ?>>
              </div>
            </div>
            <?php if ('cat' === $settings['pproductscarouselfourthstkaveh']) { ?>
               <?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouselfourthstkaveh'],
                  'orderby' => $settings['psortproductscarouselfourthstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouselfourthstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                    array(
                      'taxonomy' => 'product_cat',
                      'field' => 'term_id',
                      'terms' => $settings['catproductscarouselfourthstkaveh'],
                    ),
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouselfourthstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    $post_id = get_the_ID();
                    $product = wc_get_product($post_id);
                    ?>
                    <div class="swiper-slide">
                      <div class="product product-ten">
                        <div class="product-image">
                          <?php if ($product->get_stock_status() === 'outofstock'): ?>
                            <div class="status">
                              ناموجود
                            </div>
                          <?php endif; ?>
                          <a href="<?php the_permalink(); ?>">
                            <img src="<?php if(get_the_post_thumbnail_url()): ?>
                            <?php the_post_thumbnail_url('full'); ?>
                            <?php else: ?>
                            <?php echo wc_placeholder_img_src(); ?>
                            <?php endif; ?>"
                              alt="<?php the_title(); ?>">
                          </a>
                        </div>
                        <div class="detail">
                          <?php if ($product->get_stock_status() !== 'outofstock') { ?>
                            <?php if (!$product->is_type('variable')) { ?>
                              <?php if ($product->is_on_sale()) { ?>
                                <div class="offer">
                                  <?php echo number_format($product->get_sale_price(), 0, '.', ','); ?>
                                </div>
                                <div class="price">
                                  <?php echo number_format($product->get_regular_price(), 0, '.', ','); ?>
                                  <span> <?php echo $woo_currency; ?> </span>
                                </div>
                              <?php } else { ?>
                                <div class="price nor10p">
                                  <?php if (!empty($product->get_regular_price())) {
                                    echo number_format($product->get_regular_price(), 0, '.', ',');
                                  } ?>
                                  <span> <?php echo $woo_currency; ?></span>
                                </div>
                              <?php } ?>
                            <?php } else { ?>
                              <?php
                               echo $product->get_price_html();
                            }
                            ?>
                          <?php } else {
                            ?>
                            <div class="mt-p10"></div>
                            <?php
                          } ?>
                          <?php if (empty($product->get_regular_price())) { ?>
                            <div class="mt-p101"></div>
                          <?php } ?>
                          <h2>
                            <a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a>
                          </h2>
                          <?php if (!empty($product->get_regular_price())) { ?>
                            <?php if ($product->get_stock_status() !== 'outofstock') { ?>
                              <button type="button" class="add-to-cart single_add_to_cart_button position-relative cart11"
                                value="<?php echo $post_id; ?>">
                                <span> + </span>
                                <span> افزودن به سبد خرید </span>
                              </button>
                            <?php }
                          } ?>
                        </div>
                      </div>

                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>


            <?php } elseif ('all' === $settings['pproductscarouselfourthstkaveh']) { ?>
              
              <?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouselfourthstkaveh'],
                  'orderby' => $settings['psortproductscarouselfourthstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouselfourthstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouselfourthstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    $post_id = get_the_ID();
                    $product = wc_get_product($post_id);
                    ?>
                    <div class="swiper-slide">
                      <div class="product product-ten">
                        <div class="product-image">
                          <?php if ($product->get_stock_status() === 'outofstock'): ?>
                            <div class="status">
                              ناموجود
                            </div>
                          <?php endif; ?>
                          <a href="<?php the_permalink(); ?>">
                            <img src="<?php if(get_the_post_thumbnail_url()): ?>
                            <?php the_post_thumbnail_url('full'); ?>
                            <?php else: ?>
                            <?php echo wc_placeholder_img_src(); ?>
                            <?php endif; ?>"
                              alt="<?php the_title(); ?>">
                          </a>
                        </div>
                        <div class="detail">
                          <?php if ($product->get_stock_status() !== 'outofstock') { ?>
                            <?php if (!$product->is_type('variable')) { ?>
                              <?php if ($product->is_on_sale()) { ?>
                                <div class="offer">
                                  <?php echo number_format($product->get_sale_price(), 0, '.', ','); ?>
                                </div>
                                <div class="price">
                                  <?php echo number_format($product->get_regular_price(), 0, '.', ','); ?>
                                  <span> <?php echo $woo_currency; ?> </span>
                                </div>
                              <?php } else { ?>
                                <div class="price nor10p">
                                  <?php if (!empty($product->get_regular_price())) {
                                    echo number_format($product->get_regular_price(), 0, '.', ',');
                                  } ?>
                                  <span> <?php echo $woo_currency; ?></span>
                                </div>
                              <?php } ?>
                            <?php } else { ?>
                              <?php
                               echo $product->get_price_html();
                            }
                            ?>
                          <?php } else {
                            ?>
                            <div class="mt-p10"></div>
                            <?php
                          } ?>
                          <?php if (empty($product->get_regular_price())) { ?>
                            <div class="mt-p101"></div>
                          <?php } ?>
                          <h2>
                            <a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a>
                          </h2>
                          <?php if (!empty($product->get_regular_price())) { ?>
                            <?php if ($product->get_stock_status() !== 'outofstock') { ?>
                              <button type="button" class="add-to-cart single_add_to_cart_button position-relative cart11"
                                value="<?php echo $post_id; ?>">
                                <span> + </span>
                                <span> افزودن به سبد خرید </span>
                              </button>
                            <?php }
                          } ?>
                        </div>
                      </div>

                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>

            <?php } ?>
          </div>
          <?php if ('yes' === $settings['showarrowsproductscarouselfourthstkaveh']) { ?>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
          <?php } ?>
        </div>
      </div>
    </section>
    <style>
      <?php echo '.elementor-element-' . $clsid . ''; ?>
      .new-products-category-title::after,
      .new-products-category-title::before {
        background-repeat: no-repeat !important;
      }

      <?php echo '.elementor-element-' . $clsid . ''; ?>
      .new-products-category-title {
        background-size: cover !important;

      }

      <?php echo '.elementor-element-' . $clsid . ''; ?>
      .new-products-category-title::after,
      .new-products-category-title::before {
        -webkit-background-size: contain !important;
        -moz-background-size: contain !important;
        -o-background-size: contain !important;
        background-size: contain !important;
        object-fit: cover;
      }
    </style>
    <?php do_action('kelementor_inline_scripts'); ?>
  <?php
  }


}
