<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productscarouselfourteenthstkaveh extends Widget_Base{

  public function get_name(){
    return 'productscarouselfourteenthstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل محصولات سبک چهارده', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'عنوان المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'imgproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading::before' =>
                'background: url({{URL}}) 0 0 no-repeat',
                '{{WRAPPER}} .top-selling-products-two-heading::after' =>
                'background: url({{URL}}) 0 0 no-repeat',
        ],
        ]
      );
      $this->add_control(
        'title2productscarouselfourteenthstkaveh',
        [
            'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'محبوب ترین', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheadingproductscarouselfourteenthstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
        ],
      ]
    );
      $this->add_control(
        'titleproducts2carouseleleventhstkaveh',
        [
            'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'پر فروش ترین ها', 'kaveh-core' ),
    
        ]
    );
      $this->add_control(
        'tagheadingfproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H4',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
          ],
        ]
      );
    $this->add_control(
      'buttonti2productscarouselfourteenthstkaveh',
      [
          'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'مشاهده پیشنهاد ویژه', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'iconbuttproductscarouselfourteenthstkaveh',
    [
      'label' => esc_html__( 'آیکون', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::ICONS,
      'skin' => 'inline',
      'exclude_inline_options' => [ 'svg' ],
      'default' => [
        'value' => 'icon-arrow-left-3',
      ],
    ]
  );
  $this->add_control(
    'buttontilink2productscarouselfourteenthstkaveh',
    [
        'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
    $this->end_controls_section();   
  
      $this->start_controls_section(
        'content4productscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'تنظیمات محصولات', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'kaveh_exclude_out_of_stock',
        [
          'label' => esc_html__( 'عدم نمایش محصولات ناموجود', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
  $this->add_control(
    'pproductscarouselfourteenthstkaveh',
    [
      'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'all',
      'options' => [
        'all'  => esc_html__( 'همه', 'kaveh-core' ),
        'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),

      ],
    ]
    );
    $this->add_control(
      'psortproductscarouselfourteenthstkaveh',
      [
        'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'date',
        'options' => [
          'date'  => esc_html__( 'تاریخ', 'kaveh-core' ),
          '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
          '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
          'total_sales'  => esc_html__( 'میزان فروش', 'kaveh-core' ),
  
        ],
      ]
      );
      $this->add_control(
        'psortiproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'desc',
          'options' => [
            'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
            'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
          ],
        ]
        );
  $this->add_control(
    'stylecartproductscarouselfourteenthstkaveh',
    [
      'label' => esc_html__( 'طرح بندی باکس محصول', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'one',
      'options' => [
        'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
        'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
        'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
        'four'  => esc_html__( 'طرح بندی چهارم', 'kaveh-core' ),
        'five'  => esc_html__( 'طرح بندی پنجم', 'kaveh-core' ),
        'six'  => esc_html__( 'طرح بندی ششم', 'kaveh-core' ),
        'seven'  => esc_html__( 'طرح بندی هفتم', 'kaveh-core' ),
        'eight'  => esc_html__( 'طرح بندی هشتم', 'kaveh-core' ),
        'nine'  => esc_html__( 'طرح بندی نهم', 'kaveh-core' ),
        'ten'  => esc_html__( 'طرح بندی دهم', 'kaveh-core' ),
        'eleven'  => esc_html__( 'طرح بندی یازدهم', 'kaveh-core' ),
        'twelve'  => esc_html__( 'طرح بندی دوازدهم', 'kaveh-core' ),
        'thirteen'  => esc_html__( 'طرح بندی سیزدهم', 'kaveh-core' ),
        'fourteen'  => esc_html__( 'طرح بندی چهاردهم', 'kaveh-core' ),
        'fifteen'  => esc_html__( 'طرح بندی پانزدهم', 'kaveh-core' ),
        'sixteen'  => esc_html__( 'طرح بندی شانزدهم', 'kaveh-core' ),

      ],
    ]
    );
  $options5 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $options5[$category->term_id] = $category->name;
}
$this->add_control(
    'catproductscarouselfourteenthstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $options5,
      'condition' => [
        'pproductscarouselfourteenthstkaveh' => 'cat',
      ],
    ]
);
$this->end_controls_section();   
$this->start_controls_section(
  'content5productscarouselfourteenthstkaveh',
  [
    'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'showarrowsproductscarouselfourteenthstkaveh',
  [
    'label' => esc_html__( 'نمایش جهت ها؟', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'yes' => esc_html__( 'بله', 'kaveh-core' ),
    'no' => esc_html__( 'خیر', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);
$this->add_control(
  'productnumberproductscarouselfourteenthstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 50,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnproductscarouselfourteenthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 4,

  ]
); 
$this->add_control(
  'productcolumn2productscarouselfourteenthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 2,

  ]
);
$this->add_control(
  'productcolumn3productscarouselfourteenthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 1.5,

  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'style_productscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor3productscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading .title' => 'color: {{VALUE}} !important;',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_productscarouselfourteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-products-two-heading .title',
        ]
      );

      
      $this->add_control(
        'textcolor21productscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading .sub-title' => 'color: {{VALUE}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_productscarouselfourteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-products-two-heading .sub-title',
        ]
      );
      $this->add_control(
        'bgcolorboldbolproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه نوار عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading' => 'background-image: linear-gradient(268.1deg, {{VALUE}} 8.23%, rgba(242, 229, 221, 0.142986) 92.92%, rgba(242, 229, 221, 0) 128.56%)',
          ],
        ]
      );
      $this->add_control(
        'buttonradiusnavarproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده نوار عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'navarpaddingproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی نوار عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleb_productscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_productscarouselfourteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-products-two-heading .btn',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowproductscarouselfourteenthstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-products-two-heading .btn',
        ]
      );
      $this->add_control(
        'iconsizenchbproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabsproductscarouselfourteenthstkaveh'
      );
    
      $this->start_controls_tab(
        'style_normal_tabproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading .btn' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbutton1colorproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading .btn i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderproductscarouselfourteenthstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-products-two-heading .btn',
        ]
      );
      $this->add_control(
        'buttonbordersproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderproductscarouselfourteenthstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoverproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbutton1hovercolorproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading .btn:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoverproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverproductscarouselfourteenthstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-products-two-heading .btn:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoverproductscarouselfourteenthstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowproductscarouselfourteenthstkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-products-two-heading .btn',
        ]
      );
      $this->add_control(
        'hr2productscarouselfourteenthstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_productscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'استایل تصویر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'imagewidth3productscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 5,
            ],

          ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading::before' => 'width: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .top-selling-products-two-heading::after' => 'width: {{SIZE}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'imageheight3amazingoffersecondstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 5,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two-heading::before' => 'height: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .top-selling-products-two-heading::after' => 'height: {{SIZE}}{{UNIT}};',

          ],
        ]
      );
      
      $this->end_controls_section();
      $this->start_controls_section(
        'style5_productscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'استایل جهت های کاروسل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showarrowsproductscarouselfourteenthstkaveh' => 'yes',

          ],
        ]
      );
      $this->add_control(
        'arrowscolorproductscarouselfourteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ جهت های کاروسل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-two .swiper-button-next::after' => 'color: {{VALUE}} !important;',
            '{{WRAPPER}}  .top-selling-products-two .swiper-button-prev::after' => 'color: {{VALUE}} !important;',
          ],
        ]
      ); 
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="top-selling-products-two">
      <div class="container position-relative">
        <!-- Start Heading -->
        <div class="top-selling-products-two-heading position-relative d-flex align-items-md-center justify-content-md-between flex-column flex-md-row gap-4 gap-md-0">
          <div>
            <<?php echo  esc_attr($settings['tagheadingproductscarouselfourteenthstkaveh']); ?> class="title d-flex align-items-center">
            <?php echo  esc_html($settings['title2productscarouselfourteenthstkaveh']); ?>
            </<?php echo  esc_attr($settings['tagheadingproductscarouselfourteenthstkaveh']); ?>>
            <<?php echo  esc_attr($settings['tagheadingfproductscarouselfourteenthstkaveh']); ?> class="sub-title">  <?php echo  esc_html($settings['titleproducts2carouseleleventhstkaveh']); ?> </<?php echo  esc_attr($settings['tagheadingfproductscarouselfourteenthstkaveh']); ?>>
          </div>
          <a href="<?php echo  esc_url($settings['buttontilink2productscarouselfourteenthstkaveh']); ?>" class="btn btn-dark-3 d-flex align-items-center justify-content-center position-relative">
            <?php echo  esc_html($settings['buttonti2productscarouselfourteenthstkaveh']); ?>
            <i class="<?php echo  esc_html($settings['iconbuttproductscarouselfourteenthstkaveh']['value']); ?>"></i>
          </a>
        </div>
        <!-- End Heading -->
        <!-- Start Carousel -->
        <div class="swiper swiper-top-selling-products-two" data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"watchSlidesProgress":true,"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productscarouselfourteenthstkaveh']); ?>,"spaceBetween":4},"576":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productscarouselfourteenthstkaveh']); ?>,"spaceBetween":20},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productscarouselfourteenthstkaveh']); ?>,"spaceBetween":20},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductscarouselfourteenthstkaveh']); ?>,"spaceBetween":31}}}'>
          <div class="swiper-wrapper">
          <?php if('cat'===$settings['pproductscarouselfourteenthstkaveh']){ ?>

              <?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouselfourteenthstkaveh'],
                  'orderby' => $settings['psortproductscarouselfourteenthstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouselfourteenthstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                    array(
                      'taxonomy' => 'product_cat',
                      'field' => 'term_id',
                      'terms' => $settings['catproductscarouselfourteenthstkaveh'],
                    ),
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouselfourteenthstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="swiper-slide h-auto">
                      <?php $styleproduct2 = $settings['stylecartproductscarouselfourteenthstkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>


              <?php }elseif('all'===$settings['pproductscarouselfourteenthstkaveh']){
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouselfourteenthstkaveh'],
                  'orderby' => $settings['psortproductscarouselfourteenthstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouselfourteenthstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouselfourteenthstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="swiper-slide h-auto">
                      <?php $styleproduct2 = $settings['stylecartproductscarouselfourteenthstkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>
             
                <?php } ?>
          </div>
          <?php if('yes'===$settings['showarrowsproductscarouselfourteenthstkaveh']){ ?>
          <!-- Start Button -->
          <div class="swiper-button-next top-0 end-0"></div>
          <div class="swiper-button-prev top-0"></div>
          <!-- End Button -->
          <?php } ?>
        </div>
        <!-- End Carousel -->
      </div>
    </section>
    <style>
      .top-selling-products-two-heading::before, .top-selling-products-two-heading::after{
        background-size : contain !important;
      }
    </style>
    <?php do_action('kelementor_inline_scripts'); ?>  
    <?php
  }


}
