<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productscarouselfifthstkaveh extends Widget_Base{

  public function get_name(){
    return 'productscarouselfifthstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل محصولات سبک پنج', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductscarouselfifthstkaveh',
        [
          'label' => esc_html__( 'عنوان المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
          'titleproductscarouselfifthstkaveh',
          [
              'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'فروش ویژه', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'title2productscarouselfifthstkaveh',
        [
            'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'مکمل های بدنسازی', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheadingproductscarouselfifthstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
        ],
      ]
    );
    $this->end_controls_section();   
    $this->start_controls_section(
      'content2productscarouselfifthstkaveh',
      [
        'label' => esc_html__( 'تصاویر', 'kaveh-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'imgproductscarouselfifthstkaveh',
      [
        'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .buy-vip-right::after' =>
              'background: url({{URL}}) 0 0 no-repeat',
      ],
      ]
    );
    
    $this->add_control(
      'imgbgproductscarouselfifthstkaveh',
      [
        'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .buy-vip-right' =>
              'background: url({{URL}}) 0 0 no-repeat',
      ],
      ]
    );
    
    $this->end_controls_section();   
    $this->start_controls_section(
      'content3productscarouselfifthstkaveh',
      [
        'label' => esc_html__( 'تایمر', 'kaveh-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
      $this->add_control(
        'showtimercarouselfifthstkaveh',
        [
          'label' => esc_html__( 'نمایش تایمر؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'datecarouselfifthstkaveh',
        [
          'label' => esc_html__( 'تایم تخفیف گروهی؟', 'plugin-name' ),
          'type' => \Elementor\Controls_Manager::DATE_TIME,
          'condition' => [
            'showtimercarouselfifthstkaveh' => 'yes',
          ],
        ]
      );
      $this->end_controls_section();   
      $this->start_controls_section(
        'content4productscarouselfifthstkaveh',
        [
          'label' => esc_html__( 'تنظیمات محصولات', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'kaveh_exclude_out_of_stock',
        [
          'label' => esc_html__( 'عدم نمایش محصولات ناموجود', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
  $this->add_control(
    'pproductscarouselfifthstkaveh',
    [
      'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'all',
      'options' => [
        'all'  => esc_html__( 'همه', 'kaveh-core' ),
        'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),

      ],
    ]
    );
    $this->add_control(
      'psortproductscarouselfifthstkaveh',
      [
        'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'date',
        'options' => [
          'date'  => esc_html__( 'تاریخ', 'kaveh-core' ),
          '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
          '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
          'total_sales'  => esc_html__( 'میزان فروش', 'kaveh-core' ),
  
        ],
      ]
      );
      $this->add_control(
        'psortiproductscarouselfifthstkaveh',
        [
          'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'desc',
          'options' => [
            'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
            'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
          ],
        ]
        );
  $this->add_control(
    'stylecartproductscarouselfifthstkaveh',
    [
      'label' => esc_html__( 'طرح بندی باکس محصول', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'one',
      'options' => [
        'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
        'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
        'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
        'four'  => esc_html__( 'طرح بندی چهارم', 'kaveh-core' ),
        'five'  => esc_html__( 'طرح بندی پنجم', 'kaveh-core' ),
        'six'  => esc_html__( 'طرح بندی ششم', 'kaveh-core' ),
        'seven'  => esc_html__( 'طرح بندی هفتم', 'kaveh-core' ),
        'eight'  => esc_html__( 'طرح بندی هشتم', 'kaveh-core' ),
        'nine'  => esc_html__( 'طرح بندی نهم', 'kaveh-core' ),
        'ten'  => esc_html__( 'طرح بندی دهم', 'kaveh-core' ),
        'eleven'  => esc_html__( 'طرح بندی یازدهم', 'kaveh-core' ),
        'twelve'  => esc_html__( 'طرح بندی دوازدهم', 'kaveh-core' ),
        'thirteen'  => esc_html__( 'طرح بندی سیزدهم', 'kaveh-core' ),
        'fourteen'  => esc_html__( 'طرح بندی چهاردهم', 'kaveh-core' ),
        'fifteen'  => esc_html__( 'طرح بندی پانزدهم', 'kaveh-core' ),
        'sixteen'  => esc_html__( 'طرح بندی شانزدهم', 'kaveh-core' ),
      ],
    ]
    );
  $options5 = array();
  $orderby = 'name';
  $order = 'asc';
  $hide_empty = false ;
  $cat_args = array(
      'orderby'    => $orderby,
      'order'      => $order,
      'hide_empty' => $hide_empty,
  );

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $options5[$category->term_id] = $category->name;
}
$this->add_control(
    'catproductscarouselfifthstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $options5,
      'condition' => [
        'pproductscarouselfifthstkaveh' => 'cat',
      ],
    ]
);
$this->end_controls_section();   
$this->start_controls_section(
  'content5productscarouselfifthstkaveh',
  [
    'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'showarrowsproductscarouselfifthstkaveh',
  [
    'label' => esc_html__( 'نمایش جهت ها؟', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'yes' => esc_html__( 'بله', 'kaveh-core' ),
    'no' => esc_html__( 'خیر', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);
$this->add_control(
  'productnumberproductscarouselfifthstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 50,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnproductscarouselfifthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 3,

  ]
); 
$this->add_control(
  'productcolumn2productscarouselfifthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 2,

  ]
);
$this->add_control(
  'productcolumn3productscarouselfifthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 1.5,

  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'style_productscarouselfifthstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor3productscarouselfifthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}}  .buy-vip-right .prcr5 span' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_productscarouselfifthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .buy-vip-right .prcr5 span',
        ]
      );
      $this->add_control(
        'textcolor2productscarouselfifthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}}  .buy-vip-right .prcr5' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_productscarouselfifthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}}  .buy-vip-right .prcr5',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_productscarouselfifthstkaveh',
        [
          'label' => esc_html__( 'استایل تصاویر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'widthbgproductscarouselfifthstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
          ],
        ]
      );
      $this->add_control(
        'leftbgproductscarouselfifthstkaveh',
        [
          'label' => esc_html__( 'فاصله از راست', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => -500,
              'max' => 500,
              'step' => 5,
            ],
            '%' => [
              'min' => -100,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .buy-vip-right::after' => 'left: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_productscarouselfifthstkaveh',
        [
          'label' => esc_html__( 'استایل باکس', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'borderradiusproductscarouselfifthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .buy-vip-right' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      
      $this->end_controls_section();
      $this->start_controls_section(
        'style5_productscarouselfifthstkaveh',
        [
          'label' => esc_html__( 'استایل جهت های کاروسل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showarrowsproductscarouselfifthstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'arrowscolorproductscarouselfifthstkaveh',
        [
          'label' => esc_html__( 'رنگ جهت های کاروسل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .buy-vip .swiper-button-next::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .buy-vip .swiper-button-prev::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .buy-vip .swiper-button-next' => 'border:2px solid  {{VALUE}}',
            '{{WRAPPER}} .buy-vip .swiper-button-prev' => 'border:2px solid  {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_section();

      $this->start_controls_section(
        'style4_productscarouselfifthstkaveh',
        [
          'label' => esc_html__( 'استایل تایمر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showtimercarouselfifthstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'bordercolorproductscarouselfifthstkaveh',
        [
          'label' => esc_html__( 'رنگ خطوط', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .buy-vip-left .timear::before' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .buy-vip-left .timear::after' => 'background-color: {{VALUE}}',

          ],
        ]
      ); 
      $this->add_control(
        'texttimercolorproductscarouselfifthstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته تایمر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .buy-vip-left .timear li span' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'bgtimercolorproductscarouselfifthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه تایمر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .buy-vip-left .timear li span' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="buy-vip">
      <div class="container d-flex flex-column flex-sm-row position-relative">
        <div class="buy-vip-right position-relative d-none d-md-block">
          <<?php echo  esc_attr($settings['tagheadingproductscarouselfifthstkaveh']); ?> class="prcr5">
            <span class="d-block"> <?php echo  esc_html($settings['titleproductscarouselfifthstkaveh']); ?></span>
            <?php echo  esc_html($settings['title2productscarouselfifthstkaveh']); ?>
          </<?php echo  esc_attr($settings['tagheadingproductscarouselfifthstkaveh']); ?>>
        </div>
      <div class="buy-vip-left position-relative">
          <?php $deal_end_date = $settings['datecarouselfifthstkaveh']; ?>
          <?php if (!empty($deal_end_date)){ ?>
          <ul class="timear d-flex align-items-center ms-auto" data-time="<?php  echo $deal_end_date; ?>">
            <li>
              <span class="second"> 00 </span>
              ثانیه
            </li>
            <li>
              <span class="minute"> 00 </span>
              دقیقه
            </li>
            <li>
              <span class="hour"> 00 </span>
              ساعت
            </li>
            <li>
              <span class="day"> 00 </span>
              روز
            </li>
          </ul>
          <?php }else{}
           ?>
          <!-- Start Products --> 
        <div class="swiper swiper-products-buy-vip overflow-hidden" data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productscarouselfifthstkaveh']); ?>,"spaceBetween":8},"576":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productscarouselfifthstkaveh']); ?>,"spaceBetween":4},"768":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2productscarouselfifthstkaveh']); ?>,"spaceBetween":8},"992":{"slidesPerView":<?php echo  esc_html($settings['productcolumnproductscarouselfifthstkaveh']); ?>,"spaceBetween":13}}}'>
          <div class="swiper-wrapper">
              <div class="swiper-slide d-md-none">
                  <div class="buy-vip-right position-relative">
                    <<?php echo  esc_attr($settings['tagheadingproductscarouselfifthstkaveh']); ?> class="text-white prcr5">
                      <span class="d-block fw-light"> <?php echo  esc_html($settings['titleproductscarouselfifthstkaveh']); ?> </span>
                      <?php echo  esc_html($settings['title2productscarouselfifthstkaveh']); ?>
                    </<?php echo  esc_attr($settings['tagheadingproductscarouselfifthstkaveh']); ?>>
                  </div>
              </div>
            <?php if('cat'===$settings['pproductscarouselfifthstkaveh']){ ?>
                <?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouselfifthstkaveh'],
                  'orderby' => $settings['psortproductscarouselfifthstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouselfifthstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                    array(
                      'taxonomy' => 'product_cat',
                      'field' => 'term_id',
                      'terms' => $settings['catproductscarouselfifthstkaveh'],
                    ),
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouselfifthstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="swiper-slide h-auto">
                      <?php $styleproduct2 = $settings['stylecartproductscarouselfifthstkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>

              <?php }elseif('all'===$settings['pproductscarouselfifthstkaveh']){
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouselfifthstkaveh'],
                  'orderby' => $settings['psortproductscarouselfifthstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouselfifthstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouselfifthstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="swiper-slide h-auto">
                      <?php $styleproduct2 = $settings['stylecartproductscarouselfifthstkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>
       
                <?php } ?>
            </div>
          <?php if('yes'===$settings['showarrowsproductscarouselfifthstkaveh']){ ?>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
            <?php } ?>
        </div>
          <!-- End Products -->
        </div>
      </div>
    </section>
    <style>
      <?php echo '.elementor-element-' . $clsid . ''; ?> .buy-vip-right::after {
     -webkit-background-size: contain !important;
    -moz-background-size: contain !important;
    -o-background-size: contain !important;
    background-size: contain !important;
    object-fit: cover ;
    width: <?php echo esc_html($settings['widthbgproductscarouselfifthstkaveh']['size']); ?>px !important;
}
<?php echo '.elementor-element-' . $clsid . ''; ?> .buy-vip-right {
    -webkit-background-size: cover !important;
    -moz-background-size: cover !important;
    -o-background-size: cover !important;
    background-size: cover !important;
}
    </style>
    <?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
