<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productscarouselfifteenthstkaveh extends Widget_Base{

  public function get_name(){
    return 'productscarouselfifteenthstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل محصولات سبک پانزده', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'عنوان المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'title2productscarouselfifteenthstkaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'محبوب ترین', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheadingproductscarouselfifteenthstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
        ],
      ]
    );
      $this->add_control(
        'titleproducts2carouseleleventhstkaveh',
        [
            'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'پر فروش ترین ها', 'kaveh-core' ),
    
        ]
    );
      $this->add_control(
        'tagheadingfproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'div',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
          ],
        ]
      );
    $this->add_control(
      'buttonti2productscarouselfifteenthstkaveh',
      [
          'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'مشاهده پیشنهاد ویژه', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'iconbuttproductscarouselfifteenthstkaveh',
    [
      'label' => esc_html__( 'آیکون', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::ICONS,
      'skin' => 'inline',
      'exclude_inline_options' => [ 'svg' ],
      'default' => [
        'value' => 'icon-angle-left',
      ],
    ]
  );
  $this->add_control(
    'buttontilink2productscarouselfifteenthstkaveh',
    [
        'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
$this->add_control(
  'showticol1productscarouselfifteenthstkaveh',
  [
    'label' => esc_html__( 'نمایش ستون اول ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'yes' => esc_html__( 'بله', 'kaveh-core' ),
    'no' => esc_html__( 'خیر', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);
    $this->end_controls_section();   
    $this->start_controls_section(
      'contentcol1productscarouselfifteenthstkaveh',
      [
        'label' => esc_html__( 'ستون اول کاروسل', 'kaveh-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                  'showticol1productscarouselfifteenthstkaveh' => 'yes',
                ],
      ]
    );
    $this->add_control(
      'titlecol1productscarouselfifteenthstkaveh',
      [
          'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'پر فروش ترین ها', 'kaveh-core' ),
  
      ]
  );
    $this->add_control(
      'tagheadingfcol1productscarouselfifteenthstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H4',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
        ],
      ]
    );
    $this->add_control(
      'title2col1productscarouselfifteenthstkaveh',
      [
          'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'apple', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'tagheadingcol1productscarouselfifteenthstkaveh',
    [
      'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'div',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
      ],
    ]
  );
    $this->add_control(
      'titlepcol1productscarouselfifteenthstkaveh',
      [
          'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXTAREA,
          'default' => esc_html__( ' پرفروش‌ترین محصولات اپل به انتخاب مشتریان و با تضمین بالاترین کیفیت و ضمانت اصالت', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
      'bottomimgproductscarouselfifteenthstkaveh',
      [
        'label' => esc_html__( 'تصویر', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
      ]
      );

    $this->end_controls_section();   

      $this->start_controls_section(
        'content4productscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'تنظیمات محصولات', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'kaveh_exclude_out_of_stock',
        [
          'label' => esc_html__( 'عدم نمایش محصولات ناموجود', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
  $this->add_control(
    'pproductscarouselfifteenthstkaveh',
    [
      'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'all',
      'options' => [
        'all'  => esc_html__( 'همه', 'kaveh-core' ),
        'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),

      ],
    ]
    );
    $this->add_control(
      'psortproductscarouselfifteenthstkaveh',
      [
        'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'date',
        'options' => [
          'date'  => esc_html__( 'تاریخ', 'kaveh-core' ),
          '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
          '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
          'total_sales'  => esc_html__( 'میزان فروش', 'kaveh-core' ),
  
        ],
      ]
      );
      $this->add_control(
        'psortiproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'desc',
          'options' => [
            'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
            'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
          ],
        ]
        );
  $options5 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $options5[$category->term_id] = $category->name;
}
$this->add_control(
    'catproductscarouselfifteenthstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $options5,
      'condition' => [
        'pproductscarouselfifteenthstkaveh' => 'cat',
      ],
    ]
);
$this->end_controls_section();   
$this->start_controls_section(
  'content5productscarouselfifteenthstkaveh',
  [
    'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'showarrowsproductscarouselfifteenthstkaveh',
  [
    'label' => esc_html__( 'نمایش جهت ها؟', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'yes' => esc_html__( 'بله', 'kaveh-core' ),
    'no' => esc_html__( 'خیر', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);
$this->add_control(
  'productnumberproductscarouselfifteenthstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 50,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnproductscarouselfifteenthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.2,
    'default' => 4.6,

  ]
); 
$this->add_control(
  'productcolumn2productscarouselfifteenthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.2,
    'default' => 3.2,

  ]
);
$this->add_control(
  'productcolumn3productscarouselfifteenthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.2,
    'default' => 1.4,

  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'style_productscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor21productscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-heading .title' => 'color: {{VALUE}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_productscarouselfifteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-nic-heading .title',
        ]
      );
      $this->add_control(
        'textcolor3productscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-heading .sub-title' => 'color: {{VALUE}} !important;',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_productscarouselfifteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-nic-heading .sub-title',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleb_productscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_productscarouselfifteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-nic-heading a',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowproductscarouselfifteenthstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-nic-heading a',
        ]
      );
      $this->add_control(
        'iconsizenchbproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-heading a i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabsproductscarouselfifteenthstkaveh'
      );
    
      $this->start_controls_tab(
        'style_normal_tabproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-heading a' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbutton1colorproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-heading a i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-heading a' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-heading a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderproductscarouselfifteenthstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-nic-heading a',
        ]
      );
      $this->add_control(
        'buttonbordersproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderproductscarouselfifteenthstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-heading a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoverproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-heading a:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbutton1hovercolorproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-heading a:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-heading a:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoverproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-heading a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverproductscarouselfifteenthstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-nic-heading a:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoverproductscarouselfifteenthstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-heading a:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowproductscarouselfifteenthstkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-nic-heading a',
        ]
      );
      $this->add_control(
        'hr2productscarouselfifteenthstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-heading a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_productscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'استایل ستون اول', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showticol1productscarouselfifteenthstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'textcolor21col1productscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-box-title .title' => 'color: {{VALUE}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_col1productscarouselfifteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-nic-box-title .title',
        ]
      );
      $this->add_control(
        'textcolor3col1productscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-box-title .title-en' => 'color: {{VALUE}} !important;',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_col1productscarouselfifteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-nic-box-title .title-en',
        ]
      );
      $this->add_control(
        'pcolor3col1productscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ متن', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-box-title p' => 'color: {{VALUE}} !important;',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'p2_col1productscarouselfifteenthstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-nic-box-title p',
        ]
      );
      $this->add_control(
        'imagewidth3productscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 5,
            ],

          ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-box-title img' => 'width: {{SIZE}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'imageheight3amazingoffersecondstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 5,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-box-title img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      
      $this->end_controls_section();
      $this->start_controls_section(
        'style5_productscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'استایل جهت های کاروسل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showarrowsproductscarouselfifteenthstkaveh' => 'yes',

          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabsarrowproductscarouselfifteenthstkaveh'
      );
    
      $this->start_controls_tab(
        'style_normal_tabarrowproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbutton1colorarrowproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .swiper-button-next::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .swiper-button-prev::after' => 'color: {{VALUE}}',

          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorarrowproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic .swiper-button-next' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .top-selling-nic .swiper-button-prev' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 

      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabarrowproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbutton1hovercolorarrowproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .swiper-button-next:hover::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .swiper-button-prev:hover::after' => 'color: {{VALUE}}',          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverarrowproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic .swiper-button-next:hover' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .top-selling-nic .swiper-button-prev:hover' => 'background-color: {{VALUE}}',

          ],
        ]
      ); 
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->end_controls_section();
      $this->start_controls_section(
        'stylebox_productscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'استایل باکس سمت راست', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showticol1productscarouselfifteenthstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'boxradiproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-box-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'boxbgnproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-box-title' => 'background-color: {{VALUE}}',

          ],
        ]
      ); 
      $this->add_control(
        'boxbghovproductscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ هاور پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-nic-box-title:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_section();
      $this->start_controls_section(
        'stylebox_2productscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'استایل باکس محصولات', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'boxradi2productscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .product-sixteen' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'boxbgn2productscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .product-sixteen' => 'background-color: {{VALUE}}',

          ],
        ]
      ); 
      $this->add_control(
        'boxbghov2productscarouselfifteenthstkaveh',
        [
          'label' => esc_html__( 'رنگ هاور پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .product-sixteen:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="top-selling-nic px-md-4">  
      <div class="container">
        <!-- Start Heading -->
        <div class="top-selling-nic-heading d-flex align-items-center mb-2">
          <<?php echo  esc_attr($settings['tagheadingproductscarouselfifteenthstkaveh']); ?> class="title text-white mb-0"> <?php echo  esc_html($settings['title2productscarouselfifteenthstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingproductscarouselfifteenthstkaveh']); ?>>
          <<?php echo  esc_attr($settings['tagheadingfproductscarouselfifteenthstkaveh']); ?> class="sub-title ms-2 d-none d-sm-block"> <?php echo  esc_html($settings['titleproducts2carouseleleventhstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingfproductscarouselfifteenthstkaveh']); ?>>
          <a href="<?php echo  esc_url($settings['buttontilink2productscarouselfifteenthstkaveh']); ?>" class="ms-auto d-flex align-items-center">
            <?php echo  esc_html($settings['buttonti2productscarouselfifteenthstkaveh']); ?>
            <i class="<?php echo  esc_html($settings['iconbuttproductscarouselfifteenthstkaveh']['value']); ?> ms-1"></i>
          </a>
        </div>
        <!-- End Heading -->
        <div class="position-relative">
          <!-- Start Carousel -->
          <div class="swiper swiper-top-selling-nic overflow-hidden" data-swiper='{
  "navigation": {
    "nextEl": ".swiper-button-next",
    "prevEl": ".swiper-button-prev"
  },
  "breakpoints": {
    "320": {
      "slidesPerView": 1.2,
      "spaceBetween": 12
    },
    "576": {
      "slidesPerView": 2.2,
      "spaceBetween": 12
    },
    "768": {
      "slidesPerView": 3.2,
      "spaceBetween": 12
    },
    "992": {
      "slidesPerView": 4.2,
      "spaceBetween": 20
    },
    "1200": {
      "slidesPerView": 4.6,
      "spaceBetween": 20
    }
  }
}'
>
            <div class="swiper-wrapper">
            <?php if("yes"===$settings['showticol1productscarouselfifteenthstkaveh']){?>
              <!-- Start Slide -->
              <div class="swiper-slide h-auto">
                <div class="top-selling-nic-box-title pt-3 px-3 position-relative rounded-4 d-flex flex-column h-100">
                  <<?php echo  esc_attr($settings['tagheadingfcol1productscarouselfifteenthstkaveh']); ?> class="title text-white text-center mt-4 mb-0"><?php echo  esc_html($settings['titlecol1productscarouselfifteenthstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingfcol1productscarouselfifteenthstkaveh']); ?>>
                  <<?php echo  esc_attr($settings['tagheadingcol1productscarouselfifteenthstkaveh']); ?> class="title-en text-center"> <?php echo  esc_html($settings['title2col1productscarouselfifteenthstkaveh']); ?> </<?php echo  esc_attr($settings['tagheadingcol1productscarouselfifteenthstkaveh']); ?>>
                  <p class="mb-4"> <?php echo  esc_html($settings['titlepcol1productscarouselfifteenthstkaveh']); ?>
                  </p>
                  <img src="<?php echo esc_url($settings['bottomimgproductscarouselfifteenthstkaveh']['url']); ?>" alt=""
                    class="d-block mt-auto mx-auto" width="220" height="220">
                </div>
              </div>
              <!-- End Slide -->
              <?php } ?>
              <?php if('cat'===$settings['pproductscarouselfifteenthstkaveh']){ ?>
              <?php 
                  
                  // WP_Query args
                  $q_pc2_query_args = array(
                    'post_type' => array('product'),
'post_status' => array('publish'),
                    'posts_per_page' => $settings['productnumberproductscarouselfifteenthstkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $settings['catproductscarouselfifteenthstkaveh'],
                      ),
                    ),
                     
                    
                  );
                  if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                    $q_pc2_query_args['meta_query'] = array(
                        array(
                            'key' => '_stock_status',
                            'value' => 'outofstock',
                            'compare' => 'NOT IN',
                        ),
                    );
                  }

                  // The Query
                  $pc2_query = new \WP_Query($q_pc2_query_args);
                  
                  // The Loop
                  if ( $pc2_query->have_posts() ) {
                    while ( $pc2_query->have_posts() ) {
                      $pc2_query->the_post(); ?>
                      <?php
                        global $product;
                        $sale_price = $product->get_sale_price();
                        $normal_price = $product->get_regular_price();

                        $pr_id = get_the_ID();
                        $stocka = $product->get_stock_status();
                        ?>
                          <!-- Start Slide -->
                          <div class="swiper-slide h-auto">
                            <div
                              <?php wc_product_class( 'product-sixteen position-relative my-3 pt-2 px-2 pb-3 rounded-4 h-100 d-flex flex-column justify-content-center', $product ); ?>>
                              <div class="image mb-2">
                                <a href="#" class="d-block">
                                <?php
                                if ( is_plugin_active( 'woo-smart-compare/wpc-smart-compare.php' ) ) {
                                echo do_shortcode( '[woosc id="".<?php echo get_the_ID(); ?>.""]' ); 
                                } else {

                                }
                                ?>
                                  <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title(); ?>" width="156" height="156"
                                    class="d-block mx-auto">
                                </a>
                              </div>
                              <h2 class="title fw-bold text-white text-center">
                                <a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a>
                              </h2>
                              <?php
                              $categories = wp_get_post_terms( $product->get_id(), 'product_cat' );
                              foreach ($categories as $category) {
                              $category_link = get_term_link( $category );
                              $category_name = $category->name;
                              
                              echo '<a href="' . esc_url( $category_link ) . '">';
                              echo '<div class="detail text-center">' . esc_html( $category_name ) . '</div>';
                              echo '</a>';
                              }
                              ?>
                              <ul class="colors d-flex align-items-center justify-content-center">
                              <?php
                              // Get the terms associated with the product

                              $terms = get_the_terms( $pr_id , 'pa_color' );
                              if(!empty($terms)){
                              // Loop through the terms
                              foreach ( $terms as $term ) {
                              $val     = get_term_meta( $term->term_id, 'wpcvs_color', true ) ?: '';
                              $tooltip = get_term_meta( $term->term_id, 'wpcvs_tooltip', true ) ?: $term->name;
                              ?>
                                <li>
                                  <a href="<?php the_permalink(); ?>" aria-label="<?php echo esc_attr( $tooltip ) ?>" title="<?php echo esc_attr( $tooltip ) ?>" class="d-block rounded-circle" style="background-color: <?php echo esc_attr( $val ) ?>;"></a>
                                </li>
                                <?php
                                }
                              }
                                ?>  
                              </ul>
                            <div class="price text-center">
                              <?php if("instock"==$stocka){ 
                              if ( !$product->is_type( 'variable' ) ) { 
                                  if(empty($sale_price) && empty($normal_price)) { 
                                      $price_v = $product->get_price_html(); ?>
                                      <?php
                                      echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v); ?>
                                      <?php
                                      ?>
                                      <?php }else{ ?>
                                      <?php if(!empty($sale_price) ) { ?>
                                      
                                      <del class="d-block">
                                      <span>
                                      <?php if (!empty($normal_price)) {
                                      echo number_format($normal_price, 0, '.', ',');
                                      } ?>
                                      </span>
                                      <?php echo get_woocommerce_currency_symbol(); ?>  
                                      </del>
                                      <div class="fw-bold">
                                      <span>
                                      <?php echo number_format($sale_price, 0, '.', ','); ?>
                                      </span>
                                      <?php echo get_woocommerce_currency_symbol(); ?>
                                      </div>
                                      <?php }else{ ?>
                                      <div class="fw-bold">
                                      <?php if (!empty($normal_price)) { ?>
                                      <span>
                                      <?php
                                      echo number_format($normal_price, 0, '.', ',');
                                      } ?>
                                      </span>
                                      <?php echo get_woocommerce_currency_symbol(); ?>
                                      </div>
                                      <?php } ?>
                                      <?php } }else{ 
                                      $price_v = $product->get_price_html(); ?>
                                      <?php
                                      echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v); ?>
                                      <?php
                                      } 
                                      }else{ ?>
                                        <span class="outstock">
                                        ناموجود 
                                        </span>
                                      <?php
                                      }
                                      ?>
                              </div>
                            </div>
                          </div>
                          <!-- End Slide -->
            <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
              <?php }elseif('all'===$settings['pproductscarouselfifteenthstkaveh']){
                // WP_Query args
            $ordvalue = $settings['psortproductscarouselfifteenthstkaveh'];
            $ordi = $settings['psortiproductscarouselfifteenthstkaveh'];
            $q_pc2_query_args = array(
              'post_type' => array('product'),
'post_status' => array('publish'),
              'posts_per_page' => $settings['productnumberproductscarouselfifteenthstkaveh'],
              'order' => $ordi,
              'orderby' => 'meta_value_num',
              'meta_key'       => $ordvalue,

             
            );
            if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
              $q_pc2_query_args['meta_query'] = array(
                  array(
                      'key' => '_stock_status',
                      'value' => 'outofstock',
                      'compare' => 'NOT IN',
                  ),
              );
            }

            // The Query
            $pc2_query = new \WP_Query($q_pc2_query_args);

            // The Loop
            if ( $pc2_query->have_posts() ) {
              while ( $pc2_query->have_posts() ) {
                $pc2_query->the_post(); ?>
                      <?php
                        global $product;
                        $sale_price = $product->get_sale_price();
                        $normal_price = $product->get_regular_price();

                        $pr_id = get_the_ID();
                        $stocka = $product->get_stock_status();
                        ?>
                          <!-- Start Slide -->
                          <div class="swiper-slide h-auto">
                            <div
                              <?php wc_product_class( 'product-sixteen position-relative my-3 pt-2 px-2 pb-3 rounded-4 h-100 d-flex flex-column justify-content-center', $product ); ?>>
                              <div class="image mb-2">
                                <a href="#" class="d-block">
                                <?php
                                if ( is_plugin_active( 'woo-smart-compare/wpc-smart-compare.php' ) ) {
                                echo do_shortcode( '[woosc id="".<?php echo get_the_ID(); ?>.""]' ); 
                                } else {

                                }
                                ?>
                                  <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title(); ?>" width="156" height="156"
                                    class="d-block mx-auto">
                                </a>
                              </div>
                              <h2 class="title fw-bold text-white text-center">
                                <a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a>
                              </h2>
                              <?php
                              $categories = wp_get_post_terms( $product->get_id(), 'product_cat' );
                              foreach ($categories as $category) {
                              $category_link = get_term_link( $category );
                              $category_name = $category->name;
                              
                              echo '<a href="' . esc_url( $category_link ) . '">';
                              echo '<div class="detail text-center">' . esc_html( $category_name ) . '</div>';
                              echo '</a>';
                              }
                              ?>
                              <ul class="colors d-flex align-items-center justify-content-center">
                              <?php
                              // Get the terms associated with the product

                              $terms = get_the_terms( $pr_id , 'pa_color' );
                              if(!empty($terms)){
                              // Loop through the terms
                              foreach ( $terms as $term ) {
                              $val     = get_term_meta( $term->term_id, 'wpcvs_color', true ) ?: '';
                              $tooltip = get_term_meta( $term->term_id, 'wpcvs_tooltip', true ) ?: $term->name;
                              ?>
                                <li>
                                  <a href="<?php the_permalink(); ?>" aria-label="<?php echo esc_attr( $tooltip ) ?>" title="<?php echo esc_attr( $tooltip ) ?>" class="d-block rounded-circle" style="background-color: <?php echo esc_attr( $val ) ?>;"></a>
                                </li>
                                <?php
                                }
                              }
                                ?>  
                              </ul>
                            <div class="price text-center">
                              <?php if("instock"==$stocka){ 
                              if ( !$product->is_type( 'variable' ) ) { 
                                  if(empty($sale_price) && empty($normal_price)) { 
                                      $price_v = $product->get_price_html(); ?>
                                      <?php
                                      echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v); ?>
                                      <?php
                                      ?>
                                      <?php }else{ ?>
                                      <?php if(!empty($sale_price) ) { ?>
                                      
                                      <del class="d-block">
                                      <span>
                                      <?php if (!empty($normal_price)) {
                                      echo number_format($normal_price, 0, '.', ',');
                                      } ?>
                                      </span>
                                      <?php echo get_woocommerce_currency_symbol(); ?>  
                                      </del>
                                      <div class="fw-bold">
                                      <span>
                                      <?php echo number_format($sale_price, 0, '.', ','); ?>
                                      </span>
                                      <?php echo get_woocommerce_currency_symbol(); ?>
                                      </div>
                                      <?php }else{ ?>
                                      <div class="fw-bold">
                                      <?php if (!empty($normal_price)) { ?>
                                      <span>
                                      <?php
                                      echo number_format($normal_price, 0, '.', ',');
                                      } ?>
                                      </span>
                                      <?php echo get_woocommerce_currency_symbol(); ?>
                                      </div>
                                      <?php } ?>
                                      <?php } }else{ 
                                      $price_v = $product->get_price_html(); ?>
                                      <?php
                                      echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v); ?>
                                      <?php
                                      } 
                                      }else{ ?>
                                        <span class="outstock">
                                        ناموجود 
                                        </span>
                                      <?php
                                      }
                                      ?>
                              </div>
                            </div>
                          </div>
                          <!-- End Slide -->
                <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
                <?php } ?>
            </div>
            <?php if('yes'===$settings['showarrowsproductscarouselfifteenthstkaveh']){ ?>
            <!-- Start Button -->
            <div class="swiper-button-next rounded-circle d-flex align-items-center justify-content-center"></div>
            <div class="swiper-button-prev rounded-circle d-flex align-items-center justify-content-center"></div>
            <!-- End Button -->
            <?php } ?>
          </div>
          <!-- End Carousel -->
        </div>
      </div>
    </section>
    <?php do_action('kelementor_inline_scripts'); ?>

    <?php
  }


}
