<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productscarouseleleventhstkaveh extends Widget_Base{

  public function get_name(){
    return 'productscarouseleleventhstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل محصولات سبک یازده', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'عنوان المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'showtiproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'نمایش ستون سمت راست', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'imgproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'condition' => [
            'showtiproductscarouseleleventhstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'beftitleproductscarouseleleventhstkaveh',
        [
            'label' => esc_html__( 'پیش عنوان ۱', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'showtiproductscarouseleleventhstkaveh' => 'yes',
            ],
            'default' => esc_html__( 'فروشگاه آنلاین', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'beftitle2productscarouseleleventhstkaveh',
      [
          'label' => esc_html__( 'پیش عنوان ۲', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showtiproductscarouseleleventhstkaveh' => 'yes',
          ],
          'default' => esc_html__( 'کاوه', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'tagheadingbefproductscarouseleleventhstkaveh',
    [
      'label' => esc_html__( 'تگ پیش عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'condition' => [
        'showtiproductscarouseleleventhstkaveh' => 'yes',
      ],
      'default' => 'div',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
      ],
    ]
  );
      $this->add_control(
        'title2productscarouseleleventhstkaveh',
        [
            'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'showtiproductscarouseleleventhstkaveh' => 'yes',
            ],
            'default' => esc_html__( 'محبوب ترین', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheadingproductscarouseleleventhstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'condition' => [
          'showtiproductscarouseleleventhstkaveh' => 'yes',
        ],
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
        ],
      ]
    );
      $this->add_control(
          'titleproductscarouseleleventhstkaveh',
          [
              'label' => esc_html__( 'عنوان اصلی بولد', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'condition' => [
                'showtiproductscarouseleleventhstkaveh' => 'yes',
              ],
              'default' => esc_html__( 'محصولات', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'titleproducts2carouseleleventhstkaveh',
        [
            'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'showtiproductscarouseleleventhstkaveh' => 'yes',
            ],
            'default' => esc_html__( 'ویژه ما', 'kaveh-core' ),
    
        ]
    );
      $this->add_control(
        'tagheadingfproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'condition' => [
            'showtiproductscarouseleleventhstkaveh' => 'yes',
          ],
          'default' => 'H4',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'wigp2pproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXTAREA,
          'condition' => [
            'showtiproductscarouseleleventhstkaveh' => 'yes',
          ],
          'default' => 'همواره، قرار گرفتن در شرایطی که برای اولین بار تجربه‌اش می‌کنیم، در ما ایجاد استرس و اضطرابدر ',
  
        ]
      );
    $this->add_control(
      'buttonti2productscarouseleleventhstkaveh',
      [
          'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'showtiproductscarouseleleventhstkaveh' => 'yes',
          ],
          'default' => esc_html__( 'مشاهده پیشنهاد ویژه', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'iconbuttproductscarouseleleventhstkaveh',
    [
      'label' => esc_html__( 'آیکون', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::ICONS,
      'skin' => 'inline',
      'condition' => [
        'showtiproductscarouseleleventhstkaveh' => 'yes',
      ],
      'exclude_inline_options' => [ 'svg' ],
      'default' => [
        'value' => 'icon-arrow-left-3',
      ],
    ]
  );
  $this->add_control(
    'buttontilink2productscarouseleleventhstkaveh',
    [
        'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'showtiproductscarouseleleventhstkaveh' => 'yes',
        ],
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
    $this->end_controls_section();   
  
      $this->start_controls_section(
        'content4productscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'تنظیمات محصولات', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'kaveh_exclude_out_of_stock',
        [
          'label' => esc_html__( 'عدم نمایش محصولات ناموجود', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
  $this->add_control(
    'pproductscarouseleleventhstkaveh',
    [
      'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'all',
      'options' => [
        'all'  => esc_html__( 'همه', 'kaveh-core' ),
        'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),

      ],
    ]
    );
    $this->add_control(
      'psortproductscarouseleleventhstkaveh',
      [
        'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'date',
        'options' => [
          'date'  => esc_html__( 'تاریخ', 'kaveh-core' ),
          '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
          '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
          'total_sales'  => esc_html__( 'میزان فروش', 'kaveh-core' ),
  
        ],
      ]
      );
      $this->add_control(
        'psortiproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'desc',
          'options' => [
            'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
            'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
          ],
        ]
        );
  $this->add_control(
    'stylecartproductscarouseleleventhstkaveh',
    [
      'label' => esc_html__( 'طرح بندی باکس محصول', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'one',
      'options' => [
        'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
        'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
        'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
        'four'  => esc_html__( 'طرح بندی چهارم', 'kaveh-core' ),
        'five'  => esc_html__( 'طرح بندی پنجم', 'kaveh-core' ),
        'six'  => esc_html__( 'طرح بندی ششم', 'kaveh-core' ),
        'seven'  => esc_html__( 'طرح بندی هفتم', 'kaveh-core' ),
        'eight'  => esc_html__( 'طرح بندی هشتم', 'kaveh-core' ),
        'nine'  => esc_html__( 'طرح بندی نهم', 'kaveh-core' ),
        'ten'  => esc_html__( 'طرح بندی دهم', 'kaveh-core' ),
        'eleven'  => esc_html__( 'طرح بندی یازدهم', 'kaveh-core' ),
        'twelve'  => esc_html__( 'طرح بندی دوازدهم', 'kaveh-core' ),
        'thirteen'  => esc_html__( 'طرح بندی سیزدهم', 'kaveh-core' ),
        'fourteen'  => esc_html__( 'طرح بندی چهاردهم', 'kaveh-core' ),
        'fifteen'  => esc_html__( 'طرح بندی پانزدهم', 'kaveh-core' ),
        'sixteen'  => esc_html__( 'طرح بندی شانزدهم', 'kaveh-core' ),

      ],
    ]
    );
  $options5 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $options5[$category->term_id] = $category->name;
}
$this->add_control(
    'catproductscarouseleleventhstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $options5,
      'condition' => [
        'pproductscarouseleleventhstkaveh' => 'cat',
      ],
    ]
);
$this->end_controls_section();   
$this->start_controls_section(
  'content5productscarouseleleventhstkaveh',
  [
    'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'showarrowsproductscarouseleleventhstkaveh',
  [
    'label' => esc_html__( 'نمایش جهت ها؟', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'yes' => esc_html__( 'بله', 'kaveh-core' ),
    'no' => esc_html__( 'خیر', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);
$this->add_control(
  'productnumberproductscarouseleleventhstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 50,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnproductscarouseleleventhstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 3,

  ]
); 
$this->add_control(
  'productcolumn2productscarouseleleventhstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 2,

  ]
);
$this->add_control(
  'productcolumn3productscarouseleleventhstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 1.5,

  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'style_productscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showtiproductscarouseleleventhstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'bef1textcolor2productscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'رنگ پیش عنوان ۱', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .sup-title' => 'color: {{VALUE}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'bef1title_productscarouseleleventhstkaveh',
          'label' => esc_html__( 'تایپوگرافی پیش عنوان ۱', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .products-specials-right .sup-title',
        ]
      );
      $this->add_control(
        'bef2textcolor2productscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'رنگ پیش عنوان ۲', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .sup-title span' => 'color: {{VALUE}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'bef2title_productscarouseleleventhstkaveh',
          'label' => esc_html__( 'تایپوگرافی پیش عنوان ۲', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .products-specials-right .sup-title span',
        ]
      );
      $this->add_control(
        'textcolor3productscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .title-en' => 'color: {{VALUE}} !important;',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_productscarouseleleventhstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .products-specials-right .title-en',
        ]
      );
      $this->add_control(
        'textcolor2productscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .title b' => 'color: {{VALUE}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title1_productscarouseleleventhstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی بولد', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .products-specials-right .title b',
        ]
      );
      $this->add_control(
        'bgcolorboldbolproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .title::before' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcolor21productscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .title' => 'color: {{VALUE}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_productscarouseleleventhstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .products-specials-right .title',
        ]
      );
      $this->add_control(
        'pcolor21productscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'رنگ متن', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-specials-right p' => 'color: {{VALUE}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'p_productscarouseleleventhstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .products-specials-right p',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleb_productscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showtiproductscarouseleleventhstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_productscarouseleleventhstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .products-specials-right .btn',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowproductscarouseleleventhstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .products-specials-right .btn',
        ]
      );
      $this->add_control(
        'iconsizenchbproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabsproductscarouseleleventhstkaveh'
      );
    
      $this->start_controls_tab(
        'style_normal_tabproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .btn' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbutton1colorproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .btn i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderproductscarouseleleventhstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .products-specials-right .btn',
        ]
      );
      $this->add_control(
        'buttonbordersproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderproductscarouseleleventhstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoverproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbutton1hovercolorproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .btn:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoverproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverproductscarouseleleventhstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .products-specials-right .btn:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoverproductscarouseleleventhstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowproductscarouseleleventhstkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .products-specials-right .btn',
        ]
      );
      $this->add_control(
        'hr2productscarouseleleventhstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_productscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'استایل تصویر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'imagewidth3productscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 5,
            ],

          ],
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .logo' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'imageheight3amazingoffersecondstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 5,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .products-specials-right .logo' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      
      $this->end_controls_section();
      $this->start_controls_section(
        'style5_productscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'استایل جهت های کاروسل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showarrowsproductscarouseleleventhstkaveh' => 'yes',
            'showtiproductscarouseleleventhstkaveh' => 'yes',

          ],
        ]
      );
      $this->add_control(
        'arrowscolorproductscarouseleleventhstkaveh',
        [
          'label' => esc_html__( 'رنگ جهت های کاروسل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-specials-left .swiper-button-next::after' => 'color: {{VALUE}} !important;',
            '{{WRAPPER}}  .products-specials-left .swiper-button-prev::after' => 'color: {{VALUE}} !important;',
          ],
        ]
      ); 
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

    
    
<section class="products-specials">
      <div class="container d-flex position-relative flex-column flex-sm-row gap-4 gap-sm-0">
      <?php if('yes'===$settings['showtiproductscarouseleleventhstkaveh']){ ?>
        <!-- Start Title -->
        <div class="products-specials-right w-100 position-relative">
          <img src="<?php echo esc_url($settings['imgproductscarouseleleventhstkaveh']['url']); ?>" alt="" class="logo">
          <<?php echo  esc_attr($settings['tagheadingbefproductscarouseleleventhstkaveh']); ?> class="sup-title">
          <?php echo  esc_html($settings['beftitleproductscarouseleleventhstkaveh']); ?><span> <?php echo  esc_html($settings['beftitle2productscarouseleleventhstkaveh']); ?> </span>
          </<?php echo  esc_attr($settings['tagheadingbefproductscarouseleleventhstkaveh']); ?>>
          <<?php echo  esc_attr($settings['tagheadingproductscarouseleleventhstkaveh']); ?> class="title-en"> <?php echo  esc_html($settings['title2productscarouseleleventhstkaveh']); ?> </<?php echo  esc_attr($settings['tagheadingproductscarouseleleventhstkaveh']); ?>>
          <<?php echo  esc_attr($settings['tagheadingfproductscarouseleleventhstkaveh']); ?> class="title position-relative mb-3">
            <b>  <?php echo  esc_html($settings['titleproductscarouseleleventhstkaveh']); ?> </b>  <?php echo  esc_html($settings['titleproducts2carouseleleventhstkaveh']); ?>
          </<?php echo  esc_attr($settings['tagheadingfproductscarouseleleventhstkaveh']); ?>>
          <p> <?php echo  esc_html($settings['wigp2pproductscarouseleleventhstkaveh']); ?></p>
          <a href="<?php echo  esc_url($settings['buttontilink2productscarouseleleventhstkaveh']); ?>" class="btn d-flex align-items-center justify-content-center position-relative">
            <?php echo  esc_html($settings['buttonti2productscarouseleleventhstkaveh']); ?>
            <i class="<?php echo  esc_html($settings['iconbuttproductscarouseleleventhstkaveh']['value']); ?>"></i>
          </a>
        </div>
        <!-- End Title -->
        <?php } ?>
        <!-- Start Products -->
        <div class="products-specials-left w-100">
          <!-- Start Carousel -->
          <div class="swiper swiper-products-specials swiper-visible swiper-button-arrow" data-swiper='{"watchSlidesProgress":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"500":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productscarouseleleventhstkaveh']); ?>,"spaceBetween":12},"576":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productscarouseleleventhstkaveh']); ?>,"spaceBetween":4},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productscarouseleleventhstkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductscarouseleleventhstkaveh']); ?>,"spaceBetween":12},"1200":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductscarouseleleventhstkaveh']); ?>,"spaceBetween":34}}}'>
            <div class="swiper-wrapper">
            <?php if('cat'===$settings['pproductscarouseleleventhstkaveh']){ ?>
             <?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouseleleventhstkaveh'],
                  'orderby' => $settings['psortproductscarouseleleventhstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouseleleventhstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                    array(
                      'taxonomy' => 'product_cat',
                      'field' => 'term_id',
                      'terms' => $settings['catproductscarouseleleventhstkaveh'],
                    ),
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouseleleventhstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="swiper-slide h-auto">
                      <?php $styleproduct2 = $settings['stylecartproductscarouseleleventhstkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>
    
              <?php }elseif('all'===$settings['pproductscarouseleleventhstkaveh']){
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouseleleventhstkaveh'],
                  'orderby' => $settings['psortproductscarouseleleventhstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouseleleventhstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouseleleventhstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="swiper-slide h-auto">
                      <?php $styleproduct2 = $settings['stylecartproductscarouseleleventhstkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>
                <?php } ?>
            </div>
            <?php if('yes'===$settings['showarrowsproductscarouseleleventhstkaveh']){ ?>
            <!-- Start Button -->
            <?php if('yes'===$settings['showtiproductscarouseleleventhstkaveh']){ ?>

            <div class="swiper-button-next w-auto h-auto"></div>
            <div class="swiper-button-prev w-auto h-auto"></div>
            <!-- End Button -->
            <?php } 
            }?>
          </div>
          <!-- End Carousel -->
        </div>
        <!-- Start Products -->
      </div>
    </section>
    <?php if('yes'!==$settings['showtiproductscarouseleleventhstkaveh']){ ?>
    <style>
      .products-specials-left {
        max-width: 100% !important;
    }
    </style>
    <?php } ?>
    <style>
      .products-specials-right .logo{
        object-fit : contain;
      }
    </style>
    <?php do_action('kelementor_inline_scripts'); ?>  
    <?php
  }


}
