<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productscarouseleighthstkaveh extends Widget_Base{

  public function get_name(){
    return 'productscarouseleighthstkaveh';
  }
 
  public function get_title(){
    return esc_html__( 'کاروسل محصولات سبک هشت', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }
 
  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'تنظیمات عنوان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
    
      $this->add_control(
          'titleproductscarouseleighthstkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'پرفروش ترین محصولات', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'title3productscarouseleighthstkaveh',
        [
            'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'کاوه', 'kaveh-core' ),
    
        ]
    );
      $this->add_control(
        'tagheadingproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H2',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'title2productscarouseleighthstkaveh',
        [
            'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'پرفروش ترین ها را اینجا ببینید', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tag2headingproductscarouseleighthstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H4',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $this->add_control(
      'showbutton1productscarouseleighthstkaveh',
      [
        'label' => esc_html__( 'نمایش دکمه؟', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__( 'بله', 'kaveh-core' ),
        'no' => esc_html__( 'خیر', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
      );
      $this->add_control(
        'buttons2productscarouseleighthstkaveh',
        [
            'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'محصولات', 'kaveh-core' ),
            'condition' => [
              'showbutton1productscarouseleighthstkaveh' => 'yes',
            ],
        ]
    );
    $this->add_control(
      'iconbutts2productscarouseleighthstkaveh',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'condition' => [
          'showbutton1productscarouseleighthstkaveh' => 'yes',
        ],
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-eye-2',
        ],
      ]
    );
    $this->add_control(
      'linkbuttons2productscarouseleighthstkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
              'showbutton1productscarouseleighthstkaveh' => 'yes',
            ],
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'content2productscarouseleighthstkaveh',
    [
      'label' => esc_html__( 'تنظیمات محصولات', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );
  $this->add_control(
    'stylecartproductscarouseleighthstkaveh',
    [
      'label' => esc_html__( 'طرح بندی باکس محصول', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'one',
      'options' => [
        'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
        'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
        'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
        'four'  => esc_html__( 'طرح بندی چهارم', 'kaveh-core' ),
        'five'  => esc_html__( 'طرح بندی پنجم', 'kaveh-core' ),
        'six'  => esc_html__( 'طرح بندی ششم', 'kaveh-core' ),
        'seven'  => esc_html__( 'طرح بندی هفتم', 'kaveh-core' ),
        'eight'  => esc_html__( 'طرح بندی هشتم', 'kaveh-core' ),
        'nine'  => esc_html__( 'طرح بندی نهم', 'kaveh-core' ),
        'ten'  => esc_html__( 'طرح بندی دهم', 'kaveh-core' ),
        'eleven'  => esc_html__( 'طرح بندی یازدهم', 'kaveh-core' ),
        'twelve'  => esc_html__( 'طرح بندی دوازدهم', 'kaveh-core' ),
        'thirteen'  => esc_html__( 'طرح بندی سیزدهم', 'kaveh-core' ),
        'fourteen'  => esc_html__( 'طرح بندی چهاردهم', 'kaveh-core' ),
        'fifteen'  => esc_html__( 'طرح بندی پانزدهم', 'kaveh-core' ),
        'sixteen'  => esc_html__( 'طرح بندی شانزدهم', 'kaveh-core' ),

      ],
    ]
    );
    
    $this->add_control(
      'kaveh_exclude_out_of_stock',
      [
        'label' => esc_html__( 'عدم نمایش محصولات ناموجود', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__( 'بله', 'kaveh-core' ),
        'no' => esc_html__( 'خیر', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );

    $this->add_control(
      'pproductscarouseleighthstkaveh',
      [
        'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'all',
        'options' => [
          'all'  => esc_html__( 'همه', 'kaveh-core' ),
          'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),
  
        ],
      ]
      );
      $this->add_control(
        'psortproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'date',
          'options' => [
            'date'  => esc_html__( 'تاریخ', 'kaveh-core' ),
            '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
            '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
            'total_sales'  => esc_html__( 'میزان فروش', 'kaveh-core' ),
    
          ],
        ]
        );
        $this->add_control(
          'psortiproductscarouseleighthstkaveh',
          [
            'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'desc',
            'options' => [
              'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
              'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
            ],
          ]
          );
  $options2 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $options2[$category->term_id] = $category->name;
}
$this->add_control(
    'catproductscarouseleighthstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $options2,
      'condition' => [
        'pproductscarouseleighthstkaveh' => 'cat',
      ],
    ]
);
$this->end_controls_section();
$this->start_controls_section(
  'content3productscarouseleighthstkaveh',
  [
    'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'showarrowproductscarouseleighthstkaveh',
  [
    'label' => esc_html__( 'نمایش فلش ها؟', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'yes' => esc_html__( 'بله', 'kaveh-core' ),
    'no' => esc_html__( 'خیر', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
  );
$this->add_control(
  'productnumberproductscarouseleighthstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 50,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnproductscarouseleighthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 4,

  ]
);
$this->add_control(
  'productcolumn2productscarouseleighthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 3,

  ]
);
$this->add_control(
  'productcolumn3productscarouseleighthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 1,

  ]
); 
       $this->end_controls_section();
       $this->start_controls_section(
        'style_productscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor2productscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-heading .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcolor3productscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-heading .title span' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titleproductscarouseleighthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .latest-products-book-heading .title',
        ]
      );
      $this->add_control(
        'textcolor22productscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-heading .sub-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2productscarouseleighthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .latest-products-book-heading .sub-title',
        ]
      );
      $this->add_control(
        'iconcolor22productscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-heading::before' => ' border-color: {{VALUE}} {{VALUE}} transparent transparent;',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'styleb_productscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showbutton1productscarouseleighthstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_nchbproductscarouseleighthstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .latest-products-book-heading .btn',
        ]
      );
      $this->add_control(
        'iconsizenchbproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-heading .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadownchbproductscarouseleighthstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .latest-products-book-heading .btn',
        ]
      );
      $this->start_controls_tabs(
        'style_tabsnchbproductscarouseleighthstkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabnchbproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolornchbproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-heading .btn' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconcolornchbproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-heading .btn i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolornchbproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-heading .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusnchbproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-heading .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'bordernchbproductscarouseleighthstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .latest-products-book-heading .btn',
        ]
      );
      $this->add_control(
        'buttonbordersnchbproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'bordernchbproductscarouseleighthstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-heading .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabnchbproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhovernchbproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-heading .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconcolorhovernchbproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-heading .btn:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhovernchbproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-heading .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushovernchbproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-heading .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhovernchbproductscarouseleighthstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .latest-products-book-heading .btn:hover',
        ]
      );
      $this->add_control(
        'buttonbordershovernchbproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhovernchbproductscarouseleighthstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-heading .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hr1nchbproductscarouseleighthstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadownchbproductscarouseleighthstkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .latest-products-book-heading .btn',
        ]
      );
      $this->add_control(
        'buttonpaddingnchbproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-heading .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );

      $this->end_controls_section();
      $this->start_controls_section(
        'style3_productscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'استایل باکس', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'bgcolorproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-wrapper' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'boxradiusproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'boxpaddingproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'فضای داخلی باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .latest-products-book-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'bgcoloriconproductscarouseleighthstkaveh',
        [
          'label' => esc_html__( 'رنگ فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'showarrowproductscarouseleighthstkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .swiper-button-next::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .swiper-button-prev::after' => 'color: {{VALUE}}',

          ],
        ]
      ); 
      $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

    <section class="latest-products-book">
      <div class="container">
        <div class="latest-products-book-wrapper position-relative overflow-hidden">
          <!-- Start Heading -->
          <div
            class="latest-products-book-heading d-flex align-items-md-center position-relative flex-column flex-md-row gap-4 gap-md-0 flex-column">
            <div class="me-3">
              <<?php echo  esc_attr($settings['tagheadingproductscarouseleighthstkaveh']); ?> class="title">
              <?php echo esc_html($settings['titleproductscarouseleighthstkaveh']); ?>
                <span><?php echo esc_html($settings['title3productscarouseleighthstkaveh']); ?></span>
              </<?php echo  esc_attr($settings['tagheadingproductscarouseleighthstkaveh']); ?>>
              <<?php echo  esc_attr($settings['tag2headingproductscarouseleighthstkaveh']); ?> class="sub-title mb-0"><?php echo esc_html($settings['title2productscarouseleighthstkaveh']); ?> </<?php echo  esc_attr($settings['tag2headingproductscarouseleighthstkaveh']); ?>>
            </div>
            <div class="d-flex align-items-center ms-md-auto flex-row-reverse flex-md-row">
            <?php if("yes"===$settings['showarrowproductscarouseleighthstkaveh']){?>
              <div class="d-flex ms-3 ms-md-0 me-md-3">
                <div class="swiper-button-prev clsid<?php echo $clsid; ?> position-relative top-0 start-0 bottom-0 end-0 m-0 w-auto h-auto"></div>
                <div class="swiper-button-next clsid<?php echo $clsid; ?> position-relative top-0 start-0 bottom-0 end-0 m-0 w-auto h-auto ms-2">
                </div>
              </div>
              <?php } ?>
              <?php if("yes"===$settings['showbutton1productscarouseleighthstkaveh']){?>
              <a href="<?php echo esc_url($settings['linkbuttons2productscarouseleighthstkaveh']); ?>" class="btn btn-light-2 d-flex align-items-center text-nowrap justify-content-center">
                <i class="<?php echo esc_attr($settings['iconbutts2productscarouseleighthstkaveh']['value']); ?> me-1"></i>
                <?php echo esc_html($settings['buttons2productscarouseleighthstkaveh']); ?>
              </a>
              <?php } ?>
            </div>
          </div>
          <!-- End Heading -->
          <!-- Start Carousel -->
          <div class="swiper swiper-products-two swiper-visible" data-swiper='{"watchSlidesProgress":true,"navigation":{"nextEl":".swiper-button-next.clsid<?php echo $clsid; ?>","prevEl":".swiper-button-prev.clsid<?php echo $clsid; ?>"},"breakpoints":{"300":{"slidesPerView":<?php echo  esc_html($settings['productcolumn3productscarouseleighthstkaveh']); ?>,"spaceBetween":12},"768":{"slidesPerView":<?php echo  esc_html($settings['productcolumn2productscarouseleighthstkaveh']); ?>,"spaceBetween":12},"992":{"slidesPerView":<?php echo  esc_html($settings['productcolumnproductscarouseleighthstkaveh']); ?>,"spaceBetween":16},"1200":{"slidesPerView":<?php echo  esc_html($settings['productcolumnproductscarouseleighthstkaveh']); ?>,"spaceBetween":24}}}'>
          <div class="swiper-wrapper">
            <?php if('cat'===$settings['pproductscarouseleighthstkaveh']){ ?>

                  <?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
                  'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouseleighthstkaveh'],
                  'orderby' => $settings['psortproductscarouseleighthstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouseleighthstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                    array(
                      'taxonomy' => 'product_cat',
                      'field' => 'term_id',
                      'terms' => $settings['catproductscarouseleighthstkaveh'],
                    ),
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouseleighthstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }

                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);

                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="swiper-slide h-auto">
                      <?php $styleproduct2 = $settings['stylecartproductscarouseleighthstkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>

              <?php }elseif('all'===$settings['pproductscarouseleighthstkaveh']){
                ?>
                <?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
                  'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumberproductscarouseleighthstkaveh'],
                  'orderby' => $settings['psortproductscarouseleighthstkaveh'] === 'date' ? 'date' : 'meta_value_num', // Default to date or meta value
                  'order' => $settings['psortiproductscarouseleighthstkaveh'],
                  'tax_query' => array(
                    'relation' => 'AND',
                  ),
                );
                // Handle specific orderby values
                switch ($settings['psortproductscarouseleighthstkaveh']) {
                  case '_price':
                    $query_args['meta_key'] = '_price';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case '_wc_average_rating':
                    $query_args['meta_key'] = '_wc_average_rating';
                    $query_args['orderby'] = 'meta_value_num';
                    break;

                  case 'total_sales':
                    $query_args['meta_key'] = 'total_sales';
                    $query_args['orderby'] = 'meta_value_num';
                    break;
                }

                if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                  $query_args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field' => 'name',
                    'terms' => array('outofstock'),
                    'operator' => 'NOT IN'
                  );
                }

                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);

                if ($cached_query->have_posts()):
                  while ($cached_query->have_posts()):
                    $cached_query->the_post();
                    ?>
                    <div class="swiper-slide h-auto">
                      <?php $styleproduct2 = $settings['stylecartproductscarouseleighthstkaveh']; ?>
                      <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                    </div>
                    <?php
                  endwhile;
                  wp_reset_postdata();
                else:
                  echo 'No posts found.';
                endif;
                ?>

                <?php } ?>
            </div>
            <!-- Start Button -->
            <!-- End Button -->
          </div>
          <!-- End Carousel -->
        </div>
      </div>
    </section>
    <?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
