<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productsbanimodecarouselkaveh extends Widget_Base{

  public function get_name(){
    return 'productsbanimodecarouselkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل محصولات بانی مد', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'عنوان المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
        $this->add_control(
          'buttonti1productsbanimodecarouselkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'پر فروش ترین محصولات', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'tagheading1productsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H2',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
    $this->add_control(
      'buttonti2productsbanimodecarouselkaveh',
      [
          'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'مشاهده همه', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'buttontilink2productsbanimodecarouselkaveh',
    [
        'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
    $this->end_controls_section();   

      $this->start_controls_section(
        'content4productsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'تنظیمات محصولات', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'kaveh_exclude_out_of_stock',
        [
          'label' => esc_html__( 'عدم نمایش محصولات ناموجود', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
  $this->add_control(
    'pproductsbanimodecarouselkaveh',
    [
      'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'all',
      'options' => [
        'all'  => esc_html__( 'همه', 'kaveh-core' ),
        'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),

      ],
    ]
    );
    $this->add_control(
      'psortproductsbanimodecarouselkaveh',
      [
        'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'date',
        'options' => [
          'date'  => esc_html__( 'تاریخ', 'kaveh-core' ),
          '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
          '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
          'total_sales'  => esc_html__( 'میزان فروش', 'kaveh-core' ),
  
        ],
      ]
      );
      $this->add_control(
        'psortiproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'desc',
          'options' => [
            'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
            'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
          ],
        ]
        );
  $options5 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $options5[$category->term_id] = $category->name;
}
$this->add_control(
    'catproductsbanimodecarouselkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $options5,
      'condition' => [
        'pproductsbanimodecarouselkaveh' => 'cat',
      ],
    ]
);
$this->end_controls_section();   
$this->start_controls_section(
  'content5productsbanimodecarouselkaveh',
  [
    'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'showarrowsproductsbanimodecarouselkaveh',
  [
    'label' => esc_html__( 'نمایش جهت ها؟', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'yes' => esc_html__( 'بله', 'kaveh-core' ),
    'no' => esc_html__( 'خیر', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);
$this->add_control(
  'productnumberproductsbanimodecarouselkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 50,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnproductsbanimodecarouselkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.2,
    'default' => 4,

  ]
); 
$this->add_control(
  'productcolumn2productsbanimodecarouselkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.2,
    'default' => 2.2,

  ]
);
$this->add_control(
  'productcolumn3productsbanimodecarouselkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.2,
    'default' => 1.2,

  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'stylea_productsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'buttona_productsbanimodecarouselkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-selling-products-bani-title',
        ]
      );
      $this->add_control(
        'textabuttoncolorproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-selling-products-bani-title' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_section();
      $this->start_controls_section(
        'styleb_productsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_productsbanimodecarouselkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-more-bani',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowproductsbanimodecarouselkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-more-bani',
        ]
      );
      $this->start_controls_tabs(
        'style_tabsproductsbanimodecarouselkaveh'
      );
    
      $this->start_controls_tab(
        'style_normal_tabproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderproductsbanimodecarouselkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-more-bani',
        ]
      );
      $this->add_control(
        'buttonbordersproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderproductsbanimodecarouselkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoverproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoverproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverproductsbanimodecarouselkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-more-bani:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoverproductsbanimodecarouselkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowproductsbanimodecarouselkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-more-bani',
        ]
      );
      $this->add_control(
        'hr2productsbanimodecarouselkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .btn-more-bani' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style5_productsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'استایل جهت های کاروسل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showarrowsproductsbanimodecarouselkaveh' => 'yes',

          ],
        ]
      );
      $this->add_control(
        'iconsizenchbproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .swiper-bani .swiper-button-next::after' => 'font-size: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .swiper-bani .swiper-button-prev::after' => 'font-size: {{SIZE}}{{UNIT}};',

          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabsarrowproductsbanimodecarouselkaveh'
      );
    
      $this->start_controls_tab(
        'style_normal_tabarrowproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbutton1colorarrowproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .swiper-bani .swiper-button-next::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .swiper-bani .swiper-button-prev::after' => 'color: {{VALUE}}',

          ],
        ]
      ); 
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabarrowproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbutton1hovercolorarrowproductsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .swiper-bani .swiper-button-next:hover::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .swiper-bani .swiper-button-prev:hover::after' => 'color: {{VALUE}}',
           ],
        ]
      ); 
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->end_controls_section();
      $this->start_controls_section(
        'stylebox_2productsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'استایل باکس محصولات', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'boxbghov2productsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه تصویر محصول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .product-seventeen .image>a::before' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'boxradi2productsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه تصویر محصول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .product-seventeen .image>a::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'boxpercentage2productsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه درصد تخفیف', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .product-seventeen .image .offer' => 'background-color: {{VALUE}}',

          ],
        ]
      ); 
      $this->add_control(
        'boxbgpercentage2productsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'رنگ متن درصد تخفیف', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .product-seventeen .image .offer' => 'color: {{VALUE}} !important',

          ],
        ]
      ); 
      $this->add_control(
        'gallery2productsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'رنگ تعداد عکس گالری', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .product-seventeen .image .colors li.count' => 'color: {{VALUE}} !important',

          ],
        ]
      ); 
      $this->add_control(
        'pricecle2productsbanimodecarouselkaveh',
        [
          'label' => esc_html__( 'رنگ قیمت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .product-seventeen .price' => 'color: {{VALUE}} !important',
            '{{WRAPPER}} span.woocommerce-Price-amount.amount' => 'color: {{VALUE}} !important',


          ],
        ]
      ); 
      
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="top-selling-products-bani">
      <div class="container">
        <<?php echo  esc_attr($settings['tagheading1productsbanimodecarouselkaveh']); ?> class="top-selling-products-bani-title text-center mb-3"><?php echo esc_html($settings['buttonti1productsbanimodecarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading1productsbanimodecarouselkaveh']); ?>>
        <div class="position-relative">
          <!-- Start Carousel -->
          <div class="swiper swiper-top-selling-products-bani overflow-hidden swiper-bani" data-swiper='{"loop":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"autoplay":{"delay":3000,"disableOnInteraction":false},"breakpoints":{"320":{"slidesPerView":<?php echo esc_html($settings['productcolumn3productsbanimodecarouselkaveh']); ?>,"spaceBetween":12},"576":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productsbanimodecarouselkaveh']); ?>,"spaceBetween":12},"768":{"slidesPerView":<?php echo esc_html($settings['productcolumn2productsbanimodecarouselkaveh']); ?>,"spaceBetween":20},"992":{"slidesPerView":<?php echo esc_html($settings['productcolumnproductsbanimodecarouselkaveh']); ?>,"spaceBetween":20}}}'>
            <div class="swiper-wrapper">
            <?php if('cat'===$settings['pproductsbanimodecarouselkaveh']){ ?>
              <?php 
                  
                  // WP_Query args
                  $q_pc2_query_args = array(
                    'post_type' => array('product'),
'post_status' => array('publish'),
                    'posts_per_page' => $settings['productnumberproductsbanimodecarouselkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $settings['catproductsbanimodecarouselkaveh'],
                      ),
                    ),
                     
                    
                  );
                  if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                    $q_pc2_query_args['meta_query'] = array(
                        array(
                            'key' => '_stock_status',
                            'value' => 'outofstock',
                            'compare' => 'NOT IN',
                        ),
                    );
                  }

                  // The Query
                  $pc2_query = new \WP_Query($q_pc2_query_args);
                  
                  // The Loop
                  if ( $pc2_query->have_posts() ) {
                    while ( $pc2_query->have_posts() ) {
                      $pc2_query->the_post(); ?>
                    <?php 
                    global $product;
                    $product = wc_get_product();
                    $product_id = $product->get_id();
                    $product_type = $product->get_type();
                    $sale_price_dates_from = $sale_price_dates_to = '';
                    $sale_price = $product->get_sale_price();
                    $normal_price = $product->get_regular_price();
                    $pr_id = get_the_ID();
                    $stocka = $product->get_stock_status();
                    ?>
              <!-- Start Slide -->
              <div class="swiper-slide">
              <div <?php wc_product_class( 'product-seventeen pr' . $pr_id, $product ); ?>>
               <div class="image position-relative overflow-hidden rounded-3 align-items-center">
                    <a href="<?php the_permalink(); ?>" class="d-block">
                    <?php 
                    $attachment_ids = $product->get_gallery_image_ids();
                    ?>
                      <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title(); ?>" width="330" height="396"
                        class="w-100 d-block">
                        <?php if(!empty($attachment_ids)){ 
                         $imurl = wp_get_attachment_url($attachment_ids[0])
                          ?>
                      <img src="<?php echo $imurl; ?>" alt="<?php the_title(); ?>" width="330" height="396"
                        class="position-absolute top-0 end-0 w-100 h-100">
                        <?php }else{ ?>
                          <style>
                            <?php echo '.pr'.$pr_id ?>.product-seventeen .image>a img:last-child {
                            opacity: 1 !important;
                            visibility: visible !important;
                            }
                            <?php echo '.pr'.$pr_id ?>.product-seventeen:hover .image>a img:first-child {
                            opacity: 1 !important;
                            visibility: visible !important;
                            }
                          </style>
                          <?php } ?>
                    </a>
                    <?php if (!empty($normal_price)) {
                            if ("instock" == $stocka) {
                              if (!empty($sale_price)) { ?>
                    <span
                      class="offer position-absolute end-0 d-flex align-items-center justify-content-center fw-bold text-white">
                      <?php if (class_exists('kavehWoo')) { $offer_percentage = kavehWoo::showofferpercentage($product); echo $offer_percentage; } ?> </span>
                      <?php }
                         } 
                     } ?>
                    <ul class="icons position-absolute">
                      <li class="d-flex align-items-center justify-content-center rounded-circle bg-white">
                      <?php
                      if ( is_plugin_active( 'woo-smart-wishlist/wpc-smart-wishlist.php' ) ) { ?>
                      <?php echo do_shortcode( '[woosw id="".<?php echo get_the_ID(); ?>.""]' ); ?>
                      <?php
                      } else {

                      }
                      ?>                  
                          </li>
                      <li class="d-flex align-items-center justify-content-center rounded-circle bg-white" type="button" id="eyeid" data-bs-toggle="modal" data-bs-target="#modal-product">
                      <i class="isax isax-eye3"></i>
                      </li>
                    </ul>

                    <?php
                    $attachment_ids = $product->get_gallery_image_ids();
                  $image_count = count($attachment_ids);

                  // Start the ul element
                  echo '<ul class="colors d-flex justify-content-center w-100 px-2 end-0 position-absolute">';

                  // Check the number of images
                  if ($image_count <= 5) {
                      // Loop through each attachment ID
                      foreach ($attachment_ids as $attachment_id) {
                          // Get the image URL
                          $image_url = wp_get_attachment_url($attachment_id);
                          // Output the li element for each image
                          echo '<li class="bg-white overflow-hidden">';
                          echo '<a href="#" class="d-flex align-items-center justify-content-center">';
                          echo '<img src="' . esc_url($image_url) . '" alt="product name" width="43" height="45" class="d-block w-100 h-100">';
                          echo '</a></li>';
                      }
                  } else {
                      // If there are more than 5 images, display the first 5
                      for ($i = 0; $i < 5; $i++) {
                          $image_url = wp_get_attachment_url($attachment_ids[$i]);
                          echo '<li class="bg-white overflow-hidden">';
                          echo '<a href="#" class="d-flex align-items-center justify-content-center">';
                          echo '<img src="' . esc_url($image_url) . '" alt="product name" width="43" height="45" class="d-block w-100 h-100">';
                          echo '</a></li>';
                      }
                      // Then, display the count of additional images
                      $additional_count = $image_count - 5;
                      echo '<li class="count d-flex align-items-center justify-content-center bg-white fs-6"> +' . esc_html($additional_count) . ' </li>';
                  }

                  // Close the ul element
                  echo '</ul>';
                  ?>
                  </div>

                  <div class="brand-last-price d-flex align-items-center justify-content-between mt-3">
                    <?php
                    $categories = wp_get_post_terms( $product->get_id(), 'product_cat' );
                    foreach ($categories as $category) {
                    $category_link = get_term_link( $category );
                    $category_name = $category->name;
                    
                    echo '<a href="' . esc_url( $category_link ) . '" class="brand fw-semibold text-truncate">';
                    echo  esc_html( $category_name );
                    echo '</a>';
                    }
                    ?>
                    
                    <?php if("instock"==$stocka){ 
                          if ( !$product->is_type( 'variable' ) ) { 
                              if(!empty($sale_price) && empty(!$normal_price)) { ?>
                    <del class="last-price ms-2 text-nowrap"> <?php  echo number_format($normal_price, 0, '.', ',');  ?> <?php echo get_woocommerce_currency_symbol(); ?> </del>
                    <?php }
                    }
                   } ?>
                  </div>
                  <div class="title-price d-flex align-items-center justify-content-between my-3">
                    <h2 class="title mb-0 fw-normal w-100">
                      <a href="<?php the_permalink(); ?>" class="d-block text-truncate"> <?php the_title(); ?>
                      </a>
                    </h2>
                    <div class="price ms-2 text-nowrap">
                    <?php if("instock"==$stocka){ 
                       if ( !$product->is_type( 'variable' ) ) { 
                              if(!empty($sale_price) && !empty($normal_price)) { ?>
                              <?php echo number_format($sale_price, 0, '.', ','); ?> <?php echo get_woocommerce_currency_symbol(); ?>
                         <?php }elseif(!empty($normal_price)){
                         if (!empty($normal_price)) { ?>
                          <div class="price ms-2 text-nowrap">
                          <?php echo number_format((float)$sale_price, 0, '.', ','); ?> <?php echo get_woocommerce_currency_symbol(); ?>
                          </div>
                          <?php }
                         }else{          
                      $price_v = $product->get_price_html(); ?>
                     <?php echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v); ?>
                     <?php
                    }
                       }else{          
                        $price_v = $product->get_price_html(); ?>
                      <div class="price ms-2 text-nowrap">
                       <?php echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v); ?>
                       </div>
                       <?php
                      }
                      }else{ ?>
                        <span class="outstock">
                        ناموجود 
                        </span>
                      <?php
                      }
                      ?>  
                    </div>
                  </div>

                  <?php       
                  $terms = get_the_terms( $pr_id , 'pa_size' );
                  $max_display = 3; // Maximum number of sizes to display
                  // Check if there are any terms and more than the maximum display limit
                  if(!empty($terms) && count($terms) > $max_display){ ?>
                      <ul class="sizes d-flex align-items-center">
                      <?php
                      $displayed = 0; // Counter for displayed sizes
                      foreach ( $terms as $term ) {
                          // Stop the loop if maximum display limit is reached
                          if($displayed >= $max_display) break;
                          
                          $tooltip = get_term_meta( $term->term_id, 'wpcvs_tooltip', true ) ?: $term->name;
                          ?>
                          <li>
                              <a href="<?php the_permalink(); ?>" class="d-flex align-items-center justify-content-center"> <?php echo esc_attr( $tooltip ); ?> </a>
                          </li>
                          <?php
                          $displayed++;
                      }
                      // Calculate remaining sizes
                      $remaining = count($terms) - $max_display;
                      ?>
                      <li>
                          <a href="<?php the_permalink(); ?>" class="d-flex align-items-center justify-content-center more"> +<?php echo $remaining; ?> </a>
                      </li>
                      </ul>
                  <?php 
                  } elseif(!empty($terms)) { // If there are terms but 3 or less
                      ?>
                      <ul class="sizes d-flex align-items-center">
                      <?php
                      foreach ( $terms as $term ) {
                          $tooltip = get_term_meta( $term->term_id, 'wpcvs_tooltip', true ) ?: $term->name;
                          ?>
                          <li>
                              <a href="<?php the_permalink(); ?>" class="d-flex align-items-center justify-content-center"> <?php echo esc_attr( $tooltip ); ?> </a>
                          </li>
                          <?php
                      }
                      ?>
                      </ul>
                  <?php } ?>

                </div>
              </div>
              <!-- End Slide -->
            <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
              <?php }elseif('all'===$settings['pproductsbanimodecarouselkaveh']){
                // WP_Query args
            $ordvalue = $settings['psortproductsbanimodecarouselkaveh'];
            $ordi = $settings['psortiproductsbanimodecarouselkaveh'];
            $q_pc2_query_args = array(
              'post_type' => array('product'),
'post_status' => array('publish'),
              'posts_per_page' => $settings['productnumberproductsbanimodecarouselkaveh'],
              'order' => $ordi,
              'orderby' => 'meta_value_num',
              'meta_key'       => $ordvalue,

             
            );
            if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
              $q_pc2_query_args['meta_query'] = array(
                  array(
                      'key' => '_stock_status',
                      'value' => 'outofstock',
                      'compare' => 'NOT IN',
                  ),
              );
            }

            // The Query
            $pc2_query = new \WP_Query($q_pc2_query_args);

            // The Loop
            if ( $pc2_query->have_posts() ) {
              while ( $pc2_query->have_posts() ) {
                $pc2_query->the_post(); ?>
                <?php 
                global $product;
                $product = wc_get_product();
                $product_id = $product->get_id();
                $product_type = $product->get_type();
                $sale_price_dates_from = $sale_price_dates_to = '';
                $sale_price = $product->get_sale_price();
                $normal_price = $product->get_regular_price();
                $pr_id = get_the_ID();
                $stocka = $product->get_stock_status();
                ?>
            
              <!-- Start Slide -->
              <div class="swiper-slide">
              <div <?php wc_product_class( 'product-seventeen pr' . $pr_id, $product ); ?>>
               <div class="image position-relative overflow-hidden rounded-3 align-items-center">
                    <a href="<?php the_permalink(); ?>" class="d-block">
                    <?php 
                    $attachment_ids = $product->get_gallery_image_ids();
                    ?>
                      <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title(); ?>" width="330" height="396"
                        class="w-100 d-block">
                        <?php if(!empty($attachment_ids)){ 
                         $imurl = wp_get_attachment_url($attachment_ids[0])
                          ?>
                      <img src="<?php echo $imurl; ?>" alt="<?php the_title(); ?>" width="330" height="396"
                        class="position-absolute top-0 end-0 w-100 h-100">
                        <?php }else{ ?>
                          <style>
                            <?php echo '.pr'.$pr_id ?>.product-seventeen .image>a img:last-child {
                            opacity: 1 !important;
                            visibility: visible !important;
                            }
                            <?php echo '.pr'.$pr_id ?>.product-seventeen:hover .image>a img:first-child {
                            opacity: 1 !important;
                            visibility: visible !important;
                            }
                          </style>
                          <?php } ?>
                    </a>
                    <?php if (!empty($normal_price)) {
                            if ("instock" == $stocka) {
                              if (!empty($sale_price)) { ?>
                    <span
                      class="offer position-absolute end-0 d-flex align-items-center justify-content-center fw-bold text-white">
                      <?php if (class_exists('kavehWoo')) { $offer_percentage = kavehWoo::showofferpercentage($product); echo $offer_percentage; } ?> </span>
                      <?php }
                         } 
                     } ?>
                    <ul class="icons position-absolute">
                      <li class="d-flex align-items-center justify-content-center rounded-circle bg-white">
                      <?php
                      if ( is_plugin_active( 'woo-smart-wishlist/wpc-smart-wishlist.php' ) ) { ?>
                      <?php echo do_shortcode( '[woosw id="".<?php echo get_the_ID(); ?>.""]' ); ?>
                      <?php
                      } else {

                      }
                      ?>                  
                          </li>
                      <li class="d-flex align-items-center justify-content-center rounded-circle bg-white" type="button" id="eyeid" data-bs-toggle="modal" data-bs-target="#modal-product">
                      <i class="isax isax-eye3"></i>
                      </li>
                    </ul>

                    <?php
                    $attachment_ids = $product->get_gallery_image_ids();
                  $image_count = count($attachment_ids);

                  // Start the ul element
                  echo '<ul class="colors d-flex justify-content-center w-100 px-2 end-0 position-absolute">';

                  // Check the number of images
                  if ($image_count <= 5) {
                      // Loop through each attachment ID
                      foreach ($attachment_ids as $attachment_id) {
                          // Get the image URL
                          $image_url = wp_get_attachment_url($attachment_id);
                          // Output the li element for each image
                          echo '<li class="bg-white overflow-hidden">';
                          echo '<a href="#" class="d-flex align-items-center justify-content-center">';
                          echo '<img src="' . esc_url($image_url) . '" alt="product name" width="43" height="45" class="d-block w-100 h-100">';
                          echo '</a></li>';
                      }
                  } else {
                      // If there are more than 5 images, display the first 5
                      for ($i = 0; $i < 5; $i++) {
                          $image_url = wp_get_attachment_url($attachment_ids[$i]);
                          echo '<li class="bg-white overflow-hidden">';
                          echo '<a href="#" class="d-flex align-items-center justify-content-center">';
                          echo '<img src="' . esc_url($image_url) . '" alt="product name" width="43" height="45" class="d-block w-100 h-100">';
                          echo '</a></li>';
                      }
                      // Then, display the count of additional images
                      $additional_count = $image_count - 5;
                      echo '<li class="count d-flex align-items-center justify-content-center bg-white fs-6"> +' . esc_html($additional_count) . ' </li>';
                  }

                  // Close the ul element
                  echo '</ul>';
                  ?>
                  </div>

                  <div class="brand-last-price d-flex align-items-center justify-content-between mt-3">
                    <?php
                    $categories = wp_get_post_terms( $product->get_id(), 'product_cat' );
                    foreach ($categories as $category) {
                    $category_link = get_term_link( $category );
                    $category_name = $category->name;
                    
                    echo '<a href="' . esc_url( $category_link ) . '" class="brand fw-semibold text-truncate">';
                    echo  esc_html( $category_name );
                    echo '</a>';
                    }
                    ?>
                    
                    <?php if("instock"==$stocka){ 
                          if ( !$product->is_type( 'variable' ) ) { 
                              if(!empty($sale_price) && empty(!$normal_price)) { ?>
                    <del class="last-price ms-2 text-nowrap"> <?php  echo number_format($normal_price, 0, '.', ',');  ?> <?php echo get_woocommerce_currency_symbol(); ?> </del>
                    <?php }
                    }
                   } ?>
                  </div>
                  <div class="title-price d-flex align-items-center justify-content-between my-3">
                    <h2 class="title mb-0 fw-normal w-100">
                      <a href="<?php the_permalink(); ?>" class="d-block text-truncate"> <?php the_title(); ?>
                      </a>
                    </h2>
                    <div class="price ms-2 text-nowrap">
                    <?php if("instock"==$stocka){ 
                       if ( !$product->is_type( 'variable' ) ) { 
                              if(!empty($sale_price) && !empty($normal_price)) { ?>
                              <?php echo number_format($sale_price, 0, '.', ','); ?> <?php echo get_woocommerce_currency_symbol(); ?>
                         <?php }elseif(!empty($normal_price)){
                         if (!empty($normal_price)) { ?>
                          <div class="price ms-2 text-nowrap">
                          <?php echo number_format((float)$sale_price, 0, '.', ','); ?> <?php echo get_woocommerce_currency_symbol(); ?>
                          </div>
                          <?php }
                         }else{          
                      $price_v = $product->get_price_html(); ?>
                     <?php echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v); ?>
                     <?php
                    }
                       }else{          
                        $price_v = $product->get_price_html(); ?>
                      <div class="price ms-2 text-nowrap">
                       <?php echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v); ?>
                       </div>
                       <?php
                      }
                      }else{ ?>
                        <span class="outstock">
                        ناموجود 
                        </span>
                      <?php
                      }
                      ?>  
                    </div>
                  </div>

                  <?php       
                  $terms = get_the_terms( $pr_id , 'pa_size' );
                  $max_display = 3; // Maximum number of sizes to display
                  // Check if there are any terms and more than the maximum display limit
                  if(!empty($terms) && count($terms) > $max_display){ ?>
                      <ul class="sizes d-flex align-items-center">
                      <?php
                      $displayed = 0; // Counter for displayed sizes
                      foreach ( $terms as $term ) {
                          // Stop the loop if maximum display limit is reached
                          if($displayed >= $max_display) break;
                          
                          $tooltip = get_term_meta( $term->term_id, 'wpcvs_tooltip', true ) ?: $term->name;
                          ?>
                          <li>
                              <a href="<?php the_permalink(); ?>" class="d-flex align-items-center justify-content-center"> <?php echo esc_attr( $tooltip ); ?> </a>
                          </li>
                          <?php
                          $displayed++;
                      }
                      // Calculate remaining sizes
                      $remaining = count($terms) - $max_display;
                      ?>
                      <li>
                          <a href="<?php the_permalink(); ?>" class="d-flex align-items-center justify-content-center more"> +<?php echo $remaining; ?> </a>
                      </li>
                      </ul>
                  <?php 
                  } elseif(!empty($terms)) { // If there are terms but 3 or less
                      ?>
                      <ul class="sizes d-flex align-items-center">
                      <?php
                      foreach ( $terms as $term ) {
                          $tooltip = get_term_meta( $term->term_id, 'wpcvs_tooltip', true ) ?: $term->name;
                          ?>
                          <li>
                              <a href="<?php the_permalink(); ?>" class="d-flex align-items-center justify-content-center"> <?php echo esc_attr( $tooltip ); ?> </a>
                          </li>
                          <?php
                      }
                      ?>
                      </ul>
                  <?php } ?>

                </div>
              </div>
              <!-- End Slide -->
                <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
                <?php } ?>   
            </div>
            <?php if('yes'===$settings['showarrowsproductsbanimodecarouselkaveh']){ ?>
            <!-- Start Button -->
            <div class="swiper-button-next end-0 d-none d-sm-flex"></div>
            <div class="swiper-button-prev start-0 d-none d-sm-flex"></div>
            <!-- End Button -->
            <?php } ?>
          </div>
          <!-- End Carousel -->
        </div>
        <a href="<?php echo  esc_url($settings['buttontilink2productsbanimodecarouselkaveh']); ?>"
          class="btn btn-outline-dark-4 btn-more-bani d-flex align-items-center justify-content-center mx-auto w-100 mt-5 rounded-pill">
          <?php echo  esc_html($settings['buttonti2productsbanimodecarouselkaveh']); ?></a>
      </div>
    </section>
   <style>
    .product-seventeen.product {
    background-color: unset;
    -webkit-box-shadow: unset;
    -moz-box-shadow: unset;
    box-shadow: unset;
}
.product-seventeen .image {
    height: 370px;
    padding-top: 40px;
}
.product-seventeen .image>a img {
    object-fit: contain;
    max-height: 255px;
}
.product-seventeen .image>a img:last-child {
  object-fit: contain;
    max-height: 255px;
}
.product-seventeen .image>a img:last-child {
    object-fit: contain;
    max-height: 255px;
    margin-top: 40px;
}
   </style>
<?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
