<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class product__special__carousel extends Widget_Base
{

    public function get_name()
    {
        return 'product__special__carousel';
    }

    public function get_title()
    {
        return esc_html__('اسلایدر محصولات ویژه', 'kaveh-core');
    }

    public function get_icon()
    {
        return 'eicon-archive-posts';
    }

    public function get_categories()
    {
        return ['kavehelements'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'contentproductscarouselfourthstkaveh',
            [
                'label' => esc_html__('عنوان المان', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'titleproductscarouselfourthstkaveh',
            [
                'label' => esc_html__('عنوان فرعی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('پرفروش ترین محصولات', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'title2productscarouselfourthstkaveh',
            [
                'label' => esc_html__('عنوان اصلی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('پوشاک ورزشی', 'kaveh-core'),

            ]
        );
        $this->add_control(
            'tagheadingproductscarouselfourthstkaveh',
            [
                'label' => esc_html__('تگ عنوان', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'H3',
                'options' => [
                    'H1' => esc_html__('H1', 'kaveh-core'),
                    'H2' => esc_html__('H2', 'kaveh-core'),
                    'H3' => esc_html__('H3', 'kaveh-core'),
                    'H4' => esc_html__('H4', 'kaveh-core'),
                    'H5' => esc_html__('H5', 'kaveh-core'),
                    'H6' => esc_html__('H6', 'kaveh-core'),
                    'p' => esc_html__('p', 'kaveh-core'),
                    'div' => esc_html__('div', 'kaveh-core'),
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'content2productscarouselfourthstkaveh',
            [
                'label' => esc_html__('تصاویر', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'imgproductscarouselfourthstkaveh',
            [
                'label' => esc_html__('تصویر خود را انتخاب کنید', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'selectors' => [
                    '{{WRAPPER}} .new-products-category-title::after' =>
                        'background: url({{URL}})',
                    '{{WRAPPER}} .new-products-category-title::before' =>
                        'background: url({{URL}})',
                ],
            ]
        );

        $this->add_control(
            'imgbgproductscarouselfourthstkaveh',
            [
                'label' => esc_html__('تصویر پس زمینه', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'selectors' => [
                    '{{WRAPPER}} .new-products-category-title' =>
                        'background: url({{URL}})',
                ],
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'content3productscarouselfourthstkaveh',
            [
                'label' => esc_html__('تنظیمات محصولات', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'kaveh_exclude_out_of_stock',
            [
                'label' => esc_html__('عدم نمایش محصولات ناموجود', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'yes' => esc_html__('بله', 'kaveh-core'),
                'no' => esc_html__('خیر', 'kaveh-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'pproductscarouselfourthstkaveh',
            [
                'label' => esc_html__('نمایش محصولات', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'all',
                'options' => [
                    'all' => esc_html__('همه', 'kaveh-core'),
                    'cat' => esc_html__('دسته بندی', 'kaveh-core'),

                ],
            ]
        );
        $this->add_control(
            'psortproductscarouselfourthstkaveh',
            [
                'label' => esc_html__('مرتب سازی محصولات براساس', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date' => esc_html__('تاریخ', 'kaveh-core'),
                    '_price' => esc_html__('قیمت', 'kaveh-core'),
                    '_wc_average_rating' => esc_html__('محبوب ترین', 'kaveh-core'),
                    'total_sales' => esc_html__('بیشترین فروش', 'kaveh-core'),

                ],
            ]
        );
        $this->add_control(
            'psortiproductscarouselfourthstkaveh',
            [
                'label' => esc_html__('نوع مرتب سازی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => [
                    'asc' => esc_html__('صعودی', 'kaveh-core'),
                    'desc' => esc_html__('نزولی', 'kaveh-core'),
                ],
            ]
        );
        $options4 = array();
        $orderby = 'name';
        $order = 'asc';
        $hide_empty = false;
        $cat_args = array(
            'orderby' => $orderby,
            'order' => $order,
            'hide_empty' => $hide_empty,
        );

        $product_categories = get_terms('product_cat', $cat_args);

        foreach ($product_categories as $key => $category) {
            $options4[$category->term_id] = $category->name;
        }
        $this->add_control(
            'catproductscarouselfourthstkaveh',
            [
                'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $options4,
                'condition' => [
                    'pproductscarouselfourthstkaveh' => 'cat',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'content4productscarouselfourthstkaveh',
            [
                'label' => esc_html__('تنظیمات کاروسل', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'showarrowsproductscarouselfourthstkaveh',
            [
                'label' => esc_html__('نمایش جهت ها؟', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'yes' => esc_html__('بله', 'kaveh-core'),
                'no' => esc_html__('خیر', 'kaveh-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'productnumberproductscarouselfourthstkaveh',
            [
                'label' => esc_html__('تعداد محصولات نمایش داده شده', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 50,
                'step' => 1,
                'default' => 5,
            ]
        );
        $this->add_control(
            'productcolumnproductscarouselfourthstkaveh',
            [
                'label' => esc_html__('تعداد ستون محصولات در دسکتاپ', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 5,
                'step' => 0.5,
                'default' => 3,

            ]
        );
        $this->add_control(
            'productcolumn2productscarouselfourthstkaveh',
            [
                'label' => esc_html__('تعداد ستون محصولات در تبلت', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 5,
                'step' => 0.5,
                'default' => 2,

            ]
        );
        $this->add_control(
            'productcolumn3productscarouselfourthstkaveh',
            [
                'label' => esc_html__('تعداد ستون محصولات در موبایل', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 5,
                'step' => 0.5,
                'default' => 1.5,

            ]
        );
        $this->end_controls_section();
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $clsid = $this->get_id();
        ?>

        <!-- Start Discount -->
        <section>
            <!-- Start Carousel -->
            <div class="swiper swiper-discount-product-special position-relative">
                <div class="swiper-wrapper">
                    <?php if ('cat' === $settings['pproductscarouselfourthstkaveh']) { ?>
                        <?php

                        // WP_Query args
                        $q_pc4_query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $settings['productnumberproductscarouselfourthstkaveh'],
                            'order' => 'DESC',
                            'orderby' => 'date',
                            'tax_query' => array(
                                array(
                                    "taxonomy" => "product_cat",
                                    "field" => "tag_ID",
                                    "terms" => $settings['catproductscarouselfourthstkaveh'],
                                ),
                            ),
                        );
                        if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                            $q_pc4_query_args['meta_query'] = array(
                                array(
                                    'key' => '_stock_status',
                                    'value' => 'outofstock',
                                    'compare' => 'NOT IN',
                                ),
                            );
                        }

                        // The Query
                        $pc4_query = new \WP_Query($q_pc4_query_args);

                        // The Loop
                        if ($pc4_query->have_posts()) {
                            while ($pc4_query->have_posts()) {
                                $pc4_query->the_post();
                                global $product;
                                $sale_price = $product->get_sale_price();
                                $normal_price = $product->get_regular_price();
                                $pr_id = get_the_ID();
                                $stocka = $product->get_stock_status();
                                ?>
                                <!-- Start Slide -->

                                <div class="swiper-slide">
                                    <div class="product-eight product-eight-offer">
                                        <div class="image full-width">
                                            <a href="<?php the_permalink(); ?>">
                                                <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title(); ?>"
                                                    width="266" height="266">
                                            </a>

                                            <div class="offer">
                                                <?php echo $normal_price; ?>
                                            </div>

                                            <?php
                                            if ("instock" != $stocka) { ?>
                                                <div class="status position-absolute top-0 text-center rounded-pill">
                                                    ناموجود
                                                </div>
                                            <?php } ?>
                                        </div>
                                        <div class="content">
                                            <ul class="tags d-flex align-items-center flex-wrap">
                                                <li>
                                                    <a href="#" class="d-block rounded-pill"> #فروش ویژه </a>
                                                </li>
                                                <li>
                                                    <a href="#" class="d-block rounded-pill"> #فروش ویژه </a>
                                                </li>
                                                <li>
                                                    <a href="#" class="d-block rounded-pill"> #فروش ویژه </a>
                                                </li>
                                            </ul>
                                            <h2 class="product-name">
                                                <a href="<?php the_permalink(); ?>">
                                                    <?php the_title(); ?>
                                                </a>
                                            </h2>
                                            <div class="d-flex align-items-center justify-content-between">
                                                <?php if ("instock" == $stocka) { ?>
                                                    <?php if (!$product->is_type('variable')) { ?>
                                                        <?php if (!empty($sale_price)) { ?>
                                                            <div class="offer">
                                                                <?php echo $normal_price; ?>
                                                            </div>
                                                            <div class="price">
                                                                <?php echo number_format($sale_price, 0, '.', ','); ?>
                                                                <span>
                                                                    <?php echo get_woocommerce_currency_symbol(); ?>
                                                                </span>
                                                            </div>
                                                        <?php } else { ?>
                                                            <div class="price nor10p">
                                                                <?php if (!empty($normal_price)) {
                                                                    echo number_format($normal_price, 0, '.', ',');
                                                                } ?>
                                                                <span>
                                                                    <?php echo get_woocommerce_currency_symbol(); ?>
                                                                </span>
                                                            </div>
                                                        <?php } ?>
                                                    <?php } else { ?>
                                                        <div>
                                                            <?php
                                                            $price_v = $product->get_price_html();
                                                            echo str_replace("&ndash;", "<span class=\"dashvar\"> – </span>", $price_v); ?>
                                                        </div>
                                                        <?php
                                                    }
                                                    ?>
                                                <?php } else {
                                                    ?>
                                                    <div class="mt-p10"></div>
                                                    <?php
                                                } ?>
                                                <?php if (empty($normal_price)) { ?>
                                                    <div class="mt-p101"></div>
                                                <?php } ?>





                                                <a href="#" class="btn btn-success-2 shadow-none"> + خرید </a>
                                            </div>
                                            <a href="<?php the_permalink(); ?>" class="btn btn-secondary rounded-pill"> مشاهده و خرید محصول
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <!-- End Slide -->

                                <?php
                                // Reset Original Post Data
                                wp_reset_postdata();
                            }
                        }
                    } elseif ('all' === $settings['pproductscarouselfourthstkaveh']) {
                        // WP_Query args
                        $ordvalue = $settings['psortproductscarouselfourthstkaveh'];
                        $ordi = $settings['psortiproductscarouselfourthstkaveh'];
                        $q_pc4_query_args = array(
                            'post_type' => array('product'),
'post_status' => array('publish'),
                            'posts_per_page' => $settings['productnumberproductscarouselfourthstkaveh'],
                            'order' => $ordi,
                            'orderby' => 'meta_value_num',
                            'meta_key' => $ordvalue,
                        );
                        if ("yes" === $settings['kaveh_exclude_out_of_stock']) {
                            $q_pc4_query_args['meta_query'] = array(
                                array(
                                    'key' => '_stock_status',
                                    'value' => 'outofstock',
                                    'compare' => 'NOT IN',
                                ),
                            );
                        }

                        // The Query
                        $pc4_query = new \WP_Query($q_pc4_query_args);

                        // The Loop
                        if ($pc4_query->have_posts()) {
                            while ($pc4_query->have_posts()) {
                                $pc4_query->the_post();
                                global $product;
                                $sale_price = $product->get_sale_price();
                                $normal_price = $product->get_regular_price();
                                $pr_id = get_the_ID();
                                $stocka = $product->get_stock_status(); ?>
                                <!-- Start Slide -->

                                <div class="swiper-slide">
                                    <div class="product-eight product-eight-offer">
                                        <div class="image full-width">
                                            <a href="<?php the_permalink(); ?>">
                                                <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title(); ?>"
                                                    width="266" height="266">
                                            </a>

                                            <div class="offer">
                                                <?php echo $normal_price; ?>
                                            </div>

                                            <?php
                                            if ("instock" != $stocka) { ?>
                                                <div class="status position-absolute top-0 text-center rounded-pill">
                                                    ناموجود
                                                </div>
                                            <?php } ?>
                                        </div>
                                        <div class="content">
                                            <ul class="tags d-flex align-items-center flex-wrap">
                                                <li>
                                                    <a href="#" class="d-block rounded-pill"> #فروش ویژه </a>
                                                </li>
                                                <li>
                                                    <a href="#" class="d-block rounded-pill"> #فروش ویژه </a>
                                                </li>
                                                <li>
                                                    <a href="#" class="d-block rounded-pill"> #فروش ویژه </a>
                                                </li>
                                            </ul>
                                            <h2 class="product-name">
                                                <a href="<?php the_permalink(); ?>">
                                                    <?php the_title(); ?>
                                                </a>
                                            </h2>
                                            <div class="d-flex align-items-center justify-content-between">
                                                <?php if ("instock" == $stocka) { ?>
                                                    <?php if (!$product->is_type('variable')) { ?>
                                                        <?php if (!empty($sale_price)) { ?>
                                                            <div class="offer">
                                                                <?php echo $normal_price; ?>
                                                            </div>
                                                            <div class="price">
                                                                <?php echo number_format($sale_price, 0, '.', ','); ?>
                                                                <span>
                                                                    <?php echo get_woocommerce_currency_symbol(); ?>
                                                                </span>
                                                            </div>
                                                        <?php } else { ?>
                                                            <div class="price nor10p">
                                                                <?php if (!empty($normal_price)) {
                                                                    echo number_format($normal_price, 0, '.', ',');
                                                                } ?>
                                                                <span>
                                                                    <?php echo get_woocommerce_currency_symbol(); ?>
                                                                </span>
                                                            </div>
                                                        <?php } ?>
                                                    <?php } else { ?>
                                                        <div>
                                                            <?php
                                                            $price_v = $product->get_price_html();
                                                            echo str_replace("&ndash;", "<span class=\"dashvar\"> – </span>", $price_v); ?>
                                                        </div>
                                                        <?php
                                                    }
                                                    ?>
                                                <?php } else {
                                                    ?>
                                                    <div class="mt-p10"></div>
                                                    <?php
                                                } ?>
                                                <?php if (empty($normal_price)) { ?>
                                                    <div class="mt-p101"></div>
                                                <?php } ?>





                                                <a href="#" class="btn btn-success-2 shadow-none"> + خرید </a>
                                            </div>
                                            <a href="<?php the_permalink(); ?>" class="btn btn-secondary rounded-pill"> مشاهده و خرید محصول
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <!-- End Slide -->
                                <?php
                                // Reset Original Post Data
                                wp_reset_postdata();
                            }
                        }
                    } ?>

                </div>
                <!-- Start Pagination -->
                <div class="swiper-pagination end-0"></div>
                <!-- End Pagination -->
            </div>
            <!-- End Carousel -->
        </section>
        <!-- End Discount -->
        <style>
            .product-eight {
                height: auto !important;
            }
        </style>
        <?php
    }

}