<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Phonenumberkaveh extends Widget_Base{

  public function get_name(){
    return 'phonenumberkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان شماره تماس', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['headerfooterkavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentphonenumberkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'pish1phonenumberkaveh',
        [
            'label' => esc_html__( 'پیش شماره اول', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( '021', 'kaveh-core' ),
        ]
    ); 
    $this->add_control(
      'shomare1phonenumberkaveh',
      [
          'label' => esc_html__( 'شماره اول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '12345678', 'kaveh-core' ),
      ]
  ); 
  $this->add_control(
    'pish2phonenumberkaveh',
    [
        'label' => esc_html__( 'پیش شماره دوم', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( '021', 'kaveh-core' ),
    ]
); 
$this->add_control(
  'shomare2phonenumberkaveh',
  [
      'label' => esc_html__( 'شماره دوم', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( '12345678', 'kaveh-core' ),
  ]
);
$this->add_control(
  'titlephonenumberkaveh',
  [
      'label' => esc_html__( 'عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'پشتیبانی سریع', 'kaveh-core' ),
  ]
); 
$this->add_control(
  'showimgphonenumberkaveh',
  [
    'label' => esc_html__( 'نمایش تصویر پس زمینه؟', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'yes' => esc_html__( 'بله', 'kaveh-core' ),
    'no' => esc_html__( 'خیر', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'no',
  ]
);
$this->add_control(
  'imgphonenumberkaveh',
  [
    'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'selectors' => [
      '{{WRAPPER}} .footer-two-phone::after' =>
          'background: url({{URL}}) 0 0 no-repeat',
  ],
    'condition' => [
      'showimgphonenumberkaveh' => 'yes',
    ],
  ]
);

       $this->end_controls_section();
       $this->start_controls_section(
        'style_phonenumberkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'pishphonenumberkaveh',
        [
          'label' => esc_html__( 'رنگ پیش شماره', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .footer-two-phone div span' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'pishtypephonenumberkaveh',
          'label' => esc_html__( 'تایپوگرافی پیش شماره', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .footer-two-phone div span',
        ]
      );
      $this->add_control(
        'shomarephonenumberkaveh',
        [
          'label' => esc_html__( 'رنگ شماره', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .footer-two-phone div' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'shomaretypephonenumberkaveh',
          'label' => esc_html__( 'تایپوگرافی شماره', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .footer-two-phone div',
        ]
      );
      $this->add_control(
        'titlestphonenumberkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .footer-two-phone > span' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletypephonenumberkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .footer-two-phone > span',
        ]
      );
      
      $this->add_control(
        'widthiconphonenumberkaveh',
        [
          'label' => esc_html__( 'عرض', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'condition' => [
            'showimgphonenumberkaveh' =>'yes',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .footer-two-phone::after' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'heighticonphonenumberkaveh',
        [
          'label' => esc_html__( 'ارتفاع', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'condition' => [
            'showimgphonenumberkaveh' =>'yes',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .footer-two-phone::after' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'topiconphonenumberkaveh',
        [
          'label' => esc_html__( 'فاصله از بالا', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'condition' => [
            'showimgphonenumberkaveh' =>'yes',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .footer-two-phone::after' => 'top: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      
          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
  
?>

        <div class="footer-two-phone position-relative">
          <a href="tel:<?php echo  esc_html($settings['pish1phonenumberkaveh']); echo  esc_html($settings['shomare1phonenumberkaveh']); ?>"><div> <span><?php echo  esc_html($settings['pish1phonenumberkaveh']); ?></span><?php echo  esc_html($settings['shomare1phonenumberkaveh']); ?></div></a>
          <a href="tel:<?php echo  esc_html($settings['pish2phonenumberkaveh']); echo  esc_html($settings['shomare2phonenumberkaveh']); ?>"> <div> <span><?php echo  esc_html($settings['pish2phonenumberkaveh']); ?></span><?php echo  esc_html($settings['shomare2phonenumberkaveh']); ?></div></a>
          <span class="text-right d-block"><?php echo  esc_html($settings['titlephonenumberkaveh']); ?></span>
        </div>
    <?php
  }


}
