<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Newslettersecondstkaveh extends Widget_Base{

  public function get_name(){
    return 'newslettersecondstkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان خبرنامه سبک دو', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['headerfooterkavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentnewslettersecondstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'styledotnewslettersecondstkaveh',
        [
          'label' => esc_html__( 'استایل المان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح یک', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح دو', 'kaveh-core' ),
            'three'  => esc_html__( 'طرح سه', 'kaveh-core' ),
          ],
        ]
        );  
        $this->add_control(
          'beforetitlenewslettersecondstkaveh',
          [
              'label' => esc_html__( 'پیش از عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'از', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'titlenewslettersecondstkaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'تخفیف ها و جدیدترین ها', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'aftertitlenewslettersecondstkaveh',
      [
          'label' => esc_html__( 'پس از عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'با خبر شوید', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'tagheadingnewslettersecondstkaveh',
    [
      'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'H3',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
        'span' => esc_html__( 'span', 'kaveh-core' ),
      ],
    ]
  );
  $this->add_control(
    'iconnewslettersecondstkaveh',
    [
      'label' => esc_html__( 'آیکون', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::ICONS,
      'skin' => 'inline',
      'exclude_inline_options' => [ 'svg' ],
      'default' => [
        'value' => 'icon-email',
      ],
    ]
  ); 
  $this->add_control(
    'imgnewslettersecondstkaveh',
    [
      'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
      'selectors' => [
        '{{WRAPPER}} .footer-sixteen .footer-newsletter' =>
            'background: url({{URL}}) 0 0 no-repeat',
    ],
      'condition' => [
        'styledotnewslettersecondstkaveh' => 'three',
      ],
    ]
  );
        $this->end_controls_section();
        $this->start_controls_section(
          'style1_newslettersecondstkaveh',
          [
            'label' => esc_html__( 'استایل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        ); 
        $this->add_control(
          'iconcolor1newslettersecondstkaveh',
          [
            'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .newsl2 i' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_control(
          'iconsizenewslettersecondstkaveh',
          [
            'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .newsl2 i' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'textcolor1newslettersecondstkaveh',
          [
            'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .newsl2' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'titletype1newslettersecondstkaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .newsl2',
          ]
        );
        $this->add_control(
          'beforecolornewslettersecondstkaveh',
          [
            'label' => esc_html__( 'رنگ خط بالا', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'condition' => [
              'styledotnewslettersecondstkaveh' =>'one',
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-four .footer-namad::after' => 'background-color: {{VALUE}}',
              '{{WRAPPER}} .footer-four-news-letter::after' => 'background-color: {{VALUE}}',

            ],
          ]
        );
        $this->add_control(
          'hrernewslettersecondstkaveh',
          [
            'type' => \Elementor\Controls_Manager::DIVIDER,
            'condition' => [
              'styledotnewslettersecondstkaveh' =>'three',
            ],
          ]
        ); 
        $this->add_control(
          'buttonradius1newslettersecondstkaveh',
          [
            'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'condition' => [
              'styledotnewslettersecondstkaveh' =>'three',
            ],
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .footer-sixteen .footer-newsletter' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
  
?>
<?php if("one"===$settings['styledotnewslettersecondstkaveh']){?>
            <div class="footer-four-news-letter">
              <<?php echo  esc_attr($settings['tagheadingnewslettersecondstkaveh']); ?> class="newsl2">
                <i class="<?php echo  esc_attr($settings['iconnewslettersecondstkaveh']['value']); ?>"></i>
                <?php echo  esc_html($settings['beforetitlenewslettersecondstkaveh']); ?>
                <b><?php echo  esc_html($settings['titlenewslettersecondstkaveh']); ?></b>
                <?php echo  esc_html($settings['aftertitlenewslettersecondstkaveh']); ?>
              </<?php echo  esc_attr($settings['tagheadingnewslettersecondstkaveh']); ?>>
              <form method="post" action="#" class="d-flex align-items-center">
                <input type="email" name="newsletter" class="form-control rounded-pill text-start"
                  placeholder="ایمیل شما" />
                <button type="submit" class="btn btn-dark rounded-pill ms-auto"> مشترک شوید </button>
              </form>
            </div>
<?php }elseif("two"===$settings['styledotnewslettersecondstkaveh']){ ?>
            <div class="footer-newsletter">
              <<?php echo  esc_attr($settings['tagheadingnewslettersecondstkaveh']); ?> class="title newsl2">
                <i class="<?php echo  esc_attr($settings['iconnewslettersecondstkaveh']['value']); ?>"></i>
                <?php echo  esc_html($settings['beforetitlenewslettersecondstkaveh']); ?>
                <b><?php echo  esc_html($settings['titlenewslettersecondstkaveh']); ?></b>
                <?php echo  esc_html($settings['aftertitlenewslettersecondstkaveh']); ?>
              </<?php echo  esc_attr($settings['tagheadingnewslettersecondstkaveh']); ?>>
              <form method="post" action="#">
                <input type="text" name="newsletter" class="form-control rounded-pill" placeholder="ایمیل شما" />
                <button type="submit" class="btn btn-dark rounded-pill"> مشترک شوید </button>
              </form>
            </div>
<?php }elseif("three"===$settings['styledotnewslettersecondstkaveh']){ ?>
          <div class="footer-sixteen">
            <div class="footer-newsletter d-flex align-items-md-center rounded-pill flex-column flex-md-row">
              <<?php echo  esc_attr($settings['tagheadingnewslettersecondstkaveh']); ?> class="title newsl2 mb-3 mb-md-0">
              <i class="<?php echo  esc_attr($settings['iconnewslettersecondstkaveh']['value']); ?>"></i>
                <?php echo  esc_html($settings['beforetitlenewslettersecondstkaveh']); ?>
                <b><?php echo  esc_html($settings['titlenewslettersecondstkaveh']); ?></b>
                <?php echo  esc_html($settings['aftertitlenewslettersecondstkaveh']); ?>
              </<?php echo  esc_attr($settings['tagheadingnewslettersecondstkaveh']); ?>>
              <form method="post" action="#" class="d-flex align-items-center">
                <input type="text" name="newsletter" class="form-control rounded-pill mb-0 border-0"
                  placeholder="ایمیل شما">
                <button type="submit" class="btn btn-warning rounded-pill text-nowrap"> مشترک شوید </button>
              </form>
            </div>
          </div>
<style>
  <?php echo '.elementor-element-' . $clsid . ''; ?> .footer-sixteen .footer-newsletter {
    -webkit-background-size: 100% 100%;
    -moz-background-size: 100% 100%;
    -o-background-size: 100% 100%;
    background-size: 100% 100%;
    padding: 15px 35px 15px 15px;
}
</style>
<?php } ?>
    <?php
  }


}
