<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Newsletterkaveh extends Widget_Base{

  public function get_name(){
    return 'newsletterkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان خبرنامه', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentnewsletterkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
  
      $this->add_control(
          'title1newsletterkaveh',
          [
              'label' => esc_html__( 'قبل از عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'از', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'title2newsletterkaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'تخفیف ها و جدیدترین ها', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'title3newsletterkaveh',
      [
          'label' => esc_html__( 'بعد از عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'باخبر شوید', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'tagheadingnewsletterkaveh',
    [
      'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'H3',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
        'span' => esc_html__( 'span', 'kaveh-core' ),
      ],
    ]
  );
    $this->add_control(
      'descnewsletterkaveh',
      [
          'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXTAREA,
          'default' => esc_html__( 'دانلود این فایل کاری نداره، فقط کافیه ایمیلتون رو تو فیلد زیر وارد کنید و این راهنمای جامع ارز دیجیتال رو خیلی سریع توی ایمیلتون دریافت کنید و بخونید', 'kaveh-core' ),
  
      ]
  );

$this->add_control(
  'imgnewsletterkaveh',
  [
    'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'default' => [
      'url' => \Elementor\Utils::get_placeholder_image_src(),
    ],
  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'style1_newsletterkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'titlestnewsletterkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .news-letter .nws1' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_newsletterkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .news-letter .nws1',
        ]
      );
      $this->add_control(
        'titlepstnewsletterkaveh',
        [
          'label' => esc_html__( 'رنگ متن', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .news-letter .para' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'p_newsletterkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .news-letter .para',
        ]
      );

      $this->end_controls_section();
          
        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
<section class="news-letter">
    <div class="container position-relative">
      <div class="row align-items-center">
        <div class="col-lg-5 mb-4 mb-lg-0">
          <img src="<?php echo esc_url($settings['imgnewsletterkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $settings['imgnewsletterkaveh'] )); ?>" class="mx-auto d-block" />
        </div>
        <div class="col-lg-7">
          <<?php echo  esc_html($settings['tagheadingnewsletterkaveh']); ?> class="fw-light nws1">
            <?php echo  esc_html($settings['title1newsletterkaveh']); ?>
            <b> <?php echo  esc_html($settings['title2newsletterkaveh']); ?> </b>
            <?php echo  esc_html($settings['title3newsletterkaveh']); ?>
          </<?php echo  esc_html($settings['tagheadingnewsletterkaveh']); ?>>
          <p class="fw-light para"> <?php echo  esc_html($settings['descnewsletterkaveh']); ?> </p>
          <form method="post" action="#" class="d-flex align-items-center">
            <input type="email" name="news-letter" class="form-control rounded-pill text-start"
              placeholder="ایمیل شما" />
            <button type="submit" class="btn btn-dark rounded-pill p-0"> ارسال </button>
          </form>
        </div>
      </div>
    </div>
  </section>
    <?php
  }


}
