<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly


class Megamenutwokaveh extends Widget_Base
{

  public function get_name()
  {
    return 'megamenutwokaveh';
  }

  public function get_title()
  {
    return esc_html__('المان مگا منو طرح دوم', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['megamenufooterkavehelements'];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'content1megamenutwokaveh',
      [
        'label' => esc_html__('تعداد تب', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tabcountmegamenutwokaveh',
      [
        'label' => esc_html__('تعداد ستون', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '4',
        'options' => [
          '1' => esc_html__('1', 'kaveh-core'),
          '2' => esc_html__('2', 'kaveh-core'),
          '3' => esc_html__('3', 'kaveh-core'),
          '4' => esc_html__('4', 'kaveh-core'),
          '5' => esc_html__('5', 'kaveh-core'),
          '6' => esc_html__('6', 'kaveh-core'),
        ],
      ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
      'tab1megamenutwokaveh',
      [
        'label' => esc_html__('محتوای تب اول', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'icon1megamenutwokaveh',
      [
        'label' => esc_html__('آیکون تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => ['svg'],
        'default' => [
          'value' => 'icon icon-ball',
        ],
      ]
    );
    $this->add_control(
      'title1megamenutwokaveh',
      [
        'label' => esc_html__('عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('کالای دیجیتال', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'link1megamenutwokaveh',
      [
        'label' => esc_html__('لینک عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'title21megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('گوشی موبایل', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'hrt1megamenutwokaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'col1title1megamenutwokaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('مک بوک ۲۰۲۲', 'kaveh-core'),

      ]
    );
    $repeater->add_control(
      'activetitle1megamenutwokaveh',
      [
        'label' => esc_html__('عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('فعال', 'kaveh-core'),
        'label_off' => esc_html__('غیرفعال', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $repeater->add_control(
      'col1title21megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'activetitle1megamenutwokaveh' => 'yes',
        ],
        'default' => esc_html__('لپ تاپ اپل', 'kaveh-core'),

      ]
    );
    $repeater->add_control(
      'col1link1megamenutwokaveh',
      [
        'label' => esc_html__('لینک', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'listcol1megamenutwokaveh',
      [
        'label' => esc_html__('لیست ستون اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'col1title1megamenutwokaveh' => esc_html__('مک بوک ۲۰۲۲', 'kaveh-core'),
            'col1title21megamenutwokaveh' => esc_html__('لپ تاپ اپل', 'kaveh-core'),
            'col1link1megamenutwokaveh' => esc_html__('#', 'kaveh-core'),
          ],
        ]
      ]

    );
    $this->add_control(
      'hrl1megamenutwokaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'imgshows1megamenutwokaveh',
      [
        'label' => esc_html__('ستون سوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
          '1' => esc_html__('تصویر تک ستونه', 'kaveh-core'),
          '2' => esc_html__('تصویر دو ستونه با دکمه', 'kaveh-core'),
          '3' => esc_html__('محصولات', 'kaveh-core'),
        ],
      ]
    );
    $this->add_control(
      'imagecol31megamenutwokaveh',
      [
        'label' => esc_html__('تصویر اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'condition' => [
          'imgshows1megamenutwokaveh' => ['1', '2'],
        ],
      ]
    );
    $this->add_control(
      'imagecol3but1megamenutwokaveh',
      [
        'label' => esc_html__('متن دکمه اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows1megamenutwokaveh' => '2',
        ],
        'default' => esc_html__('خرید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'imagecol3link1megamenutwokaveh',
      [
        'label' => esc_html__('لینک اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),
        'condition' => [
          'imgshows1megamenutwokaveh' => ['1', '2'],
        ],

      ]
    );
    $this->add_control(
      'imagecol321megamenutwokaveh',
      [
        'label' => esc_html__('تصویر دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'condition' => [
          'imgshows1megamenutwokaveh' => ['1', '2'],
        ],
      ]
    );
    $this->add_control(
      'imagecol3but21megamenutwokaveh',
      [
        'label' => esc_html__('متن دکمه دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows1megamenutwokaveh' => '2',
        ],
        'default' => esc_html__('خرید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'imagecol3link321megamenutwokaveh',
      [
        'label' => esc_html__('لینک تصویر دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),
        'condition' => [
          'imgshows1megamenutwokaveh' => ['1', '2'],
        ],

      ]
    );
    $this->add_control(
      'col4button1megamenutwokaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows1megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('دوربین ها', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4button21megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows1megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('Mountaineering and camping', 'kaveh-core'),

      ]
    );
    $taboptiongrid = array();
    $orderby = 'name';
    $order = 'asc';
    $hide_empty = false;
    $cat_args = array(
      'orderby' => $orderby,
      'order' => $order,
      'hide_empty' => $hide_empty,
    );
    $product_categories = get_terms('product_cat', $cat_args);

    foreach ($product_categories as $key => $category) {
      $taboptiongrid[$category->term_id] = $category->name;
    }
    $this->add_control(
      'cat1col41megamenutwokaveh',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => true,
        'condition' => [
          'imgshows1megamenutwokaveh' => '3',
        ],
        'options' => $taboptiongrid,
      ]
    );
    $this->add_control(
      'productnumber1megamenutwokaveh',
      [
        'label' => esc_html__('تعداد محصولات', 'kaveh-core'),
        'condition' => [
          'imgshows1megamenutwokaveh' => '3',
        ],
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 3,
        'step' => 1,
        'default' => 3,
      ]
    );
    $this->add_control(
      'col4buttontitle1megamenutwokaveh',
      [
        'label' => esc_html__('عنوان دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows1megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('برای مشاهده بیشتر', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4buttontitle21megamenutwokaveh',
      [
        'label' => esc_html__('بخش دوم عنوان دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows1megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('کلیک کنید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4buttonlink1megamenutwokaveh',
      [
        'label' => esc_html__('لینک دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows1megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'tab2megamenutwokaveh',
      [
        'label' => esc_html__('محتوای تب دوم', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tabcountmegamenutwokaveh' => ['2', '3', '4', '5', '6'],
        ],
      ]
    );
    $this->add_control(
      'icon2megamenutwokaveh',
      [
        'label' => esc_html__('آیکون تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => ['svg'],
        'default' => [
          'value' => 'icon icon-ball',
        ],
      ]
    );
    $this->add_control(
      'title2megamenutwokaveh',
      [
        'label' => esc_html__('عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('کالای دیجیتال', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'link2megamenutwokaveh',
      [
        'label' => esc_html__('لینک عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'title22megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('گوشی موبایل', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'hrt2megamenutwokaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'col1title2megamenutwokaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('مک بوک ۲۰۲۲', 'kaveh-core'),

      ]
    );
    $repeater->add_control(
      'activetitle2megamenutwokaveh',
      [
        'label' => esc_html__('عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('فعال', 'kaveh-core'),
        'label_off' => esc_html__('غیرفعال', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $repeater->add_control(
      'col1title22megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'activetitle2megamenutwokaveh' => 'yes',
        ],
        'default' => esc_html__('لپ تاپ اپل', 'kaveh-core'),

      ]
    );
    $repeater->add_control(
      'col1link2megamenutwokaveh',
      [
        'label' => esc_html__('لینک', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'listcol2megamenutwokaveh',
      [
        'label' => esc_html__('لیست ستون اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'col1title2megamenutwokaveh' => esc_html__('مک بوک ۲۰۲۲', 'kaveh-core'),
            'col1title22megamenutwokaveh' => esc_html__('لپ تاپ اپل', 'kaveh-core'),
            'col1link2megamenutwokaveh' => esc_html__('#', 'kaveh-core'),
          ],
        ]
      ]

    );
    $this->add_control(
      'hrl2megamenutwokaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'imgshows2megamenutwokaveh',
      [
        'label' => esc_html__('ستون سوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
          '1' => esc_html__('تصویر تک ستونه', 'kaveh-core'),
          '2' => esc_html__('تصویر دو ستونه با دکمه', 'kaveh-core'),
          '3' => esc_html__('محصولات', 'kaveh-core'),
        ],
      ]
    );
    $this->add_control(
      'imagecol32megamenutwokaveh',
      [
        'label' => esc_html__('تصویر اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'condition' => [
          'imgshows2megamenutwokaveh' => ['1', '2'],
        ],
      ]
    );
    $this->add_control(
      'imagecol3but2megamenutwokaveh',
      [
        'label' => esc_html__('متن دکمه اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows2megamenutwokaveh' => '2',
        ],
        'default' => esc_html__('خرید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'imagecol3link2megamenutwokaveh',
      [
        'label' => esc_html__('لینک اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),
        'condition' => [
          'imgshows2megamenutwokaveh' => ['1', '2'],
        ],

      ]
    );
    $this->add_control(
      'imagecol322megamenutwokaveh',
      [
        'label' => esc_html__('تصویر دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'condition' => [
          'imgshows2megamenutwokaveh' => ['1', '2'],
        ],
      ]
    );
    $this->add_control(
      'imagecol3but22megamenutwokaveh',
      [
        'label' => esc_html__('متن دکمه دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows2megamenutwokaveh' => '2',
        ],
        'default' => esc_html__('خرید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'imagecol3link322megamenutwokaveh',
      [
        'label' => esc_html__('لینک تصویر دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),
        'condition' => [
          'imgshows2megamenutwokaveh' => ['1', '2'],
        ],

      ]
    );
    $this->add_control(
      'col4button2megamenutwokaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows2megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('دوربین ها', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4button22megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows2megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('Mountaineering and camping', 'kaveh-core'),

      ]
    );
    $taboptiongrid = array();
    $orderby = 'name';
    $order = 'asc';
    $hide_empty = false;
    $cat_args = array(
      'orderby' => $orderby,
      'order' => $order,
      'hide_empty' => $hide_empty,
    );

    foreach ($product_categories as $key => $category) {
      $taboptiongrid[$category->term_id] = $category->name;
    }
    $this->add_control(
      'cat1col42megamenutwokaveh',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => true,
        'condition' => [
          'imgshows2megamenutwokaveh' => '3',
        ],
        'options' => $taboptiongrid,
      ]
    );
    $this->add_control(
      'productnumber2megamenutwokaveh',
      [
        'label' => esc_html__('تعداد محصولات', 'kaveh-core'),
        'condition' => [
          'imgshows2megamenutwokaveh' => '3',
        ],
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 3,
        'step' => 1,
        'default' => 3,
      ]
    );
    $this->add_control(
      'col4buttontitle2megamenutwokaveh',
      [
        'label' => esc_html__('عنوان دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows2megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('برای مشاهده بیشتر', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4buttontitle22megamenutwokaveh',
      [
        'label' => esc_html__('بخش دوم عنوان دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows2megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('کلیک کنید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4buttonlink2megamenutwokaveh',
      [
        'label' => esc_html__('لینک دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows2megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'tab3megamenutwokaveh',
      [
        'label' => esc_html__('محتوای تب سوم', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tabcountmegamenutwokaveh' => ['3', '4', '5', '6'],
        ],
      ]
    );
    $this->add_control(
      'icon3megamenutwokaveh',
      [
        'label' => esc_html__('آیکون تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => ['svg'],
        'default' => [
          'value' => 'icon icon-ball',
        ],
      ]
    );
    $this->add_control(
      'title3megamenutwokaveh',
      [
        'label' => esc_html__('عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('کالای دیجیتال', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'link3megamenutwokaveh',
      [
        'label' => esc_html__('لینک عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'title23megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('گوشی موبایل', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'hrt3megamenutwokaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'col1title3megamenutwokaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('مک بوک ۲۰۲۲', 'kaveh-core'),

      ]
    );
    $repeater->add_control(
      'activetitle3megamenutwokaveh',
      [
        'label' => esc_html__('عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('فعال', 'kaveh-core'),
        'label_off' => esc_html__('غیرفعال', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $repeater->add_control(
      'col1title23megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'activetitle3megamenutwokaveh' => 'yes',
        ],
        'default' => esc_html__('لپ تاپ اپل', 'kaveh-core'),

      ]
    );
    $repeater->add_control(
      'col1link3megamenutwokaveh',
      [
        'label' => esc_html__('لینک', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'listcol3megamenutwokaveh',
      [
        'label' => esc_html__('لیست ستون اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'col1title3megamenutwokaveh' => esc_html__('مک بوک ۲۰۲۲', 'kaveh-core'),
            'col1title23megamenutwokaveh' => esc_html__('لپ تاپ اپل', 'kaveh-core'),
            'col1link3megamenutwokaveh' => esc_html__('#', 'kaveh-core'),
          ],
        ]
      ]

    );
    $this->add_control(
      'hrl3megamenutwokaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'imgshows3megamenutwokaveh',
      [
        'label' => esc_html__('ستون سوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
          '1' => esc_html__('تصویر تک ستونه', 'kaveh-core'),
          '2' => esc_html__('تصویر دو ستونه با دکمه', 'kaveh-core'),
          '3' => esc_html__('محصولات', 'kaveh-core'),
        ],
      ]
    );
    $this->add_control(
      'imagecol33megamenutwokaveh',
      [
        'label' => esc_html__('تصویر اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'condition' => [
          'imgshows3megamenutwokaveh' => ['1', '2'],
        ],
      ]
    );
    $this->add_control(
      'imagecol3but3megamenutwokaveh',
      [
        'label' => esc_html__('متن دکمه اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows3megamenutwokaveh' => '2',
        ],
        'default' => esc_html__('خرید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'imagecol3link3megamenutwokaveh',
      [
        'label' => esc_html__('لینک اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),
        'condition' => [
          'imgshows3megamenutwokaveh' => ['1', '2'],
        ],

      ]
    );
    $this->add_control(
      'imagecol323megamenutwokaveh',
      [
        'label' => esc_html__('تصویر دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'condition' => [
          'imgshows3megamenutwokaveh' => ['1', '2'],
        ],
      ]
    );
    $this->add_control(
      'imagecol3but23megamenutwokaveh',
      [
        'label' => esc_html__('متن دکمه دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows3megamenutwokaveh' => '2',
        ],
        'default' => esc_html__('خرید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'imagecol3link323megamenutwokaveh',
      [
        'label' => esc_html__('لینک تصویر دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),
        'condition' => [
          'imgshows3megamenutwokaveh' => ['1', '2'],
        ],

      ]
    );
    $this->add_control(
      'col4button3megamenutwokaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows3megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('دوربین ها', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4button23megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows3megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('Mountaineering and camping', 'kaveh-core'),

      ]
    );
    $taboptiongrid = array();
    $orderby = 'name';
    $order = 'asc';
    $hide_empty = false;
    $cat_args = array(
      'orderby' => $orderby,
      'order' => $order,
      'hide_empty' => $hide_empty,
    );

    foreach ($product_categories as $key => $category) {
      $taboptiongrid[$category->term_id] = $category->name;
    }
    $this->add_control(
      'cat1col43megamenutwokaveh',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => true,
        'condition' => [
          'imgshows3megamenutwokaveh' => '3',
        ],
        'options' => $taboptiongrid,
      ]
    );
    $this->add_control(
      'productnumber3megamenutwokaveh',
      [
        'label' => esc_html__('تعداد محصولات', 'kaveh-core'),
        'condition' => [
          'imgshows3megamenutwokaveh' => '3',
        ],
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 3,
        'step' => 1,
        'default' => 3,
      ]
    );
    $this->add_control(
      'col4buttontitle3megamenutwokaveh',
      [
        'label' => esc_html__('عنوان دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows3megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('برای مشاهده بیشتر', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4buttontitle23megamenutwokaveh',
      [
        'label' => esc_html__('بخش دوم عنوان دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows3megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('کلیک کنید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4buttonlink3megamenutwokaveh',
      [
        'label' => esc_html__('لینک دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows3megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'tab4megamenutwokaveh',
      [
        'label' => esc_html__('محتوای تب چهارم', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tabcountmegamenutwokaveh' => ['4', '5', '6'],
        ],
      ]
    );
    $this->add_control(
      'icon4megamenutwokaveh',
      [
        'label' => esc_html__('آیکون تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => ['svg'],
        'default' => [
          'value' => 'icon icon-ball',
        ],
      ]
    );
    $this->add_control(
      'title4megamenutwokaveh',
      [
        'label' => esc_html__('عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('کالای دیجیتال', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'link4megamenutwokaveh',
      [
        'label' => esc_html__('لینک عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'title24megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('گوشی موبایل', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'hrt4megamenutwokaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'col1title4megamenutwokaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('مک بوک ۲۰۲۲', 'kaveh-core'),

      ]
    );
    $repeater->add_control(
      'activetitle4megamenutwokaveh',
      [
        'label' => esc_html__('عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('فعال', 'kaveh-core'),
        'label_off' => esc_html__('غیرفعال', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $repeater->add_control(
      'col1title24megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'activetitle4megamenutwokaveh' => 'yes',
        ],
        'default' => esc_html__('لپ تاپ اپل', 'kaveh-core'),

      ]
    );
    $repeater->add_control(
      'col1link4megamenutwokaveh',
      [
        'label' => esc_html__('لینک', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'listcol4megamenutwokaveh',
      [
        'label' => esc_html__('لیست ستون اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'col1title4megamenutwokaveh' => esc_html__('مک بوک ۲۰۲۲', 'kaveh-core'),
            'col1title24megamenutwokaveh' => esc_html__('لپ تاپ اپل', 'kaveh-core'),
            'col1link4megamenutwokaveh' => esc_html__('#', 'kaveh-core'),
          ],
        ]
      ]

    );
    $this->add_control(
      'hrl4megamenutwokaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'imgshows4megamenutwokaveh',
      [
        'label' => esc_html__('ستون سوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
          '1' => esc_html__('تصویر تک ستونه', 'kaveh-core'),
          '2' => esc_html__('تصویر دو ستونه با دکمه', 'kaveh-core'),
          '3' => esc_html__('محصولات', 'kaveh-core'),
        ],
      ]
    );
    $this->add_control(
      'imagecol34megamenutwokaveh',
      [
        'label' => esc_html__('تصویر اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'condition' => [
          'imgshows4megamenutwokaveh' => ['1', '2'],
        ],
      ]
    );
    $this->add_control(
      'imagecol3but4megamenutwokaveh',
      [
        'label' => esc_html__('متن دکمه اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows4megamenutwokaveh' => '2',
        ],
        'default' => esc_html__('خرید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'imagecol3link4megamenutwokaveh',
      [
        'label' => esc_html__('لینک اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),
        'condition' => [
          'imgshows4megamenutwokaveh' => ['1', '2'],
        ],

      ]
    );
    $this->add_control(
      'imagecol324megamenutwokaveh',
      [
        'label' => esc_html__('تصویر دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'condition' => [
          'imgshows4megamenutwokaveh' => ['1', '2'],
        ],
      ]
    );
    $this->add_control(
      'imagecol3but24megamenutwokaveh',
      [
        'label' => esc_html__('متن دکمه دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows4megamenutwokaveh' => '2',
        ],
        'default' => esc_html__('خرید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'imagecol3link324megamenutwokaveh',
      [
        'label' => esc_html__('لینک تصویر دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),
        'condition' => [
          'imgshows4megamenutwokaveh' => ['1', '2'],
        ],

      ]
    );
    $this->add_control(
      'col4button4megamenutwokaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows4megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('دوربین ها', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4button24megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows4megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('Mountaineering and camping', 'kaveh-core'),

      ]
    );
    $taboptiongrid = array();
    $orderby = 'name';
    $order = 'asc';
    $hide_empty = false;
    $cat_args = array(
      'orderby' => $orderby,
      'order' => $order,
      'hide_empty' => $hide_empty,
    );

    foreach ($product_categories as $key => $category) {
      $taboptiongrid[$category->term_id] = $category->name;
    }
    $this->add_control(
      'cat1col44megamenutwokaveh',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => true,
        'condition' => [
          'imgshows4megamenutwokaveh' => '3',
        ],
        'options' => $taboptiongrid,
      ]
    );
    $this->add_control(
      'productnumber4megamenutwokaveh',
      [
        'label' => esc_html__('تعداد محصولات', 'kaveh-core'),
        'condition' => [
          'imgshows4megamenutwokaveh' => '3',
        ],
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 3,
        'step' => 1,
        'default' => 3,
      ]
    );
    $this->add_control(
      'col4buttontitle4megamenutwokaveh',
      [
        'label' => esc_html__('عنوان دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows4megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('برای مشاهده بیشتر', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4buttontitle24megamenutwokaveh',
      [
        'label' => esc_html__('بخش دوم عنوان دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows4megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('کلیک کنید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4buttonlink4megamenutwokaveh',
      [
        'label' => esc_html__('لینک دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows4megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'tab5megamenutwokaveh',
      [
        'label' => esc_html__('محتوای تب پنجم', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tabcountmegamenutwokaveh' => ['5', '6'],
        ],
      ]
    );
    $this->add_control(
      'icon5megamenutwokaveh',
      [
        'label' => esc_html__('آیکون تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => ['svg'],
        'default' => [
          'value' => 'icon icon-ball',
        ],
      ]
    );
    $this->add_control(
      'title5megamenutwokaveh',
      [
        'label' => esc_html__('عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('کالای دیجیتال', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'link5megamenutwokaveh',
      [
        'label' => esc_html__('لینک عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'title25megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('گوشی موبایل', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'hrt5megamenutwokaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'col1title5megamenutwokaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('مک بوک ۲۰۲۲', 'kaveh-core'),

      ]
    );
    $repeater->add_control(
      'activetitle5megamenutwokaveh',
      [
        'label' => esc_html__('عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('فعال', 'kaveh-core'),
        'label_off' => esc_html__('غیرفعال', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $repeater->add_control(
      'col1title25megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'activetitle5megamenutwokaveh' => 'yes',
        ],
        'default' => esc_html__('لپ تاپ اپل', 'kaveh-core'),

      ]
    );
    $repeater->add_control(
      'col1link5megamenutwokaveh',
      [
        'label' => esc_html__('لینک', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'listcol5megamenutwokaveh',
      [
        'label' => esc_html__('لیست ستون اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'col1title5megamenutwokaveh' => esc_html__('مک بوک ۲۰۲۲', 'kaveh-core'),
            'col1title25megamenutwokaveh' => esc_html__('لپ تاپ اپل', 'kaveh-core'),
            'col1link5megamenutwokaveh' => esc_html__('#', 'kaveh-core'),
          ],
        ]
      ]

    );
    $this->add_control(
      'hrl5megamenutwokaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'imgshows5megamenutwokaveh',
      [
        'label' => esc_html__('ستون سوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
          '1' => esc_html__('تصویر تک ستونه', 'kaveh-core'),
          '2' => esc_html__('تصویر دو ستونه با دکمه', 'kaveh-core'),
          '3' => esc_html__('محصولات', 'kaveh-core'),
        ],
      ]
    );
    $this->add_control(
      'imagecol35megamenutwokaveh',
      [
        'label' => esc_html__('تصویر اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'condition' => [
          'imgshows5megamenutwokaveh' => ['1', '2'],
        ],
      ]
    );
    $this->add_control(
      'imagecol3but5megamenutwokaveh',
      [
        'label' => esc_html__('متن دکمه اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows5megamenutwokaveh' => '2',
        ],
        'default' => esc_html__('خرید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'imagecol3link5megamenutwokaveh',
      [
        'label' => esc_html__('لینک اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),
        'condition' => [
          'imgshows5megamenutwokaveh' => ['1', '2'],
        ],

      ]
    );
    $this->add_control(
      'imagecol325megamenutwokaveh',
      [
        'label' => esc_html__('تصویر دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'condition' => [
          'imgshows5megamenutwokaveh' => ['1', '2'],
        ],
      ]
    );
    $this->add_control(
      'imagecol3but25megamenutwokaveh',
      [
        'label' => esc_html__('متن دکمه دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows5megamenutwokaveh' => '2',
        ],
        'default' => esc_html__('خرید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'imagecol3link325megamenutwokaveh',
      [
        'label' => esc_html__('لینک تصویر دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),
        'condition' => [
          'imgshows5megamenutwokaveh' => ['1', '2'],
        ],

      ]
    );
    $this->add_control(
      'col4button5megamenutwokaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows5megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('دوربین ها', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4button25megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows5megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('Mountaineering and camping', 'kaveh-core'),

      ]
    );
    $taboptiongrid = array();
    $orderby = 'name';
    $order = 'asc';
    $hide_empty = false;
    $cat_args = array(
      'orderby' => $orderby,
      'order' => $order,
      'hide_empty' => $hide_empty,
    );

    foreach ($product_categories as $key => $category) {
      $taboptiongrid[$category->term_id] = $category->name;
    }
    $this->add_control(
      'cat1col45megamenutwokaveh',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => true,
        'condition' => [
          'imgshows5megamenutwokaveh' => '3',
        ],
        'options' => $taboptiongrid,
      ]
    );
    $this->add_control(
      'productnumber5megamenutwokaveh',
      [
        'label' => esc_html__('تعداد محصولات', 'kaveh-core'),
        'condition' => [
          'imgshows5megamenutwokaveh' => '3',
        ],
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 3,
        'step' => 1,
        'default' => 3,
      ]
    );
    $this->add_control(
      'col4buttontitle5megamenutwokaveh',
      [
        'label' => esc_html__('عنوان دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows5megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('برای مشاهده بیشتر', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4buttontitle25megamenutwokaveh',
      [
        'label' => esc_html__('بخش دوم عنوان دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows5megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('کلیک کنید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4buttonlink5megamenutwokaveh',
      [
        'label' => esc_html__('لینک دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows5megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'tab6megamenutwokaveh',
      [
        'label' => esc_html__('محتوای تب ششم', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tabcountmegamenutwokaveh' => ['6'],
        ],
      ]
    );
    $this->add_control(
      'icon6megamenutwokaveh',
      [
        'label' => esc_html__('آیکون تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => ['svg'],
        'default' => [
          'value' => 'icon icon-ball',
        ],
      ]
    );
    $this->add_control(
      'title6megamenutwokaveh',
      [
        'label' => esc_html__('عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('کالای دیجیتال', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'link6megamenutwokaveh',
      [
        'label' => esc_html__('لینک عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'title26megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان تب', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('گوشی موبایل', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'hrt6megamenutwokaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'col1title6megamenutwokaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('مک بوک ۲۰۲۲', 'kaveh-core'),

      ]
    );
    $repeater->add_control(
      'activetitle6megamenutwokaveh',
      [
        'label' => esc_html__('عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('فعال', 'kaveh-core'),
        'label_off' => esc_html__('غیرفعال', 'kaveh-core'),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $repeater->add_control(
      'col1title26megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'activetitle6megamenutwokaveh' => 'yes',
        ],
        'default' => esc_html__('لپ تاپ اپل', 'kaveh-core'),

      ]
    );
    $repeater->add_control(
      'col1link6megamenutwokaveh',
      [
        'label' => esc_html__('لینک', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'listcol6megamenutwokaveh',
      [
        'label' => esc_html__('لیست ستون اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'col1title6megamenutwokaveh' => esc_html__('مک بوک ۲۰۲۲', 'kaveh-core'),
            'col1title26megamenutwokaveh' => esc_html__('لپ تاپ اپل', 'kaveh-core'),
            'col1link6megamenutwokaveh' => esc_html__('#', 'kaveh-core'),
          ],
        ]
      ]

    );
    $this->add_control(
      'hrl6megamenutwokaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'imgshows6megamenutwokaveh',
      [
        'label' => esc_html__('ستون سوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
          '1' => esc_html__('تصویر تک ستونه', 'kaveh-core'),
          '2' => esc_html__('تصویر دو ستونه با دکمه', 'kaveh-core'),
          '3' => esc_html__('محصولات', 'kaveh-core'),
        ],
      ]
    );
    $this->add_control(
      'imagecol36megamenutwokaveh',
      [
        'label' => esc_html__('تصویر اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'condition' => [
          'imgshows6megamenutwokaveh' => ['1', '2'],
        ],
      ]
    );
    $this->add_control(
      'imagecol3but6megamenutwokaveh',
      [
        'label' => esc_html__('متن دکمه اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows6megamenutwokaveh' => '2',
        ],
        'default' => esc_html__('خرید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'imagecol3link6megamenutwokaveh',
      [
        'label' => esc_html__('لینک اول', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),
        'condition' => [
          'imgshows6megamenutwokaveh' => ['1', '2'],
        ],

      ]
    );
    $this->add_control(
      'imagecol326megamenutwokaveh',
      [
        'label' => esc_html__('تصویر دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'condition' => [
          'imgshows6megamenutwokaveh' => ['1', '2'],
        ],
      ]
    );
    $this->add_control(
      'imagecol3but26megamenutwokaveh',
      [
        'label' => esc_html__('متن دکمه دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows6megamenutwokaveh' => '2',
        ],
        'default' => esc_html__('خرید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'imagecol3link326megamenutwokaveh',
      [
        'label' => esc_html__('لینک تصویر دوم', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('#', 'kaveh-core'),
        'condition' => [
          'imgshows6megamenutwokaveh' => ['1', '2'],
        ],

      ]
    );
    $this->add_control(
      'col4button6megamenutwokaveh',
      [
        'label' => esc_html__('عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows6megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('دوربین ها', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4button26megamenutwokaveh',
      [
        'label' => esc_html__('زیر عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows6megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('Mountaineering and camping', 'kaveh-core'),

      ]
    );
    $taboptiongrid = array();
    $orderby = 'name';
    $order = 'asc';
    $hide_empty = false;
    $cat_args = array(
      'orderby' => $orderby,
      'order' => $order,
      'hide_empty' => $hide_empty,
    );

    foreach ($product_categories as $key => $category) {
      $taboptiongrid[$category->term_id] = $category->name;
    }
    $this->add_control(
      'cat1col46megamenutwokaveh',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => true,
        'condition' => [
          'imgshows6megamenutwokaveh' => '3',
        ],
        'options' => $taboptiongrid,
      ]
    );
    $this->add_control(
      'productnumber6megamenutwokaveh',
      [
        'label' => esc_html__('تعداد محصولات', 'kaveh-core'),
        'condition' => [
          'imgshows6megamenutwokaveh' => '3',
        ],
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 3,
        'step' => 1,
        'default' => 3,
      ]
    );
    $this->add_control(
      'col4buttontitle6megamenutwokaveh',
      [
        'label' => esc_html__('عنوان دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows6megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('برای مشاهده بیشتر', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4buttontitle26megamenutwokaveh',
      [
        'label' => esc_html__('بخش دوم عنوان دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows6megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('کلیک کنید', 'kaveh-core'),

      ]
    );
    $this->add_control(
      'col4buttonlink6megamenutwokaveh',
      [
        'label' => esc_html__('لینک دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows6megamenutwokaveh' => '3',
        ],
        'default' => esc_html__('#', 'kaveh-core'),

      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style1megamenutwokaveh',
      [
        'label' => esc_html__('استایل تب ها', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'bficonsize1megamenutwokaveh',
      [
        'label' => esc_html__('سایز آیکون', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 200,
            'step' => 1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 24,
        ],
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-tabs-item i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->start_controls_tabs(
      'style_tabsmegamenutwokaveh'
    );

    $this->start_controls_tab(
      'style_normal_tabmegamenutwokaveh',
      [
        'label' => esc_html__('عادی', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'beforeic1colormegamenutwokaveh',
      [
        'label' => esc_html__('رنگ آیکون', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-tabs-item i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'iconbg1hrcolormegamenutwokaveh',
      [
        'label' => esc_html__('رنگ پس زمینه آیکون', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-tabs-item i' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'txttypomegamenutwokaveh',
        'label' => esc_html__('تایپوگرافی عنوان اصلی', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .megamenu-two-tabs-item .name span.fa',
      ]
    );
    $this->add_control(
      'text1colormegamenutwokaveh',
      [
        'label' => esc_html__('رنگ عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-tabs-item .name span.fa' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'txt2typomegamenutwokaveh',
        'label' => esc_html__('تایپوگرافی عنوان فرعی', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .megamenu-two-tabs-item .name span.en',
      ]
    );
    $this->add_control(
      'text2colormegamenutwokaveh',
      [
        'label' => esc_html__('رنگ عنوان فرعی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-tabs-item .name span.en' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hove_tabmegamenutwokaveh',
      [
        'label' => esc_html__('هاور', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'beforeic1colorhovermegamenutwokaveh',
      [
        'label' => esc_html__('رنگ آیکون', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-tabs-item.active i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .megamenu-two-tabs-item.active:hover i' => 'color: {{VALUE}}',

        ],
      ]
    );
    $this->add_control(
      'iconbg1hovercolormegamenutwokaveh',
      [
        'label' => esc_html__('رنگ پس زمینه آیکون', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-tabs-item.active i' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'txttypohovermegamenutwokaveh',
        'label' => esc_html__('تایپوگرافی عنوان اصلی', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .megamenu-two-tabs-item.active .name span.fa',
      ]
    );
    $this->add_control(
      'text1colorhovermegamenutwokaveh',
      [
        'label' => esc_html__('رنگ عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-tabs-item.active .name span.fa' => 'color: {{VALUE}}',

        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'txt2typohovermegamenutwokaveh',
        'label' => esc_html__('تایپوگرافی عنوان فرعی', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .megamenu-two-tabs-item.active .name span.en',
      ]
    );
    $this->add_control(
      'text2colorhovermegamenutwokaveh',
      [
        'label' => esc_html__('رنگ عنوان فرعی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-tabs-item.active .name span.en' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_control(
      'hr1megamenutwokaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'bgcolortabmegamenutwokaveh',
      [
        'label' => esc_html__('رنگ پس زمینه تب فعال', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-tabs-item::after' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style2megamenutwokaveh',
      [
        'label' => esc_html__('استایل محتوای تب ها', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'colmaint1megamenutwokaveh',
        'label' => esc_html__('تایپوگرافی عنوان اصلی', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .megamenu-two-content-item .title .name-fa',
      ]
    );
    $this->add_control(
      'colmaintityp1rmegamenutwokaveh',
      [
        'label' => esc_html__('رنگ عنوان اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .title .name-fa' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'colmaintsmegamenutwokaveh',
        'label' => esc_html__('تایپوگرافی عنوان فرعی', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .megamenu-two-content-item .title .name-en',
      ]
    );
    $this->add_control(
      'colmaintitypsrmegamenutwokaveh',
      [
        'label' => esc_html__('رنگ عنوان فرعی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .title .name-en' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'colmaintitypsharmegamenutwokaveh',
      [
        'label' => esc_html__('رنگ شیپ عنوان', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .title .name-fa::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'hr2megamenutwokaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'colmaint2megamenutwokaveh',
        'label' => esc_html__('تایپوگرافی زیر منوها', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .megamenu-two-content-item ul li a',
      ]
    );
    $this->add_control(
      'colmaintity2prmegamenutwokaveh',
      [
        'label' => esc_html__('رنگ زیر منوها', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item ul li a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'colmainmenuypsharmegamenutwokaveh',
      [
        'label' => esc_html__('رنگ شیپ زیرمنو', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item ul li a::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'colmaintitysprmegamenutwokaveh',
      [
        'label' => esc_html__('رنگ هاور زیر منوها', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item ul li a:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style3megamenutwokaveh',
      [
        'label' => esc_html__('استایل دکمه روی تصویر', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'imageradiushover5megamenutwokaveh',
      [
        'label' => esc_html__('گوشه خمیده تصویر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .banners-megamenu-two-item img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .megamenu-two-content-item .banners-megamenu a img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'txttypomainbut1megamenutwokaveh',
        'label' => esc_html__('تایپوگرافی متن دکمه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .megamenu-two-content-item .banners-megamenu-two-item a',
      ]
    );
    $this->start_controls_tabs(
      'style_tabs4megamenutwokaveh'
    );

    $this->start_controls_tab(
      'style_normal_tab4megamenutwokaveh',
      [
        'label' => esc_html__('عادی', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'textbuttoncolor4megamenutwokaveh',
      [
        'label' => esc_html__('رنگ نوشته دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .banners-megamenu-two-item a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttoncolor4megamenutwokaveh',
      [
        'label' => esc_html__('رنگ پس زمینه دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .banners-megamenu-two-item a' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttoniconcolor4megamenutwokaveh',
      [
        'label' => esc_html__('رنگ آیکون دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .banners-megamenu-two-item a i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonradius4megamenutwokaveh',
      [
        'label' => esc_html__('گوشه خمیده دکمه بیشتر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .banners-megamenu-two-item a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'border4megamenutwokaveh',
        'label' => esc_html__('حاشیه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .megamenu-two-content-item .banners-megamenu-two-item a',
      ]
    );
    $this->add_control(
      'buttonborders4megamenutwokaveh',
      [
        'label' => esc_html__('عرض حاشیه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'border4megamenutwokaveh!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .banners-megamenu-two-item a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hove_tab4megamenutwokaveh',
      [
        'label' => esc_html__('هاور', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'textbuttoncolorhover4megamenutwokaveh',
      [
        'label' => esc_html__('رنگ نوشته دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .banners-megamenu-two-item a:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttoncolorhover4megamenutwokaveh',
      [
        'label' => esc_html__('رنگ پس زمینه دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .banners-megamenu-two-item a:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttoniconcolorhover4megamenutwokaveh',
      [
        'label' => esc_html__('رنگ آیکون دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .banners-megamenu-two-item a:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonradiushover4megamenutwokaveh',
      [
        'label' => esc_html__('گوشه خمیده دکمه بیشتر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .banners-megamenu-two-item a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'borderhover4megamenutwokaveh',
        'label' => esc_html__('حاشیه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .megamenu-two-content-item .banners-megamenu-two-item a:hover',
      ]
    );
    $this->add_control(
      'buttonbordershover4megamenutwokaveh',
      [
        'label' => esc_html__('عرض حاشیه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'borderhover4megamenutwokaveh!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .banners-megamenu-two-item a:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_control(
      'hr4megamenutwokaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadow4megamenutwokavehh',
        'label' => esc_html__('سایه دکمه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .megamenu-two-content-item .banners-megamenu-two-item a',
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style4megamenutwokaveh',
      [
        'label' => esc_html__('استایل ستون محصولات', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'bgproduct5megamenutwokaveh',
      [
        'label' => esc_html__('رنگ پس زمینه تصویر محصولات', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .product-megamenu-two .image' => 'background-color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_control(
      'subjpro5megamenutwokaveh',
      [
        'label' => esc_html__('رنگ عنوان محصولات', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .product-megamenu-two .detail h2' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'productradiushover5megamenutwokaveh',
      [
        'label' => esc_html__('گوشه خمیده محصولات', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .product-megamenu-two .image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->add_control(
      'hr7megamenutwokaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'bgproductprice5megamenutwokaveh',
      [
        'label' => esc_html__('رنگ پس زمینه باکس قیمت', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .product-megamenu-two .detail .price' => 'background-color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_control(
      'productradiusprice5megamenutwokaveh',
      [
        'label' => esc_html__('گوشه خمیده باکس قیمت', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .product-megamenu-two .detail .price' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->add_control(
      'subjproprice25megamenutwokaveh',
      [
        'label' => esc_html__('رنگ واحد پولی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
      ]
    );
    $this->add_control(
      'subjproprice5megamenutwokaveh',
      [
        'label' => esc_html__('رنگ قیمت', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .product-megamenu-two .detail .price' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'subjproshapemegamenutwokaveh',
      [
        'label' => esc_html__('رنگ شیپ', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products::after' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'txttypomainbutmegamenutwokaveh',
        'label' => esc_html__('تایپوگرافی عنوان اصلی دکمه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more .name',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'txttyposubbutmegamenutwokaveh',
        'label' => esc_html__('تایپوگرافی عنوان فرعی دکمه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more .name span',
      ]
    );
    $this->start_controls_tabs(
      'style_tabs5megamenutwokaveh'
    );
    $this->start_controls_tab(
      'style_normal_tab5megamenutwokaveh',
      [
        'label' => esc_html__('عادی', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'text1color5megamenutwokaveh',
      [
        'label' => esc_html__('رنگ عنوان اصلی دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more .name' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'text2color5megamenutwokaveh',
      [
        'label' => esc_html__('رنگ عنوان فرعی دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more .name span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'iconbuttoncolor5megamenutwokaveh',
      [
        'label' => esc_html__('رنگ آیکون دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttoncolor5megamenutwokaveh',
      [
        'label' => esc_html__('رنگ پس زمینه دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonradius5megamenutwokaveh',
      [
        'label' => esc_html__('گوشه خمیده دکمه بیشتر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'border5megamenutwokaveh',
        'label' => esc_html__('حاشیه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more',
      ]
    );
    $this->add_control(
      'buttonborders5megamenutwokaveh',
      [
        'label' => esc_html__('عرض حاشیه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'border5megamenutwokaveh!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hove_tab5megamenutwokaveh',
      [
        'label' => esc_html__('هاور', 'kaveh-core'),
      ]
    );
    $this->add_control(
      'text1colorhover5megamenutwokaveh',
      [
        'label' => esc_html__('رنگ عنوان اصلی دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more:hover .name' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'text2colorhover5megamenutwokaveh',
      [
        'label' => esc_html__('رنگ عنوان فرعی دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more:hover .name span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'iconbuttoncolorhover5megamenutwokaveh',
      [
        'label' => esc_html__('رنگ آیکون دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttoncolorhover5megamenutwokaveh',
      [
        'label' => esc_html__('رنگ پس زمینه دکمه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonradiushover5megamenutwokaveh',
      [
        'label' => esc_html__('گوشه خمیده دکمه بیشتر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'borderhover5megamenutwokaveh',
        'label' => esc_html__('حاشیه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more:hover',
      ]
    );
    $this->add_control(
      'buttonbordershover5megamenutwokaveh',
      [
        'label' => esc_html__('عرض حاشیه', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'condition' => [
          'borderhover5megamenutwokaveh!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_control(
      'hr5megamenutwokaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );

    $this->add_control(
      'bficonsize5megamenutwokaveh',
      [
        'label' => esc_html__('سایز آیکون بعد از نوشته', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 200,
            'step' => 1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 10,
        ],
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadow5megamenutwokaveh',
        'label' => esc_html__('سایه دکمه', 'kaveh-core'),
        'selector' => '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more',
      ]
    );
    $this->add_control(
      'buttonpadding15megamenutwokaveh',
      [
        'label' => esc_html__('فاصله داخلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products .heading .show-more' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style5megamenutwokaveh',
      [
        'label' => esc_html__('استایل عمومی مگامنو', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'bgmegamenucolor5megamenutwokaveh',
      [
        'label' => esc_html__('رنگ پس زمینه مگامنو', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-two' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .megamenu-two-tabs-item::after' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .megamenu-two-content-item .megamenu-products::after' => 'background-color: {{VALUE}}',

        ],
      ]
    );
    $this->add_control(
      'megamenuradiushover5megamenutwokaveh',
      [
        'label' => esc_html__('گوشه خمیده تصویر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} .megamenu-two' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }



  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();

    ?>
    <div class="megamenu-two position-absolute w-100 start-0 top-100">
      <div class="megamenu-two-tabs w-100 position-relative">
        <?php $tabco = (int) $settings['tabcountmegamenutwokaveh']; ?>
        <?php
        for ($a = 1; $a <= $tabco; $a++) {
          ?>
          <div class="megamenu-two-tabs-item d-flex align-items-center position-relative <?php if ($a == 1) { ?>active<?php } ?>"
            data-target="megamenu-2<?php echo $a . $clsid; ?>">
            <i
              class="<?php echo esc_attr($settings['icon' . $a . 'megamenutwokaveh']['value']); ?> d-flex align-items-center justify-content-center position-relative"></i>
            <div class="name">
              <a href="<?php echo esc_html($settings['link' . $a . 'megamenutwokaveh']); ?>"><span
                  class="fa d-block"><?php echo esc_html($settings['title' . $a . 'megamenutwokaveh']); ?></span>
                <span class="en d-block"><?php echo esc_html($settings['title2' . $a . 'megamenutwokaveh']); ?></span></a>
            </div>
          </div>
        <?php } ?>
      </div>
      <div class="megamenu-two-content w-100">
        <?php $tabco = $settings['tabcountmegamenutwokaveh']; ?>
        <?php $a = 1;
        for ($a = 1; $a <= $tabco; $a++) { ?>
          <div id="megamenu-2<?php echo $a . $clsid; ?>"
            class="megamenu-two-content-item align-items-center <?php if ($a == 1) { ?>active<?php } ?>">
            <ul class="d-flex flex-column flex-wrap">
              <?php
              if ($settings['listcol' . $a . 'megamenutwokaveh']) {
                foreach ($settings['listcol' . $a . 'megamenutwokaveh'] as $item) {
                  ?>
                  <?php if ("yes" === $item['activetitle' . $a . 'megamenutwokaveh']) { ?>

                    <li class="title">
                      <a href="<?php echo esc_html($item['col1link' . $a . 'megamenutwokaveh']); ?>">
                      <span
                        class="name-fa d-block position-relative"><?php echo esc_html($item['col1title' . $a . 'megamenutwokaveh']); ?></span>
                      <span class="name-en d-block"><?php echo esc_html($item['col1title2' . $a . 'megamenutwokaveh']); ?></span>
                      </a>
                    </li>
                  <?php } else { ?>
                    <li>
                      <a href="<?php echo esc_html($item['col1link' . $a . 'megamenutwokaveh']); ?>" class="d-block position-relative">
                        <?php echo esc_html($item['col1title' . $a . 'megamenutwokaveh']); ?></a>
                    </li>
                  <?php } ?>
                  <?php
                }
              }
              ?>
            </ul>
            <?php if ("1" === $settings['imgshows' . $a . 'megamenutwokaveh']) { ?>
              <?php if (!empty($settings['imagecol3' . $a . 'megamenutwokaveh']['url'])): ?>
                <div class="banners-megamenu d-flex flex-column w-100">
                  <a href="<?php echo esc_url($settings['imagecol3link' . $a . 'megamenutwokaveh']); ?>">
                    <img src="<?php echo esc_url($settings['imagecol3' . $a . 'megamenutwokaveh']['url']); ?>"
                      alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt($settings['imagecol3' . $a . 'megamenutwokaveh'])); ?>"
                      class="d-block w-100" />
                  </a>
                  <a href="<?php echo esc_url($settings['imagecol3link32' . $a . 'megamenutwokaveh']); ?>">
                    <img src="<?php echo esc_url($settings['imagecol32' . $a . 'megamenutwokaveh']['url']); ?>"
                      alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt($settings['imagecol32' . $a . 'megamenutwokaveh'])); ?>"
                      class="d-block w-100" />
                  </a>
                </div>
              <?php endif; ?>
            <?php } elseif ("2" === $settings['imgshows' . $a . 'megamenutwokaveh']) { ?>
              <?php if (!empty($settings['imagecol3' . $a . 'megamenutwokaveh']['url'])): ?>

                <div class="banners-megamenu banners-megamenu-two d-flex align-items-center w-100">
                  <div class="banners-megamenu-two-item position-relative">
                    <img src="<?php echo esc_url($settings['imagecol3' . $a . 'megamenutwokaveh']['url']); ?>"
                      alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt($settings['imagecol3' . $a . 'megamenutwokaveh'])); ?>"
                      class="w-100 d-block" />
                    <a href="<?php echo esc_url($settings['imagecol3link' . $a . 'megamenutwokaveh']); ?>" class="position-absolute">
                      <?php echo esc_html($settings['imagecol3but' . $a . 'megamenutwokaveh']); ?>
                      <i class="icon-arrow-left-3"></i>
                    </a>
                  </div>
                  <div class="banners-megamenu-two-item position-relative">
                    <img src="<?php echo esc_url($settings['imagecol32' . $a . 'megamenutwokaveh']['url']); ?>"
                      alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt($settings['imagecol32' . $a . 'megamenutwokaveh'])); ?>"
                      class="w-100 d-block" />
                    <a href="<?php echo esc_url($settings['imagecol3link32' . $a . 'megamenutwokaveh']); ?>"
                      class="position-absolute">
                      <?php echo esc_html($settings['imagecol3but2' . $a . 'megamenutwokaveh']); ?>
                      <i class="icon-arrow-left-3"></i>
                    </a>
                  </div>
                </div>
              <?php endif; ?>

            <?php } elseif ("3" === $settings['imgshows' . $a . 'megamenutwokaveh']) { ?>
              <div class="megamenu-products w-100 position-relative">
                <div class="heading d-flex align-items-center justify-content-between">
                  <div class="title">
                    <span class="name-fa d-block position-relative">
                      <?php echo esc_html($settings['col4button' . $a . 'megamenutwokaveh']); ?></span>
                    <span
                      class="name-en d-block"><?php echo esc_html($settings['col4button2' . $a . 'megamenutwokaveh']); ?></span>
                  </div>
                  <div class="show-more position-relative d-flex align-items-center">
                    <a href="<?php echo esc_url($settings['col4buttonlink' . $a . 'megamenutwokaveh']); ?>"
                      class="stretched-link"></a>
                    <div class="name">
                      <?php echo esc_html($settings['col4buttontitle' . $a . 'megamenutwokaveh']); ?>
                      <span class="d-block fw-normal">
                        <?php echo esc_html($settings['col4buttontitle2' . $a . 'megamenutwokaveh']); ?></span>
                    </div>
                    <i class="icon-arrow-left-2"></i>
                  </div>
                </div>
                <?php
                // Define your custom query arguments
                $query_args = array(
                  'post_type' => array('product'),
'post_status' => array('publish'),
                  'posts_per_page' => $settings['productnumber' . $a . 'megamenutwokaveh'],
                  'order' => 'desc',
                  'orderby' => 'date',
                  'tax_query' => array(
                  array(
                      'taxonomy' => 'product_cat',
                      'field'    => 'term_id',
                      'terms'    =>  $settings['cat1col4' . $a . 'megamenutwokaveh'],
                      ),
                  ),
                );
                // Get the cached query results
                $cached_query = KavehCustomQuery::get_cached_query($query_args);
                if ($cached_query->have_posts()) :
                    while ($cached_query->have_posts()) : $cached_query->the_post();
                    $post_id = get_the_ID();
                    $product = wc_get_product($post_id);
                    ?>
                    <div class="product-megamenu-two d-flex">
                      <div class="image d-flex align-items-center justify-content-center">
                        <img src="<?php if(get_the_post_thumbnail_url()): ?>
                        <?php the_post_thumbnail_url('full'); ?>
                        <?php else: ?>
                        <?php echo wc_placeholder_img_src(); ?>
                        <?php endif; ?>"
                          alt="<?php the_title(); ?>" />
                      </div>
                      <div class="detail d-flex flex-column">
                        <h2 class="text-truncate">
                          <a href="<?php the_permalink(); ?>"><?php
                             echo wp_trim_words(get_the_title(), 5); ?></a>
                        </h2>
                        <div class="price mt-auto">
                          <span class="d-block"> <?php echo get_woocommerce_currency_symbol(); ?> </span>
                          <?php
                          if ($product->is_type('variable')) {
                            echo $product->get_variation_regular_price('min');
                          } else {
                            echo $product->get_regular_price();
                          }
                          ?>
                          <i class="icon-arrow-left"></i>
                        </div>
                      </div>
                    </div>
                    <?php
                    endwhile;
                    wp_reset_postdata();
                else :
                    echo 'No posts found.';
                endif;
                ?>

              </div>
            <?php } ?>
          </div>
        <?php } ?>
      </div>
    </div>
    <?php if (\Elementor\Plugin::$instance->editor->is_edit_mode()): ?>
      <style>
        .megamenu-two {
          transform: unset !important;
          z-index: 99 !important;
        }

        .megamenu {
          transform: unset !important;
          z-index: 99 !important;
        }
      </style>
      <script>
        // Megamenu
        const tabsMegamenu = document.querySelectorAll(
          ".megamenu-tabs span, .megamenu-two-tabs-item"
        );

        if (tabsMegamenu.length > 0) {
          tabsMegamenu.forEach((tab) => {
            tab.addEventListener("mouseover", (ev) => {
              const el = ev.currentTarget,
                id = el.dataset.target,
                content = document.getElementById(id);

              if (content) {
                [...el.parentElement.children].map((tabItems) => {
                  const id = tabItems.dataset.target;

                  tabItems.classList.remove("active");
                  document.getElementById(id).classList.remove("active");
                });

                el.classList.add("active");
                content.classList.add("active");

                content.style.opacity = 0;

                setTimeout(() => {
                  content.style.opacity = 1;
                  content.removeAttribute("style");
                }, 50);
              }
            });
          });
        }
      </script>
    <?php endif; ?>
    <style>
      .megamenu-two-content-item .megamenu-products .product-megamenu-two .detail .price>span {
        background: -webkit-linear-gradient(top,
            <?php echo esc_html($settings['subjproprice25megamenutwokaveh']); ?>
            0%, rgba(116, 116, 116, 0) 100%);
        background: -moz-linear-gradient(top,
            <?php echo esc_html($settings['subjproprice25megamenutwokaveh']); ?>
            0%, rgba(116, 116, 116, 0) 100%);
        background: -o-linear-gradient(top,
            <?php echo esc_html($settings['subjproprice25megamenutwokaveh']); ?>
            0%, rgba(116, 116, 116, 0) 100%);
        background: linear-gradient(180deg,
            <?php echo esc_html($settings['subjproprice25megamenutwokaveh']); ?>
            0%, rgba(116, 116, 116, 0) 100%);
        -webkit-text-fill-color: transparent;
        -webkit-background-clip: text;
        -moz-background-clip: text;
        -o-background-clip: text;
        background-clip: text;
      }
    </style>
    <?php
  }


}
