<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Megamenuthreekaveh extends Widget_Base{
 
  public function get_name(){
    return 'megamenuthreekaveh';
  }

  public function get_title(){
    return esc_html__( 'المان مگا منو طرح سوم', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['megamenufooterkavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'content1megamenuthreekaveh',
        [
          'label' => esc_html__( 'تعداد تب', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'tabcountmegamenuthreekaveh',
        [
          'label' => esc_html__( 'تعداد ستون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => '4',
          'options' => [
            '1'  => esc_html__( '1', 'kaveh-core' ),
            '2' => esc_html__( '2', 'kaveh-core' ),
            '3' => esc_html__( '3', 'kaveh-core' ),
            '4' => esc_html__( '4', 'kaveh-core' ),
            '5' => esc_html__( '5', 'kaveh-core' ),
            '6' => esc_html__( '6', 'kaveh-core' ),
            '7' => esc_html__( '7', 'kaveh-core' ),
            '8' => esc_html__( '8', 'kaveh-core' ),
            '9' => esc_html__( '9', 'kaveh-core' ),
            '10' => esc_html__( '10', 'kaveh-core' ),
            '11' => esc_html__( '11', 'kaveh-core' ),
            '12' => esc_html__( '12', 'kaveh-core' ),

          ],
        ]
      );

        $this->end_controls_section();

        $this->start_controls_section(
          'tab1megamenuthreekaveh',
          [
            'label' => esc_html__( 'محتوای تب اول', 'kaveh-core' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
          ]
        );
        $this->add_control(
          'icon1megamenuthreekaveh',
          [
            'label' => esc_html__( 'آیکون تب', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::ICONS,
            'skin' => 'inline',
            'exclude_inline_options' => [ 'svg' ],
            'default' => [
              'value' => 'icon-printer',
            ],
          ]
        ); 
        $this->add_control(
          'boldtitle1megamenuthreekaveh',
          [
              'label' => esc_html__( 'عنوان بولد تب', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'تجهیزات', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'title1megamenuthreekaveh',
        [
            'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'دوربین', 'kaveh-core' ),
    
        ]
    );
      $this->add_control(
        'title21megamenuthreekaveh',
        [
            'label' => esc_html__( 'زیر عنوان تب', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'iconm1megamenuthreekaveh',
      [
        'label' => esc_html__( 'آیکون محتوای تب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-printer',
        ],
      ]
    ); 
    $this->add_control(
      'boldtitlem1megamenuthreekaveh',
      [
          'label' => esc_html__( 'عنوان بولد محتوای تب', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'titlem1megamenuthreekaveh',
    [
        'label' => esc_html__( 'عنوان محتوای تب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

    ]
);
  $this->add_control(
    'titlem21megamenuthreekaveh',
    [
        'label' => esc_html__( 'زیر عنوان محتوای تب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

    ]
);
$this->add_control(
  'titlemlink21megamenuthreekaveh',
  [
      'label' => esc_html__( 'لینک عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( '#', 'kaveh-core' ),

  ]
);
      $this->add_control(
        'hrt1megamenuthreekaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
    $repeater = new \Elementor\Repeater(); 
      $repeater->add_control(
        'col1title1megamenuthreekaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'col1activetitle1megamenuthreekaveh',
      [
        'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
        'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $repeater->add_control(
      'col1title21megamenuthreekaveh',
      [
          'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'col1activetitle1megamenuthreekaveh!' => 'yes',
          ],
          'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
  
      ]
  );
    $repeater->add_control(
      'col1link1megamenuthreekaveh',
      [
          'label' => esc_html__( 'لینک', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
    $this->add_control(
      'listcol1megamenuthreekaveh',
      [
        'label' => esc_html__( 'لیست ستون اول', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'col1title1megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
            'col1title21megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
            'col1link1megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
    $repeater = new \Elementor\Repeater(); 
    $repeater->add_control(
      'col2title1megamenuthreekaveh',
      [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'col2activetitle1megamenuthreekaveh',
    [
      'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
      'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
      'return_value' => 'yes',
      'default' => 'no',
    ]
  );
  $repeater->add_control(
    'col2title21megamenuthreekaveh',
    [
        'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'col2activetitle1megamenuthreekaveh!' => 'yes',
        ],
        'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

    ]
);
  $repeater->add_control(
    'col2link1megamenuthreekaveh',
    [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
  $this->add_control(
    'listcol21megamenuthreekaveh',
    [
      'label' => esc_html__( 'لیست ستون دوم', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::REPEATER,
      'fields' => $repeater->get_controls(),
      'default' => [
        [
          'col2title1megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
          'col2title21megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
          'col2link1megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
        ],
    ]
    ]
  
  );
  $repeater = new \Elementor\Repeater(); 
  $repeater->add_control(
    'col3title1megamenuthreekaveh',
    [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

    ]
);
$repeater->add_control(
  'col3activetitle1megamenuthreekaveh',
  [
    'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
    'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'no',
  ]
);
$repeater->add_control(
  'col3title21megamenuthreekaveh',
  [
      'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'condition' => [
        'col3activetitle1megamenuthreekaveh!' => 'yes',
      ],
      'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

  ]
);
$repeater->add_control(
  'col3link1megamenuthreekaveh',
  [
      'label' => esc_html__( 'لینک', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( '#', 'kaveh-core' ),

  ]
);
$this->add_control(
  'listcol31megamenuthreekaveh',
  [
    'label' => esc_html__( 'لیست ستون سوم', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::REPEATER,
    'fields' => $repeater->get_controls(),
    'default' => [
      [
        'col3title1megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
        'col3title21megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
        'col3link1megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
      ],
  ]
  ]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
  'col4title1megamenuthreekaveh',
  [
      'label' => esc_html__( 'عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

  ]
);
$repeater->add_control(
'col4activetitle1megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::SWITCHER,
  'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
  'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
  'return_value' => 'yes',
  'default' => 'no',
]
);
$repeater->add_control(
'col4title21megamenuthreekaveh',
[
    'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'col4activetitle1megamenuthreekaveh!' => 'yes',
    ],
    'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4link1megamenuthreekaveh',
[
    'label' => esc_html__( 'لینک', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol41megamenuthreekaveh',
[
  'label' => esc_html__( 'لیست ستون چهارم', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::REPEATER,
  'fields' => $repeater->get_controls(),
  'default' => [
    [
      'col4title1megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
      'col4title21megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
      'col4link1megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
    ],
]
]

);
    $this->add_control(
      'hrl1megamenuthreekaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'imgshows1megamenuthreekaveh',
      [
        'label' => esc_html__( 'ستون پنجم', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
          '1'  => esc_html__( 'لیست دسته بندی ها', 'kaveh-core' ),
          '2' => esc_html__( 'لیست محصولات سبک یک', 'kaveh-core' ),
          '3' => esc_html__( 'لیست محصولات سبک دو', 'kaveh-core' ),
          '4' => esc_html__( 'لیست محصولات سبک سه', 'kaveh-core' ),

        ],
      ]
    );
    $repeater = new \Elementor\Repeater(); 
      $repeater->add_control(
        'col5title1megamenuthreekaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'col5activetitle1megamenuthreekaveh',
      [
        'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
        'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $repeater->add_control(
      'col5title21megamenuthreekaveh',
      [
          'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'col5activetitle1megamenuthreekaveh!' => 'yes',
          ],
          'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
  
      ]
  );
    $repeater->add_control(
      'col5link1megamenuthreekaveh',
      [
          'label' => esc_html__( 'لینک', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
    $this->add_control(
      'listcol51megamenuthreekaveh',
      [
        'label' => esc_html__( 'لیست ستون پنجم', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'condition' => [
              'imgshows1megamenuthreekaveh' => '1',
            ],
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'col5title1megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
            'col5title21megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
            'col5link1megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );

    $this->add_control(
      'icond1megamenuthreekaveh',
      [
        'label' => esc_html__( 'آیکون عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'condition' => [
          'imgshows1megamenuthreekaveh' => ['3','2','4'],
        ],
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-folder-2',
        ],
      ]
    ); 
      $this->add_control(
        'boldtitled1megamenuthreekaveh',
        [
            'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'imgshows1megamenuthreekaveh' => ['3','2','4'],
            ],
            'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'titled1megamenuthreekaveh',
      [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'imgshows1megamenuthreekaveh' => ['3','2','4'],
          ],
          'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

      ]
  );
    $this->add_control(
      'titled21megamenuthreekaveh',
      [
          'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'imgshows1megamenuthreekaveh' => ['3','2','4'],
          ],
          'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

      ]
  );
  $this->add_control(
    'linktitlecol51megamenuthreekaveh',
    [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows1megamenuthreekaveh' => ['3','2','4'],
        ],
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
$taboptiongrid = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);
$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $taboptiongrid[$category->term_id] = $category->name;
}
$this->add_control(
    'cat1col41megamenuthreekaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'condition' => [
        'imgshows1megamenuthreekaveh' => ['3','2','4'],
      ],
      'options' => $taboptiongrid,
    ]
);
$this->add_control(
  'productnumber1megamenuthreekaveh',
  [
    'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
    'condition' => [
      'imgshows1megamenuthreekaveh' => ['3','2','4'],
    ],
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 4,
    'step' => 1,
    'default' => 4,
  ]
);
$this->add_control(
  'productboxbg1megamenuthreekaveh',
  [
    'label' => esc_html__( 'تصویر پس زمینه باکس', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'selectors' => [
      '{{WRAPPER}} .megamenu-three .last-products-three .last-products-box' => 'background: url({{URL}}) center center no-repeat',
  ],   
    'condition' => [
      'imgshows1megamenuthreekaveh' => ['4'],
    ],
  ]
);
$this->add_control(
  'iconcol51megamenuthreekaveh',
  [
    'label' => esc_html__( 'آیکون دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::ICONS,
    'skin' => 'inline',
    'condition' => [
      'imgshows1megamenuthreekaveh' => ['3','2','4'],
    ],
    'exclude_inline_options' => [ 'svg' ],
    'default' => [
      'value' => 'icon icon-ball',
    ],
  ]
); 
$this->add_control(
  'col5buttontitle1megamenuthreekaveh',
  [
      'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'condition' => [
        'imgshows1megamenuthreekaveh' => ['3','2','4'],
      ],
      'default' => esc_html__( 'برای مشاهده بیشتر', 'kaveh-core' ),

  ]
);
$this->add_control(
'col5buttonlink1megamenuthreekaveh',
[
    'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'imgshows1megamenuthreekaveh' => ['3','2','4'],
    ],
    'default' => esc_html__( '#', 'kaveh-core' ),

]
);

        $this->end_controls_section();
        $this->start_controls_section(
          'tab2megamenuthreekaveh',
          [
            'label' => esc_html__( 'محتوای تب دوم', 'kaveh-core' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'condition' => [
                      'tabcountmegamenuthreekaveh!' => '1',
    ],
          ]
        );
        $this->add_control(
          'icon2megamenuthreekaveh',
          [
            'label' => esc_html__( 'آیکون تب', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::ICONS,
            'skin' => 'inline',
            'exclude_inline_options' => [ 'svg' ],
            'default' => [
              'value' => 'icon-printer',
            ],
          ]
        ); 
        $this->add_control(
          'boldtitle2megamenuthreekaveh',
          [
              'label' => esc_html__( 'عنوان بولد تب', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'تجهیزات', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'title2megamenuthreekaveh',
        [
            'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'دوربین', 'kaveh-core' ),
    
        ]
    );
      $this->add_control(
        'title22megamenuthreekaveh',
        [
            'label' => esc_html__( 'زیر عنوان تب', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'iconm2megamenuthreekaveh',
      [
        'label' => esc_html__( 'آیکون محتوای تب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-printer',
        ],
      ]
    ); 
    $this->add_control(
      'boldtitlem2megamenuthreekaveh',
      [
          'label' => esc_html__( 'عنوان بولد محتوای تب', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'titlem2megamenuthreekaveh',
    [
        'label' => esc_html__( 'عنوان محتوای تب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

    ]
);
  $this->add_control(
    'titlem22megamenuthreekaveh',
    [
        'label' => esc_html__( 'زیر عنوان محتوای تب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

    ]
);
$this->add_control(
  'titlemlink22megamenuthreekaveh',
  [
      'label' => esc_html__( 'لینک عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( '#', 'kaveh-core' ),

  ]
);
      $this->add_control(
        'hrt2megamenuthreekaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
    $repeater = new \Elementor\Repeater(); 
      $repeater->add_control(
        'col1title2megamenuthreekaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'col1activetitle2megamenuthreekaveh',
      [
        'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
        'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $repeater->add_control(
      'col1title22megamenuthreekaveh',
      [
          'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'col1activetitle2megamenuthreekaveh!' => 'yes',
          ],
          'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
  
      ]
  );
    $repeater->add_control(
      'col1link2megamenuthreekaveh',
      [
          'label' => esc_html__( 'لینک', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
    $this->add_control(
      'listcol2megamenuthreekaveh',
      [
        'label' => esc_html__( 'لیست ستون اول', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'col1title2megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
            'col1title22megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
            'col1link2megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
    $repeater = new \Elementor\Repeater(); 
    $repeater->add_control(
      'col2title2megamenuthreekaveh',
      [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'col2activetitle2megamenuthreekaveh',
    [
      'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
      'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
      'return_value' => 'yes',
      'default' => 'no',
    ]
  );
  $repeater->add_control(
    'col2title22megamenuthreekaveh',
    [
        'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'col2activetitle2megamenuthreekaveh!' => 'yes',
        ],
        'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

    ]
);
  $repeater->add_control(
    'col2link2megamenuthreekaveh',
    [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
  $this->add_control(
    'listcol22megamenuthreekaveh',
    [
      'label' => esc_html__( 'لیست ستون دوم', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::REPEATER,
      'fields' => $repeater->get_controls(),
      'default' => [
        [
          'col2title2megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
          'col2title22megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
          'col2link2megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
        ],
    ]
    ]
  
  );
  $repeater = new \Elementor\Repeater(); 
  $repeater->add_control(
    'col3title2megamenuthreekaveh',
    [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

    ]
);
$repeater->add_control(
  'col3activetitle2megamenuthreekaveh',
  [
    'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
    'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'no',
  ]
);
$repeater->add_control(
  'col3title22megamenuthreekaveh',
  [
      'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'condition' => [
        'col3activetitle2megamenuthreekaveh!' => 'yes',
      ],
      'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

  ]
);
$repeater->add_control(
  'col3link2megamenuthreekaveh',
  [
      'label' => esc_html__( 'لینک', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( '#', 'kaveh-core' ),

  ]
);
$this->add_control(
  'listcol32megamenuthreekaveh',
  [
    'label' => esc_html__( 'لیست ستون سوم', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::REPEATER,
    'fields' => $repeater->get_controls(),
    'default' => [
      [
        'col3title2megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
        'col3title22megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
        'col3link2megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
      ],
  ]
  ]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
  'col4title2megamenuthreekaveh',
  [
      'label' => esc_html__( 'عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

  ]
);
$repeater->add_control(
'col4activetitle2megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::SWITCHER,
  'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
  'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
  'return_value' => 'yes',
  'default' => 'no',
]
);
$repeater->add_control(
'col4title22megamenuthreekaveh',
[
    'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'col4activetitle2megamenuthreekaveh!' => 'yes',
    ],
    'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4link2megamenuthreekaveh',
[
    'label' => esc_html__( 'لینک', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol42megamenuthreekaveh',
[
  'label' => esc_html__( 'لیست ستون چهارم', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::REPEATER,
  'fields' => $repeater->get_controls(),
  'default' => [
    [
      'col4title2megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
      'col4title22megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
      'col4link2megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
    ],
]
]

);
    $this->add_control(
      'hrl2megamenuthreekaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'imgshows2megamenuthreekaveh',
      [
        'label' => esc_html__( 'ستون پنجم', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
          '1'  => esc_html__( 'لیست دسته بندی ها', 'kaveh-core' ),
          '2' => esc_html__( 'لیست محصولات سبک یک', 'kaveh-core' ),
          '3' => esc_html__( 'لیست محصولات سبک دو', 'kaveh-core' ),
          '4' => esc_html__( 'لیست محصولات سبک سه', 'kaveh-core' ),

        ],
      ]
    );
    $repeater = new \Elementor\Repeater(); 
      $repeater->add_control(
        'col5title2megamenuthreekaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'col5activetitle2megamenuthreekaveh',
      [
        'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
        'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $repeater->add_control(
      'col5title22megamenuthreekaveh',
      [
          'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'col5activetitle2megamenuthreekaveh!' => 'yes',
          ],
          'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
  
      ]
  );
    $repeater->add_control(
      'col5link2megamenuthreekaveh',
      [
          'label' => esc_html__( 'لینک', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
    $this->add_control(
      'listcol52megamenuthreekaveh',
      [
        'label' => esc_html__( 'لیست ستون پنجم', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'condition' => [
              'imgshows2megamenuthreekaveh' => '1',
            ],
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'col5title2megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
            'col5title22megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
            'col5link2megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );

    $this->add_control(
      'icond2megamenuthreekaveh',
      [
        'label' => esc_html__( 'آیکون عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'condition' => [
          'imgshows2megamenuthreekaveh' => ['3','2','4'],
        ],
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-folder-2',
        ],
      ]
    ); 
      $this->add_control(
        'boldtitled2megamenuthreekaveh',
        [
            'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'imgshows2megamenuthreekaveh' => ['3','2','4'],
            ],
            'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'titled2megamenuthreekaveh',
      [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'imgshows2megamenuthreekaveh' => ['3','2','4'],
          ],
          'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

      ]
  );
    $this->add_control(
      'titled22megamenuthreekaveh',
      [
          'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'imgshows2megamenuthreekaveh' => ['3','2','4'],
          ],
          'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

      ]
  );
  $this->add_control(
    'linktitlecol52megamenuthreekaveh',
    [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows2megamenuthreekaveh' => ['3','2','4'],
        ],
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
$taboptiongrid = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

foreach ( $product_categories as $key => $category ) {
    $taboptiongrid[$category->term_id] = $category->name;
}
$this->add_control(
    'cat1col42megamenuthreekaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'condition' => [
        'imgshows2megamenuthreekaveh' => ['3','2','4'],
      ],
      'options' => $taboptiongrid,
    ]
);
$this->add_control(
  'productnumber2megamenuthreekaveh',
  [
    'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
    'condition' => [
      'imgshows2megamenuthreekaveh' => ['3','2','4'],
    ],
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 4,
    'step' => 1,
    'default' => 4,
  ]
);
$this->add_control(
  'productboxbg2megamenuthreekaveh',
  [
    'label' => esc_html__( 'تصویر پس زمینه باکس', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'selectors' => [
      '{{WRAPPER}} .megamenu-three .last-products-three .last-products-box' => 'background: url({{URL}}) center center no-repeat',
  ],   
    'condition' => [
      'imgshows2megamenuthreekaveh' => ['4'],
    ],
  ]
);
$this->add_control(
  'iconcol52megamenuthreekaveh',
  [
    'label' => esc_html__( 'آیکون دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::ICONS,
    'skin' => 'inline',
    'condition' => [
      'imgshows2megamenuthreekaveh' => ['3','2','4'],
    ],
    'exclude_inline_options' => [ 'svg' ],
    'default' => [
      'value' => 'icon icon-ball',
    ],
  ]
); 
$this->add_control(
  'col5buttontitle2megamenuthreekaveh',
  [
      'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'condition' => [
        'imgshows2megamenuthreekaveh' => ['3','2','4'],
      ],
      'default' => esc_html__( 'برای مشاهده بیشتر', 'kaveh-core' ),

  ]
);
$this->add_control(
'col5buttonlink2megamenuthreekaveh',
[
    'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'imgshows2megamenuthreekaveh' => ['3','2','4'],
    ],
    'default' => esc_html__( '#', 'kaveh-core' ),

]
);

 $this->end_controls_section();
        $this->start_controls_section(
          'tab3megamenuthreekaveh',
          [
            'label' => esc_html__( 'محتوای تب سوم', 'kaveh-core' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'condition' => [
                      'tabcountmegamenuthreekaveh!' => ['1','2'],
    ],
          ]
        );
        $this->add_control(
          'icon3megamenuthreekaveh',
          [
            'label' => esc_html__( 'آیکون تب', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::ICONS,
            'skin' => 'inline',
            'exclude_inline_options' => [ 'svg' ],
            'default' => [
              'value' => 'icon-printer',
            ],
          ]
        ); 
        $this->add_control(
          'boldtitle3megamenuthreekaveh',
          [
              'label' => esc_html__( 'عنوان بولد تب', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'تجهیزات', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'title3megamenuthreekaveh',
        [
            'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'دوربین', 'kaveh-core' ),
    
        ]
    );
      $this->add_control(
        'title23megamenuthreekaveh',
        [
            'label' => esc_html__( 'زیر عنوان تب', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'iconm3megamenuthreekaveh',
      [
        'label' => esc_html__( 'آیکون محتوای تب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-printer',
        ],
      ]
    ); 
    $this->add_control(
      'boldtitlem3megamenuthreekaveh',
      [
          'label' => esc_html__( 'عنوان بولد محتوای تب', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'titlem3megamenuthreekaveh',
    [
        'label' => esc_html__( 'عنوان محتوای تب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

    ]
);
  $this->add_control(
    'titlem23megamenuthreekaveh',
    [
        'label' => esc_html__( 'زیر عنوان محتوای تب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

    ]
);
$this->add_control(
  'titlemlink23megamenuthreekaveh',
  [
      'label' => esc_html__( 'لینک عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( '#', 'kaveh-core' ),

  ]
);
      $this->add_control(
        'hrt3megamenuthreekaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
    $repeater = new \Elementor\Repeater(); 
      $repeater->add_control(
        'col1title3megamenuthreekaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'col1activetitle3megamenuthreekaveh',
      [
        'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
        'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $repeater->add_control(
      'col1title23megamenuthreekaveh',
      [
          'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'col1activetitle3megamenuthreekaveh!' => 'yes',
          ],
          'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
  
      ]
  );
    $repeater->add_control(
      'col1link3megamenuthreekaveh',
      [
          'label' => esc_html__( 'لینک', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
    $this->add_control(
      'listcol3megamenuthreekaveh',
      [
        'label' => esc_html__( 'لیست ستون اول', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'col1title3megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
            'col1title23megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
            'col1link3megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
    $repeater = new \Elementor\Repeater(); 
    $repeater->add_control(
      'col2title3megamenuthreekaveh',
      [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'col2activetitle3megamenuthreekaveh',
    [
      'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
      'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
      'return_value' => 'yes',
      'default' => 'no',
    ]
  );
  $repeater->add_control(
    'col2title23megamenuthreekaveh',
    [
        'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'col2activetitle3megamenuthreekaveh!' => 'yes',
        ],
        'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

    ]
);
  $repeater->add_control(
    'col2link3megamenuthreekaveh',
    [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
  $this->add_control(
    'listcol23megamenuthreekaveh',
    [
      'label' => esc_html__( 'لیست ستون دوم', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::REPEATER,
      'fields' => $repeater->get_controls(),
      'default' => [
        [
          'col2title3megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
          'col2title23megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
          'col2link3megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
        ],
    ]
    ]
  
  );
  $repeater = new \Elementor\Repeater(); 
  $repeater->add_control(
    'col3title3megamenuthreekaveh',
    [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

    ]
);
$repeater->add_control(
  'col3activetitle3megamenuthreekaveh',
  [
    'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
    'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'no',
  ]
);
$repeater->add_control(
  'col3title23megamenuthreekaveh',
  [
      'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'condition' => [
        'col3activetitle3megamenuthreekaveh!' => 'yes',
      ],
      'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

  ]
);
$repeater->add_control(
  'col3link3megamenuthreekaveh',
  [
      'label' => esc_html__( 'لینک', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( '#', 'kaveh-core' ),

  ]
);
$this->add_control(
  'listcol33megamenuthreekaveh',
  [
    'label' => esc_html__( 'لیست ستون سوم', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::REPEATER,
    'fields' => $repeater->get_controls(),
    'default' => [
      [
        'col3title3megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
        'col3title23megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
        'col3link3megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
      ],
  ]
  ]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
  'col4title3megamenuthreekaveh',
  [
      'label' => esc_html__( 'عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

  ]
);
$repeater->add_control(
'col4activetitle3megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::SWITCHER,
  'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
  'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
  'return_value' => 'yes',
  'default' => 'no',
]
);
$repeater->add_control(
'col4title23megamenuthreekaveh',
[
    'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'col4activetitle3megamenuthreekaveh!' => 'yes',
    ],
    'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4link3megamenuthreekaveh',
[
    'label' => esc_html__( 'لینک', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol43megamenuthreekaveh',
[
  'label' => esc_html__( 'لیست ستون چهارم', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::REPEATER,
  'fields' => $repeater->get_controls(),
  'default' => [
    [
      'col4title3megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
      'col4title23megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
      'col4link3megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
    ],
]
]

);
    $this->add_control(
      'hrl3megamenuthreekaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'imgshows3megamenuthreekaveh',
      [
        'label' => esc_html__( 'ستون پنجم', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
          '1'  => esc_html__( 'لیست دسته بندی ها', 'kaveh-core' ),
          '2' => esc_html__( 'لیست محصولات سبک یک', 'kaveh-core' ),
          '3' => esc_html__( 'لیست محصولات سبک دو', 'kaveh-core' ),
          '4' => esc_html__( 'لیست محصولات سبک سه', 'kaveh-core' ),

        ],
      ]
    );
    $repeater = new \Elementor\Repeater(); 
      $repeater->add_control(
        'col5title3megamenuthreekaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'col5activetitle3megamenuthreekaveh',
      [
        'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
        'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $repeater->add_control(
      'col5title23megamenuthreekaveh',
      [
          'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'col5activetitle3megamenuthreekaveh!' => 'yes',
          ],
          'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
  
      ]
  );
    $repeater->add_control(
      'col5link3megamenuthreekaveh',
      [
          'label' => esc_html__( 'لینک', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
    $this->add_control(
      'listcol53megamenuthreekaveh',
      [
        'label' => esc_html__( 'لیست ستون پنجم', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'condition' => [
              'imgshows3megamenuthreekaveh' => '1',
            ],
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'col5title3megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
            'col5title23megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
            'col5link3megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );

    $this->add_control(
      'icond3megamenuthreekaveh',
      [
        'label' => esc_html__( 'آیکون عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'condition' => [
          'imgshows3megamenuthreekaveh' => ['3','2','4'],
        ],
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-folder-2',
        ],
      ]
    ); 
      $this->add_control(
        'boldtitled3megamenuthreekaveh',
        [
            'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'condition' => [
              'imgshows3megamenuthreekaveh' => ['3','2','4'],
            ],
            'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'titled3megamenuthreekaveh',
      [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'imgshows3megamenuthreekaveh' => ['3','2','4'],
          ],
          'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

      ]
  );
    $this->add_control(
      'titled23megamenuthreekaveh',
      [
          'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'imgshows3megamenuthreekaveh' => ['3','2','4'],
          ],
          'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

      ]
  );
  $this->add_control(
    'linktitlecol53megamenuthreekaveh',
    [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'imgshows3megamenuthreekaveh' => ['3','2','4'],
        ],
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
$taboptiongrid = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

foreach ( $product_categories as $key => $category ) {
    $taboptiongrid[$category->term_id] = $category->name;
}
$this->add_control(
    'cat1col43megamenuthreekaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'condition' => [
        'imgshows3megamenuthreekaveh' => ['3','2','4'],
      ],
      'options' => $taboptiongrid,
    ]
);
$this->add_control(
  'productnumber3megamenuthreekaveh',
  [
    'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
    'condition' => [
      'imgshows3megamenuthreekaveh' => ['3','2','4'],
    ],
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 4,
    'step' => 1,
    'default' => 4,
  ]
);
$this->add_control(
  'productboxbg3megamenuthreekaveh',
  [
    'label' => esc_html__( 'تصویر پس زمینه باکس', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'selectors' => [
      '{{WRAPPER}} .megamenu-three .last-products-three .last-products-box' => 'background: url({{URL}}) center center no-repeat',
  ],   
    'condition' => [
      'imgshows3megamenuthreekaveh' => ['4'],
    ],
  ]
);
$this->add_control(
  'iconcol53megamenuthreekaveh',
  [
    'label' => esc_html__( 'آیکون دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::ICONS,
    'skin' => 'inline',
    'condition' => [
      'imgshows3megamenuthreekaveh' => ['3','2','4'],
    ],
    'exclude_inline_options' => [ 'svg' ],
    'default' => [
      'value' => 'icon icon-ball',
    ],
  ]
); 
$this->add_control(
  'col5buttontitle3megamenuthreekaveh',
  [
      'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'condition' => [
        'imgshows3megamenuthreekaveh' => ['3','2','4'],
      ],
      'default' => esc_html__( 'برای مشاهده بیشتر', 'kaveh-core' ),

  ]
);
$this->add_control(
'col5buttonlink3megamenuthreekaveh',
[
    'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'imgshows3megamenuthreekaveh' => ['3','2','4'],
    ],
    'default' => esc_html__( '#', 'kaveh-core' ),

]
);

 $this->end_controls_section();

 $this->start_controls_section(
  'tab4megamenuthreekaveh',
  [
    'label' => esc_html__( 'محتوای تب چهارم', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            'condition' => [
              'tabcountmegamenuthreekaveh!' => ['1','2','3'],
],
  ]
);
$this->add_control(
  'icon4megamenuthreekaveh',
  [
    'label' => esc_html__( 'آیکون تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::ICONS,
    'skin' => 'inline',
    'exclude_inline_options' => [ 'svg' ],
    'default' => [
      'value' => 'icon-printer',
    ],
  ]
); 
$this->add_control(
  'boldtitle4megamenuthreekaveh',
  [
      'label' => esc_html__( 'عنوان بولد تب', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'تجهیزات', 'kaveh-core' ),

  ]
);
$this->add_control(
'title4megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'title24megamenuthreekaveh',
[
    'label' => esc_html__( 'زیر عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'iconm4megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-printer',
],
]
); 
$this->add_control(
'boldtitlem4megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان بولد محتوای تب', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titlem4megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titlem24megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'titlemlink24megamenuthreekaveh',
[
'label' => esc_html__( 'لینک عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'hrt4megamenuthreekaveh',
[
  'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col1title4megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1activetitle4megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col1title24megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col1activetitle4megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1link4megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol4megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون اول', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col1title4megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col1title24megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col1link4megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col2title4megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2activetitle4megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col2title24megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'col2activetitle4megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2link4megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol24megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون دوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
  'col2title4megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
  'col2title24megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
  'col2link4megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col3title4megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3activetitle4megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col3title24megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col3activetitle4megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3link4megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol34megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون سوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col3title4megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col3title24megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col3link4megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col4title4megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4activetitle4megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col4title24megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col4activetitle4megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4link4megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol44megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون چهارم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col4title4megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col4title24megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col4link4megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$this->add_control(
'hrl4megamenuthreekaveh',
[
'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$this->add_control(
'imgshows4megamenuthreekaveh',
[
'label' => esc_html__( 'ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT,
'default' => '1',
'options' => [
  '1'  => esc_html__( 'لیست دسته بندی ها', 'kaveh-core' ),
  '2' => esc_html__( 'لیست محصولات سبک یک', 'kaveh-core' ),
  '3' => esc_html__( 'لیست محصولات سبک دو', 'kaveh-core' ),
  '4' => esc_html__( 'لیست محصولات سبک سه', 'kaveh-core' ),

],
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col5title4megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5activetitle4megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col5title24megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col5activetitle4megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5link4megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol54megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'condition' => [
      'imgshows4megamenuthreekaveh' => '1',
    ],
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col5title4megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col5title24megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col5link4megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);

$this->add_control(
'icond4megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
  'imgshows4megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-folder-2',
],
]
); 
$this->add_control(
'boldtitled4megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'imgshows4megamenuthreekaveh' => ['3','2','4'],
    ],
    'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titled4megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows4megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titled24megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows4megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'linktitlecol54megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'imgshows4megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$taboptiongrid = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
'orderby'    => $orderby,
'order'      => $order,
'hide_empty' => $hide_empty,
);

foreach ( $product_categories as $key => $category ) {
$taboptiongrid[$category->term_id] = $category->name;
}
$this->add_control(
'cat1col44megamenuthreekaveh',
[
'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT2, 
'multiple' => true,
'condition' => [
'imgshows4megamenuthreekaveh' => ['3','2','4'],
],
'options' => $taboptiongrid,
]
);
$this->add_control(
'productnumber4megamenuthreekaveh',
[
'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
'condition' => [
'imgshows4megamenuthreekaveh' => ['3','2','4'],
],
'type' => \Elementor\Controls_Manager::NUMBER,
'min' => 0,
'max' => 4,
'step' => 1,
'default' => 4,
]
);
$this->add_control(
'productboxbg4megamenuthreekaveh',
[
'label' => esc_html__( 'تصویر پس زمینه باکس', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::MEDIA,
'selectors' => [
'{{WRAPPER}} .megamenu-three .last-products-three .last-products-box' => 'background: url({{URL}}) center center no-repeat',
],   
'condition' => [
'imgshows4megamenuthreekaveh' => ['4'],
],
]
);
$this->add_control(
'iconcol54megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
'imgshows4megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
'value' => 'icon icon-ball',
],
]
); 
$this->add_control(
'col5buttontitle4megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows4megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( 'برای مشاهده بیشتر', 'kaveh-core' ),

]
);
$this->add_control(
'col5buttonlink4megamenuthreekaveh',
[
'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows4megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);

$this->end_controls_section();
$this->start_controls_section(
  'tab5megamenuthreekaveh',
  [
    'label' => esc_html__( 'محتوای تب پنجم', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            'condition' => [
              'tabcountmegamenuthreekaveh!' => ['1','2','3','4'],
],
  ]
);
$this->add_control(
  'icon5megamenuthreekaveh',
  [
    'label' => esc_html__( 'آیکون تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::ICONS,
    'skin' => 'inline',
    'exclude_inline_options' => [ 'svg' ],
    'default' => [
      'value' => 'icon-printer',
    ],
  ]
); 
$this->add_control(
  'boldtitle5megamenuthreekaveh',
  [
      'label' => esc_html__( 'عنوان بولد تب', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'تجهیزات', 'kaveh-core' ),

  ]
);
$this->add_control(
'title5megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'title25megamenuthreekaveh',
[
    'label' => esc_html__( 'زیر عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'iconm5megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-printer',
],
]
); 
$this->add_control(
'boldtitlem5megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان بولد محتوای تب', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titlem5megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titlem25megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'titlemlink25megamenuthreekaveh',
[
'label' => esc_html__( 'لینک عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'hrt5megamenuthreekaveh',
[
  'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col1title5megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1activetitle5megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col1title25megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col1activetitle5megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1link5megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol5megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون اول', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col1title5megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col1title25megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col1link5megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col2title5megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2activetitle5megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col2title25megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'col2activetitle5megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2link5megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol25megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون دوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
  'col2title5megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
  'col2title25megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
  'col2link5megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col3title5megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3activetitle5megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col3title25megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col3activetitle5megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3link5megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol35megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون سوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col3title5megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col3title25megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col3link5megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col4title5megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4activetitle5megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col4title25megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col4activetitle5megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4link5megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol45megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون چهارم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col4title5megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col4title25megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col4link5megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$this->add_control(
'hrl5megamenuthreekaveh',
[
'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$this->add_control(
'imgshows5megamenuthreekaveh',
[
'label' => esc_html__( 'ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT,
'default' => '1',
'options' => [
  '1'  => esc_html__( 'لیست دسته بندی ها', 'kaveh-core' ),
  '2' => esc_html__( 'لیست محصولات سبک یک', 'kaveh-core' ),
  '3' => esc_html__( 'لیست محصولات سبک دو', 'kaveh-core' ),
  '4' => esc_html__( 'لیست محصولات سبک سه', 'kaveh-core' ),

],
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col5title5megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5activetitle5megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col5title25megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col5activetitle5megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5link5megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol55megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'condition' => [
      'imgshows5megamenuthreekaveh' => '1',
    ],
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col5title5megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col5title25megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col5link5megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);

$this->add_control(
'icond5megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
  'imgshows5megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-folder-2',
],
]
); 
$this->add_control(
'boldtitled5megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'imgshows5megamenuthreekaveh' => ['3','2','4'],
    ],
    'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titled5megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows5megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titled25megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows5megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'linktitlecol55megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'imgshows5megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$taboptiongrid = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
'orderby'    => $orderby,
'order'      => $order,
'hide_empty' => $hide_empty,
);

foreach ( $product_categories as $key => $category ) {
$taboptiongrid[$category->term_id] = $category->name;
}
$this->add_control(
'cat1col45megamenuthreekaveh',
[
'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT2, 
'multiple' => true,
'condition' => [
'imgshows5megamenuthreekaveh' => ['3','2','4'],
],
'options' => $taboptiongrid,
]
);
$this->add_control(
'productnumber5megamenuthreekaveh',
[
'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
'condition' => [
'imgshows5megamenuthreekaveh' => ['3','2','4'],
],
'type' => \Elementor\Controls_Manager::NUMBER,
'min' => 0,
'max' => 4,
'step' => 1,
'default' => 4,
]
);
$this->add_control(
'productboxbg5megamenuthreekaveh',
[
'label' => esc_html__( 'تصویر پس زمینه باکس', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::MEDIA,
'selectors' => [
'{{WRAPPER}} .megamenu-three .last-products-three .last-products-box' => 'background: url({{URL}}) center center no-repeat',
],   
'condition' => [
'imgshows5megamenuthreekaveh' => ['4'],
],
]
);
$this->add_control(
'iconcol55megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
'imgshows5megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
'value' => 'icon icon-ball',
],
]
); 
$this->add_control(
'col5buttontitle5megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows5megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( 'برای مشاهده بیشتر', 'kaveh-core' ),

]
);
$this->add_control(
'col5buttonlink5megamenuthreekaveh',
[
'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows5megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);

$this->end_controls_section();
$this->start_controls_section(
  'tab6megamenuthreekaveh',
  [
    'label' => esc_html__( 'محتوای تب ششم', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            'condition' => [
              'tabcountmegamenuthreekaveh!' => ['1','2','3','4','5'],
],
  ]
);
$this->add_control(
  'icon6megamenuthreekaveh',
  [
    'label' => esc_html__( 'آیکون تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::ICONS,
    'skin' => 'inline',
    'exclude_inline_options' => [ 'svg' ],
    'default' => [
      'value' => 'icon-printer',
    ],
  ]
); 
$this->add_control(
  'boldtitle6megamenuthreekaveh',
  [
      'label' => esc_html__( 'عنوان بولد تب', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'تجهیزات', 'kaveh-core' ),

  ]
);
$this->add_control(
'title6megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'title26megamenuthreekaveh',
[
    'label' => esc_html__( 'زیر عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'iconm6megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-printer',
],
]
); 
$this->add_control(
'boldtitlem6megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان بولد محتوای تب', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titlem6megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titlem26megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'titlemlink26megamenuthreekaveh',
[
'label' => esc_html__( 'لینک عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'hrt6megamenuthreekaveh',
[
  'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col1title6megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1activetitle6megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col1title26megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col1activetitle6megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1link6megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol6megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون اول', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col1title6megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col1title26megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col1link6megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col2title6megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2activetitle6megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col2title26megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'col2activetitle6megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2link6megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol26megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون دوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
  'col2title6megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
  'col2title26megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
  'col2link6megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col3title6megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3activetitle6megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col3title26megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col3activetitle6megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3link6megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol36megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون سوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col3title6megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col3title26megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col3link6megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col4title6megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4activetitle6megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col4title26megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col4activetitle6megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4link6megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol46megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون چهارم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col4title6megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col4title26megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col4link6megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$this->add_control(
'hrl6megamenuthreekaveh',
[
'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$this->add_control(
'imgshows6megamenuthreekaveh',
[
'label' => esc_html__( 'ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT,
'default' => '1',
'options' => [
  '1'  => esc_html__( 'لیست دسته بندی ها', 'kaveh-core' ),
  '2' => esc_html__( 'لیست محصولات سبک یک', 'kaveh-core' ),
  '3' => esc_html__( 'لیست محصولات سبک دو', 'kaveh-core' ),
  '4' => esc_html__( 'لیست محصولات سبک سه', 'kaveh-core' ),

],
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col5title6megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5activetitle6megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col5title26megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col5activetitle6megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5link6megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol56megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'condition' => [
      'imgshows6megamenuthreekaveh' => '1',
    ],
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col5title6megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col5title26megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col5link6megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);

$this->add_control(
'icond6megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
  'imgshows6megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-folder-2',
],
]
); 
$this->add_control(
'boldtitled6megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'imgshows6megamenuthreekaveh' => ['3','2','4'],
    ],
    'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titled6megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows6megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titled26megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows6megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'linktitlecol56megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'imgshows6megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$taboptiongrid = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
'orderby'    => $orderby,
'order'      => $order,
'hide_empty' => $hide_empty,
);

foreach ( $product_categories as $key => $category ) {
$taboptiongrid[$category->term_id] = $category->name;
}
$this->add_control(
'cat1col46megamenuthreekaveh',
[
'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT2, 
'multiple' => true,
'condition' => [
'imgshows6megamenuthreekaveh' => ['3','2','4'],
],
'options' => $taboptiongrid,
]
);
$this->add_control(
'productnumber6megamenuthreekaveh',
[
'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
'condition' => [
'imgshows6megamenuthreekaveh' => ['3','2','4'],
],
'type' => \Elementor\Controls_Manager::NUMBER,
'min' => 0,
'max' => 4,
'step' => 1,
'default' => 4,
]
);
$this->add_control(
'productboxbg6megamenuthreekaveh',
[
'label' => esc_html__( 'تصویر پس زمینه باکس', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::MEDIA,
'selectors' => [
'{{WRAPPER}} .megamenu-three .last-products-three .last-products-box' => 'background: url({{URL}}) center center no-repeat',
],   
'condition' => [
'imgshows6megamenuthreekaveh' => ['4'],
],
]
);
$this->add_control(
'iconcol56megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
'imgshows6megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
'value' => 'icon icon-ball',
],
]
); 
$this->add_control(
'col5buttontitle6megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows6megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( 'برای مشاهده بیشتر', 'kaveh-core' ),

]
);
$this->add_control(
'col5buttonlink6megamenuthreekaveh',
[
'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows6megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);

$this->end_controls_section();
$this->start_controls_section(
  'tab7megamenuthreekaveh',
  [
    'label' => esc_html__( 'محتوای تب هفتم', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            'condition' => [
              'tabcountmegamenuthreekaveh!' => ['1','2','3','4','5','6'],
],
  ]
);
$this->add_control(
  'icon7megamenuthreekaveh',
  [
    'label' => esc_html__( 'آیکون تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::ICONS,
    'skin' => 'inline',
    'exclude_inline_options' => [ 'svg' ],
    'default' => [
      'value' => 'icon-printer',
    ],
  ]
); 
$this->add_control(
  'boldtitle7megamenuthreekaveh',
  [
      'label' => esc_html__( 'عنوان بولد تب', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'تجهیزات', 'kaveh-core' ),

  ]
);
$this->add_control(
'title7megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'title27megamenuthreekaveh',
[
    'label' => esc_html__( 'زیر عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'iconm7megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-printer',
],
]
); 
$this->add_control(
'boldtitlem7megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان بولد محتوای تب', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titlem7megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titlem27megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'titlemlink27megamenuthreekaveh',
[
'label' => esc_html__( 'لینک عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'hrt7megamenuthreekaveh',
[
  'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col1title7megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1activetitle7megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col1title27megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col1activetitle7megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1link7megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol7megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون اول', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col1title7megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col1title27megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col1link7megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col2title7megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2activetitle7megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col2title27megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'col2activetitle7megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2link7megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol27megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون دوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
  'col2title7megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
  'col2title27megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
  'col2link7megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col3title7megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3activetitle7megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col3title27megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col3activetitle7megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3link7megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol37megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون سوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col3title7megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col3title27megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col3link7megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col4title7megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4activetitle7megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col4title27megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col4activetitle7megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4link7megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol47megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون چهارم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col4title7megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col4title27megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col4link7megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$this->add_control(
'hrl7megamenuthreekaveh',
[
'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$this->add_control(
'imgshows7megamenuthreekaveh',
[
'label' => esc_html__( 'ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT,
'default' => '1',
'options' => [
  '1'  => esc_html__( 'لیست دسته بندی ها', 'kaveh-core' ),
  '2' => esc_html__( 'لیست محصولات سبک یک', 'kaveh-core' ),
  '3' => esc_html__( 'لیست محصولات سبک دو', 'kaveh-core' ),
  '4' => esc_html__( 'لیست محصولات سبک سه', 'kaveh-core' ),

],
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col5title7megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5activetitle7megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col5title27megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col5activetitle7megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5link7megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol57megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'condition' => [
      'imgshows7megamenuthreekaveh' => '1',
    ],
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col5title7megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col5title27megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col5link7megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);

$this->add_control(
'icond7megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
  'imgshows7megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-folder-2',
],
]
); 
$this->add_control(
'boldtitled7megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'imgshows7megamenuthreekaveh' => ['3','2','4'],
    ],
    'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titled7megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows7megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titled27megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows7megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'linktitlecol57megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'imgshows7megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$taboptiongrid = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
'orderby'    => $orderby,
'order'      => $order,
'hide_empty' => $hide_empty,
);

foreach ( $product_categories as $key => $category ) {
$taboptiongrid[$category->term_id] = $category->name;
}
$this->add_control(
'cat1col47megamenuthreekaveh',
[
'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT2, 
'multiple' => true,
'condition' => [
'imgshows7megamenuthreekaveh' => ['3','2','4'],
],
'options' => $taboptiongrid,
]
);
$this->add_control(
'productnumber7megamenuthreekaveh',
[
'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
'condition' => [
'imgshows7megamenuthreekaveh' => ['3','2','4'],
],
'type' => \Elementor\Controls_Manager::NUMBER,
'min' => 0,
'max' => 4,
'step' => 1,
'default' => 4,
]
);
$this->add_control(
'productboxbg7megamenuthreekaveh',
[
'label' => esc_html__( 'تصویر پس زمینه باکس', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::MEDIA,
'selectors' => [
'{{WRAPPER}} .megamenu-three .last-products-three .last-products-box' => 'background: url({{URL}}) center center no-repeat',
],   
'condition' => [
'imgshows7megamenuthreekaveh' => ['4'],
],
]
);
$this->add_control(
'iconcol57megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
'imgshows7megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
'value' => 'icon icon-ball',
],
]
); 
$this->add_control(
'col5buttontitle7megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows7megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( 'برای مشاهده بیشتر', 'kaveh-core' ),

]
);
$this->add_control(
'col5buttonlink7megamenuthreekaveh',
[
'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows7megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);

$this->end_controls_section();
$this->start_controls_section(
  'tab8megamenuthreekaveh',
  [
    'label' => esc_html__( 'محتوای تب هشتم', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            'condition' => [
              'tabcountmegamenuthreekaveh!' => ['1','2','3','4','5','6','7'],
],
  ]
);
$this->add_control(
  'icon8megamenuthreekaveh',
  [
    'label' => esc_html__( 'آیکون تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::ICONS,
    'skin' => 'inline',
    'exclude_inline_options' => [ 'svg' ],
    'default' => [
      'value' => 'icon-printer',
    ],
  ]
); 
$this->add_control(
  'boldtitle8megamenuthreekaveh',
  [
      'label' => esc_html__( 'عنوان بولد تب', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'تجهیزات', 'kaveh-core' ),

  ]
);
$this->add_control(
'title8megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'title28megamenuthreekaveh',
[
    'label' => esc_html__( 'زیر عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'iconm8megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-printer',
],
]
); 
$this->add_control(
'boldtitlem8megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان بولد محتوای تب', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titlem8megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titlem28megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'titlemlink28megamenuthreekaveh',
[
'label' => esc_html__( 'لینک عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'hrt8megamenuthreekaveh',
[
  'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col1title8megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1activetitle8megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col1title28megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col1activetitle8megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1link8megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol8megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون اول', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col1title8megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col1title28megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col1link8megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col2title8megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2activetitle8megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col2title28megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'col2activetitle8megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2link8megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol28megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون دوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
  'col2title8megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
  'col2title28megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
  'col2link8megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col3title8megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3activetitle8megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col3title28megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col3activetitle8megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3link8megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol38megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون سوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col3title8megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col3title28megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col3link8megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col4title8megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4activetitle8megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col4title28megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col4activetitle8megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4link8megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol48megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون چهارم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col4title8megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col4title28megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col4link8megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$this->add_control(
'hrl8megamenuthreekaveh',
[
'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$this->add_control(
'imgshows8megamenuthreekaveh',
[
'label' => esc_html__( 'ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT,
'default' => '1',
'options' => [
  '1'  => esc_html__( 'لیست دسته بندی ها', 'kaveh-core' ),
  '2' => esc_html__( 'لیست محصولات سبک یک', 'kaveh-core' ),
  '3' => esc_html__( 'لیست محصولات سبک دو', 'kaveh-core' ),
  '4' => esc_html__( 'لیست محصولات سبک سه', 'kaveh-core' ),

],
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col5title8megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5activetitle8megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col5title28megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col5activetitle8megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5link8megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol58megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'condition' => [
      'imgshows8megamenuthreekaveh' => '1',
    ],
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col5title8megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col5title28megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col5link8megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);

$this->add_control(
'icond8megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
  'imgshows8megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-folder-2',
],
]
); 
$this->add_control(
'boldtitled8megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'imgshows8megamenuthreekaveh' => ['3','2','4'],
    ],
    'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titled8megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows8megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titled28megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows8megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'linktitlecol58megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'imgshows8megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$taboptiongrid = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
'orderby'    => $orderby,
'order'      => $order,
'hide_empty' => $hide_empty,
);

foreach ( $product_categories as $key => $category ) {
$taboptiongrid[$category->term_id] = $category->name;
}
$this->add_control(
'cat1col48megamenuthreekaveh',
[
'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT2, 
'multiple' => true,
'condition' => [
'imgshows8megamenuthreekaveh' => ['3','2','4'],
],
'options' => $taboptiongrid,
]
);
$this->add_control(
'productnumber8megamenuthreekaveh',
[
'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
'condition' => [
'imgshows8megamenuthreekaveh' => ['3','2','4'],
],
'type' => \Elementor\Controls_Manager::NUMBER,
'min' => 0,
'max' => 4,
'step' => 1,
'default' => 4,
]
);
$this->add_control(
'productboxbg8megamenuthreekaveh',
[
'label' => esc_html__( 'تصویر پس زمینه باکس', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::MEDIA,
'selectors' => [
'{{WRAPPER}} .megamenu-three .last-products-three .last-products-box' => 'background: url({{URL}}) center center no-repeat',
],   
'condition' => [
'imgshows8megamenuthreekaveh' => ['4'],
],
]
);
$this->add_control(
'iconcol58megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
'imgshows8megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
'value' => 'icon icon-ball',
],
]
); 
$this->add_control(
'col5buttontitle8megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows8megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( 'برای مشاهده بیشتر', 'kaveh-core' ),

]
);
$this->add_control(
'col5buttonlink8megamenuthreekaveh',
[
'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows8megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);

$this->end_controls_section();
$this->start_controls_section(
  'tab9megamenuthreekaveh',
  [
    'label' => esc_html__( 'محتوای تب نهم', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            'condition' => [
              'tabcountmegamenuthreekaveh' => ['9','10','11','12'],
],
  ]
);
$this->add_control(
  'icon9megamenuthreekaveh',
  [
    'label' => esc_html__( 'آیکون تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::ICONS,
    'skin' => 'inline',
    'exclude_inline_options' => [ 'svg' ],
    'default' => [
      'value' => 'icon-printer',
    ],
  ]
); 
$this->add_control(
  'boldtitle9megamenuthreekaveh',
  [
      'label' => esc_html__( 'عنوان بولد تب', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'تجهیزات', 'kaveh-core' ),

  ]
);
$this->add_control(
'title9megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'title29megamenuthreekaveh',
[
    'label' => esc_html__( 'زیر عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'iconm9megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-printer',
],
]
); 
$this->add_control(
'boldtitlem9megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان بولد محتوای تب', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titlem9megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titlem29megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'titlemlink29megamenuthreekaveh',
[
'label' => esc_html__( 'لینک عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'hrt9megamenuthreekaveh',
[
  'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col1title9megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1activetitle9megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col1title29megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col1activetitle9megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1link9megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol9megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون اول', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col1title9megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col1title29megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col1link9megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col2title9megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2activetitle9megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col2title29megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'col2activetitle9megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2link9megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol29megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون دوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
  'col2title9megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
  'col2title29megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
  'col2link9megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col3title9megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3activetitle9megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col3title29megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col3activetitle9megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3link9megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol39megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون سوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col3title9megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col3title29megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col3link9megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col4title9megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4activetitle9megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col4title29megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col4activetitle9megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4link9megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol49megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون چهارم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col4title9megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col4title29megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col4link9megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$this->add_control(
'hrl9megamenuthreekaveh',
[
'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$this->add_control(
'imgshows9megamenuthreekaveh',
[
'label' => esc_html__( 'ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT,
'default' => '1',
'options' => [
  '1'  => esc_html__( 'لیست دسته بندی ها', 'kaveh-core' ),
  '2' => esc_html__( 'لیست محصولات سبک یک', 'kaveh-core' ),
  '3' => esc_html__( 'لیست محصولات سبک دو', 'kaveh-core' ),
  '4' => esc_html__( 'لیست محصولات سبک سه', 'kaveh-core' ),

],
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col5title9megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5activetitle9megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col5title29megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col5activetitle9megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5link9megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol59megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'condition' => [
      'imgshows9megamenuthreekaveh' => '1',
    ],
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col5title9megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col5title29megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col5link9megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);

$this->add_control(
'icond9megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
  'imgshows9megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-folder-2',
],
]
); 
$this->add_control(
'boldtitled9megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'imgshows9megamenuthreekaveh' => ['3','2','4'],
    ],
    'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titled9megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows9megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titled29megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows9megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'linktitlecol59megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'imgshows9megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$taboptiongrid = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
'orderby'    => $orderby,
'order'      => $order,
'hide_empty' => $hide_empty,
);

foreach ( $product_categories as $key => $category ) {
$taboptiongrid[$category->term_id] = $category->name;
}
$this->add_control(
'cat1col49megamenuthreekaveh',
[
'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT2, 
'multiple' => true,
'condition' => [
'imgshows9megamenuthreekaveh' => ['3','2','4'],
],
'options' => $taboptiongrid,
]
);
$this->add_control(
'productnumber9megamenuthreekaveh',
[
'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
'condition' => [
'imgshows9megamenuthreekaveh' => ['3','2','4'],
],
'type' => \Elementor\Controls_Manager::NUMBER,
'min' => 0,
'max' => 4,
'step' => 1,
'default' => 4,
]
);
$this->add_control(
'productboxbg9megamenuthreekaveh',
[
'label' => esc_html__( 'تصویر پس زمینه باکس', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::MEDIA,
'selectors' => [
'{{WRAPPER}} .megamenu-three .last-products-three .last-products-box' => 'background: url({{URL}}) center center no-repeat',
],   
'condition' => [
'imgshows9megamenuthreekaveh' => ['4'],
],
]
);
$this->add_control(
'iconcol59megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
'imgshows9megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
'value' => 'icon icon-ball',
],
]
); 
$this->add_control(
'col5buttontitle9megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows9megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( 'برای مشاهده بیشتر', 'kaveh-core' ),

]
);
$this->add_control(
'col5buttonlink9megamenuthreekaveh',
[
'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows9megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);

$this->end_controls_section();
$this->start_controls_section(
  'tab10megamenuthreekaveh',
  [
    'label' => esc_html__( 'محتوای تب دهم', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            'condition' => [
              'tabcountmegamenuthreekaveh' => ['10','11','12'],
],
  ]
);
$this->add_control(
  'icon10megamenuthreekaveh',
  [
    'label' => esc_html__( 'آیکون تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::ICONS,
    'skin' => 'inline',
    'exclude_inline_options' => [ 'svg' ],
    'default' => [
      'value' => 'icon-printer',
    ],
  ]
); 
$this->add_control(
  'boldtitle10megamenuthreekaveh',
  [
      'label' => esc_html__( 'عنوان بولد تب', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'تجهیزات', 'kaveh-core' ),

  ]
);
$this->add_control(
'title10megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'title210megamenuthreekaveh',
[
    'label' => esc_html__( 'زیر عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'iconm10megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-printer',
],
]
); 
$this->add_control(
'boldtitlem10megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان بولد محتوای تب', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titlem10megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titlem210megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'titlemlink210megamenuthreekaveh',
[
'label' => esc_html__( 'لینک عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'hrt10megamenuthreekaveh',
[
  'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col1title10megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1activetitle10megamenuthreekaveh!',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col1title210megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col1activetitle10megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1link10megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol10megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون اول', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col1title10megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col1title210megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col1link10megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col2title10megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2activetitle10megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col2title210megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'col2activetitle10megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2link10megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol210megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون دوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
  'col2title10megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
  'col2title210megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
  'col2link10megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col3title10megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3activetitle10megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col3title210megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col3activetitle10megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3link10megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol310megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون سوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col3title10megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col3title210megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col3link10megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col4title10megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4activetitle10megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col4title210megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col4activetitle10megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4link10megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol410megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون چهارم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col4title10megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col4title210megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col4link10megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$this->add_control(
'hrl10megamenuthreekaveh',
[
'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$this->add_control(
'imgshows10megamenuthreekaveh',
[
'label' => esc_html__( 'ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT,
'default' => '1',
'options' => [
  '1'  => esc_html__( 'لیست دسته بندی ها', 'kaveh-core' ),
  '2' => esc_html__( 'لیست محصولات سبک یک', 'kaveh-core' ),
  '3' => esc_html__( 'لیست محصولات سبک دو', 'kaveh-core' ),
  '4' => esc_html__( 'لیست محصولات سبک سه', 'kaveh-core' ),

],
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col5title10megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5activetitle10megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col5title210megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col5activetitle10megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5link10megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol510megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'condition' => [
      'imgshows10megamenuthreekaveh' => '1',
    ],
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col5title10megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col5title210megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col5link10megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);

$this->add_control(
'icond10megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
  'imgshows10megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-folder-2',
],
]
); 
$this->add_control(
'boldtitled10megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'imgshows10megamenuthreekaveh' => ['3','2','4'],
    ],
    'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titled10megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows10megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titled210megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows10megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'linktitlecol510megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'imgshows10megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$taboptiongrid = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
'orderby'    => $orderby,
'order'      => $order,
'hide_empty' => $hide_empty,
);

foreach ( $product_categories as $key => $category ) {
$taboptiongrid[$category->term_id] = $category->name;
}
$this->add_control(
'cat1col410megamenuthreekaveh',
[
'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT2, 
'multiple' => true,
'condition' => [
'imgshows10megamenuthreekaveh' => ['3','2','4'],
],
'options' => $taboptiongrid,
]
);
$this->add_control(
'productnumber10megamenuthreekaveh',
[
'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
'condition' => [
'imgshows10megamenuthreekaveh' => ['3','2','4'],
],
'type' => \Elementor\Controls_Manager::NUMBER,
'min' => 0,
'max' => 4,
'step' => 1,
'default' => 4,
]
);
$this->add_control(
'productboxbg10megamenuthreekaveh',
[
'label' => esc_html__( 'تصویر پس زمینه باکس', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::MEDIA,
'selectors' => [
'{{WRAPPER}} .megamenu-three .last-products-three .last-products-box' => 'background: url({{URL}}) center center no-repeat',
],   
'condition' => [
'imgshows10megamenuthreekaveh' => ['4'],
],
]
);
$this->add_control(
'iconcol510megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
'imgshows10megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
'value' => 'icon icon-ball',
],
]
); 
$this->add_control(
'col5buttontitle10megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows10megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( 'برای مشاهده بیشتر', 'kaveh-core' ),

]
);
$this->add_control(
'col5buttonlink10megamenuthreekaveh',
[
'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows10megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);

$this->end_controls_section();
$this->start_controls_section(
  'tab11megamenuthreekaveh',
  [
    'label' => esc_html__( 'محتوای تب یازدهم', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            'condition' => [
              'tabcountmegamenuthreekaveh' => ['11','12'],
],
  ]
);
$this->add_control(
  'icon11megamenuthreekaveh',
  [
    'label' => esc_html__( 'آیکون تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::ICONS,
    'skin' => 'inline',
    'exclude_inline_options' => [ 'svg' ],
    'default' => [
      'value' => 'icon-printer',
    ],
  ]
); 
$this->add_control(
  'boldtitle11megamenuthreekaveh',
  [
      'label' => esc_html__( 'عنوان بولد تب', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'تجهیزات', 'kaveh-core' ),

  ]
);
$this->add_control(
'title11megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'title211megamenuthreekaveh',
[
    'label' => esc_html__( 'زیر عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'iconm11megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-printer',
],
]
); 
$this->add_control(
'boldtitlem11megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان بولد محتوای تب', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titlem11megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titlem211megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'titlemlink211megamenuthreekaveh',
[
'label' => esc_html__( 'لینک عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'hrt11megamenuthreekaveh',
[
  'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col1title11megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1activetitle11megamenuthreekaveh!',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col1title211megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col1activetitle11megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1link11megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol11megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون اول', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col1title11megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col1title211megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col1link11megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col2title11megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2activetitle11megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col2title211megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'col2activetitle11megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2link11megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol211megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون دوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
  'col2title11megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
  'col2title211megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
  'col2link11megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col3title11megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3activetitle11megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col3title211megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col3activetitle11megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3link11megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol311megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون سوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col3title11megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col3title211megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col3link11megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col4title11megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4activetitle11megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col4title211megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col4activetitle11megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4link11megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol411megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون چهارم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col4title11megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col4title211megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col4link11megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$this->add_control(
'hrl11megamenuthreekaveh',
[
'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$this->add_control(
'imgshows11megamenuthreekaveh',
[
'label' => esc_html__( 'ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT,
'default' => '1',
'options' => [
  '1'  => esc_html__( 'لیست دسته بندی ها', 'kaveh-core' ),
  '2' => esc_html__( 'لیست محصولات سبک یک', 'kaveh-core' ),
  '3' => esc_html__( 'لیست محصولات سبک دو', 'kaveh-core' ),
  '4' => esc_html__( 'لیست محصولات سبک سه', 'kaveh-core' ),

],
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col5title11megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5activetitle11megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col5title211megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col5activetitle11megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5link11megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol511megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'condition' => [
      'imgshows11megamenuthreekaveh' => '1',
    ],
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col5title11megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col5title211megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col5link11megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);

$this->add_control(
'icond11megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
  'imgshows11megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-folder-2',
],
]
); 
$this->add_control(
'boldtitled11megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'imgshows11megamenuthreekaveh' => ['3','2','4'],
    ],
    'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titled11megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows11megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titled211megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows11megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'linktitlecol511megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'imgshows11megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$taboptiongrid = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
'orderby'    => $orderby,
'order'      => $order,
'hide_empty' => $hide_empty,
);

foreach ( $product_categories as $key => $category ) {
$taboptiongrid[$category->term_id] = $category->name;
}
$this->add_control(
'cat1col411megamenuthreekaveh',
[
'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT2, 
'multiple' => true,
'condition' => [
'imgshows11megamenuthreekaveh' => ['3','2','4'],
],
'options' => $taboptiongrid,
]
);
$this->add_control(
'productnumber11megamenuthreekaveh',
[
'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
'condition' => [
'imgshows11megamenuthreekaveh' => ['3','2','4'],
],
'type' => \Elementor\Controls_Manager::NUMBER,
'min' => 0,
'max' => 4,
'step' => 1,
'default' => 4,
]
);
$this->add_control(
'productboxbg11megamenuthreekaveh',
[
'label' => esc_html__( 'تصویر پس زمینه باکس', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::MEDIA,
'selectors' => [
'{{WRAPPER}} .megamenu-three .last-products-three .last-products-box' => 'background: url({{URL}}) center center no-repeat',
],   
'condition' => [
'imgshows11megamenuthreekaveh' => ['4'],
],
]
);
$this->add_control(
'iconcol511megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
'imgshows11megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
'value' => 'icon icon-ball',
],
]
); 
$this->add_control(
'col5buttontitle11megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows11megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( 'برای مشاهده بیشتر', 'kaveh-core' ),

]
);
$this->add_control(
'col5buttonlink11megamenuthreekaveh',
[
'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows11megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);

$this->end_controls_section();
$this->start_controls_section(
  'tab12megamenuthreekaveh',
  [
    'label' => esc_html__( 'محتوای تب دوازدهم', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            'condition' => [
              'tabcountmegamenuthreekaveh' => ['12'],
],
  ]
);
$this->add_control(
  'icon12megamenuthreekaveh',
  [
    'label' => esc_html__( 'آیکون تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::ICONS,
    'skin' => 'inline',
    'exclude_inline_options' => [ 'svg' ],
    'default' => [
      'value' => 'icon-printer',
    ],
  ]
); 
$this->add_control(
  'boldtitle12megamenuthreekaveh',
  [
      'label' => esc_html__( 'عنوان بولد تب', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'تجهیزات', 'kaveh-core' ),

  ]
);
$this->add_control(
'title12megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'title212megamenuthreekaveh',
[
    'label' => esc_html__( 'زیر عنوان تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'iconm12megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-printer',
],
]
); 
$this->add_control(
'boldtitlem12megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان بولد محتوای تب', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titlem12megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titlem212megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان محتوای تب', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'titlemlink212megamenuthreekaveh',
[
'label' => esc_html__( 'لینک عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'hrt12megamenuthreekaveh',
[
  'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col1title12megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1activetitle12megamenuthreekaveh!',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col1title212megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col1activetitle12megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col1link12megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol12megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون اول', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col1title12megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col1title212megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col1link12megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col2title12megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2activetitle12megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col2title212megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'col2activetitle12megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col2link12megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol212megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون دوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
  'col2title12megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
  'col2title212megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
  'col2link12megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col3title12megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3activetitle12megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col3title212megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col3activetitle12megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col3link12megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol312megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون سوم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col3title12megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col3title212megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col3link12megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col4title12megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4activetitle12megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col4title212megamenuthreekaveh',
[
'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'col4activetitle12megamenuthreekaveh!' => 'yes',
],
'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col4link12megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol412megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون چهارم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'fields' => $repeater->get_controls(),
'default' => [
[
'col4title12megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
'col4title212megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
'col4link12megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
],
]
]

);
$this->add_control(
'hrl12megamenuthreekaveh',
[
'type' => \Elementor\Controls_Manager::DIVIDER,
]
);
$this->add_control(
'imgshows12megamenuthreekaveh',
[
'label' => esc_html__( 'ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT,
'default' => '1',
'options' => [
  '1'  => esc_html__( 'لیست دسته بندی ها', 'kaveh-core' ),
  '2' => esc_html__( 'لیست محصولات سبک یک', 'kaveh-core' ),
  '3' => esc_html__( 'لیست محصولات سبک دو', 'kaveh-core' ),
  '4' => esc_html__( 'لیست محصولات سبک سه', 'kaveh-core' ),

],
]
);
$repeater = new \Elementor\Repeater(); 
$repeater->add_control(
'col5title12megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5activetitle12megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SWITCHER,
'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
'return_value' => 'yes',
'default' => 'no',
]
);
$repeater->add_control(
'col5title212megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'col5activetitle12megamenuthreekaveh!' => 'yes',
  ],
  'default' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),

]
);
$repeater->add_control(
'col5link12megamenuthreekaveh',
[
  'label' => esc_html__( 'لینک', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
'listcol512megamenuthreekaveh',
[
'label' => esc_html__( 'لیست ستون پنجم', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::REPEATER,
'condition' => [
      'imgshows12megamenuthreekaveh' => '1',
    ],
'fields' => $repeater->get_controls(),
'default' => [
  [
    'col5title12megamenuthreekaveh' => esc_html__( 'دوربین حرفه ای سونی', 'kaveh-core' ),
    'col5title212megamenuthreekaveh' => esc_html__( '۴ محصول موجود', 'kaveh-core' ),
    'col5link12megamenuthreekaveh' => esc_html__( '#', 'kaveh-core' ),
  ],
]
]

);

$this->add_control(
'icond12megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون عنوان', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
  'imgshows12megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
  'value' => 'icon-folder-2',
],
]
); 
$this->add_control(
'boldtitled12megamenuthreekaveh',
[
    'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'imgshows12megamenuthreekaveh' => ['3','2','4'],
    ],
    'default' => esc_html__( 'همه محصولات', 'kaveh-core' ),

]
);
$this->add_control(
'titled12megamenuthreekaveh',
[
  'label' => esc_html__( 'عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows12megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'تجهیزات دوربین', 'kaveh-core' ),

]
);
$this->add_control(
'titled212megamenuthreekaveh',
[
  'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
  'type' => \Elementor\Controls_Manager::TEXT,
  'condition' => [
    'imgshows12megamenuthreekaveh' => ['3','2','4'],
  ],
  'default' => esc_html__( 'برای مشاهده بیشتر کلیک کنید', 'kaveh-core' ),

]
);
$this->add_control(
'linktitlecol512megamenuthreekaveh',
[
'label' => esc_html__( 'لینک', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
  'imgshows12megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$taboptiongrid = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
'orderby'    => $orderby,
'order'      => $order,
'hide_empty' => $hide_empty,
);

foreach ( $product_categories as $key => $category ) {
$taboptiongrid[$category->term_id] = $category->name;
}
$this->add_control(
'cat1col412megamenuthreekaveh',
[
'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::SELECT2, 
'multiple' => true,
'condition' => [
'imgshows12megamenuthreekaveh' => ['3','2','4'],
],
'options' => $taboptiongrid,
]
);
$this->add_control(
'productnumber12megamenuthreekaveh',
[
'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
'condition' => [
'imgshows12megamenuthreekaveh' => ['3','2','4'],
],
'type' => \Elementor\Controls_Manager::NUMBER,
'min' => 0,
'max' => 4,
'step' => 1,
'default' => 4,
]
);
$this->add_control(
'productboxbg12megamenuthreekaveh',
[
'label' => esc_html__( 'تصویر پس زمینه باکس', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::MEDIA,
'selectors' => [
'{{WRAPPER}} .megamenu-three .last-products-three .last-products-box' => 'background: url({{URL}}) center center no-repeat',
],   
'condition' => [
'imgshows12megamenuthreekaveh' => ['4'],
],
]
);
$this->add_control(
'iconcol512megamenuthreekaveh',
[
'label' => esc_html__( 'آیکون دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::ICONS,
'skin' => 'inline',
'condition' => [
'imgshows12megamenuthreekaveh' => ['3','2','4'],
],
'exclude_inline_options' => [ 'svg' ],
'default' => [
'value' => 'icon icon-ball',
],
]
); 
$this->add_control(
'col5buttontitle12megamenuthreekaveh',
[
'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows12megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( 'برای مشاهده بیشتر', 'kaveh-core' ),

]
);
$this->add_control(
'col5buttonlink12megamenuthreekaveh',
[
'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
'type' => \Elementor\Controls_Manager::TEXT,
'condition' => [
'imgshows12megamenuthreekaveh' => ['3','2','4'],
],
'default' => esc_html__( '#', 'kaveh-core' ),

]
);

$this->end_controls_section();
$this->start_controls_section(
  'style1megamenuthreekaveh',
  [
    'label' => esc_html__( 'استایل تب ها', 'kaveh-core' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
  ]
);
$this->add_control(
  'bficonsize1megamenuthreekaveh',
  [
    'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SLIDER,
    'size_units' => [ 'px' ],
    'range' => [
      'px' => [
        'min' => 0,
        'max' => 200,
        'step' => 1,
      ],
    ],
    'default' => [
      'unit' => 'px',
      'size' => 16,
    ],
    'selectors' => [
      '{{WRAPPER}} .megamenu-three-tabs ul li i' => 'font-size: {{SIZE}}{{UNIT}};',
    ],
  ]
);
$this->add_control(
  'bficonsizewidth1megamenuthreekaveh',
  [
    'label' => esc_html__( 'عرض پس زمینه آیکون', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SLIDER,
    'size_units' => [ 'px' ],
    'range' => [
      'px' => [
        'min' => 0,
        'max' => 200,
        'step' => 1,
      ],
    ],
    'default' => [
      'unit' => 'px',
      'size' => 32,
    ],
    'selectors' => [
      '{{WRAPPER}} .megamenu-three-tabs ul li i' => 'width: {{SIZE}}{{UNIT}};',
    ],
  ]
);
$this->add_control(
  'bficonsizeheight1megamenuthreekaveh',
  [
    'label' => esc_html__( 'ارتفاع پس زمینه آیکون', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SLIDER,
    'size_units' => [ 'px' ],
    'range' => [
      'px' => [
        'min' => 0,
        'max' => 200,
        'step' => 1,
      ],
    ],
    'default' => [
      'unit' => 'px',
      'size' => 32,
    ],
    'selectors' => [
      '{{WRAPPER}} .megamenu-three-tabs ul li i' => 'height: {{SIZE}}{{UNIT}};',
    ],
  ]
);
$this->add_control(
  'tabiconbgbxradiusmegamenuthreekaveh',
  [
    'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::DIMENSIONS,
    'size_units' => [ 'px' ],
    'selectors' => [
      '{{WRAPPER}} .megamenu-three-tabs ul li i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
    ],
  ]
);
$this->start_controls_tabs(
      'style_tabsmegamenuthreekaveh'
    );

    $this->start_controls_tab(
      'style_normal_tabmegamenuthreekaveh',
      [
        'label' => esc_html__( 'عادی', 'kaveh-core' ),
      ]
    );
    $this->add_control(
      'beforeic1colormegamenuthreekaveh',
      [
        'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-tabs ul li i' => 'color: {{VALUE}}',
        ],
      ]
    ); 
    $this->add_control(
      'iconbg1hrcolormegamenuthreekaveh',
      [
        'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-tabs ul li i' => 'background-color: {{VALUE}}',
        ],
      ]
    ); 
    $this->add_control(
      'iconbgtab1hrcolormegamenuthreekaveh',
      [
        'label' => esc_html__( 'رنگ پس زمینه تب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-tabs ul li' => 'background-color: {{VALUE}}',
        ],
      ]
    ); 
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'txtboldtypomegamenuthreekaveh',
        'label' => esc_html__( 'تایپوگرافی عنوان بولد', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .megamenu-three-tabs ul li .detail .title b',
      ]
    );
    $this->add_control(
      'text1boldcolormegamenuthreekaveh',
      [
        'label' => esc_html__( 'رنگ عنوان بولد', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-tabs ul li .detail .title b' => 'color: {{VALUE}}',
        ],
      ]
    ); 
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'txttypomegamenuthreekaveh',
        'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .megamenu-three-tabs ul li .detail .title',
      ]
    );
    $this->add_control(
      'text1colormegamenuthreekaveh',
      [
        'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-tabs ul li .detail .title' => 'color: {{VALUE}}',
        ],
      ]
    ); 
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'txt2typomegamenuthreekaveh',
        'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .megamenu-three-tabs ul li .detail .sub-title',
      ]
    );
    $this->add_control(
      'text2colormegamenuthreekaveh',
      [
        'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-tabs ul li .detail .sub-title' => 'color: {{VALUE}}',
        ],
      ]
    ); 
    $this->add_control(
      'tabradiusmegamenuthreekaveh',
      [
        'label' => esc_html__( 'گوشه خمیده تب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-tabs ul li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'tabbordermegamenuthreekaveh',
        'label' => esc_html__( 'حاشیه تب', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .megamenu-three-tabs ul li',
      ]
    );
    $this->add_control(
      'tabbordersmegamenuthreekaveh',
      [
        'label' => esc_html__( 'عرض حاشیه تب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'condition' => [
          'tabbordermegamenuthreekaveh!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-tabs ul li' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'tab_shadow4megamenuthreekavehh',
        'label' => esc_html__( 'سایه تب', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .megamenu-three-tabs ul li',
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hove_tabmegamenuthreekaveh',
      [
        'label' => esc_html__( 'هاور', 'kaveh-core' ),
      ]
    );
    $this->add_control(
      'beforeic1colorhovermegamenuthreekaveh',
      [
        'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-tabs ul li.active i' => 'color: {{VALUE}}',        
        ],
      ]
    ); 
    $this->add_control(
      'iconbg1hovercolormegamenuthreekaveh',
      [
        'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-tabs ul li.active i' => 'background-color: {{VALUE}}',
        ],
      ]
    ); 
    $this->add_control(
      'iconbgtabhover1hrcolormegamenuthreekaveh',
      [
        'label' => esc_html__( 'رنگ پس زمینه تب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-tabs ul li.active' => 'background-color: {{VALUE}}',
        ],
      ]
    ); 
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'txtboldhovertypomegamenuthreekaveh',
        'label' => esc_html__( 'تایپوگرافی عنوان بولد', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .megamenu-three-tabs ul li.active .detail .title b',
      ]
    );
    $this->add_control(
      'text1boldhovercolormegamenuthreekaveh',
      [
        'label' => esc_html__( 'رنگ عنوان بولد', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-tabs ul li.active .detail .title b' => 'color: {{VALUE}}',
        ],
      ]
    ); 
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'txttypohovermegamenuthreekaveh',
        'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .megamenu-three-tabs ul li.active .detail .title',
      ]
    );
    $this->add_control(
      'text1colorhovermegamenuthreekaveh',
      [
        'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-tabs ul li.active .detail .title' => 'color: {{VALUE}}',

        ],
      ]
    ); 
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'txt2typohovermegamenuthreekaveh',
        'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .megamenu-three-tabs ul li.active .detail .sub-title',
      ]
    );
    $this->add_control(
      'text2colorhovermegamenuthreekaveh',
      [
        'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-tabs ul li.active .detail .sub-title' => 'color: {{VALUE}}',
        ],
      ]
    ); 
    $this->add_control(
      'tabradiushovermegamenuthreekaveh',
      [
        'label' => esc_html__( 'گوشه خمیده تب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-tabs ul li.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'tabborderhovermegamenuthreekaveh',
        'label' => esc_html__( 'حاشیه تب', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .megamenu-three-tabs ul li.active',
      ]
    );
    $this->add_control(
      'tabborderhoversmegamenuthreekaveh',
      [
        'label' => esc_html__( 'عرض حاشیه تب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'condition' => [
          'tabborderhovermegamenuthreekaveh!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-tabs ul li.active' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'tab_shadowactive4megamenuthreekavehh',
        'label' => esc_html__( 'سایه تب', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .megamenu-three-tabs ul li.active',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
          
$this->add_control(
  'hr1megamenuthreekaveh',
  [
    'type' => \Elementor\Controls_Manager::DIVIDER,
  ]
);
$this->add_control(
  'tabpaddingmegamenuthreekaveh',
  [
    'label' => esc_html__( 'فاصله داخلی تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::DIMENSIONS,
    'size_units' => [ 'px' ],
    'selectors' => [
      '{{WRAPPER}} .megamenu-three-tabs ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
    ],
  ]
);
$this->add_control(
  'bgtabboxes1hrcolormegamenuthreekaveh',
  [
    'label' => esc_html__( 'رنگ پس زمینه باکس تب ها', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
      '{{WRAPPER}} .megamenu-three-tabs' => 'background-color: {{VALUE}}',
    ],
  ]
); 
$this->add_control(
  'tabboxesradiushovermegamenuthreekaveh',
  [
    'label' => esc_html__( 'گوشه خمیده باکس تب', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::DIMENSIONS,
    'size_units' => [ 'px' ],
    'selectors' => [
      '{{WRAPPER}} .megamenu-three-tabs' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
    ],
  ]
);
$this->add_control(
  'scrolbartabboxes1hrcolormegamenuthreekaveh',
  [
    'label' => esc_html__( 'رنگ پس زمینه اسکرولبار', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
      '{{WRAPPER}} .megamenu-three-tabs ul::-webkit-scrollbar' => 'background-color: {{VALUE}}',
    ],
  ]
); 
$this->add_control(
  'scrolbarthumbtabboxes1hrcolormegamenuthreekaveh',
  [
    'label' => esc_html__( 'رنگ اسکرولبار', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
      '{{WRAPPER}} .megamenu-three-tabs ul::-webkit-scrollbar-thumb' => 'background-color: {{VALUE}}',
    ],
  ]
); 
$this->end_controls_section();
$this->start_controls_section(
  'style2megamenuthreekaveh',
  [
    'label' => esc_html__( 'استایل محتوای تب ها', 'kaveh-core' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
  ]
);
 $this->add_control(
  'bciconsize1megamenuthreekaveh',
  [
    'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SLIDER,
    'size_units' => [ 'px' ],
    'range' => [
      'px' => [
        'min' => 0,
        'max' => 200,
        'step' => 1,
      ],
    ],
    'default' => [
      'unit' => 'px',
      'size' => 16,
    ],
    'selectors' => [
      '{{WRAPPER}} .megamenu-three-heading > i' => 'font-size: {{SIZE}}{{UNIT}};',
    ],
  ]
);
$this->add_control(
  'bciconsizewidth1megamenuthreekaveh',
  [
    'label' => esc_html__( 'عرض پس زمینه آیکون', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SLIDER,
    'size_units' => [ 'px' ],
    'range' => [
      'px' => [
        'min' => 0,
        'max' => 200,
        'step' => 1,
      ],
    ],
    'default' => [
      'unit' => 'px',
      'size' => 32,
    ],
    'selectors' => [
      '{{WRAPPER}} .megamenu-three-heading > i' => 'width: {{SIZE}}{{UNIT}};',
    ],
  ]
);
$this->add_control(
  'bciconsizeheight1megamenuthreekaveh',
  [
    'label' => esc_html__( 'ارتفاع پس زمینه آیکون', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SLIDER,
    'size_units' => [ 'px' ],
    'range' => [
      'px' => [
        'min' => 0,
        'max' => 200,
        'step' => 1,
      ],
    ],
    'default' => [
      'unit' => 'px',
      'size' => 32,
    ],
    'selectors' => [
      '{{WRAPPER}} .megamenu-three-heading > i' => 'height: {{SIZE}}{{UNIT}};',
    ],
  ]
);
$this->add_control(
  'bciconbgbxradiusmegamenuthreekaveh',
  [
    'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::DIMENSIONS,
    'size_units' => [ 'px' ],
    'selectors' => [
      '{{WRAPPER}} .megamenu-three-heading > i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
    ],
  ]
);
    $this->add_control(
      'bcic1colormegamenuthreekaveh',
      [
        'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-heading > i' => 'color: {{VALUE}}',
        ],
      ]
    ); 
    $this->add_control(
      'bciconbg1hrcolormegamenuthreekaveh',
      [
        'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-heading > i' => 'background-color: {{VALUE}}',
        ],
      ]
    ); 
    $this->add_control(
      'bciconbgtab1hrcolormegamenuthreekaveh',
      [
        'label' => esc_html__( 'رنگ حاشیه آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-heading > i' => 'border: 1px solid {{VALUE}}',
        ],
      ]
    ); 
    $this->add_control(
      'cbf2colormegamenuthreekaveh',
      [
        'label' => esc_html__( 'رنگ خط زیر آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .megamenu-three-heading::before' => 'background-color: {{VALUE}}',
        ],
      ]
    ); 

        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'ctxtboldtypomegamenuthreekaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان بولد', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-three-heading .detail .title b',
          ]
        );
        $this->add_control(
          'ctext1boldcolormegamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ عنوان بولد', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three-heading .detail .title b' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'ctxttypomegamenuthreekaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-three-heading .detail .title',
          ]
        );
        $this->add_control(
          'ctext1colormegamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three-heading .detail .title' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'ctxt2typomegamenuthreekaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-three-heading .detail .sub-title',
          ]
        );
        $this->add_control(
          'ctext2colormegamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three-heading .detail .sub-title' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'cbf2colormegamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ خط زیر عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three-heading::after' => 'background-image: linear-gradient(-90deg, {{VALUE}} -2.07%, rgba(240, 240, 240, 0) 105.3%)',
            ],
          ]
        ); 
        
        $this->add_control(
          'hr2megamenuthreekaveh',
          [
            'type' => \Elementor\Controls_Manager::DIVIDER,
          ]
        );
        $this->add_control(
          'cbeforetext1colormegamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ آیکون عنوان اصلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .navs .titr::before' => 'background-image: linear-gradient(261.58deg, {{VALUE}} -219.92%, rgba(160, 160, 160, 0) 83.54%)',
            ],
          ]
        ); 
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'colmaint2megamenuthreekaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان اصلی منوها', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-three .navs .titr',
          ]
        );
        $this->add_control(
          'colmaintity2prmegamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ عنوان اصلی منوها', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .navs .titr' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'colmfint2megamenuthreekaveh',
            'label' => esc_html__( 'تایپوگرافی زیر منوها', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-three .navs ul li .title',
          ]
        );
        $this->add_control(
          'colmfintity2prmegamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ زیر منوها', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .navs ul li .title' => 'color: {{VALUE}}',
              '{{WRAPPER}} .megamenu-three .navs ul li::before' => 'border: 0.75px solid {{VALUE}}',
              '{{WRAPPER}} .megamenu-three .navs ul li .quantity' => 'color: {{VALUE}}',

            ],
          ]
        ); 
        $this->add_control(
          'scrolbartabcboxes1hrcolormegamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه اسکرولبار', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .navs::-webkit-scrollbar' => 'background-color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'scrolbarthumbtabcboxes1hrcolormegamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ اسکرولبار', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .navs::-webkit-scrollbar-thumb' => 'background-color: {{VALUE}}',
            ],
          ]
        ); 
        $this->end_controls_section();
        $this->start_controls_section(
          'style4megamenuthreekaveh',
          [
            'label' => esc_html__( 'استایل ستون محصولات', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        );
        $this->add_control(
          'bgproduct1colormegamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه باکس محصولات', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box' => 'background-color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'padding15probt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'فاصله داخلی ستون محصولات', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'bgproductradiusmegamenuthreekaveh',
          [
            'label' => esc_html__( 'گوشه خمیده پس زمینه باکس محصولات', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'dividercolprodmegamenutwokaveh',
          [
            'label' => esc_html__( 'رنگ جدا کننده ستون محصولات', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products::before' => 'background-image:linear-gradient(180deg, rgba(240, 240, 240, 0) -2.07%, {{VALUE}} 105.3%)',
            ],
          ]
        ); 
        $this->add_control(
          'colmaintity2prtmegamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ عنوان محصولات', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box ul li .title' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'colmfintprt2megamenuthreekaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان محصولات', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-three .last-products-box ul li .title',
          ]
        );
        $this->add_control(
          'hr3megamenuthreekaveh',
          [
            'type' => \Elementor\Controls_Manager::DIVIDER,
          ]
        );
        $this->add_control(
          'bgthumbproduct1colormegamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه تصویر محصولات', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box ul li .image' => 'background-color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'bgthumbproductradiusmegamenuthreekaveh',
          [
            'label' => esc_html__( 'گوشه خمیده تصویر محصولات', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box ul li .image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'hr3promegamenuthreekaveh',
          [
            'type' => \Elementor\Controls_Manager::DIVIDER,
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'txttypomainbutprodt1megamenuthreekaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان دکمه', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-three .last-products-box .btn',
          ]
        );
        $this->add_control(
          'bficonsize5prodt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'سایز آیکون دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
            ],
            'default' => [
              'unit' => 'px',
              'size' => 10,
            ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->start_controls_tabs(
          'style_tabs5prodt1megamenuthreekaveh'
        );
        $this->start_controls_tab(
          'style_normal_tab5prodt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'عادی', 'kaveh-core' ),
          ]
        );
        $this->add_control(
          'text1color5prodt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ عنوان دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box .btn' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'iconbuttoncolor5prodt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ آیکون دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box .btn i' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'buttoncolor5prodt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box .btn' => 'background-color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'buttonradius5prodt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Border::get_type(),
          [
            'name' => 'border5prodt1megamenuthreekaveh',
            'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-three .last-products-box .btn',
          ]
        );
        $this->add_control(
          'buttonborders5prodt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'condition' => [
              'border5prodt1megamenuthreekaveh!' => '',
            ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ],
          ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
          'style_hove_tab5prodt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'هاور', 'kaveh-core' ),
          ]
        );
        $this->add_control(
          'text1colorhover5prodt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ عنوان دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box .btn:hover' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'iconbuttoncolorhover5prodt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ آیکون دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box .btn:hover i' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'buttoncolorhover5prodt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box .btn:hover' => 'background-color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'buttonradiushover5prodt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Border::get_type(),
          [
            'name' => 'borderhover5prodt1megamenuthreekaveh',
            'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-three .last-products-box .btn:hover',
          ]
        );
        $this->add_control(
          'buttonbordershover5prodt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'condition' => [
              'borderhover5prodt1megamenuthreekaveh!' => '',
            ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ],
          ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
          'hr5prodt1megamenuthreekaveh',
          [
            'type' => \Elementor\Controls_Manager::DIVIDER,
          ]
        );
        
        $this->add_group_control(
          \Elementor\Group_Control_Box_Shadow::get_type(),
          [
            'name' => 'box_shadow5prodt1megamenuthreekaveh',
            'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-three .last-products-box .btn',
          ]
        );
        $this->add_control(
          'buttonpadding15prodt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-three .last-products-box .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
          'style5megamenuthreekaveh',
          [
            'label' => esc_html__( 'استایل عمومی مگامنو', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        );
        $this->add_control(
          'megamenubgcprodt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه مگامنو', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-three-wrapper' => 'background-color: {{VALUE}} !important',
            ],
          ]
        ); 
        $this->add_control(
          'megamenubgpt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'فاصله داخلی مگامنو', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-three-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'megamenubgpadddtprodt1megamenuthreekaveh',
          [
            'label' => esc_html__( 'گوشه خمیده مگامنو', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-three-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->end_controls_section();

        }
 


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
  
?>
    <section class="megamenu-three">
      <div class="container">
        <div class="megamenu-three-wrapper d-flex bg-white h-100 overflow-hidden">
          <!-- Start Tabs -->
          <div class="megamenu-three-tabs w-100">
            <ul class="w-100">
            <?php $tabco=(int)$settings['tabcountmegamenuthreekaveh'];
              for($a=1;$a <= $tabco; $a++ ){ 
            ?>
              <li class="d-flex align-items-center position-relative <?php if($a==1){ ?>active<?php } ?>" data-tab="#tab-<?php echo $a . $clsid; ?>">
                <i class="<?php echo  esc_attr($settings['icon'.$a.'megamenuthreekaveh']['value']); ?> d-flex align-items-center justify-content-center me-2"></i>
                <div class="detail">
                  <div class="title mb-1">
                    <b> <?php echo  esc_html($settings['boldtitle'.$a.'megamenuthreekaveh']); ?> </b> <?php echo  esc_html($settings['title'.$a.'megamenuthreekaveh']); ?>
                  </div>
                  <div class="sub-title"> <?php echo  esc_html($settings['title2'.$a.'megamenuthreekaveh']); ?></div>
                </div>
              </li>
              <?php }?>
              
            </ul>
          </div>
          <!-- End Tabs -->
          <!-- Start Tab Contents -->
          <div class="megamenu-three-tab-contents w-100">
          <?php $tabco=$settings['tabcountmegamenuthreekaveh'];?>
          <?php $a=1; for($a=1;$a <= $tabco;$a++){ ?>
            <!-- Start Tab Content -->
            <div id="tab-<?php echo $a . $clsid; ?>" class="megamenu-three-tab-content w-100 <?php if($a==1){ ?>active<?php } ?> h-100">
              <div class="content w-100 h-100">
                <div class="megamenu-three-heading position-relative d-flex align-items-center">
                  <a href="<?php echo  esc_url($settings['titlemlink2'.$a.'megamenuthreekaveh']); ?>" class="stretched-link" aria-label="link"></a>
                  <i class="<?php echo  esc_attr($settings['iconm'.$a.'megamenuthreekaveh']['value']); ?> d-flex align-items-center justify-content-center me-2"></i>
                  <div class="detail">
                    <div class="title mb-1">
                      <b> <?php echo  esc_html($settings['boldtitlem'.$a.'megamenuthreekaveh']); ?></b>
                      <?php echo  esc_html($settings['titlem'.$a.'megamenuthreekaveh']); ?>
                    </div>
                    <div class="sub-title">
                    <?php echo  esc_html($settings['titlem2'.$a.'megamenuthreekaveh']); ?>
                      <i class="icon-arrow-left"></i>
                    </div>
                  </div>
                </div>
                <div class="navs d-flex justify-content-between h-100">
                  <div class="col <?php if("1"!==$settings['imgshows'.$a.'megamenuthreekaveh']){?>col25 <?php } ?>">
                    <ul>
                      <?php
                      if ( $settings['listcol'.$a.'megamenuthreekaveh'] ) {
                      foreach (  $settings['listcol'.$a.'megamenuthreekaveh'] as $item ) {
                      ?>
                      <?php if("yes"===$item['col1activetitle'.$a.'megamenuthreekaveh']){?>
                      <div class="titr position-relative"><a href="<?php echo  esc_html($item['col1link'.$a.'megamenuthreekaveh']); ?>">  <?php echo  esc_html($item['col1title'.$a.'megamenuthreekaveh']); ?> </a></div>
                      <?php }else{ ?>
                      <?php if(!empty($item['col1title'.$a.'megamenuthreekaveh'])): ?>
                        <li class="position-relative">
                          <a href="<?php echo  esc_html($item['col1link'.$a.'megamenuthreekaveh']); ?>" class="stretched-link" aria-label="category"></a>
                          <div class="title mb-1">  <?php echo  esc_html($item['col1title'.$a.'megamenuthreekaveh']); ?> </div>
                          <div class="quantity">
                          <?php echo  esc_html($item['col1title2'.$a.'megamenuthreekaveh']); ?>
                            <i class="icon-arrow-left"></i>
                        </div>
                      </li>
                      <?php endif; ?>  
                      <?php } ?>
                      <?php
                      }
                    }
                    ?>
                    </ul>
                  </div>
                  <div class="col <?php if("1"!==$settings['imgshows'.$a.'megamenuthreekaveh']){?>col25 <?php } ?>">
                    <ul>
                        <?php
                        if ( $settings['listcol2'.$a.'megamenuthreekaveh'] ) {
                        foreach (  $settings['listcol2'.$a.'megamenuthreekaveh'] as $item ) {
                        ?>
                        <?php if("yes"===$item['col2activetitle'.$a.'megamenuthreekaveh']){?>
                        <div class="titr position-relative"><a href="<?php echo  esc_html($item['col2link'.$a.'megamenuthreekaveh']); ?>">  <?php echo  esc_html($item['col2title'.$a.'megamenuthreekaveh']); ?> </a></div>
                        <?php }else{ ?>
                        <?php if(!empty($item['col2title'.$a.'megamenuthreekaveh'])): ?>
                          <li class="position-relative">
                          <a href="<?php echo  esc_html($item['col2link'.$a.'megamenuthreekaveh']); ?>" class="stretched-link" aria-label="category"></a>
                          <div class="title mb-1">  <?php echo  esc_html($item['col2title'.$a.'megamenuthreekaveh']); ?> </div>
                          <div class="quantity">
                          <?php echo  esc_html($item['col2title2'.$a.'megamenuthreekaveh']); ?>
                            <i class="icon-arrow-left"></i>
                        </li>
                        <?php endif; ?>

                        <?php } ?>
                        <?php
                        }
                      }
                      ?>
                    </ul>
                  </div>
                  <div class="col <?php if("1"!==$settings['imgshows'.$a.'megamenuthreekaveh']){?>col25 <?php } ?>">
                    <ul>
                        <?php
                        if ( $settings['listcol3'.$a.'megamenuthreekaveh'] ) {
                        foreach (  $settings['listcol3'.$a.'megamenuthreekaveh'] as $item ) {
                        ?>
                        <?php if("yes"===$item['col3activetitle'.$a.'megamenuthreekaveh']){?>
                        <div class="titr position-relative"><a href="<?php echo  esc_html($item['col3link'.$a.'megamenuthreekaveh']); ?>">  <?php echo  esc_html($item['col3title'.$a.'megamenuthreekaveh']); ?> </a></div>
                        <?php }else{ ?>
                        <?php if(!empty($item['col3title'.$a.'megamenuthreekaveh'])): ?>
                          <li class="position-relative">
                          <a href="<?php echo  esc_html($item['col3link'.$a.'megamenuthreekaveh']); ?>" class="stretched-link" aria-label="category"></a>
                          <div class="title mb-1">  <?php echo  esc_html($item['col3title'.$a.'megamenuthreekaveh']); ?> </div>
                          <div class="quantity">
                          <?php echo  esc_html($item['col3title2'.$a.'megamenuthreekaveh']); ?>
                            <i class="icon-arrow-left"></i>
                        </li>
                        <?php endif; ?>

                        <?php } ?>
                        <?php
                        }
                      }
                      ?>
                    </ul>
                  </div>
                  <div class="col <?php if("1"!==$settings['imgshows'.$a.'megamenuthreekaveh']){?>col25 <?php } ?>">
                    <ul>
                        <?php
                        if ( $settings['listcol4'.$a.'megamenuthreekaveh'] ) {
                        foreach (  $settings['listcol4'.$a.'megamenuthreekaveh'] as $item ) {
                        ?>
                         <?php if("yes"===$item['col4activetitle'.$a.'megamenuthreekaveh']){?>
                        <div class="titr position-relative"><a href="<?php echo  esc_html($item['col4link'.$a.'megamenuthreekaveh']); ?>">  <?php echo  esc_html($item['col4title'.$a.'megamenuthreekaveh']); ?> </a></div>
                        <?php }else{ ?>
                          <?php if(!empty($item['col4title'.$a.'megamenuthreekaveh'])): ?>
                            <li class="position-relative">
                          <a href="<?php echo  esc_html($item['col4link'.$a.'megamenuthreekaveh']); ?>" class="stretched-link" aria-label="category"></a>
                          <div class="title mb-1">  <?php echo  esc_html($item['col4title'.$a.'megamenuthreekaveh']); ?> </div>
                          <div class="quantity">
                          <?php echo  esc_html($item['col4title2'.$a.'megamenuthreekaveh']); ?>
                            <i class="icon-arrow-left"></i>
                          </div>
                        </li>
                          <?php endif; ?>

                        <?php } ?>
                        <?php
                        }
                      }
                      ?>
                    </ul>
                  </div>
                  <?php if("1"===$settings['imgshows'.$a.'megamenuthreekaveh']){?>
                  <div class="col">
                    <ul>
                        <?php
                        if ( $settings['listcol5'.$a.'megamenuthreekaveh'] ) {
                        foreach (  $settings['listcol5'.$a.'megamenuthreekaveh'] as $item ) {
                        ?>
                         <?php if("yes"===$item['col5activetitle'.$a.'megamenuthreekaveh']){?>
                        <div class="titr position-relative"><a href="<?php echo  esc_html($item['col5link'.$a.'megamenuthreekaveh']); ?>">  <?php echo  esc_html($item['col5title'.$a.'megamenuthreekaveh']); ?> </a></div>
                        <?php }else{ ?>
                        <?php if(!empty($item['col5title'.$a.'megamenuthreekaveh'])): ?>
                          <li class="position-relative">
                          <a href="<?php echo  esc_html($item['col5link'.$a.'megamenuthreekaveh']); ?>" class="stretched-link" aria-label="category"></a>
                          <div class="title mb-1">  <?php echo  esc_html($item['col5title'.$a.'megamenuthreekaveh']); ?> </div>
                          <div class="quantity">
                          <?php echo  esc_html($item['col5title2'.$a.'megamenuthreekaveh']); ?>
                            <i class="icon-arrow-left"></i>
                        </li>
                        <?php endif; ?>

                        <?php } ?>
                        <?php
                        }
                      }
                      ?>
                    </ul>
                    </div>
                  </div>
                  <?php }elseif("2"===$settings['imgshows'.$a.'megamenuthreekaveh']){?>
                  </div>
                  </div>
                  <div class="last-products w-100 position-relative">
                <div class="megamenu-three-heading position-relative d-flex align-items-center">
                  <a href="<?php echo  esc_url($settings['linktitlecol5'.$a.'megamenuthreekaveh']); ?>" class="stretched-link" aria-label="link"></a>
                  <i class="<?php echo  esc_attr($settings['icond'.$a.'megamenuthreekaveh']['value']); ?> d-flex align-items-center justify-content-center me-2"></i>
                  <div class="detail">
                    <div class="title mb-1">
                      <b> <?php echo  esc_html($settings['boldtitled'.$a.'megamenuthreekaveh']); ?></b>
                      <?php echo  esc_html($settings['titled'.$a.'megamenuthreekaveh']); ?>
                    </div>
                    <div class="sub-title">
                    <?php echo  esc_html($settings['titled2'.$a.'megamenuthreekaveh']); ?>
                      <i class="icon-arrow-left"></i>
                    </div>
                  </div>
                </div>

                <div class="last-products-box">
                    <ul>
                      <?php 
                      // Define your custom query arguments
                      $query_args = array(
                        'post_type' => array('product'),
'post_status' => array('publish'),
                        'posts_per_page' => $settings['productnumber'.$a.'megamenuthreekaveh'],
                        'order' => 'desc',
                        'orderby' => 'date',
                        'tax_query' => array(
                        'relation' => 'AND',
                        array(
                            'taxonomy' => 'product_cat',
                            'field'    => 'term_id',
                            'terms'    => $settings['cat1col4'.$a.'megamenuthreekaveh'],
                            ),
                        ),
                      );
                      // Get the cached query results
                      $cached_query = KavehCustomQuery::get_cached_query($query_args);
                      if ($cached_query->have_posts()) :
                          while ($cached_query->have_posts()) : $cached_query->the_post();
                          ?>
                          <li class="position-relative d-flex align-items-center">
                          <a href="<?php the_permalink(); ?>" class="stretched-link" aria-label="<?php the_title(); ?>"></a>
                          <div class="image d-flex align-items-center justify-content-center">
                              <img src="<?php if(get_the_post_thumbnail_url()): ?>
                              <?php the_post_thumbnail_url('full'); ?>
                              <?php else: ?>
                              <?php echo wc_placeholder_img_src(); ?>
                              <?php endif; ?>" alt="<?php the_title(); ?>" width="31" height="29">
                          </div>
                          <h2 class="title overflow-hidden ms-2 mb-0 fw-bold"><?php echo wp_trim_words(get_the_title(),5); ?></h2>
                          </li>
                          <?php
                          endwhile;
                          wp_reset_postdata();
                      else :
                          echo 'No posts found.';
                      endif;
                      ?>

                    </ul>
                    <a href="<?php echo esc_url($settings['col5buttonlink'.$a.'megamenuthreekaveh']); ?>" class="btn btn-outline-default d-flex align-items-center justify-content-center mt-4">
                    <?php echo  esc_html($settings['col5buttontitle'.$a.'megamenuthreekaveh']); ?>
                        <i class="<?php echo  esc_html($settings['iconcol5'.$a.'megamenuthreekaveh']['value']); ?> ms-1"></i>
                    </a>
                    </div>
                 <?php }elseif("3"===$settings['imgshows'.$a.'megamenuthreekaveh']){?>
                    </div>
                    </div>

                    <div class="last-products last-products-two w-100 position-relative">
                            <div class="megamenu-three-heading position-relative d-flex align-items-center">
                            <a href="<?php echo  esc_url($settings['linktitlecol5'.$a.'megamenuthreekaveh']); ?>" class="stretched-link" aria-label="link"></a>
                            <i class="<?php echo  esc_attr($settings['icond'.$a.'megamenuthreekaveh']['value']); ?> d-flex align-items-center justify-content-center me-2"></i>
                            <div class="detail">
                                <div class="title mb-1">
                                <b> <?php echo  esc_html($settings['boldtitled'.$a.'megamenuthreekaveh']); ?></b>
                                <?php echo  esc_html($settings['titled'.$a.'megamenuthreekaveh']); ?>
                                </div>
                                <div class="sub-title">
                                <?php echo  esc_html($settings['titled2'.$a.'megamenuthreekaveh']); ?>
                                <i class="icon-arrow-left"></i>
                                </div>
                            </div>
                            </div>

                        <div class="last-products-box">
                        <ul>
                        <?php 
                      // Define your custom query arguments
                      $query_args = array(
                        'post_type' => array('product'),
'post_status' => array('publish'),
                        'posts_per_page' => $settings['productnumber'.$a.'megamenuthreekaveh'],
                        'order' => 'desc',
                        'orderby' => 'date',
                        'tax_query' => array(
                        'relation' => 'AND',
                        array(
                            'taxonomy' => 'product_cat',
                            'field'    => 'term_id',
                            'terms'    => $settings['cat1col4'.$a.'megamenuthreekaveh'],
                            ),
                        ),
                      );
                      // Get the cached query results
                      $cached_query = KavehCustomQuery::get_cached_query($query_args);
                      if ($cached_query->have_posts()) :
                          while ($cached_query->have_posts()) : $cached_query->the_post();
                          ?>
                          <li class="position-relative d-flex align-items-center">
                          <a href="<?php the_permalink(); ?>" class="stretched-link" aria-label="<?php the_title(); ?>"></a>
                          <div class="image d-flex align-items-center justify-content-center">
                              <img src="<?php if(get_the_post_thumbnail_url()): ?>
                              <?php the_post_thumbnail_url('full'); ?>
                              <?php else: ?>
                              <?php echo wc_placeholder_img_src(); ?>
                              <?php endif; ?>" alt="<?php the_title(); ?>" width="31" height="29">
                          </div>
                          <h2 class="title overflow-hidden ms-2 mb-0 fw-bold"><?php echo wp_trim_words(get_the_title(),5); ?></h2>
                          </li>
                          <?php
                          endwhile;
                          wp_reset_postdata();
                      else :
                          echo 'No posts found.';
                      endif;
                      ?>
                        </ul>
                        <a href="<?php echo  esc_url($settings['col5buttonlink'.$a.'megamenuthreekaveh']); ?>" class="btn btn-outline-default d-flex align-items-center justify-content-center mt-4">
                        <?php echo  esc_html($settings['col5buttontitle'.$a.'megamenuthreekaveh']); ?>
                        <i class="<?php echo  esc_html($settings['iconcol5'.$a.'megamenuthreekaveh']['value']); ?> ms-1"></i>
                        </a>
                        </div>
                   <?php }elseif("4"===$settings['imgshows'.$a.'megamenuthreekaveh']){?>
                    </div>
                    </div>

                    <div class="last-products last-products-three w-100 position-relative">
                            <div class="megamenu-three-heading position-relative d-flex align-items-center">
                            <a href="<?php echo  esc_url($settings['linktitlecol5'.$a.'megamenuthreekaveh']); ?>" class="stretched-link" aria-label="link"></a>
                            <i class="<?php echo  esc_attr($settings['icond'.$a.'megamenuthreekaveh']['value']); ?> d-flex align-items-center justify-content-center me-2"></i>
                            <div class="detail">
                                <div class="title mb-1">
                                <b> <?php echo  esc_html($settings['boldtitled'.$a.'megamenuthreekaveh']); ?></b>
                                <?php echo  esc_html($settings['titled'.$a.'megamenuthreekaveh']); ?>
                                </div>
                                <div class="sub-title">
                                <?php echo  esc_html($settings['titled2'.$a.'megamenuthreekaveh']); ?>
                                <i class="icon-arrow-left"></i>
                                </div>
                            </div>
                            </div>

                        <div class="last-products-box">
                        <ul>
                        <?php 
                      // Define your custom query arguments
                      $query_args = array(
                        'post_type' => array('product'),
'post_status' => array('publish'),
                        'posts_per_page' => $settings['productnumber'.$a.'megamenuthreekaveh'],
                        'order' => 'desc',
                        'orderby' => 'date',
                        'tax_query' => array(
                        'relation' => 'AND',
                        array(
                            'taxonomy' => 'product_cat',
                            'field'    => 'term_id',
                            'terms'    => $settings['cat1col4'.$a.'megamenuthreekaveh'],
                            ),
                        ),
                      );
                      // Get the cached query results
                      $cached_query = KavehCustomQuery::get_cached_query($query_args);
                      if ($cached_query->have_posts()) :
                          while ($cached_query->have_posts()) : $cached_query->the_post();
                          ?>
                          <li class="position-relative d-flex align-items-center">
                          <a href="<?php the_permalink(); ?>" class="stretched-link" aria-label="<?php the_title(); ?>"></a>
                          <div class="image d-flex align-items-center justify-content-center">
                              <img src="<?php if(get_the_post_thumbnail_url()): ?>
                              <?php the_post_thumbnail_url('full'); ?>
                              <?php else: ?>
                              <?php echo wc_placeholder_img_src(); ?>
                              <?php endif; ?>" alt="<?php the_title(); ?>" width="31" height="29">
                          </div>
                          <h2 class="title overflow-hidden ms-2 mb-0 fw-bold"><?php echo wp_trim_words(get_the_title(),5); ?></h2>
                          </li>
                          <?php
                          endwhile;
                          wp_reset_postdata();
                      else :
                          echo 'No posts found.';
                      endif;
                      ?>
                        </ul>
                        <a href="<?php echo  esc_url($settings['col5buttonlink'.$a.'megamenuthreekaveh']); ?>" class="btn btn-outline-default d-flex align-items-center justify-content-center mt-4">
                        <?php echo  esc_html($settings['col5buttontitle'.$a.'megamenuthreekaveh']); ?>
                        <i class="<?php echo  esc_html($settings['iconcol5'.$a.'megamenuthreekaveh']['value']); ?> ms-1"></i>
                        </a>
                        </div>
                 <?php } ?>
              </div>
            </div>
            <!-- End Tab Content -->
            <?php } ?>

          </div>
          <!-- End Tab Contents -->
        </div>
      </div>
    </section>
           <?php if( \Elementor\Plugin::$instance->editor->is_edit_mode() ) : ?>
            <style>
  .megamenu-three {
    transform: unset !important;
    z-index: 99 !important;
}
.megamenu {
    transform: unset!important;
    z-index: 99 !important;
}
</style>
<?php if( \Elementor\Plugin::$instance->editor->is_edit_mode() ) : ?> 
<script> 
    function init<?php echo $clsid; ?>() {
    // Mega Menu Three
    const megamenuThreeTabs = document.querySelectorAll(
      ".megamenu-three-tabs ul li"
    );

    if (megamenuThreeTabs.length > 0) {
      megamenuThreeTabs.forEach((tab) => {
        tab.addEventListener("mouseover", (ev) => {
          const el = ev.currentTarget,
            id = el.dataset.tab,
            content = document.querySelector(id);

          if (content) {
            [...el.parentElement.children].map((tabItem) => {
              const contentItem = document.querySelector(tabItem.dataset.tab);

              if (contentItem) {
                contentItem.classList.remove("active");
                tabItem.classList.remove("active");
              }
            });

            el.classList.add("active");

            content.classList.add("active");
            content.style.opacity = "0.5";

            setTimeout(() => {
              content.style.opacity = 1;
            }, 5);
          }
        });
      });
    }
  }
    if (window.Swiper) {
      // Swiper library already loaded, initialize Swiper instance
      init<?php echo $clsid; ?>();
    } else {
      // Swiper library not yet loaded, wait for it to load
      window.addEventListener("load", function() {
        init<?php echo $clsid; ?>();
      });
    }
</script>
<?php endif; ?>
<?php endif; ?>
<style>
.megamenu-three .last-products-three .last-products-box {
  -webkit-background-size: cover !important;
    -moz-background-size: cover !important;
    -o-background-size: cover !important;
    background-size: cover !important;
}
.boostify-menu .megamenu-three a {
    line-height: unset;
    display: unset;
}
</style>
    <?php
  }


}
