<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Logoupkaveh extends Widget_Base{

  public function get_name(){
    return 'kavehlogoup';
  }

  public function get_title(){
    return esc_html__( 'المان لوگو کاوه', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['headerfooterkavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
			'style_kavehlogoup',
			[
				'label' => esc_html__( 'Style Section', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'logo-sizekavehlogoup',
			[
				'type' => \Elementor\Controls_Manager::SLIDER,
				'label' => esc_html__( 'سایز لوگو', 'textdomain' ),
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 160,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 150,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 140,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .kavehlogost' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
          
  }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $options = get_option( 'kaveh_frame' );
    
    ?>
    <a href="<?php echo site_url(); ?>"><img class="kavehlogost" src="<?php echo $options['kaveh_logo_up']; ?>"></a>
    <?php
  }
}
