<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Loginandsignupkaveh extends Widget_Base{

  public function get_name(){
    return 'loginandsignupkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان حساب کاربری', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['headerfooterkavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentloginandsignupkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'styleboxloginandsignupkaveh',
        [
          'label' => esc_html__( 'طرح بندی المان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
            'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
            'four'  => esc_html__( 'طرح بندی چهار', 'kaveh-core' ),
            'five'  => esc_html__( 'طرح بندی پنج', 'kaveh-core' ),
            'six'  => esc_html__( 'طرح بندی ششم', 'kaveh-core' ),
            'seven'  => esc_html__( 'طرح بندی هفتم', 'kaveh-core' ),

          ],
        ]
        ); 
      $this->add_control(
          'titleloginandsignupkaveh',
          [
              'label' => esc_html__( 'متن', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'ورود/ثبت نام', 'kaveh-core' ),
              'condition' => [
                'styleboxloginandsignupkaveh!' => ['four','five'],
              ],
      
          ]
      ); 
      $this->add_control(
        'title2loginandsignupkaveh',
        [
            'label' => esc_html__( 'متن نگهدارنده سرج', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'جستجو...', 'kaveh-core' ),
            'condition' => [
              'styleboxloginandsignupkaveh' =>'three',
            ],

    
        ]
    ); 
    $this->add_control(
      'iconele4loginandsignupkave',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'condition' => [
          'styleboxloginandsignupkaveh' => ['four','five'],
        ],
        'default' => [
          'value' => 'icon-user-circle',
          'library' => 'fa-solid',
        ],
      ]
    );
      $this->add_control(
        'showiconbeforeloginandsignupkaveh',
        [
          'label' => esc_html__( 'نمایش آیکون قبل از نوشته؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' => 'one',
          ],
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
          $this->add_control(
            'iconeleloginandsignupkave',
            [
              'label' => esc_html__( 'آیکون', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::ICONS,
              'skin' => 'inline',
              'exclude_inline_options' => [ 'svg' ],
              'condition' => [
                'showiconbeforeloginandsignupkaveh' => 'yes',
                'styleboxloginandsignupkaveh' => 'one',
              ],
              'default' => [
                'value' => 'icon-user-circle',
                'library' => 'fa-solid',
              ],
            ]
          );
          $this->add_control(
            'showiconafterloginandsignupkaveh',
            [
              'label' => esc_html__( 'نمایش آیکون بعد از نوشته؟', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'yes' => esc_html__( 'بله', 'kaveh-core' ),
              'no' => esc_html__( 'خیر', 'kaveh-core' ),
              'condition' => [
                'styleboxloginandsignupkaveh' => ['one', 'two'],
              ],
              'return_value' => 'yes',
              'default' => 'yes',
            ]
          );
              $this->add_control(
                'iconeleafterloginandsignupkave',
                [
                  'label' => esc_html__( 'Icon', 'kaveh-core' ),
                  'type' => \Elementor\Controls_Manager::ICONS,
                  'skin' => 'inline',
                  'exclude_inline_options' => [ 'svg' ],
                  'condition' => [
                    'showiconafterloginandsignupkaveh' => 'yes',
                    'styleboxloginandsignupkaveh' => ['one', 'two','seven'],

                  ],
                  'default' => [
                    'value' => 'icon-angle-left',
                    'library' => 'fa-solid',
                  ],
                ]
              );
              $this->add_control(
                'styleulloginandsignupkave',
                [
                  'label' => esc_html__( 'جهت باز شدن زیرمنو ها', 'kaveh-core' ),
                  'type' => \Elementor\Controls_Manager::SELECT,
                  'default' => 'right',
                  'condition' => [
                    'styleboxloginandsignupkaveh' =>['six'],
                  ],
                  'options' => [
                    'right'  => esc_html__( 'راست', 'kaveh-core' ),
                    'left'  => esc_html__( 'چپ', 'kaveh-core' ),
                  ],
                ]
                );
                $this->add_control(
                  'element_loginandsignupkave',
                  [
                    'label' => esc_html__( 'چیدمان المان', 'kaveh-core' ),
                    'type' => \Elementor\Controls_Manager::CHOOSE,
                    'options' => [
                      'left' => [
                        'title' => esc_html__( 'چپ چین', 'kaveh-core' ),
                        'icon' => 'eicon-text-align-left',
                      ],
                      'center' => [
                        'title' => esc_html__( 'وسط چین', 'kaveh-core' ),
                        'icon' => 'eicon-text-align-center',
                      ],
                      'right' => [
                        'title' => esc_html__( 'راست چین', 'kaveh-core' ),
                        'icon' => 'eicon-text-align-right',
                      ],
                    ],
                    'toggle' => true,
                  ]
                );
       $this->end_controls_section();
       $this->start_controls_section(
        'styleloginandsignupkave',
        [
          'label' => esc_html__( 'استایل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'iconsize11loginandsignupkaveh',
        [
          'label' => esc_html__( 'سایز آیکون قبل از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
            'showiconbeforeloginandsignupkaveh' => 'yes',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 24,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a i:first-child' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_loginandsignupkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),          
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selector' => '{{WRAPPER}} .top-header-auth > a',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button2_loginandsignupkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),          
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'selector' => '{{WRAPPER}} .top-header-eight .top-header-auth > a',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button3_loginandsignupkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),          
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selector' => '{{WRAPPER}} .top-header-nine .top-header-auth > a',
        ]
      );
      $this->add_control(
        'iconsize12loginandsignupkaveh',
        [
          'label' => esc_html__( 'سایز آیکون بعد از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
            'showiconafterloginandsignupkaveh' => 'yes',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 11,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a i:last-child' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconsize2loginandsignupkaveh',
        [
          'label' => esc_html__( 'سایز آیکون بعد از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
            'showiconafterloginandsignupkaveh' => 'yes',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 11,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconsize3loginandsignupkaveh',
        [
          'label' => esc_html__( 'سایز آیکون بعد از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 16,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-four-btn-search' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconsize4loginandsignupkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'four',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 28,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-twelve .top-header-auth > a i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconsize5loginandsignupkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 22,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'width1loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 174,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'width3loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض بخش نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 126,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'width31loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 172,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'width5loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 50,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'height1loginandsignupkaveh',
        [
          'label' => esc_html__( 'ارتفاع دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 50,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'height3loginandsignupkaveh',
        [
          'label' => esc_html__( 'ارتفاع دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 40,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'height5loginandsignupkaveh',
        [
          'label' => esc_html__( 'ارتفاع دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 68,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabsloginandsignupkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabloginandsignupkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
        ]
      );
      $this->add_control(
        'icon11buttoncolorloginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون قبل از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
            'showiconbeforeloginandsignupkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a i:first-child' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbuttoncolorloginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'icon12buttoncolorloginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون بعد از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
            'showiconafterloginandsignupkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a i:last-child' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorloginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusloginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده  ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderloginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selector' => '{{WRAPPER}} .top-header-auth > a',
        ]
      );
      $this->add_control(
        'buttonbordersloginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderloginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabloginandsignupkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
        ]
      );
      $this->add_control(
        'icon11buttonhovercolorloginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون قبل از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
            'showiconbeforeloginandsignupkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a:hover i:first-child' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbuttoncolorhoverloginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'icon12buttonhovercolorloginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون بعد از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
            'showiconafterloginandsignupkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a:hover i:last-child' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverloginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoverloginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverloginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selector' => '{{WRAPPER}} .top-header-auth > a:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverloginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoverloginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrerloginandsignupkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow1loginandsignupkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selector' => '{{WRAPPER}} .top-header-auth > a',
        ]
      );



      $this->start_controls_tabs(
        'style_tabs2loginandsignupkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab2loginandsignupkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
        ]
      );
      $this->add_control(
        'textbuttoncolor2loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'icon12buttoncolor2loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون بعد از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
            'showiconafterloginandsignupkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolor21loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ اول پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolor22loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ دوم پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradius2loginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده  ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border2loginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'selector' => '{{WRAPPER}} .top-header-eight .top-header-auth > a',
        ]
      );
      $this->add_control(
        'buttonborders2loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border2loginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab2loginandsignupkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
        ]
      );
      $this->add_control(
        'textbuttoncolorhover2loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'icon12buttonhovercolor2loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون بعد از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
            'showiconafterloginandsignupkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhover21loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ اول پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhover22loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ دوم پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushover2loginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده  ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhover2loginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'selector' => '{{WRAPPER}} .top-header-eight .top-header-auth > a:hover',
        ]
      );
      $this->add_control(
        'buttonbordershover2loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhover2loginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer2loginandsignupkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow12loginandsignupkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'selector' => '{{WRAPPER}} .top-header-eight .top-header-auth > a',
        ]
      );
      $this->add_control(
        'buttonpadding2loginandsignupkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabs3loginandsignupkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab3loginandsignupkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
        ]
      );
      $this->add_control(
        'textbuttoncolor3loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolor211loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'icon12buttoncolor3loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-four-btn-search' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      
      $this->add_control(
        'buttoncolor23loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine-auth-search' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolor24loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradius3loginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'buttonradius32loginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine-auth-search' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border3loginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selector' => '{{WRAPPER}} .top-header-nine-auth-search',
        ]
      );
      $this->add_control(
        'buttonborders3loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border3loginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine-auth-search' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab3loginandsignupkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
        ]
      );
      $this->add_control(
        'textbuttoncolorhover3loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'icon12buttonhovercolor3loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-four-btn-search:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhover23loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine-auth-search:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhover211loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ  پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushover3loginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'buttonradius32hoverloginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine-auth-search:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhover3loginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selector' => '{{WRAPPER}} .top-header-nine-auth-search:hover',
        ]
      );
      $this->add_control(
        'buttonbordershover3loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhover3loginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine-auth-search:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer3loginandsignupkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow13loginandsignupkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selector' => '{{WRAPPER}} .top-header-nine-auth-search',
        ]
      );
      $this->start_controls_tabs(
        'style_tabs4loginandsignupkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab4loginandsignupkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'four',
          ],
        ]
      );
      $this->add_control(
        'icon12buttoncolor4loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-twelve .top-header-auth > a i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab4loginandsignupkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'four',
          ],
        ]
      );
      $this->add_control(
        'icon12buttonhovercolor4loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-twelve .top-header-auth > a:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer4loginandsignupkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'four',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow14loginandsignupkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'four',
          ],
          'selector' => '{{WRAPPER}} .top-header-twelve .top-header-auth > a',
        ]
      );
      $this->start_controls_tabs(
        'style_tabs5loginandsignupkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab5loginandsignupkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
        ]
      );
      $this->add_control(
        'icon12buttoncolor5loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      
      $this->add_control(
        'buttoncolor25loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradius5loginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border5loginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selector' => '{{WRAPPER}} .top-header-fourteen .top-header-auth > a',
        ]
      );
      $this->add_control(
        'buttonborders5loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border5loginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab5loginandsignupkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
        ]
      );
      $this->add_control(
        'icon12buttonhovercolor5loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhover25loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushover5loginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhover5loginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selector' => '{{WRAPPER}} .top-header-fourteen .top-header-auth > a:hover',
        ]
      );
      $this->add_control(
        'buttonbordershover5loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhover5loginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer5loginandsignupkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow15loginandsignupkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selector' => '{{WRAPPER}} .top-header-fourteen .top-header-auth > a',
        ]
      );
      $this->add_control(
        'width6loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'six',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 45,
          ],
          'selectors' => [
            '{{WRAPPER}} .auth-avatar img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'height6loginandsignupkaveh',
        [
          'label' => esc_html__( 'ارتفاع دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'six',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 45,
          ],
          'selectors' => [
            '{{WRAPPER}} .auth-avatar img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'buttonradius6loginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده  ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'six',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .auth-avatar img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow6loginandsignupkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'six',
          ],
          'selector' => '{{WRAPPER}} .auth-avatar img',
        ]
      );
      $this->add_control(
        'iconsize7loginandsignupkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-auth > .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
        $this->add_control(
        'iconbefore7loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ خط زیر آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-auth > .btn span::after' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconafter7loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ نقطه کنار آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-auth > .btn span::before' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'hrer7loginandsignupkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
        ]
      ); 
      $this->add_control(
        'ticacolor7loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ متن', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-auth > .btn' => 'color: {{VALUE}} !important',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'ticarttype7loginandsignupkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
          'selector' => '{{WRAPPER}} .header-three-auth > .btn',
        ]
      );
      $this->start_controls_tabs(
        'style_tabs7loginandsignupkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab7loginandsignupkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
        ]
      );
      $this->add_control(
        'iconcolor7loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-auth > .btn i' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbgbut7loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-auth > .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius7loginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .header-three-auth > .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border7loginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
          'selector' => '{{WRAPPER}} .header-three-auth > .btn',
        ]
      );
      $this->add_control(
        'buttonborders7loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border7loginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'seven',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-auth > .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab7loginandsignupkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
        ]
      );
      $this->add_control(
        'iconcolor1hover7loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-auth > .btn:hover i' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbgbut1hover7loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-auth > .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradius1hover7loginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .header-three-auth > .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border1hover7loginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
          'selector' => '{{WRAPPER}} .header-three-auth > .btn:hover',
        ]
      );
      $this->add_control(
        'buttonborders1hover7loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border7loginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'seven',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-auth > .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer71cartkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow7loginandsignupkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
          'selector' => '{{WRAPPER}} .header-three-auth > .btn',
        ]
      );
      $this->add_control(
        'button2paddingaboutuskaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'seven',
          ],
          'selectors' => [
            '{{WRAPPER}} .header-three-auth > .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    $options = get_option( 'kaveh_frame' );
  
?>
    <?php if('one'===$settings['styleboxloginandsignupkaveh']){ ?>
      <div class="top-header-auth align-self-center <?php if("right"===$settings['element_loginandsignupkave']){?>float-start<?php }elseif("center"===$settings['element_loginandsignupkave']){?>mx-auto<?php }elseif("left"===$settings['element_loginandsignupkave']){?>float-end<?php } ?>">
          <a <?php if( !is_user_logged_in() && $options['kaveh_login_redirect'] === '1' ): ?> data-auth-toggle="modal" data-auth-target="auth-gajmarket" <?php else: ?> href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"<?php endif; ?> class="btn p-0">
          <?php if('yes'===$settings['showiconbeforeloginandsignupkaveh']){ ?>
            <i class="<?php echo  esc_attr($settings['iconeleloginandsignupkave']['value']); ?>"></i>
            <?php } ?>
            <span><?php if( !is_user_logged_in() ): echo esc_html($settings['titleloginandsignupkaveh']); else: echo 'حساب کاربری من'; endif; ?></span>
            <?php if('yes'===$settings['showiconafterloginandsignupkaveh']){ ?>
            <i class="<?php echo  esc_attr($settings['iconeleafterloginandsignupkave']['value']); ?>"></i>
            <?php } ?>         
           </a>
          <?php if( is_user_logged_in() ): 
          $current_user = wp_get_current_user();  
          $display_name = $current_user->display_name;
          $orders_url = wc_get_endpoint_url( 'orders', '', wc_get_page_permalink( 'myaccount' ) );
          $profile_url = wc_get_endpoint_url( 'edit-account', '', wc_get_page_permalink( 'myaccount' ) );
          $avatar_url = get_avatar_url( wp_get_current_user()->user_email);
          ?>
          <ul class="top-header-auth-dropdown">
            <li>
            <img class="rounded-circle profimg" src="<?php echo $avatar_url; ?>" alt="">
              <?php echo $display_name; ?>
            </li>
            <li>
              <a href="<?php echo $orders_url; ?>"> سفارش ها </a>
            </li>
            <li>
              <a href="<?php echo $profile_url; ?>"> پروفایل کاربری</a>
            </li>
           
            <li>
              <a href="<?php echo wp_logout_url( home_url() ); ?>"> خروج از حساب کاربری </a>
            </li>
          </ul>
          <?php endif; ?>
      </div>
       
    <?php }elseif('two'===$settings['styleboxloginandsignupkaveh']){ ?>
    <div class="top-header-eight">
      <div class="top-header-auth top-header-three-auth ms-sm-auto <?php if("right"===$settings['element_loginandsignupkave']){?>float-start<?php }elseif("center"===$settings['element_loginandsignupkave']){?>mx-auto<?php }elseif("left"===$settings['element_loginandsignupkave']){?>float-end<?php } ?>">
          <a <?php if( !is_user_logged_in() && $options['kaveh_login_redirect'] === '1' ): ?> data-auth-toggle="modal" data-auth-target="auth-gajmarket" <?php else: ?> href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"<?php endif; ?>>
            <span class="d-none d-sm-inline-block"><?php if( !is_user_logged_in() ): echo esc_html($settings['titleloginandsignupkaveh']); else: echo 'حساب کاربری من'; endif; ?></span>
            <?php if('yes'===$settings['showiconafterloginandsignupkaveh']){ ?>
            <i class="<?php echo  esc_attr($settings['iconeleafterloginandsignupkave']['value']); ?> d-none d-sm-inline-block"></i>
            <?php } ?>   
          </a>
          <?php if( is_user_logged_in() ): 
          $current_user = wp_get_current_user();  
          $display_name = $current_user->display_name;
          $orders_url = wc_get_endpoint_url( 'orders', '', wc_get_page_permalink( 'myaccount' ) );
          $profile_url = wc_get_endpoint_url( 'edit-account', '', wc_get_page_permalink( 'myaccount' ) );
          $avatar_url = get_avatar_url( wp_get_current_user()->user_email);
          ?>
          <ul class="top-header-auth-dropdown">
            <li>
            <img class="rounded-circle profimg" src="<?php echo $avatar_url; ?>" alt="">
              <?php echo $display_name; ?>
            </li>
            <li>
              <a href="<?php echo $orders_url; ?>"> سفارش ها </a>
            </li>
            <li>
              <a href="<?php echo $profile_url; ?>"> پروفایل کاربری</a>
            </li>
           
            <li>
              <a href="<?php echo wp_logout_url( home_url() ); ?>"> خروج از حساب کاربری </a>
            </li>
          </ul>
          <?php endif; ?>
        </div>
        </div>
        <style>
          <?php echo '.elementor-element-' . $clsid . ''; ?> .top-header-eight .top-header-auth > a {
          background-image: -webkit-linear-gradient(left, <?php echo  esc_html($settings['buttoncolor21loginandsignupkaveh']); ?>, <?php echo  esc_html($settings['buttoncolor22loginandsignupkaveh']); ?>);
          background-image: -moz-linear-gradient(left, <?php echo  esc_html($settings['buttoncolor21loginandsignupkaveh']); ?>, <?php echo  esc_html($settings['buttoncolor22loginandsignupkaveh']); ?>);
          background-image: -o-linear-gradient(left, <?php echo  esc_html($settings['buttoncolor21loginandsignupkaveh']); ?>, <?php echo  esc_html($settings['buttoncolor22loginandsignupkaveh']); ?>);
          background-image: linear-gradient(to right, <?php echo  esc_html($settings['buttoncolor21loginandsignupkaveh']); ?>, <?php echo  esc_html($settings['buttoncolor22loginandsignupkaveh']); ?>);
          }
          <?php echo '.elementor-element-' . $clsid . ''; ?> .top-header-eight .top-header-auth > a:hover {
          background-image: -webkit-linear-gradient(left, <?php echo  esc_html($settings['buttoncolorhover21loginandsignupkaveh']); ?>, <?php echo  esc_html($settings['buttoncolorhover22loginandsignupkaveh']); ?>);
          background-image: -moz-linear-gradient(left, <?php echo  esc_html($settings['buttoncolorhover21loginandsignupkaveh']); ?>, <?php echo  esc_html($settings['buttoncolorhover22loginandsignupkaveh']); ?>);
          background-image: -o-linear-gradient(left, <?php echo  esc_html($settings['buttoncolorhover21loginandsignupkaveh']); ?>, <?php echo  esc_html($settings['buttoncolorhover22loginandsignupkaveh']); ?>);
          background-image: linear-gradient(to right, <?php echo  esc_html($settings['buttoncolorhover21loginandsignupkaveh']); ?>, <?php echo  esc_html($settings['buttoncolorhover22loginandsignupkaveh']); ?>);
          }
        </style>
    <?php }elseif('three'===$settings['styleboxloginandsignupkaveh']){ ?>
    <div class="top-header-nine <?php if("right"===$settings['element_loginandsignupkave']){?>float-start<?php }elseif("center"===$settings['element_loginandsignupkave']){?>mx-auto<?php }elseif("left"===$settings['element_loginandsignupkave']){?>float-end<?php } ?>">
      <div class="top-header-nine-auth-search d-flex align-items-center ms-auto">
          <div class="top-header-auth ms-sm-auto ms-lg-0">
            <a <?php if( !is_user_logged_in() && $options['kaveh_login_redirect'] === '1' ): ?> data-auth-toggle="modal" data-auth-target="auth-gajmarket" <?php else: ?> href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"<?php endif; ?> class="btn p-0">
              <span><?php if( !is_user_logged_in() ): echo esc_html($settings['titleloginandsignupkaveh']); else: echo 'حساب کاربری من'; endif; ?></span>
              <i class="icon-user-circle d-block d-sm-none m-0"></i>
            </a>
            <?php if( is_user_logged_in() ): 
          $current_user = wp_get_current_user();  
          $display_name = $current_user->display_name;
          $orders_url = wc_get_endpoint_url( 'orders', '', wc_get_page_permalink( 'myaccount' ) );
          $profile_url = wc_get_endpoint_url( 'edit-account', '', wc_get_page_permalink( 'myaccount' ) );
          $avatar_url = get_avatar_url( wp_get_current_user()->user_email);
          ?>
          <ul class="top-header-auth-dropdown">
            <li>
            <img class="rounded-circle profimg" src="<?php echo $avatar_url; ?>" alt="">
              <?php echo $display_name; ?>
            </li>
            <li>
              <a href="<?php echo $orders_url; ?>"> سفارش ها </a>
            </li>
            <li>
              <a href="<?php echo $profile_url; ?>"> پروفایل کاربری</a>
            </li>
           
            <li>
              <a href="<?php echo wp_logout_url( home_url() ); ?>"> خروج از حساب کاربری </a>
            </li>
          </ul>
          <?php endif; ?>
          </div>
          <button type="button" class="top-header-four-btn-search bg-transparent p-0 w-auto h-auto">
            <i class="icon-search"></i>
          </button>
          <div class="top-header-four-search">
            <div class="backdrop"></div>
            <form method="get" action="#" class="position-relative">
              <input id="maninpu" type="text" name="search" class="form-control maninpu" placeholder="<?php echo  esc_attr($settings['title2loginandsignupkaveh']); ?>">
              <button type="submit">
                <i class="icon-search"></i>
              </button>
            </form>
          </div>
        </div>
    </div>
    <?php }elseif('four'===$settings['styleboxloginandsignupkaveh']){ ?>
    <div class="top-header-twelve <?php if("right"===$settings['element_loginandsignupkave']){?>float-start<?php }elseif("center"===$settings['element_loginandsignupkave']){?>mx-auto<?php }elseif("left"===$settings['element_loginandsignupkave']){?>float-end<?php } ?>">
      <div class="top-header-auth">
          <a <?php if( !is_user_logged_in() && $options['kaveh_login_redirect'] === '1' ): ?> data-auth-toggle="modal" data-auth-target="auth-gajmarket" <?php else: ?> href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"<?php endif; ?> class="top-header-auth btn p-0">
            <i class="<?php echo esc_attr($settings['iconele4loginandsignupkave']['value']); ?>"></i>
          </a>
          <?php if( is_user_logged_in() ): 
          $current_user = wp_get_current_user();  
          $display_name = $current_user->display_name;
          $orders_url = wc_get_endpoint_url( 'orders', '', wc_get_page_permalink( 'myaccount' ) );
          $profile_url = wc_get_endpoint_url( 'edit-account', '', wc_get_page_permalink( 'myaccount' ) );
          $avatar_url = get_avatar_url( wp_get_current_user()->user_email);
          ?>
          <ul class="top-header-auth-dropdown">
            <li>
            <img class="rounded-circle profimg" src="<?php echo $avatar_url; ?>" alt="">
              <?php echo $display_name; ?>
            </li>
            <li>
              <a href="<?php echo $orders_url; ?>"> سفارش ها </a>
            </li>
            <li>
              <a href="<?php echo $profile_url; ?>"> پروفایل کاربری</a>
            </li>
           
            <li>
              <a href="<?php echo wp_logout_url( home_url() ); ?>"> خروج از حساب کاربری </a>
            </li>
          </ul>
          <?php endif; ?>
        </div>
        </div>
    <?php }elseif('five'===$settings['styleboxloginandsignupkaveh']){ ?>
      <div class="top-header-fourteen <?php if("right"===$settings['element_loginandsignupkave']){?>float-start<?php }elseif("center"===$settings['element_loginandsignupkave']){?>mx-auto<?php }elseif("left"===$settings['element_loginandsignupkave']){?>float-end<?php } ?>">
        <div class="top-header-auth">
            <a <?php if( !is_user_logged_in() && $options['kaveh_login_redirect'] === '1' ): ?> data-auth-toggle="modal" data-auth-target="auth-gajmarket" <?php else: ?> href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"<?php endif; ?> class="top-header-auth btn p-0">
              <i class="icon-user-fill"></i>
            </a>
            <?php if( is_user_logged_in() ): 
          $current_user = wp_get_current_user();  
          $display_name = $current_user->display_name;
          $orders_url = wc_get_endpoint_url( 'orders', '', wc_get_page_permalink( 'myaccount' ) );
          $profile_url = wc_get_endpoint_url( 'edit-account', '', wc_get_page_permalink( 'myaccount' ) );
          $avatar_url = get_avatar_url( wp_get_current_user()->user_email);
          ?>
          <ul class="top-header-auth-dropdown">
            <li>
              <img class="rounded-circle profimg" src="<?php echo $avatar_url; ?>" alt="">
              <?php echo $display_name; ?>
            </li>
            <li>
              <a href="<?php echo $orders_url; ?>"> سفارش ها </a>
            </li>
            <li>
              <a href="<?php echo $profile_url; ?>"> پروفایل کاربری</a>
            </li>
           
            <li>
              <a href="<?php echo wp_logout_url( home_url() ); ?>"> خروج از حساب کاربری </a>
            </li>
          </ul>
          <?php endif; ?>
          </div>
        </div>
    <?php }elseif('six'===$settings['styleboxloginandsignupkaveh']){ ?>
       <!-- Start Avatar -->
    <div class="container">
      <div class="top-header-auth header-auth <?php if("right"===$settings['element_loginandsignupkave']){?>float-start<?php }elseif("center"===$settings['element_loginandsignupkave']){?>mx-auto<?php }elseif("left"===$settings['element_loginandsignupkave']){?>float-end<?php } ?> <?php if('left'===$settings['styleulloginandsignupkave']){ ?>right<?php }else{ ?>left<?php } ?>">
        <a <?php if( !is_user_logged_in() && $options['kaveh_login_redirect'] === '1' ): ?> data-auth-toggle="modal" data-auth-target="auth-gajmarket" <?php else: ?> href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"<?php endif; ?> class="auth-avatar w-auto h-auto">
          <img src="<?php if( !is_user_logged_in() ): ?>https://s8.uupload.ir/files/avatar_2qtm.png<?php else: $user = wp_get_current_user(); echo esc_url( get_avatar_url( $user->ID ) ); ?><?php endif; ?>" alt="avatar" width="43" height="43">
        </a>
        <?php if( is_user_logged_in() ): 
          $current_user = wp_get_current_user();  
          $display_name = $current_user->display_name;
          $orders_url = wc_get_endpoint_url( 'orders', '', wc_get_page_permalink( 'myaccount' ) );
          $profile_url = wc_get_endpoint_url( 'edit-account', '', wc_get_page_permalink( 'myaccount' ) );
          $avatar_url = get_avatar_url( wp_get_current_user()->user_email);
          ?>
          <ul class="top-header-auth-dropdown">
            <li>
              <img class="rounded-circle profimg" src="<?php echo $avatar_url; ?>" alt="">
              <?php echo $display_name; ?>
            </li>
            <li>
              <a href="<?php echo $orders_url; ?>"> سفارش ها </a>
            </li>
            <li>
              <a href="<?php echo $profile_url; ?>"> پروفایل کاربری</a>
            </li>
           
            <li>
              <a href="<?php echo wp_logout_url( home_url() ); ?>"> خروج از حساب کاربری </a>
            </li>
          </ul>
          <?php endif; ?>
      </div>
    </div>
    <!-- End Avatar -->
    <?php }elseif('seven'===$settings['styleboxloginandsignupkaveh']){ ?>
      <div class="top-header-auth header-three-auth <?php if("right"===$settings['element_loginandsignupkave']){?>float-start<?php }elseif("center"===$settings['element_loginandsignupkave']){?>mx-auto<?php }elseif("left"===$settings['element_loginandsignupkave']){?>float-end<?php } ?>">
        <a <?php if( !is_user_logged_in() && $options['kaveh_login_redirect'] === '1' ): ?> data-auth-toggle="modal" data-auth-target="auth-gajmarket" <?php else: ?> href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"<?php endif; ?> class="btn d-flex align-items-center justify-content-center position-relative">
          <i class="<?php echo  esc_attr($settings['iconeleafterloginandsignupkave']['value']); ?>"></i>
          <span><?php if( !is_user_logged_in() ): echo esc_html($settings['titleloginandsignupkaveh']); else: echo 'حساب کاربری من'; endif; ?></span>
        </a>
          <?php if( is_user_logged_in() ): 
          $current_user = wp_get_current_user();  
          $display_name = $current_user->display_name;
          $orders_url = wc_get_endpoint_url( 'orders', '', wc_get_page_permalink( 'myaccount' ) );
          $profile_url = wc_get_endpoint_url( 'edit-account', '', wc_get_page_permalink( 'myaccount' ) );
          $avatar_url = get_avatar_url( wp_get_current_user()->user_email);
          ?>
          <ul class="top-header-auth-dropdown">
            <li>
              <img class="rounded-circle profimg" src="<?php echo $avatar_url; ?>" alt="">
              <?php echo $display_name; ?>
            </li>
            <li>
              <a href="<?php echo $orders_url; ?>"> سفارش ها </a>
            </li>
            <li>
              <a href="<?php echo $profile_url; ?>"> پروفایل کاربری</a>
            </li>
          
            <li>
              <a href="<?php echo wp_logout_url( home_url() ); ?>"> خروج از حساب کاربری </a>
            </li>
          </ul>
          <?php endif; ?>
      </div>
      <style>
      .top-header-auth > a, .top-header-auth > a:hover, .top-header-auth > a:focus, .top-header-auth > a:active {
          width: unset;
          height: unset;
          line-height: unset;
          background-color: unset;
          -webkit-box-shadow: unset;
          -moz-box-shadow: unset;
          box-shadow: unset;
          border: unset;
          color: unset;
          text-align: unset;
          -webkit-border-radius: unset;
          -moz-border-radius: unset;
          border-radius: unset;
          font-weight: unset;
      }
      </style>
    <?php } ?>
    <!--end search popup -->
    <?php
  }


}
