<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Listkaveh extends Widget_Base{

  public function get_name(){
    return 'listkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان لیست', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['headerfooterkavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentlistkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'styledotlistkaveh',
        [
          'label' => esc_html__( 'استایل لیست', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح یک', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح دو', 'kaveh-core' ),
            'three'  => esc_html__( 'طرح سه', 'kaveh-core' ),
          ],
        ]
        ); 
  $repeater = new \Elementor\Repeater();

  $repeater->add_control(
    'tlistkaveh',
    [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( 'عنوان تستی', 'kaveh-core' ),

    ]
  );
    $repeater->add_control(
      'linklistkaveh',
      [
          'label' => esc_html__( 'لینک برند', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),

      ]
  );
  $this->add_control(
  'listlistkaveh',
  [
    'label' => esc_html__( 'لیست', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::REPEATER,
    'fields' => $repeater->get_controls(),
    'default' => [
      [
        'tlistkaveh' => esc_html__( 'عنوان تستی' , 'kaveh-core' ),
        'linklistkaveh' => esc_html__( '#', 'kaveh-core' ),
      ],
  ]
  ]

  );
        $this->end_controls_section();
        $this->start_controls_section(
          'style_phonenumberkaveh',
          [
            'label' => esc_html__( 'استایل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        );
        $this->add_control(
          'pishphonenumberkaveh',
          [
            'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .footer-list-kaveh li a' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'pishtypephonenumberkaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .footer-list-kaveh li a',
          ]
        );
        
        $this->add_control(
          'titlebeforephonenumberkaveh',
          [
            'label' => esc_html__( 'رنگ شیپ', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'condition' => [
              'styledotlistkaveh' =>'one',
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-four-nav li a::before' => 'background-color: {{VALUE}}',
            ],
          ]
        );
        $this->add_control(
          'titlebefore2phonenumberkaveh',
          [
            'label' => esc_html__( 'رنگ شیپ', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'condition' => [
              'styledotlistkaveh' =>'two',
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-nav li a::before' => 'background-color: {{VALUE}}',
            ],
          ]
        );
        $this->add_control(
          'titlebefore3phonenumberkaveh',
          [
            'label' => esc_html__( 'رنگ شیپ', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'condition' => [
              'styledotlistkaveh' =>'three',
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-nav li a::before' => 'background-color: {{VALUE}}',
              '{{WRAPPER}} .footer-seven-nav li a::before' => 'border: 1px solid {{VALUE}}',

            ],
          ]
        );
        $this->add_control(
          'titlehoverphonenumberkaveh',
          [
            'label' => esc_html__( 'رنگ هاور', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .footer-list-kaveh li a:hover' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->end_controls_section();
          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
  
?>

                <ul class="footer-list-kaveh <?php if("one"===$settings['styledotlistkaveh']){?>footer-four-nav<?php }elseif("two"===$settings['styledotlistkaveh']){?>footer-nav<?php }elseif("three"===$settings['styledotlistkaveh']){?>footer-seven-nav<?php } ?>">
                <?php
                if ( $settings['listlistkaveh'] ) {
                foreach (  $settings['listlistkaveh'] as $item ) {
                ?>
                  <li>
                    <a href="<?php echo  esc_url($item['linklistkaveh']); ?>"><?php echo  esc_html($item['tlistkaveh']); ?></a>
                  </li>
                  <?php
                }
              }
                ?>
                </ul>
    <?php
  }


}
