<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
  exit;
} // Exit if accessed directly

class Kavehwoocommerceproducttabs extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'kavehwoocommerceproducttabs';
  }

  public function get_title()
  {
    return esc_html__('المان تب های محصول تکی', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['woocommercekavehelements'];
  }

  protected function register_controls()
  {
    $this->start_controls_section(
      'content1kavehwoocommerceproducttabs',
      [
        'label' => esc_html__( 'محتوا', 'kaveh-core' ),
    
       'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'text_alignkavehwoocommerceproducttabs',
      [
        'label' => esc_html__( 'چیدمان متن', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::CHOOSE,
        'default'   => 'text-start',
        'options' => [
          'text-end' => [
            'title' => esc_html__( 'چپ چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-left',
          ],
          'text-center' => [
            'title' => esc_html__( 'وسط چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-center',
          ],
          'text-start' => [
            'title' => esc_html__( 'راست چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-right',
          ],
          'text-justify' => [
            'title' => esc_html__( 'تراز', 'kaveh-core' ),
            'icon' => 'eicon-text-align-justify',
          ],
        ],
        'toggle' => true,
      ]
    );
    $this->end_controls_section();





/////////////////////////////////////// style ///////////////////////////////





    $this->start_controls_section(
      'style1_kavehwoocommerceproducttabs',
      [
        'label' => esc_html__( 'تب ها', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'titletabsـcolor1_kavehwoocommerceproducttabs',
      [
        'label' => esc_html__( 'رنگ عنوان تب ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .nav-pills .nav-link' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titletabs_type_kavehwoocommerceproducttabs',
        'label' => esc_html__( 'تایپوگرافی عنوان تب ها', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .nav-pills .nav-link',
      ]
    );

    $this->add_control(
      'titleactivetabs_color1ـkavehwoocommerceproducttabs',
      [
        'label' => esc_html__( 'رنگ عنوان تب فعال', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .nav-pills .nav-link.active' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titleactivetabs_type_kavehwoocommerceproducttabs',
        'label' => esc_html__( 'تایپوگرافی عنوان تب فعال', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .nav-pills .nav-link.active',
      ]
    );

    $this->add_control(
      'bgactivetabs_color1_kavehwoocommerceproducttabs',
      [
        'label' => esc_html__( 'رنگ بک گراند تب فعال', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .nav-pills .nav-link.active' => 'background-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'bgactivetab_one_kavehwoocommerceproducttabs',
      [
      'label' => __( 'پدینگ  باکس تب فعال', 'kaveh-core'),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => [ 'px' ],
      'selectors' => [
      '{{WRAPPER}} .nav-pills .nav-link.active' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
      ],
      ]
      );
      
      $this->add_control(
      'btnborderradiustabactive_one_kavehwoocommerceproducttabs',
      [
        'label' => __( 'شعاع انحنای باکس تب فعال', 'kaveh-core'),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => [ 'px' ],
      'selectors' => [
      '{{WRAPPER}} .nav-pills .nav-link.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
      ],
      ]
      );

      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'boxshadowactivetab_one_kavehwoocommerceproducttabs',
          'label' => esc_html__( 'سایه باکس عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .nav-pills .nav-link.active',
        ]
        );
    $this->end_controls_section();





    $this->start_controls_section(
      'style2_kavehwoocommerceproducttabs',
      [
        'label' => esc_html__( 'تب مشخصات محصول', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'titletab1ـcolor1_kavehwoocommerceproducttabs',
      [
        'label' => esc_html__( 'رنگ عنوان ویژگی های محصول', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #specifications ul li span:first-child' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titletab1_type_kavehwoocommerceproducttabs',
        'label' => esc_html__( 'تایپوگرافی عنوان ویژگی های محصول', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} #specifications ul li span:first-child',
      ]
    );

    $this->add_control(
      'titletab1ـcolor2_kavehwoocommerceproducttabs',
      [
        'label' => esc_html__( 'رنگ مقدار ویژگی های محصول', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #specifications ul li span:last-child' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titletab1_type2_kavehwoocommerceproducttabs',
        'label' => esc_html__( 'تایپوگرافی مقدار ویژگی های محصول', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} #specifications ul li span:last-child',
      ]
    );

    $this->add_control(
      'linetab1ـcolor1_kavehwoocommerceproducttabs',
      [
        'label' => esc_html__( 'رنگ بوردر جانبی عنوان ویژگی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #specifications ul li::after' => 'background-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'bgtab1ـcolor1_kavehwoocommerceproducttabs',
      [
        'label' => esc_html__( 'رنگ بک گراند مقدار ویژگی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #specifications ul li span:last-child' => 'background-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'paddingboxtab1_one_kavehwoocommerceproducttabs',
      [
      'label' => __( 'پدینگ  باکس مقدار ویژگی ها', 'kaveh-core'),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => [ 'px' ],
      'selectors' => [
      '{{WRAPPER}} #specifications ul li span:last-child' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
      ],
      ]
      );
      
      $this->add_control(
      'btnborderradiusboxtab1_one_kavehwoocommerceproducttabs',
      [
        'label' => __( 'شعاع انحنای باکس مقدار ویژگی ها', 'kaveh-core'),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => [ 'px' ],
      'selectors' => [
      '{{WRAPPER}} #specifications ul li span:last-child' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
      ],
      ]
      );

      $this->add_control(
        'widthboxtab1_one_aboutusthreekaren',
        [
          'label' => esc_html__( 'عرض باکس مقدار ویژگی ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'unit' => '%',
          'range' => [
            'px' => [
              'min' => 1,
              'max' => 100,
            ]
          ],
          'selectors' => [
            '{{WRAPPER}} #specifications ul li span:last-child' => 'width: {{SIZE}}%;',   
          ],
        ]
      );
      $this->end_controls_section();





      $this->start_controls_section(
        'style3_kavehwoocommerceproducttabs',
        [
          'label' => esc_html__( 'تب توضیحات ', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      
      $this->add_control(
        'titletab2ـcolor1_kavehwoocommerceproducttabs',
        [
          'label' => esc_html__( 'رنگ عنوان توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .tab-pane h4' => 'color: {{VALUE}}',
          ],
        ]
      );
  
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletab2_type_kavehwoocommerceproducttabs',
          'label' => esc_html__( 'تایپوگرافی عنوان توضیحات', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .tab-pane h4',
        ]
      );
  
      $this->add_control(
        'titletab2_color2_kavehwoocommerceproducttabs',
        [
          'label' => esc_html__( 'رنگ توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .tab-pane p' => 'color: {{VALUE}}',
          ],
        ]
      );
  
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletab2_type2_kavehwoocommerceproducttabs',
          'label' => esc_html__( 'تایپوگرافی توضیحات', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .tab-pane p',
        ]
      );
      $this->end_controls_section();





      $this->start_controls_section(
        'style4_kavehwoocommerceproducttabs',
        [
          'label' => esc_html__( 'تب نظرات کاربران ', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );

      $this->add_control(
        'more_options1',
        [
          'label' => esc_html__( 'عنوان نظرات کاربران', 'textdomain' ),
          'type' => \Elementor\Controls_Manager::HEADING,
          'separator' => 'before',
        ]
      );

      $this->add_control(
        'title_color5_kavehwoocommerceproductcomment',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .detail-blog-comments .title ' => 'color: {{VALUE}}',
          ],
        ]
      );

      $this->add_control(
        'title_color6_kavehwoocommerceproductcomment',
        [
          'label' => esc_html__( 'رنگ عنوان دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .detail-blog-comments .title span ' => 'color: {{VALUE}}',
          ],
        ]
      );

      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title1_typest5_kavehwoocommerceproductcomment',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .detail-blog-comments .title ',
        ]
      );

      $this->add_control(
        'more_options2',
        [
          'label' => esc_html__( 'بخش نمایش و افزودن نظر جدید', 'textdomain' ),
          'type' => \Elementor\Controls_Manager::HEADING,
          'separator' => 'before',
        ]
      );

      $this->add_control(
        'title_upbutt1_kavehwoocommerceproductcomment',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} #comments .rate-comment .title, #comments .rate-comment .sub-title ' => 'color: {{VALUE}}',
          ],
        ]
      );

      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titileupbutt_typo_kavehwoocommerceproductcomment',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} #comments .rate-comment .title, #comments .rate-comment .sub-title',
        ]
      );

      $this->add_control(
        'title_upbutt2_kavehwoocommerceproductcomment',
        [
          'label' => esc_html__( 'رنگ عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} #comments .rate-comment .btn' => 'color: {{VALUE}}',
          ],
        ]
      );

      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titileupbutt2_typo_kavehwoocommerceproductcomment',
          'label' => esc_html__( 'تایپوگرافی عنوان دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} #comments .rate-comment .btn',
        ]
      );

      $this->add_control(
        'bgcolor_upbutt_kavehwoocommerceproductcomment',
        [
          'label' => esc_html__( 'رنگ بک گراند دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} #comments .rate-comment .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      );

      $this->add_control(
        'borderradius_upbutt_kavehwoocommerceproductcomment',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه خط', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
          '{{WRAPPER}} #comments .rate-comment .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );

      $this->add_control(
        'paddingbox_upbutt_kavehwoocommerceproductcomment',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} #comments .rate-comment .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );

      $this->add_control(
        'title_uptitle1_kavehwoocommerceproductcomment',
        [
          'label' => esc_html__( 'رنگ عنوان امتیاز محصول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} #comments .rate-comment .rate-box-title' => 'color: {{VALUE}}',
          ],
        ]
      );

      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titileuptitle1_typo_kavehwoocommerceproductcomment',
          'label' => esc_html__( 'تایپوگرافی عنوان امتیاز محصول', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} #comments .rate-comment .rate-box-title',
        ]
      );

      $this->add_control(
        'title_uptitle2_kavehwoocommerceproductcomment',
        [
          'label' => esc_html__( 'رنگ عنوان مجموع امتیاز ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} #comments .rate-comment .rate-box-count' => 'color: {{VALUE}}',
          ],
        ]
      );

      $this->add_control(
        'title_uptitle3_kavehwoocommerceproductcomment',
        [
          'label' => esc_html__( 'رنگ تعداد امتیاز ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} #comments .rate-comment .rate-box-count i' => 'color: {{VALUE}}',
          ],
        ]
      );

      $this->add_control(
        'more_options3',
        [
          'label' => esc_html__( 'خط بالا', 'textdomain' ),
          'type' => \Elementor\Controls_Manager::HEADING,
          'separator' => 'before',
        ]
      );

      $this->add_control(
        'title1color1_kavehwoocommerceproducttabs',
        [
          'label' => esc_html__( 'رنگ خط', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} #comments::before' => 'background-color: {{VALUE}} !important',
          ],
        ]
      );

      $this->add_control(
        'width_line_kavehwoocommerceproducttabs',
        [
          'label' => esc_html__( 'عرض خط', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'unit' => '%',
          'range' => [
          '%' => [
            'min' => 1,
            'max' => 100,
          ],
          ],
          'selectors' => [
          '{{WRAPPER}} #comments::before' => 'width: {{SIZE}}%;',
          ],
        ]
        );

        $this->add_control(
          'height_line_kavehwoocommerceproducttabs',
          [
            'label' => esc_html__( 'ارتفاع خط', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'unit' => 'px',
            'range' => [
            'px' => [
            'min' => 1,
            'max' => 20,
            ],
            ],
            'selectors' => [
            '{{WRAPPER}} #comments::before' => 'height: {{SIZE}}{{UNIT}};',
            ],
          ]
          );

          $this->add_control(
            'borderradius_line_kavehwoocommerceproducttabs',
            [
              'label' => esc_html__( 'گوشه خمیده پس زمینه خط', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
              '{{WRAPPER}} #comments::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
              ],
            ]
          );

          $this->add_control(
            'more_options4',
            [
              'label' => esc_html__( 'باکس اطلاعات کاربر', 'textdomain' ),
              'type' => \Elementor\Controls_Manager::HEADING,
              'separator' => 'before',
            ]
          );

          $this->add_control(
            'bgcolor1_user_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ بک گراند اطلاعات کاربر', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .comments li .content .info .detail' => 'background-color: {{VALUE}}',
              ],
            ]
          );

          $this->add_control(
            'borderradius_box_user_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'گوشه خمیده پس زمینه اطلاعات کاربر', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
              '{{WRAPPER}} .comments li .content .info .detail' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
              ],
            ]
          );

          $this->add_control(
            'paddingbox_user_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'فاصله داخلی باکس اطلاعات کاربر', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
                '{{WRAPPER}} .comments li .content .info .detail' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
              ],
            ]
          );

          $this->add_control(
            'more_options5',
            [
              'label' => esc_html__( 'عناوین اطلاعات کاربر', 'textdomain' ),
              'type' => \Elementor\Controls_Manager::HEADING,
              'separator' => 'before',
            ]
          );

          $this->add_control(
            'title_color1_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ نام کاربر', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .comments li .content .info .detail .author' => 'color: {{VALUE}}',
              ],
            ]
          );

          $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
              'name' => 'title1_typest1_kavehwoocommerceproductcomment',
              'label' => esc_html__( 'تایپوگرافی نام کاربر', 'kaveh-core' ),
              'selector' => '{{WRAPPER}} .comments li .content .info .detail .author',
            ]
          );

          $this->add_control(
            'title_color2_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ تاریخ دیدگاه', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .comments li .content .info .detail .date' => 'color: {{VALUE}}',
              ],
            ]
          );
          
          $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
              'name' => 'title2_typest1_kavehwoocommerceproductcomment',
              'label' => esc_html__( 'تایپوگرافی تاریخ دیدگاه', 'kaveh-core' ),
              'selector' => '{{WRAPPER}} .comments li .content .info .detail .date',
            ]
          );

          $this->add_control(
            'more_options6',
            [
              'label' => esc_html__( 'دکمه های باکس اطلاعات کاربر', 'textdomain' ),
              'type' => \Elementor\Controls_Manager::HEADING,
              'separator' => 'before',
            ]
          );

          $this->add_control(
            'title_color1butt_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ عنوان دکمه', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .comments li .content .info .detail .position' => 'color: {{VALUE}}',
              ],
            ]
          );

          $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
              'name' => 'title1_typest1butt_kavehwoocommerceproductcomment',
              'label' => esc_html__( 'تایپوگرافی عنوان دکمه', 'kaveh-core' ),
              'selector' => '{{WRAPPER}} .comments li .content .info .detail .position',
            ]
          );

          $this->add_control(
            'bgcolor1_butt_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ بکگراند دکمه', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .comments li .content .info .detail .position' => 'background-color: {{VALUE}}',
              ],
            ]
          );

          $this->add_control(
            'borderradius_box_butt_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'گوشه خمیده پس زمینه دکمه', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
              '{{WRAPPER}} .comments li .content .info .detail .position' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
              ],
            ]
          );

          $this->add_control(
            'paddingbox_butt_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
                '{{WRAPPER}} .comments li .content .info .detail .position' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
              ],
            ]
          );

          $this->add_control(
            'more_options7',
            [
              'label' => esc_html__( 'کامنت و عنوان دیدگاه', 'textdomain' ),
              'type' => \Elementor\Controls_Manager::HEADING,
              'separator' => 'before',
            ]
          );

          $this->add_control(
            'title_comment1_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ متن کامنت', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .comments li .content .box p' => 'color: {{VALUE}}',
              ],
            ]
          );

          $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
              'name' => 'title1_comment1_kavehwoocommerceproductcomment',
              'label' => esc_html__( 'تایپوگرافی متن کامنت', 'kaveh-core' ),
              'selector' => '{{WRAPPER}} .comments li .content .box p',
            ]
          );

          $this->add_control(
            'title_comment2_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ عنوان دیدگاه', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} h3#reply-title' => 'color: {{VALUE}}',
              ],
            ]
          );

          $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
              'name' => 'title1_comment2_kavehwoocommerceproductcomment',
              'label' => esc_html__( 'تایپوگرافی عنوان دیدگاه', 'kaveh-core' ),
              'selector' => '{{WRAPPER}} h3#reply-title',
            ]
          );  

          $this->add_control(
            'more_options8',
            [
              'label' => esc_html__( 'باکس ویژگی ها', 'textdomain' ),
              'type' => \Elementor\Controls_Manager::HEADING,
              'separator' => 'before',
            ]
          );

          $this->add_control(
            'title_colorbox1_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ عناوین ویژگی ها', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .pcf-field-container' => 'color: {{VALUE}} !important',
              ],
            ]
          );

          $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
              'name' => 'title_colorbox1_typo_kavehwoocommerceproductcomment',
              'label' => esc_html__( 'تایپوگرافی عناوین ویژگی ها', 'kaveh-core' ),
              'selector' => 
              '{{WRAPPER}} .pcf-field-container',
            ]
          );

          $this->add_control(
            'title_colorplaceholder1_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ عناوین پلیس هولدر', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .tagify__input::before' => 'color: {{VALUE}}',
              ],
            ]
          );

          $this->add_control(
            'titlehover_colorplaceholder1_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ هاور عناوین پلیس هولدر', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .tagify__input:focus:empty::before' => 'color: {{VALUE}} !important',
              ],
            ]
          );

          $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
              'name' => 'title_colorplaceholder1_typo_kavehwoocommerceproductcomment',
              'label' => esc_html__( 'تایپوگرافی عناوین پلیس هولدر', 'kaveh-core' ),
              'selector' => 
              '{{WRAPPER}} .tagify__input::before',
            ]
          );

          $this->add_control(
            'bgcolor1_box1_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ بک گراند باکس ویژگی ها', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .tagify' => 'background-color: {{VALUE}}!important',
              ],
            ]
          );

          $this->add_control(
            'bghovercolor1_box1_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ هاور بک گراند باکس ویژگی ها', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .tagify--focus' => 'background-color: {{VALUE}}!important',
              ],
            ]
          );

          $this->add_control(
            'bordercolor1_box1_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ بورد باکس ویژگی ها', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .tagify' => 'border: 1px solid {{VALUE}}',
              ],
            ]
          );

          $this->add_control(
            'borderhovercolor1_box1_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ هاور بوردر باکس ویژگی ها', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .tagify--focus' => 'border: 1px solid {{VALUE}}!important',
              ],
            ]
          );

          $this->add_control(
            'paddingbox2_box_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'فاصله داخلی باکس ویژگی ها', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
                '{{WRAPPER}} .tagify' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
              ],
            ]
          );

          $this->add_control(
            'borderradius1_box_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'گوشه خمیده پس زمینه خط', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
              '{{WRAPPER}} .tagify' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
              ],
            ]
          );

          $this->add_control(
            'more_options9',
            [
              'label' => esc_html__( 'دیدگاه', 'textdomain' ),
              'type' => \Elementor\Controls_Manager::HEADING,
              'separator' => 'before',
            ]
          );

          $this->add_control(
            'title_colorcomment1_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'خروج از حساب کاربری', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .send-comment .logged-in-as ' => 'color: {{VALUE}} !important',
              ],
            ]
          );

          $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
              'name' => 'title_colorcomment1_typo_kavehwoocommerceproductcomment',
              'label' => esc_html__( 'تایپوگرافی خروج از حساب کاربری', 'kaveh-core' ),
              'selector' => 
              '{{WRAPPER}} .send-comment .logged-in-as ',
            ]
          );

          $this->add_control(
            'title_coloryourcomment1_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ نظر شما', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .send-comment .form-group label, .auth .form-group label' => 'color: {{VALUE}} !important',
              ],
            ]
          );

          $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
              'name' => 'title_coloryourcomment1_typo_kavehwoocommerceproductcomment',
              'label' => esc_html__( 'تایپوگرافی نظر شما', 'kaveh-core' ),
              'selector' => 
              '{{WRAPPER}} .send-comment .form-group label, .auth .form-group label',
            ]
          );

          $this->add_control(
            'bgcolor_yourcomment_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ بک گراند نظر شما', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .send-comment .form-group label, .auth .form-group label' => 'background-color: {{VALUE}} !important',
              ],
            ]
          );

          $this->add_control(
            'paddingbox3_comment_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'فاصله داخلی باکس ویژگی ها', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
                '{{WRAPPER}} .send-comment .form-group label, .auth .form-group label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
              ],
            ]
          );

          $this->add_control(
            'borderradius2_comment_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'گوشه خمیده پس زمینه باکس ویژگی ها', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
              '{{WRAPPER}} .send-comment .form-group label, .auth .form-group label' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
              ],
            ]
          );

          $this->add_control(
            'bgcolor_comment2_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ بک گراند باکس نظرات', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .send-comment .form-group .form-control, .auth .form-group .form-control' => 'background-color: {{VALUE}} !important',
              ],
            ]
          );

          $this->add_control(
            'bordercolor1_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ بوردر باکس نظرات', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .send-comment .form-group .form-control, .auth .form-group .form-control' => 'border-color: {{VALUE}} !important',
              ],
            ]
          );

          $this->add_control(
            'bordercolorhover1_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ هاور بوردر باکس نظرات', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .send-comment .form-group .form-control:focus, .auth .form-group .form-control:focus' => 'border-color: {{VALUE}} !important',
              ],
            ]
          );

          $this->add_control(
            'heightsize_box_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'ارتفاع باکس نظرات', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'unit' => 'px',
              'range' => [
                'px' => [
                  'min' => 1,
                  'max' => 280,
                ]
              ],
              'selectors' => [
                '{{WRAPPER}} .send-comment .form-group textarea.form-control, .auth .form-group textarea.form-control' => 'height: {{SIZE}}{{UNIT}};',
              ],
            ]
          );

          $this->add_control(
            'widthtsize_box_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'عرض باکس نظرات', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'unit' => '%',
              'range' => [
                'px' => [
                  'min' => 1,
                  'max' => 100,
                ]
              ],
              'selectors' => [
                '{{WRAPPER}} .send-comment .form-group textarea.form-control, .auth .form-group textarea.form-control' => 'width: {{SIZE}}%;',
              ],
            ]
          );
          
          $this->add_control(
            'borderradius1_comment_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'گوشه خمیده پس زمینه باکس نظرات', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
              '{{WRAPPER}} .send-comment .form-group textarea.form-control, .auth .form-group textarea.form-control' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
              ],
            ]
          );

          $this->add_control(
            'more_options10',
            [
              'label' => esc_html__( 'دکمه ارسال', 'textdomain' ),
              'type' => \Elementor\Controls_Manager::HEADING,
              'separator' => 'before',
            ]
          );

          $this->add_control(
            'title_colo2butt_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ عنوان دکمه ارسال', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .comment-respond .btn' => 'color: {{VALUE}} !important',
              ],
            ]
          );

          $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
              'name' => 'title1_typest2butt_kavehwoocommerceproductcomment',
              'label' => esc_html__( 'تایپوگرافی عنوان دکمه ارسال', 'kaveh-core' ),
              'selector' => 
              '{{WRAPPER}} .comment-respond .btn',
            ]
          );

          $this->add_control(
            'bgcolor2_butt_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ بکگراند دکمه ارسال', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .comment-respond .btn' => 'background-color: {{VALUE}}!important',
              ],
            ]
          );

          $this->add_control(
            'bgcolorhover2_butt_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ هاور بکگراند دکمه ارسال', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} .comment-respond .btn:hover' => 'background-color: {{VALUE}}!important',
              ],
            ]
          );

          $this->add_control(
            'borderradius1_box_butt_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'گوشه خمیده پس زمینه دکمه ارسال', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
              '{{WRAPPER}} .comment-respond .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
              ],
            ]
          );
          
          $this->add_control(
            'more_options11',
            [
              'label' => esc_html__( 'باکس اصلی', 'textdomain' ),
              'type' => \Elementor\Controls_Manager::HEADING,
              'separator' => 'before',
            ]
          );

          $this->add_control(
            'bgcolor1_box_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'رنگ باکس اصلی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'selectors' => [
                '{{WRAPPER}} #comments' => 'background-color: {{VALUE}} !important',
              ],
            ]
          );

          $this->add_control(
            'paddingbox_box_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'فاصله داخلی باکس اصلی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
                '{{WRAPPER}} #comments' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
              ],
            ]
          );

          $this->add_control(
            'borderradius_box_kavehwoocommerceproductcomment',
            [
              'label' => esc_html__( 'گوشه خمیده پس زمینه باکس اصلی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::DIMENSIONS,
              'size_units' => [ 'px' ],
              'selectors' => [
              '{{WRAPPER}} #comments' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
              ],
            ]
          );
          
          $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
              'name' => 'box_shadow_one_kavehwoocommerceproductcommen',
              'label' => esc_html__( 'سایه باکس اصلی', 'kaveh-core' ),
              'selector' => '{{WRAPPER}} #comments',
            ]
            );



 



  }



  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    if (!class_exists('WooCommerce')) {
      return;
  }
  if (\Elementor\Plugin::$instance->editor->is_edit_mode()) {
    $args = array(
      'post_type' => 'product',
      'posts_per_page' => 1, // آخرین محصول
      'orderby' => 'date',
      'order' => 'DESC',
  );
      $latest_product = wc_get_products($args);
        // دریافت ID محصول
        $product_id = $latest_product[0]; 
      
        if(!empty($product_id)){
        $product    = wc_get_product( $product_id );
              $product_attributes = $product->get_attributes();
                ?>
  <!-- Start Specifications & Comments -->
      <ul class="nav nav-pills justify-content-center">
        <?php if(!empty($product_attributes)){ ?>
          <li class="nav-item">
            <a href="#specifications" class="nav-link active" data-bs-toggle="pill"> مشخصات محصول </a>
          </li>
          <?php } ?>
          <?php if ($product && !empty($product->get_description())) { ?>

            <li class="nav-item">
              <a href="#description" class="nav-link" data-bs-toggle="pill"> توضیحات </a>
            </li>
            <?php } ?>

          <?php if ( comments_open() ) { ?>

          <li class="nav-item">
            <a href="#comment" class="nav-link" data-bs-toggle="pill"> نظرات کاربران </a>
          </li>
          <?php } ?>
      </ul>
        <div class="tab-content mt-5">
          <?php if(!empty($product_attributes)){ ?>

          <!-- Start Specifications -->
          <div id="specifications" class="tab-pane show fade active">
            <ul>
            <?php
                      // Loop through each attribute
                      foreach ($product_attributes as $attribute){
                      $attribute_slug = $attribute->get_name();
              ?>
              <li class="d-flex align-items-center flex-wrap position-relative">
                <span> <?php echo wc_attribute_label( $attribute_slug ) ?></span>
                <span> <?php echo $product->get_attribute( $attribute_slug ) ?> </span>
              </li>
              <?php 
                  }
                ?>
            </ul>
          </div>
          <!-- End Specifications -->
           <?php } ?>
           <?php if ($product && !empty($product->get_description())) { ?>
            <!-- Start Comments -->
          <div id="description" class="tab-pane show fade position-relative">
              <?php $content = !empty($latest_product) ? get_post_field('post_content', $latest_product[0]) : esc_html__('هیچ محصولی یافت نشد.', 'kaveh-core'); ?>
              <?php echo wp_kses_post($content); ?>
          </div>
          <!-- End Comments -->
           <?php } ?>

           <?php if ( comments_open() ) { ?>
          <!-- Start Comments -->
          <div id="comment" class="tab-pane show fade position-relative">
              <?php  comments_template(); ?>
          </div>
          <!-- End Comments -->
           <?php } ?>
        </div>
        <!-- End Specifications & Comments -->
         
            <?php      
            }
} else {
    global $post;
    $product_id = get_queried_object_id();

    if(!empty($product_id)){
      $product    = wc_get_product( $product_id );
            $product_attributes = $product->get_attributes();
              ?>
<!-- Start Specifications & Comments -->
    <ul class="nav nav-pills justify-content-center پذ">
      <?php if(!empty($product_attributes)){ ?>
        <li class="nav-item">
          <a href="#specifications" class="nav-link active" data-bs-toggle="pill"> مشخصات محصول </a>
        </li>
        <?php } ?>
        <?php if ($product && !empty($product->get_description())) { ?>

          <li class="nav-item">
            <a href="#description" class="nav-link" data-bs-toggle="pill"> توضیحات </a>
          </li>
          <?php } ?>

        <?php if ( comments_open() ) { ?>

        <li class="nav-item">
          <a href="#comment" class="nav-link" data-bs-toggle="pill"> نظرات کاربران </a>
        </li>
        <?php } ?>
    </ul>
      <div class="tab-content mt-5">
        <?php if(!empty($product_attributes)){ ?>

        <!-- Start Specifications -->
        <div id="specifications" class="tab-pane show fade active">
          <ul>
          <?php
                    // Loop through each attribute
                    foreach ($product_attributes as $attribute){
                    $attribute_slug = $attribute->get_name();
            ?>
            <li class="d-flex align-items-center flex-wrap position-relative">
              <span> <?php echo wc_attribute_label( $attribute_slug ) ?></span>
              <span> <?php echo $product->get_attribute( $attribute_slug ) ?> </span>
            </li>
            <?php 
                }
              ?>
          </ul>
        </div>
        <!-- End Specifications -->
         <?php } ?>
         <?php if ($product && !empty($product->get_description())) { ?>
          <!-- Start Comments -->
        <div id="description" class="tab-pane show fade position-relative">
            <?php     $content = apply_filters('the_content', get_the_content(null, false, $post)); ?>
            <?php echo wp_kses_post($content); ?>
        </div>
        <!-- End Comments -->
         <?php } ?>

         <?php if ( comments_open() ) { ?>
        <!-- Start Comments -->
        <div id="comment" class="tab-pane show fade position-relative">
            <?php  comments_template(); ?>
        </div>
        <!-- End Comments -->
         <?php } ?>
      </div>
      <!-- End Specifications & Comments -->
       
          <?php      
          }

}

?>

      <style>
        .product {
        background-color: #fff;
        -webkit-box-shadow: unset;
        -moz-box-shadow: unset;
        box-shadow: unset;
        }
       </style>


    <?php
  }

}


