<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
  exit;
} // Exit if accessed directly

class Kavehwoocommerceproductcomment extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'kavehwoocommerceproductcomment';
  }

  public function get_title()
  {
    return esc_html__('المان دیدگاه محصول تکی', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['woocommercekavehelements'];
  }

  protected function register_controls()
  {
    $this->start_controls_section(
      'content1kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'محتوا', 'kaveh-core' ),
    
       'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'text_alignkavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'چیدمان متن', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::CHOOSE,
        'default'   => 'text-start',
        'options' => [
          'text-end' => [
            'title' => esc_html__( 'چپ چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-left',
          ],
          'text-center' => [
            'title' => esc_html__( 'وسط چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-center',
          ],
          'text-start' => [
            'title' => esc_html__( 'راست چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-right',
          ],
        ],
        'toggle' => true,
      ]
    );
    $this->add_control(
      'titletagkavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'تگ عنوان ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $this->end_controls_section();

    /////////////////////////////////////// style ///////////////////////////////


    $this->start_controls_section(
      'style1kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'عنوان نظرات کاربران', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_color5_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .detail-blog-comments .title ' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'title_color6_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ عنوان دوم', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .detail-blog-comments .title span ' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title1_typest5_kavehwoocommerceproductcomment',
        'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .detail-blog-comments .title ',
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style2kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'دکمه افزودن نظر جدید', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_upbutt1_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #comments .rate-comment .title, #comments .rate-comment .sub-title ' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titileupbutt_typo_kavehwoocommerceproductcomment',
        'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} #comments .rate-comment .title, #comments .rate-comment .sub-title',
      ]
    );
    $this->add_control(
      'title_upbutt2_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ عنوان دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #comments .rate-comment .btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titileupbutt2_typo_kavehwoocommerceproductcomment',
        'label' => esc_html__( 'تایپوگرافی عنوان دکمه', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} #comments .rate-comment .btn',
      ]
    );
    $this->add_control(
      'bgcolor_upbutt_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ بک گراند دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #comments .rate-comment .btn' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'borderradius_upbutt_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'گوشه خمیده پس زمینه خط', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
        '{{WRAPPER}} #comments .rate-comment .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'paddingbox_upbutt_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} #comments .rate-comment .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'title_uptitle1_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ عنوان امتیاز محصول', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #comments .rate-comment .rate-box-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titileuptitle1_typo_kavehwoocommerceproductcomment',
        'label' => esc_html__( 'تایپوگرافی عنوان امتیاز محصول', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} #comments .rate-comment .rate-box-title',
      ]
    );
    $this->add_control(
      'title_uptitle2_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ عنوان مجموع امتیاز ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #comments .rate-comment .rate-box-count' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'title_uptitle3_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ تعداد امتیاز ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #comments .rate-comment .rate-box-count i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style3kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'استایل خط بالا', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title1color1kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ خط', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #comments::before' => 'background-color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_control(
			'width_line_kavehwoocommerceproductcomment',
			[
			  'label' => esc_html__( 'عرض خط', 'kaveh-core' ),
			  'type' => \Elementor\Controls_Manager::SLIDER,
				'unit' => '%',
			  'range' => [
				'%' => [
				  'min' => 1,
				  'max' => 100,
				],
			  ],
			  'selectors' => [
				'{{WRAPPER}} #comments::before' => 'width: {{SIZE}}%;',
			  ],
			]
		  );
      $this->add_control(
        'height_line_kavehwoocommerceproductcomment',
        [
          'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'unit' => 'px',
          'range' => [
          'px' => [
          'min' => 1,
          'max' => 20,
          ],
          ],
          'selectors' => [
          '{{WRAPPER}} #comments::before' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
        );
        $this->add_control(
          'borderradius_line_kavehwoocommerceproductcomment',
          [
            'label' => esc_html__( 'گوشه خمیده پس زمینه خط', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
            '{{WRAPPER}} #comments::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
      
    $this->end_controls_section();
    $this->start_controls_section(
      'style4_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'بک گراند اطلاعات کاربر', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'bgcolor1_user_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ بکگراند', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .comments li .content .info .detail' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'borderradius_box_user_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'گوشه خمیده پس زمینه خط', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
        '{{WRAPPER}} .comments li .content .info .detail' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'paddingbox_user_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .comments li .content .info .detail' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style5_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'عناوین کاربر', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_color1_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .comments li .content .info .detail .author' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title1_typest1_kavehwoocommerceproductcomment',
        'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .comments li .content .info .detail .author',
      ]
    );
    $this->add_control(
      'title_color2_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ عنوان دوم', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .comments li .content .info .detail .date' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title2_typest1_kavehwoocommerceproductcomment',
        'label' => esc_html__( 'تایپوگرافی عنوان دوم', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .comments li .content .info .detail .date',
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style6_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'دکمه', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_color1butt_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ عنوان دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .comments li .content .info .detail .position' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title1_typest1butt_kavehwoocommerceproductcomment',
        'label' => esc_html__( 'تایپوگرافی عنوان دکمه', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .comments li .content .info .detail .position',
      ]
    );
    $this->add_control(
      'bgcolor1_butt_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ بکگراند دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .comments li .content .info .detail .position' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'borderradius_box_butt_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'گوشه خمیده پس زمینه دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
        '{{WRAPPER}} .comments li .content .info .detail .position' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->add_control(
      'paddingbox_butt_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .comments li .content .info .detail .position' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'style7_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'کامنت', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_comment1_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .comments li .content .box p' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title1_comment1_kavehwoocommerceproductcomment',
        'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .comments li .content .box p',
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style8_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'عنوان دیدگاه', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_comment2_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} h3#reply-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title1_comment2_kavehwoocommerceproductcomment',
        'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} h3#reply-title',
      ]
    );    
    $this->end_controls_section();
    $this->start_controls_section(
      'style9_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'باکس ویژگی ها', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_colorbox1_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ عناوین ویژگی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .pcf-field-container' => 'color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title_colorbox1_typo_kavehwoocommerceproductcomment',
        'label' => esc_html__( 'تایپوگرافی عناوین ویژگی ها', 'kaveh-core' ),
        'selector' => 
        '{{WRAPPER}} .pcf-field-container',
      ]
    );
    $this->add_control(
      'title_colorplaceholder1_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ عناوین پلیس هولدر', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tagify__input::before' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'titlehover_colorplaceholder1_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ هاور عناوین پلیس هولدر', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tagify__input:focus:empty::before' => 'color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title_colorplaceholder1_typo_kavehwoocommerceproductcomment',
        'label' => esc_html__( 'تایپوگرافی عناوین پلیس هولدر', 'kaveh-core' ),
        'selector' => 
        '{{WRAPPER}} .tagify__input::before',
      ]
    );
    $this->add_control(
      'bgcolor1_box1_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ بک گراند باکس ویژگی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tagify' => 'background-color: {{VALUE}}!important',
        ],
      ]
    );
    $this->add_control(
      'bghovercolor1_box1_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ هاور بک گراند باکس ویژگی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tagify--focus' => 'background-color: {{VALUE}}!important',
        ],
      ]
    );
    $this->add_control(
      'bordercolor1_box1_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ بورد باکس ویژگی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tagify' => 'border: 1px solid {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'borderhovercolor1_box1_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ هاور بوردر باکس ویژگی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tagify--focus' => 'border: 1px solid {{VALUE}}!important',
        ],
      ]
    );
    $this->add_control(
      'paddingbox2_box_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'فاصله داخلی باکس ویژگی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .tagify' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'borderradius1_box_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'گوشه خمیده پس زمینه خط', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
        '{{WRAPPER}} .tagify' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style10_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'دیدگاه', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_colorcomment1_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'خروج از حساب کاربری', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .send-comment .logged-in-as ' => 'color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title_colorcomment1_typo_kavehwoocommerceproductcomment',
        'label' => esc_html__( 'تایپوگرافی خروج از حساب کاربری', 'kaveh-core' ),
        'selector' => 
        '{{WRAPPER}} .send-comment .logged-in-as ',
      ]
    );
    $this->add_control(
      'title_coloryourcomment1_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ نظر شما', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .send-comment .form-group label, .auth .form-group label' => 'color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title_coloryourcomment1_typo_kavehwoocommerceproductcomment',
        'label' => esc_html__( 'تایپوگرافی نظر شما', 'kaveh-core' ),
        'selector' => 
        '{{WRAPPER}} .send-comment .form-group label, .auth .form-group label',
      ]
    );
    $this->add_control(
      'bgcolor_yourcomment_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ بک گراند نظر شما', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .send-comment .form-group label, .auth .form-group label' => 'background-color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_control(
      'paddingbox3_comment_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'فاصله داخلی باکس ویژگی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .send-comment .form-group label, .auth .form-group label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'borderradius2_comment_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'گوشه خمیده پس زمینه باکس ویژگی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
        '{{WRAPPER}} .send-comment .form-group label, .auth .form-group label' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->add_control(
      'bgcolor_comment2_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ بک گراند باکس نظرات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .send-comment .form-group .form-control, .auth .form-group .form-control' => 'background-color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_control(
      'bordercolor1_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ بوردر باکس نظرات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .send-comment .form-group .form-control, .auth .form-group .form-control' => 'border-color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_control(
      'bordercolorhover1_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ هاور بوردر باکس نظرات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .send-comment .form-group .form-control:focus, .auth .form-group .form-control:focus' => 'border-color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_control(
      'heightsize_box_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'ارتفاع باکس نظرات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'unit' => 'px',
        'range' => [
          'px' => [
            'min' => 1,
            'max' => 280,
          ]
        ],
        'selectors' => [
          '{{WRAPPER}} .send-comment .form-group textarea.form-control, .auth .form-group textarea.form-control' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'widthtsize_box_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'عرض باکس نظرات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'unit' => '%',
        'range' => [
          'px' => [
            'min' => 1,
            'max' => 100,
          ]
        ],
        'selectors' => [
          '{{WRAPPER}} .send-comment .form-group textarea.form-control, .auth .form-group textarea.form-control' => 'width: {{SIZE}}%;',
        ],
      ]
    );
    $this->add_control(
      'borderradius1_comment_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'گوشه خمیده پس زمینه باکس نظرات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
        '{{WRAPPER}} .send-comment .form-group textarea.form-control, .auth .form-group textarea.form-control' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style11_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'دکمه ارسال', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_colo2butt_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ عنوان دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .comment-respond .btn' => 'color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title1_typest2butt_kavehwoocommerceproductcomment',
        'label' => esc_html__( 'تایپوگرافی عنوان دکمه', 'kaveh-core' ),
        'selector' => 
        '{{WRAPPER}} .comment-respond .btn',
      ]
    );
    $this->add_control(
      'bgcolor2_butt_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ بکگراند دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .comment-respond .btn' => 'background-color: {{VALUE}}!important',
        ],
      ]
    );
    $this->add_control(
      'bgcolorhover2_butt_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ هاور بکگراند دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .comment-respond .btn:hover' => 'background-color: {{VALUE}}!important',
        ],
      ]
    );
    $this->add_control(
      'borderradius1_box_butt_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'گوشه خمیده پس زمینه دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
        '{{WRAPPER}} .comment-respond .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'style12_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'باکس اصلی', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'bgcolor1_box_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'رنگ بکگراند', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #comments' => 'background-color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadow_one_kavehwoocommerceproductcommen',
        'label' => esc_html__( 'سایه باکس', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} #comments',
      ]
      );
    $this->add_control(
      'paddingbox_box_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} #comments' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'borderradius_box_kavehwoocommerceproductcomment',
      [
        'label' => esc_html__( 'گوشه خمیده پس زمینه خط', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
        '{{WRAPPER}} #comments' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

  }



  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    if (!class_exists('WooCommerce')) {
      return;
  }
  if (\Elementor\Plugin::$instance->editor->is_edit_mode()) {
    $args = array(
      'post_type' => 'product',
      'posts_per_page' => 1, // آخرین محصول
      'orderby' => 'date',
      'order' => 'DESC',
  );
      $latest_product = wc_get_products($args);
        // دریافت ID محصول
        $product_id = $latest_product[0]; 
      
        if(!empty($product_id)){
        $product    = wc_get_product( $product_id );
                ?>
            <div class="comment-elementor">
              <?php  comments_template(); ?>
            </div>
            <?php      
            }
} else {
    global $post;
    $product_id = get_queried_object_id();

    if(!empty($product_id)){
      $product    = wc_get_product( $product_id );
            $product_attributes = $product->get_attributes();
              ?>


        <div class="comment-elementor">
           <?php  comments_template(); ?>
        </div>
       <style>
        .product {
        background-color: #fff;
        -webkit-box-shadow: unset;
        -moz-box-shadow: unset;
        box-shadow: unset;
        }
        #comments .rate-comment {
        padding-bottom: 63px;
        margin-bottom: 59px;
        border-bottom: unset;
        }
       </style>
          <?php      
          }

}

?>
    <?php
  }

}


