<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
  exit;
} // Exit if accessed directly

class Kavehwoocommerceproductattr extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'kavehwoocommerceproductattr';
  }

  public function get_title()
  {
    return esc_html__('المان ویژگی های محصول تکی', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['woocommercekavehelements'];
  }

  protected function register_controls()
  {
    $this->start_controls_section(
      'content1kavehwoocommerceproductattr',
      [
        'label' => esc_html__( 'محتوا', 'kaveh-core' ),
    
       'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'text_alignkavehwoocommerceproductattr',
      [
        'label' => esc_html__( 'چیدمان متن', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::CHOOSE,
        'default'   => 'text-start',
        'options' => [
          'text-end' => [
            'title' => esc_html__( 'چپ چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-left',
          ],
          'text-center' => [
            'title' => esc_html__( 'وسط چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-center',
          ],
          'text-start' => [
            'title' => esc_html__( 'راست چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-right',
          ],
        ],
        'toggle' => true,
      ]
    );
    $this->add_control(
      'titletagkavehwoocommerceproductattr',
      [
        'label' => esc_html__( 'تگ عنوان ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'style_kavehwoocommerceproductattr',
      [
        'label' => esc_html__( 'استایل', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title1typekavehwoocommerceproductattr',
        'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .main-post-title',
      ]
    );
    $this->add_control(
      'title1color1kavehwoocommerceproductattr',
      [
        'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .main-post-title' => 'color: {{VALUE}} !important',
        ],
      ]
    );
    $this->end_controls_section();

  }



  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    if (!class_exists('WooCommerce')) {
      return;
  }
  if (\Elementor\Plugin::$instance->editor->is_edit_mode()) {
    $args = array(
      'post_type' => 'product',
      'posts_per_page' => 1, // آخرین محصول
      'orderby' => 'date',
      'order' => 'DESC',
  );
      $latest_product = wc_get_products($args);
        // دریافت ID محصول
        $product_id = $latest_product[0]; 
      
        if(!empty($product_id)){
        $product    = wc_get_product( $product_id );
              $product_attributes = $product->get_attributes();
                ?>
          <?php if(!empty($product_attributes)){ ?>

          <!-- Start Specifications -->
          <div id="specifications" class="tab-pane show fade active">
            <ul>
            <?php
                      // Loop through each attribute
                      foreach ($product_attributes as $attribute){
                      $attribute_slug = $attribute->get_name();
              ?>
              <li class="d-flex align-items-center flex-wrap position-relative">
                <span> <?php echo wc_attribute_label( $attribute_slug ) ?></span>
                <span> <?php echo $product->get_attribute( $attribute_slug ) ?> </span>
              </li>
              <?php 
                  }
                ?>
            </ul>
          </div>
          <!-- End Specifications -->
           <?php } ?>
      
         
            <?php      
            }
} else {
    global $post;
    $product_id = get_queried_object_id();

    if(!empty($product_id)){
      $product    = wc_get_product( $product_id );
            $product_attributes = $product->get_attributes();
              ?>

        <?php if(!empty($product_attributes)){ ?>

        <!-- Start Specifications -->
        <div id="specifications" class="">
          <ul>
          <?php
                    // Loop through each attribute
                    foreach ($product_attributes as $attribute){
                    $attribute_slug = $attribute->get_name();
            ?>
            <li class="d-flex align-items-center flex-wrap position-relative">
              <span> <?php echo wc_attribute_label( $attribute_slug ) ?></span>
              <span> <?php echo $product->get_attribute( $attribute_slug ) ?> </span>
            </li>
            <?php 
                }
              ?>
          </ul>
        </div>
        <!-- End Specifications -->
         <?php } ?>
       
          <?php      
          }

}

?>
    <?php
  }

}


