<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
  exit;
} // Exit if accessed directly

class kavehwoocommerceprice extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'kavehwoocommerceprice';
  }

  public function get_title()
  {
    return esc_html__('المان قیمت محصول تکی', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['woocommercekavehelements'];
  }

  protected function register_controls()
  {
    $this->start_controls_section(
      'content1kavehwoocommerceprice',
      [
        'label' => esc_html__( 'محتوا', 'kaveh-core' ),
    
       'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'text_alignkavehwoocommerceprice',
      [
        'label' => esc_html__( 'چیدمان متن', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::CHOOSE,
        'default'   => 'text-start',
        'options' => [
          'text-end' => [
            'title' => esc_html__( 'چپ چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-left',
          ],
          'text-center' => [
            'title' => esc_html__( 'وسط چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-center',
          ],
          'text-start' => [
            'title' => esc_html__( 'راست چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-right',
          ],
        ],
        'toggle' => true,
      ]
    );
    $this->add_control(
      'titletagkavehwoocommerceprice',
      [
        'label' => esc_html__( 'تگ عنوان ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'style_kavehwoocommerceprice',
      [
        'label' => esc_html__( 'استایل', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title1ـcolor1_kavehwoocommerceprice',
      [
        'label' => esc_html__( 'رنگ عنوان تخفیف', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .price-add-to-cart .offer-product' => 'color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title1ـtype_kavehwoocommerceprice',
        'label' => esc_html__( 'تایپوگرافی عنوان تخفیف', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .price-add-to-cart .offer-product',
      ]
    );
    $this->add_control(
      'title2ـcolor1_kavehwoocommerceprice',
      [
        'label' => esc_html__( 'رنگ قیمت تخفیف خورده', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} del .woocommerce-Price-amount bdi:first-child' => 'color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title2ـtype_kavehwoocommerceprice',
        'label' => esc_html__( 'تایپوگرافی قیمت تخفیف خورده', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} del .woocommerce-Price-amount bdi:first-child',
      ]
    );
    $this->add_control(
      'lineـcolor1_kavehwoocommerceprice',
      [
        'label' => esc_html__( 'رنگ خط تخفیف', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} del .woocommerce-Price-amount bdi:first-child' => 'text-decoration: line-through {{VALUE}} !important',
        ],
      ]
    );
    $this->add_control(
      'title3ـcolor1_kavehwoocommerceprice',
      [
        'label' => esc_html__( 'رنگ تومان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .woocommerce-Price-amount:only-child .woocommerce-Price-currencySymbol' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title3ـtype_kavehwoocommerceprice',
        'label' => esc_html__( 'تایپوگرافی تومان', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .woocommerce-Price-amount:only-child .woocommerce-Price-currencySymbol',
      ]
    );
    $this->end_controls_section();

  }



  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    if ( ! class_exists( 'WooCommerce' ) ) {
      return;
  }

  if (\Elementor\Plugin::$instance->editor->is_edit_mode()) {
    $args = array(
      'post_type' => 'product',
      'posts_per_page' => 1, // آخرین محصول
      'orderby' => 'date',
      'order' => 'DESC',
  );
      $latest_product = wc_get_products($args);
        // دریافت ID محصول
        $product_id = $latest_product[0]; 
      global $product;
        if(!empty($product_id)){
        $product    = wc_get_product( $product_id );

        if ($product) {
          $regular_price = $product->get_regular_price(); // قیمت اصلی
          $sale_price    = $product->get_sale_price();    // قیمت تخفیف خورده
          $currency      = get_woocommerce_currency_symbol(); // واحد پول
  
          // بررسی تخفیف
          $has_discount = $sale_price && $regular_price > $sale_price;
  
          // محاسبه درصد تخفیف
          $discount_percentage = $has_discount ? round((($regular_price - $sale_price) / $regular_price) * 100) : 0;
  
          // تولید HTML داینامیک
          ?>
           <div class="price-add-to-cart">
                <?php if ( !$product->is_type( 'variable' ) ) : ?>
                    <?php if(!empty($sale_price) ): ?>
                    <div class="offer-product">
                        <span> <?php
                $percentage = round( ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100 );
                echo $percentage . "%";
                ?> </span>
                        تخفیف
                    </div>
                    <?php endif; ?>
               <div class="price d-flex align-items-center mt-sm-0">
                <?php
                $price_v = $product->get_price_html(); 
                echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                ?>
                </div>
              <?php elseif ( $product->is_type( 'variable' ) ) : 
              ?>

               <div class="price d-flex align-items-center mt-sm-0">
                <?php
                $price_v = $product->get_price_html(); 
                echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                ?>
                </div>

              <?php
              endif; ?>
             
            </div>
          <?php
      }
          }else{
        esc_html__('هیچ محصولی یافت نشد.', 'kaveh-core');  
      } 

  }else{
   global $product;


    $product_id = get_queried_object_id();
    if(!empty($product_id)){
    $product    = wc_get_product( $product_id ); ?>

<?php 
      if ($product) {
        $regular_price = $product->get_regular_price(); // قیمت اصلی
        $sale_price    = $product->get_sale_price();    // قیمت تخفیف خورده
        $currency      = get_woocommerce_currency_symbol(); // واحد پول

        // بررسی تخفیف
        $has_discount = $sale_price && $regular_price > $sale_price;

        // محاسبه درصد تخفیف
        $discount_percentage = $has_discount ? round((($regular_price - $sale_price) / $regular_price) * 100) : 0;

        // تولید HTML داینامیک
        ?>
            <div class="price-add-to-cart">
                <?php if ( !$product->is_type( 'variable' ) ) : ?>
                    <?php if(!empty($sale_price) ): ?>
                    <div class="offer-product">
                        <span> <?php
                $percentage = round( ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100 );
                echo $percentage . "%";
                ?> </span>
                        تخفیف
                    </div>
                    <?php endif; ?>
               <div class="price d-flex align-items-center mt-sm-0">
                <?php
                $price_v = $product->get_price_html(); 
                echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                ?>
                </div>
              <?php elseif ( $product->is_type( 'variable' ) ) : 
              ?>

               <div class="price d-flex align-items-center mt-sm-0">
                <?php
                $price_v = $product->get_price_html(); 
                echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                ?>
                </div>

              <?php
              endif; ?>
             
            </div>
        <?php 
    }

      }else{
    esc_html__('هیچ محصولی یافت نشد.', 'kaveh-core');  
  } 


  }


  }

}


