<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
  exit;
} // Exit if accessed directly

class kavehwoocommerceimages extends \Elementor\Widget_Base
{
  public function get_name()
  {
    return 'kavehwoocommerceimages';
  }

  public function get_title()
  {
    return esc_html__('المان گالری تصاویر محصول تکی', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['woocommercekavehelements'];
  }

  protected function register_controls()
  {
    $this->start_controls_section(
      'content1kavehwoocommerceimages',
      [
        'label' => esc_html__('محتوا', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->end_controls_section();




///////////////////////////////// style //////////////////////////////////




    $this->start_controls_section(
      'style1_kavehwoocommerceimages',
      [
        'label' => esc_html__('باکس کناری گالری محصول', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'bgcolorbox_one_kavehwoocommerceimages',
      [
        'label' => esc_html__('رنگ بک گراند باکس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .detail-product-icons' => 'background-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'iconcolorbox_one_kavehwoocommerceimages',
      [
        'label' => esc_html__('رنگ آیکون های اشتراک گذاری باکس', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .detail-product-icons li' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'paddingbox_one_kavehwoocommerceimages',
      [
        'label' => esc_html__( 'فاصله داخلی باکس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .detail-product-icons' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'borderradiusbox_one_kavehwoocommerceimages',
      [
        'label' => esc_html__( 'گوشه خمیده باکس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
        '{{WRAPPER}} .detail-product-icons' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'boxshadow_one_kavehwoocommerceimages',
        'label' => esc_html__( 'سایه باکس', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .detail-product-icons',
      ]
      );
    $this->end_controls_section();
    $this->start_controls_section(
      'style2_kavehwoocommerceimages',
      [
        'label' => esc_html__('استایل باکس تصویر اصلی', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'bgcolorboximgorg_one_kavehwoocommerceimages',
      [
        'label' => esc_html__('رنگ بک گراند باکس تصویر اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .detail-product-info .gallery-image-origin' => 'background-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'paddingboximgorg_one_kavehwoocommerceimages',
      [
        'label' => esc_html__( 'فاصله داخلی باکس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .detail-product-info .gallery-image-origin' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'borderradiusboximgorg_one_kavehwoocommerceimages',
      [
        'label' => esc_html__( 'گوشه خمیده باکس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
        '{{WRAPPER}} .detail-product-info .gallery-image-origin' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'style3_kavehwoocommerceimages',
      [
        'label' => esc_html__('استایل باکس تصاویر', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'bgcolorboximgs_one_kavehwoocommerceimages',
      [
        'label' => esc_html__('رنگ بک گراند باکس تصاویر', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .detail-product-info .gallery-image-item' => 'background-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'paddingboximgs_one_kavehwoocommerceimages',
      [
        'label' => esc_html__( 'فاصله داخلی باکس تصاویر', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .detail-product-info .gallery-image-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'borderradiusboximgs_one_kavehwoocommerceimages',
      [
        'label' => esc_html__( 'گوشه خمیده باکس تصاویر', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
        '{{WRAPPER}} .detail-product-info .gallery-image-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'borderradiusimgs_one_kavehwoocommerceimages',
      [
        'label' => esc_html__( 'گوشه خمیده تصاویر', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
        '{{WRAPPER}} .detail-product-info .gallery-image-item img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'style4_kavehwoocommerceimages',
      [
        'label' => esc_html__('استایل باکس اصلی', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'bgcolorboxorg_one_kavehwoocommerceimages',
      [
        'label' => esc_html__('رنگ بک گراند باکس اصلی', 'kaveh-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .detail-product-info .gallery-image' => 'background-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'paddingboxorg_one_kavehwoocommerceimages',
      [
        'label' => esc_html__( 'فاصله داخلی باکس تصاویر', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .detail-product-info .gallery-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'borderradiusboxorg_one_kavehwoocommerceimages',
      [
        'label' => esc_html__( 'گوشه خمیده باکس تصاویر', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
        '{{WRAPPER}} .detail-product-info .gallery-image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );


  }





  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    if (!class_exists('WooCommerce')) {
      return;
    }
    // بررسی اینکه آیا در ویرایشگر المنتور هستیم
    if (\Elementor\Plugin::$instance->editor->is_edit_mode()) {
      $args = array(
        'post_type' => 'product',
        'posts_per_page' => 1, // آخرین محصول
        'orderby' => 'date',
        'order' => 'DESC',
      );

      $query = new WP_Query($args);

      if ($query->have_posts()) {
        while ($query->have_posts()) {
          $query->the_post();

          // ID آخرین محصول
          $product_id = get_the_ID();
          // دریافت شیء محصول
          $product = wc_get_product($product_id);

          // دریافت گالری تصاویر محصول
          $product_gallery = $product->get_gallery_image_ids();

          $post_thumbnail_id = $product->get_image_id();
          $columns = apply_filters('woocommerce_product_thumbnails_columns', 4);


          $wrapper_classes = apply_filters(
            'woocommerce_single_product_image_gallery_classes',
            array(
              'woocommerce-product-gallery',
              'woocommerce-product-gallery--' . ($post_thumbnail_id ? 'with-images' : 'without-images'),
              'woocommerce-product-gallery--columns-' . absint($columns),
              'images',
            )
          );

          // اگر گالری تصاویر وجود دارد
          if ($product_id) {
            // کد نمایش گالری تصاویر
            ?>
            <div class="detail-product-info">
              <div class="gallery-image position-relative">
                <!-- Start Gallery Image Origin -->
                <div class="gallery-image-origin d-flex align-items-center justify-content-center">
                  <?php $image = wp_get_attachment_image_src(get_post_thumbnail_id($product_id), 'single-post-thumbnail'); ?>
                  <div class="<?php echo esc_attr(implode(' ', array_map('sanitize_html_class', $wrapper_classes))); ?>"
                    data-columns="<?php echo esc_attr($columns); ?>" style="opacity: 0; transition: opacity .25s ease-in-out;">
                    <div class="woocommerce-product-gallery__wrapper">
                      <?php
                      // تصویر برجسته محصول
                      $image = wp_get_attachment_image_src(get_post_thumbnail_id($product_id), 'single-post-thumbnail');
                      ?>
                      <img src="<?php echo $image[0]; ?>" alt="product" width="264" height="264" class="d-block mx-auto">
                    </div>
                  </div>
                </div>
                <!-- End Gallery Image Origin -->


                <!-- Start Gallery Image Items -->
                <div class="swiper gallery-image-items overflow-hidden"
                  data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"0":{"slidesPerView":3,"spaceBetween":10},"768":{"slidesPerView":3,"spaceBetween":20}}}'>
                  <div class="swiper-wrapper">

                    <?php
                    // نمایش تصاویر گالری
                    foreach ($product_gallery as $attachment_id) {
                      $image_url = wp_get_attachment_url($attachment_id);
                      ?>
                      <!-- Start Slide -->
                      <div class="swiper-slide">
                        <img src="<?php echo esc_url($image_url); ?>" alt="product" width="264" height="264"
                          class="d-block mx-auto">
                      </div>
                      <!-- End Slide -->
                      <?php
                    }
                    ?>
                    <div class="swiper-slide">
                      <div class="gallery-image-item" data-bs-toggle="modal" data-bs-target="#modal-gallery">
                        <?php
                        $thumbnail_id = $product->get_image_id(); // Get the attachment ID of the product thumbnail
                        $thumbnail_url = wp_get_attachment_url($thumbnail_id);
                        ?>
                        <img src="<?php echo $thumbnail_url; ?>" alt="product" />
                      </div>
                    </div>

                  </div>
                  <div class="swiper-button-next"></div>
                  <div class="swiper-button-prev"></div>
                </div>
                <!-- End Gallery Image Items -->
                <?php if (!empty($sale_price)) { ?>
                  <!-- Start Offer -->
                  <div class="detail-product-offer">
                    <?php
                    $percentage = round((($product->get_regular_price() - $product->get_sale_price()) / $product->get_regular_price()) * 100);
                    echo $percentage . "%";
                    ?>
                  </div>
                  <!-- End Offer -->
                <?php } ?>

                <!-- Start Icons -->
                <ul class="detail-product-icons">
                  <li data-bs-toggle="tooltip" title="مقایسه" data-bs-placement="left">
                    <?php
                    if (is_plugin_active('woo-smart-compare/wpc-smart-compare.php')) {
                      echo do_shortcode('[woosc id="".<?php echo get_the_ID(); ?>.""]');
                    } else {

                    }
                    ?>
                  </li>
                  <li data-bs-toggle="tooltip" title="اشتراک گذاری" data-bs-placement="left">
                    <i class="isax isax-share5" data-bs-toggle="modal" data-bs-target="#exampleModal"></i>
                  </li>
                  <li data-bs-toggle="tooltip" title="افزودن به موردعلاقه" data-bs-placement="left">
                    <?php
                    if (is_plugin_active('woo-smart-wishlist/wpc-smart-wishlist.php')) { ?>
                      <?php echo do_shortcode('[woosw id="".<?php echo get_the_ID(); ?>.""]'); ?>
                      <?php
                    } else {

                    }
                    ?>
                  </li>
                </ul>
                <!-- End Icons -->

              </div>
            </div>
            <?php
          }
        }
        wp_reset_postdata();
      }

    } else {
      // در حالت نمایش در سایت (وقتی در ویرایشگر نیستیم)
      global $product;
      $product_id = get_queried_object_id();
      // اطمینان از اینکه $product یک شیء محصول است
      $product_gallery = get_post_meta($product_id, '_product_image_gallery', true);
      $post_thumbnail_id = get_post_thumbnail_id($product_id);
      $columns = apply_filters('woocommerce_product_thumbnails_columns', 4);

      $wrapper_classes = apply_filters(
        'woocommerce_single_product_image_gallery_classes',
        array(
          'woocommerce-product-gallery',
          'woocommerce-product-gallery--' . ($post_thumbnail_id ? 'with-images' : 'without-images'),
          'woocommerce-product-gallery--columns-' . absint($columns),
          'images',
        )
      );

      if ($product_id) {
        $product_gallery = explode(',', $product_gallery); // جدا کردن آیدی‌ها
        ?>
        <div class="detail-product-info">
          <div class="gallery-image position-relative">
            <!-- Start Gallery Image Origin -->
            <div class="gallery-image-origin d-flex align-items-center justify-content-center">
              <?php $image = wp_get_attachment_image_src(get_post_thumbnail_id($product_id), 'single-post-thumbnail'); ?>
              <div class="<?php echo esc_attr(implode(' ', array_map('sanitize_html_class', $wrapper_classes))); ?>"
                data-columns="<?php echo esc_attr($columns); ?>" style="opacity: 0; transition: opacity .25s ease-in-out;">
                <div class="woocommerce-product-gallery__wrapper">
                  <?php
                  if ($post_thumbnail_id) {
                    $html = wc_get_gallery_image_html($post_thumbnail_id, true);
                  } else {
                    $html = '<div class="woocommerce-product-gallery__image--placeholder">';
                    $html .= sprintf('<img src="%s" alt="%s" class="wp-post-image" />', esc_url(wc_placeholder_img_src('woocommerce_single')), esc_html__('Awaiting product image', 'woocommerce'));
                    $html .= '</div>';
                  }

                  echo apply_filters('woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id);
                  ?>
                </div>
              </div>
            </div>
            <!-- End Gallery Image Origin -->


            <!-- Start Gallery Image Items -->
            <div class="swiper gallery-image-items overflow-hidden"
              data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"0":{"slidesPerView":3,"spaceBetween":10},"768":{"slidesPerView":3,"spaceBetween":20}}}'>
              <div class="swiper-wrapper">

                <?php
                if ($product_gallery) {
                  foreach ($product_gallery as $attachment_id) {
                    ?>

                    <div class="swiper-slide">
                      <div class="gallery-image-item" data-bs-toggle="modal" data-bs-target="#modal-gallery">
                        <img src="<?php echo wp_get_attachment_url($attachment_id); ?>" alt="product" />
                      </div>
                    </div>
                    <?php
                  }
                }

                ?>
                <div class="swiper-slide">
                  <div class="gallery-image-item" data-bs-toggle="modal" data-bs-target="#modal-gallery">
                    <?php
                    $thumbnail_id = $product->get_image_id(); // Get the attachment ID of the product thumbnail
                    $thumbnail_url = wp_get_attachment_url($thumbnail_id);
                    ?>
                    <img src="<?php echo $thumbnail_url; ?>" alt="product" />
                  </div>
                </div>

              </div>
              <div class="swiper-button-next"></div>
              <div class="swiper-button-prev"></div>
            </div>
            <!-- End Gallery Image Items -->
            <?php if (!empty($sale_price)) { ?>
              <!-- Start Offer -->
              <div class="detail-product-offer">
                <?php
                $percentage = round((($product->get_regular_price() - $product->get_sale_price()) / $product->get_regular_price()) * 100);
                echo $percentage . "%";
                ?>
              </div>
              <!-- End Offer -->
            <?php } ?>

            <!-- Start Icons -->
            <ul class="detail-product-icons">
              <li data-bs-toggle="tooltip" title="مقایسه" data-bs-placement="left">
                <?php
                if (is_plugin_active('woo-smart-compare/wpc-smart-compare.php')) {
                  echo do_shortcode('[woosc id="".<?php echo get_the_ID(); ?>.""]');
                } else {

                }
                ?>
              </li>
              <li data-bs-toggle="tooltip" title="اشتراک گذاری" data-bs-placement="left">
                <i class="isax isax-share5" data-bs-toggle="modal" data-bs-target="#exampleModal"></i>
              </li>
              <li data-bs-toggle="tooltip" title="افزودن به موردعلاقه" data-bs-placement="left">
                <?php
                if (is_plugin_active('woo-smart-wishlist/wpc-smart-wishlist.php')) { ?>
                  <?php echo do_shortcode('[woosw id="".<?php echo get_the_ID(); ?>.""]'); ?>
                  <?php
                } else {

                }
                ?>
              </li>
            </ul>
            <!-- End Icons -->

          </div>
        </div>
        <?php
      }


    }
    ?>
    <?php if (\Elementor\Plugin::$instance->editor->is_edit_mode()): ?>
    <?php else: ?>
      <?php do_action('kaveh_single_modal_gallery'); ?>
    <?php endif; ?>
    <style>
      .detail-product__images {
        max-width: 500px;
      }
    </style>
    <?php
  }
}
