<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

class kavehwoocommerceExcerpt extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'kavehwoocommerceexcerpt';
    }

    public function get_title()
    {
        return esc_html__('المان خلاصه توضیحات محصول تکی', 'kaveh-core');
    }

    public function get_icon()
    {
        return 'eicon-archive-posts';
    }

    public function get_categories()
    {
        return ['woocommercekavehelements'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content1kavehwoocommerceexcerpt',
            [
                'label' => esc_html__('محتوا', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'text_alignkavehwoocommerceexcerpt',
            [
                'label' => esc_html__('چیدمان متن', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'default' => 'text-start',
                'options' => [
                    'text-end' => [
                        'title' => esc_html__('چپ چین', 'kaveh-core'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'text-center' => [
                        'title' => esc_html__('وسط چین', 'kaveh-core'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'text-start' => [
                        'title' => esc_html__('راست چین', 'kaveh-core'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'text-justify' => [
                        'title' => esc_html__('تراز', 'kaveh-core'),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'toggle' => true,
            ]
        );

        // Add Trim Switcher
        $this->add_control(
            'enable_trimkavehwoocommerceexcerpt',
            [
                'label' => esc_html__('فعال کردن برش متن', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'kaveh-core'),
                'label_off' => esc_html__('خیر', 'kaveh-core'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        // Add Word Limit Control
        $this->add_control(
            'word_limittrimkavehwoocommerceexcerpt',
            [
                'label' => esc_html__('تعداد کلمات', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 20,
                'min' => 5,
                'max' => 100,
                'step' => 1,
                'condition' => [
                    'enable_trimkavehwoocommerceexcerpt' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_kavehwoocommerceexcerpt',
            [
                'label' => esc_html__('استایل', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'excerpt_typography',
                'label' => esc_html__('تایپوگرافی متن', 'kaveh-core'),
                'selector' => '{{WRAPPER}} .product-summary',
            ]
        );

        $this->add_control(
            'excerpt_color',
            [
                'label' => esc_html__('رنگ متن', 'kaveh-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-summary' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        if (!class_exists('WooCommerce')) {
            return;
        }

        if (\Elementor\Plugin::$instance->editor->is_edit_mode()) {
            $args = [
                'limit' => 1,
                'orderby' => 'date',
                'order' => 'DESC',
                'return' => 'ids',
                'status' => 'publish',
            ];
            $latest_product = wc_get_products($args);
            $excerpt = !empty($latest_product) ? get_post_field('post_excerpt', $latest_product[0]) : esc_html__('هیچ محصولی یافت نشد.', 'kaveh-core');
        } else {
            global $post;
            $excerpt = $post ? get_the_excerpt($post) : esc_html__('هیچ توضیحی موجود نیست.', 'kaveh-core');
        }

        // Trim the excerpt if enabled
        if ($settings['enable_trimkavehwoocommerceexcerpt'] === 'yes' && !empty($settings['word_limittrimkavehwoocommerceexcerpt'])) {
            $countexcerpt = (int)$settings['word_limittrimkavehwoocommerceexcerpt'];
            $excerpt = wp_trim_words($excerpt, $countexcerpt, ' […]');
        }
        ?>

        <div class="product-summary <?php echo esc_attr($settings['text_alignkavehwoocommerceexcerpt']); ?>">
            <?php echo wp_kses_post($excerpt); ?>
        </div>

        <style>
            .text-justify {
                text-align: justify;
            }
        </style>

        <?php
    }
}
