<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
  exit;
} // Exit if accessed directly

class kavehwoocommercecontent extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'kavehwoocommercecontent';
  }

  public function get_title()
  {
    return esc_html__('المان توضیحات محصول تکی', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['woocommercekavehelements'];
  }

  protected function register_controls()
  {
    $this->start_controls_section(
      'content1kavehwoocommercecontent',
      [
        'label' => esc_html__( 'محتوا', 'kaveh-core' ),
    
       'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'text_alignkavehwoocommercecontent',
      [
        'label' => esc_html__( 'چیدمان متن', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::CHOOSE,
        'default'   => 'text-start',
        'options' => [
          'text-end' => [
            'title' => esc_html__( 'چپ چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-left',
          ],
          'text-center' => [
            'title' => esc_html__( 'وسط چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-center',
          ],
          'text-start' => [
            'title' => esc_html__( 'راست چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-right',
          ],
          'text-justify' => [
            'title' => esc_html__( 'تراز', 'kaveh-core' ),
            'icon' => 'eicon-text-align-justify',
          ],
        ],
        'toggle' => true,
      ]
    );
    

    $this->end_controls_section();
    $this->start_controls_section(
      'style_kavehwoocommercecontent',
      [
        'label' => esc_html__( 'استایل', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title1typekavehwoocommercecontent',
        'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .main-post-content',
      ]
    );
    $this->add_control(
      'title1color1kavehwoocommercecontent',
      [
        'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .main-post-content' => 'color: {{VALUE}} !important',
        ],
      ]
    );
    $this->end_controls_section();

  }



  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    if (!class_exists('WooCommerce')) {
      return;
  }
  if (\Elementor\Plugin::$instance->editor->is_edit_mode()) {
    $args = [
        'limit'   => 1,
        'orderby' => 'date',
        'order'   => 'DESC',
        'return'  => 'ids',
        'status'  => 'publish',
    ];
    $latest_product = wc_get_products($args);
    $content = !empty($latest_product) ? get_post_field('post_content', $latest_product[0]) : esc_html__('هیچ محصولی یافت نشد.', 'kaveh-core');
} else {
    global $post;
    $content = apply_filters('the_content', get_the_content(null, false, $post));
}

?>
<div class="product-description main-post-description <?php echo esc_attr($this->get_settings_for_display('text_alignkavehwoocommercecontent')); ?>">
    <?php echo wp_kses_post($content); ?>
</div>

<style>
  .text-justify {
    text-align: justify;
}

</style>
    <?php
  }

}


