<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
  exit;
} // Exit if accessed directly

class kavehwoocommerceattrexe extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'kavehwoocommerceattrexe';
  }

  public function get_title()
  {
    return esc_html__('المان خلاصه ویژگی های محصول تکی', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['woocommercekavehelements'];
  }

  protected function register_controls()
  {
    $this->start_controls_section(
      'content1kavehwoocommerceattrexe',
      [
        'label' => esc_html__( 'محتوا', 'kaveh-core' ),
    
       'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'text_alignkavehwoocommerceattrexe',
      [
        'label' => esc_html__( 'چیدمان متن', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::CHOOSE,
        'default'   => 'text-start',
        'options' => [
          'text-end' => [
            'title' => esc_html__( 'چپ چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-left',
          ],
          'text-center' => [
            'title' => esc_html__( 'وسط چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-center',
          ],
          'text-start' => [
            'title' => esc_html__( 'راست چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-right',
          ],
        ],
        'toggle' => true,
      ]
    );
    $this->add_control(
      'titletagkavehwoocommerceattrexe',
      [
        'label' => esc_html__( 'تگ عنوان ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'style_kavehwoocommerceattrexe',
      [
        'label' => esc_html__( 'استایل', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title1typekavehwoocommerceattrexe',
        'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .main-post-title',
      ]
    );
    $this->add_control(
      'title1color1kavehwoocommerceattrexe',
      [
        'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .main-post-title' => 'color: {{VALUE}} !important',
        ],
      ]
    );
    $this->end_controls_section();

  }



  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    if ( ! class_exists( 'WooCommerce' ) ) {
      return;
  }

  if (\Elementor\Plugin::$instance->editor->is_edit_mode()) {
    $args = array(
      'post_type' => 'product',
      'posts_per_page' => 1, // آخرین محصول
      'orderby' => 'date',
      'order' => 'DESC',
  );
      $latest_product = wc_get_products($args);
        // دریافت ID محصول
        $product_id = $latest_product[0]; 
      
        if(!empty($product_id)){
        $product    = wc_get_product( $product_id );
        $i = 0;
              $product_attributes = $product->get_attributes();
              if(!empty($product_attributes)){
                ?>
        <div class="detail-product">
           <div class="detail">
            <div class="options">
              <ul class="d-flex align-items-center flex-wrap">
              <?php
                      // Loop through each attribute
                      foreach ($product_attributes as $attribute){
                      $attribute_slug = $attribute->get_name();
                      if($i<8){
              ?>

              <li> <?php echo wc_attribute_label( $attribute_slug ) ?> : <?php echo $product->get_attribute( $attribute_slug ) ?> </li>
          <?php 
          $i++;
                  }
                }      
                ?>
                </ul>
                  </div>
              </div>
            </div>
            <?php      
            }

          }else{
        esc_html__('هیچ محصولی یافت نشد.', 'kaveh-core');  
      } 

  }else{
    global $product;


    $product_id = get_queried_object_id();
    if(!empty($product_id)){
    $product    = wc_get_product( $product_id );

    $i = 0;
          $product_attributes = $product->get_attributes();

          if(!empty($product_attributes)){
            ?>
    <div class="detail-product detail-elementor">
      <div class="detail">
         <div class="options">
         <ul class="d-flex align-items-center flex-wrap">
          <?php
                  // Loop through each attribute
                  foreach ($product_attributes as $attribute){
                  $attribute_slug = $attribute->get_name();
                  if($i<8){
          ?>
              <li> <?php echo wc_attribute_label( $attribute_slug ) ?> : <?php echo $product->get_attribute( $attribute_slug ) ?> </li>

      <?php 
      $i++;
              }
            }      
            ?>
              </ul>
                </div>
            </div>
        </div>
        <?php      
        }

      }else{
    esc_html__('هیچ محصولی یافت نشد.', 'kaveh-core');  
  } 


  }
?>
  <style>
    .detail-product .detail .options{
    padding-right: 0;
    }
    .product .detail {
    padding: 0;
      }
  </style>
<?php

  }

}


