<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
  exit;
} // Exit if accessed directly

class kavehwoocommerceaddtocart extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'kavehwoocommerceaddtocart';
  }

  public function get_title()
  {
    return esc_html__('المان افزودن به کارت محصول تکی', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['woocommercekavehelements'];
  }

  protected function register_controls()
  {
    $this->start_controls_section(
      'content1kavehwoocommerceaddtocart',
      [
        'label' => esc_html__( 'محتوا', 'kaveh-core' ),
    
       'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'title1kavehwoocommerceaddtocart',
      [
          'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'افزودن به سبد', 'kaveh-core' ),
  
      ]
  );

    $this->add_control(
      'text_alignkavehwoocommerceaddtocart',
      [
        'label' => esc_html__( 'چیدمان متن', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::CHOOSE,
        'default'   => 'text-start',
        'options' => [
          'text-end' => [
            'title' => esc_html__( 'چپ چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-left',
          ],
          'text-center' => [
            'title' => esc_html__( 'وسط چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-center',
          ],
          'text-start' => [
            'title' => esc_html__( 'راست چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-right',
          ],
        ],
        'toggle' => true,
      ]
    );
    $this->add_control(
      'titletagkavehwoocommerceaddtocart',
      [
        'label' => esc_html__( 'تگ عنوان ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'style_kavehwoocommerceaddtocart',
      [
        'label' => esc_html__( 'استایل', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title1typekavehwoocommerceaddtocart',
        'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .main-post-title',
      ]
    );
    $this->add_control(
      'title1color1kavehwoocommerceaddtocart',
      [
        'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .main-post-title' => 'color: {{VALUE}} !important',
        ],
      ]
    );
    $this->end_controls_section();

  }



  protected function render()
  {
      global $product;
      $product_id = get_the_ID();
      $product = wc_get_product($product_id); // گرفتن محصول

      // گرفتن تنظیمات ویجت
      $settings = $this->get_settings_for_display();
      $custom_button_text = $settings['title1kavehwoocommerceaddtocart'];
  
      // بررسی وجود ووکامرس
      if (!class_exists('WooCommerce')) {
          return;
      }
  
      // بررسی حالت ویرایشگر المنتور
      if (\Elementor\Plugin::$instance->editor->is_edit_mode()) {
          // کوئری برای گرفتن یک محصول نمونه
          $args = array(
              'post_type' => 'product',
              'posts_per_page' => 1,
              'orderby' => 'date',
              'order' => 'DESC',
          );
  
          $product_query = new \WP_Query($args);
  
          if ($product_query->have_posts()) {
              $product_query->the_post(); // تنظیم محصول فعلی در حلقه
              $product = wc_get_product(get_the_ID()); // گرفتن محصول
          } else {
              echo '<p>' . esc_html__('محصولی یافت نشد.', 'kaveh-core') . '</p>';
              return;
          }
      }
  
      // بررسی وجود محصول
      if (!$product) {
          echo '<p>' . esc_html__('محصولی یافت نشد.', 'kaveh-core') . '</p>';
          return;
      }
  
      // تغییر متن دکمه افزودن به سبد خرید
      add_filter('woocommerce_product_single_add_to_cart_text', function () use ($custom_button_text) {
          return $custom_button_text ? $custom_button_text : __('Add to Cart', 'woocommerce');
      });


      if (\Elementor\Plugin::$instance->editor->is_edit_mode()):
        ?>
        <div class="woocommerce insingle_pr">
          <?php 
          // نمایش دکمه افزودن به کارت
          woocommerce_template_single_add_to_cart();
          ?>
        </div>
        <?php
      else:
        ?>
        <div class="insingle_pr">
          <?php  
          woocommerce_template_single_add_to_cart();
          ?>
        </div>
        <?php

      endif;
  


  
      // بازنشانی داده‌ها
      if (\Elementor\Plugin::$instance->editor->is_edit_mode()) {
          wp_reset_postdata();
      }
  }
  

}


