<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
  exit;
} // Exit if accessed directly

class KavehBlogSingletitle extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'kavehblogsingletitle';
  }

  public function get_title()
  {
    return esc_html__('المان عنوان پست تکی', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['blogsingleelements'];
  }

  protected function register_controls()
  {
    $this->start_controls_section(
      'content1karenblogsingletitle',
      [
        'label' => esc_html__( 'محتوا', 'kaveh-core' ),
    
       'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'text_alignbuttononekaren',
      [
        'label' => esc_html__( 'چیدمان متن', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::CHOOSE,
        'default'   => 'text-start',
        'options' => [
          'text-end' => [
            'title' => esc_html__( 'چپ چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-left',
          ],
          'text-center' => [
            'title' => esc_html__( 'وسط چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-center',
          ],
          'text-start' => [
            'title' => esc_html__( 'راست چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-right',
          ],
        ],
        'toggle' => true,
      ]
    );
    $this->add_control(
      'titletagkarenblogsingletitle',
      [
        'label' => esc_html__( 'تگ عنوان ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H4',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'style_karenblogsingletitle',
      [
        'label' => esc_html__( 'استایل', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title1typekarenblogsingletitle',
        'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .main-post-title',
      ]
    );
    $this->add_control(
      'title1color1karenblogsingletitle',
      [
        'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .main-post-title' => 'color: {{VALUE}} !important',
        ],
      ]
    );
    $this->end_controls_section();

  }



  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <?php if (is_single()): ?>
      <?php $title = get_the_title(); ?>
      <div>
        <<?php echo  esc_attr($settings['titletagkarenblogsingletitle']); ?> class="main-post-title group_title <?php echo esc_attr($settings['text_alignbuttononekaren']); ?> mb-0"> <?php echo $title; ?></<?php echo  esc_attr($settings['titletagkarenblogsingletitle']); ?>>
      </div>
    <?php endif; ?>


    <?php
  }

}


