<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
  exit;
} // Exit if accessed directly

class KavehBlogSingleRelated extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'kavehblogsinglerelated';
  }

  public function get_title()
  {
    return esc_html__('المان پست های مرتبط پست تکی', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['blogsingleelements'];
  }

  protected function register_controls()
  {


  }



  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

    <?php if (is_single()): ?>
                <!-- Start Related Articles -->
                <div class="detail-blog-related overflow-hidden">
            <div class="container position-relative">
                <!-- Start Heading -->
                <div class="heading d-flex align-items-center justify-content-between">
                    <h4 class="fw-bold position-relative">
                        <span class="fw-light d-block">
                            <?php
                            // مطالب
                            esc_html_e('Articles', 'kavehTheme');
                            ?>
                        </span>
                        <?php
                        // مرتبط
                        esc_html_e('Related', 'kavehTheme');
                        ?>
                    </h4>
                    <a href="javascript:void(0)" class="btn btn-outline-dark rounded-pill">
                        <?php
                        // مشاهده همه
                        esc_html_e('View All', 'kavehTheme');
                        ?>
                    </a>
                </div>
                <!-- End Heading -->
                <div class="detail-blog-related-wrapper">
                    <div class="swiper swiper-related-articles"
                        data-swiper='{"loop":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":1,"spaceBetween":4},"768":{"slidesPerView":2,"spaceBetween":12},"992":{"slidesPerView":2,"spaceBetween":30}}}'>
                        <div class="swiper-wrapper">
                            <?php
                            // WP_Query args
                            $q_querylast_args = array(
                                'post_type' => array('post'),
                                'posts_per_page' => 5,
                                'order' => 'DESC',
                                'orderby' => 'date',
                            );

                            // The Query
                            $querylast = new WP_Query($q_querylast_args);

                            // The Loop
                            if ($querylast->have_posts()) {
                                while ($querylast->have_posts()) {
                                    $querylast->the_post();
                                    $categories = get_the_category(); // Get categories assigned to the post
                                    $category_name = !empty($categories) ? $categories[0]->name : ''; // Retrieve the first category name
                        
                                    ?>
                                    <div class="swiper-slide">
                                        <article class="article">
                                            <figure>
                                                <?php if (has_post_thumbnail(get_the_ID())) { ?>
                                                    <a href="<?php the_permalink(); ?>">
                                                        <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title(); ?>"
                                                            class="d-flex w-100" />
                                                    </a>
                                                <?php } ?>
                                                <div class="category-time">
                                                    <a href="javascript:void(0)">
                                                        <?php echo $category_name; ?>
                                                    </a>
                                                    <span><?php echo get_the_date(); ?></span>
                                                </div>
                                            </figure>
                                            <h2>
                                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                            </h2>
                                            <p><?php echo get_the_excerpt(); ?></p>
                                        </article>
                                    </div>
                                    <?php
                                }
                            } else {
                                // There are no posts
                            }
                            // Reset Original Post Data
                            wp_reset_postdata();
                            ?>
                        </div>
                        <div class="swiper-button-next"></div>
                        <div class="swiper-button-prev"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Related Articles -->
    <?php endif; ?>

    <?php
  }

}


