<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
  exit;
} // Exit if accessed directly

class KavehBlogSinglemeta extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'kavehblogsinglemeta';
  }

  public function get_title()
  {
    return esc_html__('المان متاهای پست تکی', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['blogsingleelements'];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'content1karenblogsinglemeta',
      [
        'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
      $this->add_control(
        'text_alignkarenblogsinglemeta',
        [
          'label' => esc_html__( 'چیدمان متا', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::CHOOSE,
          'default'   => 'justify-content-center',
          'options' => [
            'justify-content-end' => [
              'title' => esc_html__('چپ چین', 'kaveh-core'),
              'icon' => 'eicon-h-align-left',
            ],
            'justify-content-center' => [
              'title' => esc_html__('وسط چین', 'kaveh-core'),
              'icon' => 'eicon-h-align-center',
            ],
            'justify-content-start' => [
              'title' => esc_html__('راست چین', 'kaveh-core'),
              'icon' => 'eicon-h-align-right',
            ],
          ],
          'toggle' => true,
        ]
      );
      $repeater = new \Elementor\Repeater();         
      $repeater->add_control(
        'typeofkarenblogsinglemeta',
        [
          'label' => esc_html__( 'طرح بندی المان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'categories',
          'options' => [
            'categories'  => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
            'tags'  => esc_html__( 'برچسب ها', 'kaveh-core' ),
            'date'  => esc_html__( 'تاریخ', 'kaveh-core' ),
            'author'  => esc_html__( 'نویسنده', 'kaveh-core' ),
            'comment'  => esc_html__( 'تعداد نظرات', 'kaveh-core' ),
          ],
        ]
        ); 
        $repeater->add_control(
          'dateformatkarenblogsinglemeta',
          [
            'label' => esc_html__( 'فرمت نمایش تاریخ', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'condition' => [
              'typeofkarenblogsinglemeta' => [ 'date' ],
            ],
            'default' => 'F j, Y',
            'options' => [
              'F j, Y'  => esc_html__( ' جولای 4, 2024', 'kaveh-core' ),
              'Y-m-d'  => esc_html__( '2024-07-04', 'kaveh-core' ),
              'm/d/Y'  => esc_html__( '07/04/2024', 'kaveh-core' ),
              'd/m/Y'  => esc_html__( '04/07/2024', 'kaveh-core' ),

            ],
          ]
          );
      $repeater->add_control(
        'titleboxcol1karenblogsinglemeta',
        [
          'label' => esc_html__( 'متن قبل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => '',
        ]
      );
      $repeater->add_control(
        'zerocommentboxcol1karenblogsinglemeta',
        [
          'label' => esc_html__( 'متن جای صفر کامنت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'typeofkarenblogsinglemeta' => [ 'comment' ],
          ],
          'default' => 'بدون دیدگاه',
        ]
      );
      $repeater->add_control(
        'aftercommentboxcol1karenblogsinglemeta',
        [
          'label' => esc_html__( 'متن بعد از تعداد کامنت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'typeofkarenblogsinglemeta' => [ 'comment' ],
          ],
          'default' => 'دیدگاه',
        ]
      );
      $repeater->add_control(
        'showauthorimgkarenblogsinglemeta',
        [
          'label' => esc_html__( 'نمایش قبل از نویسنده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'condition' => [
            'typeofkarenblogsinglemeta' => [ 'author' ],
          ],
          'default' => 'avatar',
          'options' => [
            'avatar'  => esc_html__( 'تصویر آواتار', 'kaveh-core' ),
            'icon'  => esc_html__( 'آیکون', 'kaveh-core' ),
            'none'  => esc_html__( 'هیچکدام', 'kaveh-core' ),
          ],
        ]
        ); 
      $repeater->add_control(
        'iconskarenblogsinglemeta',
        [
          'label' => esc_html__( 'آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::ICONS,
          'skin' => 'inline',
          'exclude_inline_options' => [ 'svg' ],
          'default' => [
            'value' => 'icon-folder',
          ],
        ]
      );
        $this->add_control(
          'tabsboxkarenblogsinglemeta',
          [
              'label' => esc_html__( 'افزودن متا', 'kaveh-core' ),
              'type' => Elementor\Controls_Manager::REPEATER,
              'placeholder' => esc_html__( 'متا جدید اضافه کنید', 'kaveh-core' ),
              'fields' => $repeater->get_controls(),
          ]
      );
     $this->end_controls_section();
     $this->start_controls_section(
      'style_mainmenukarenblogsinglemeta',
      [
        'label' => esc_html__( 'استایل متای دسته بندی', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titlemenukarenblogsinglemeta',
        'label' => esc_html__( 'تایپوگرافی قبل از متای دسته بندی', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-category .item span',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title2menukarenblogsinglemeta',
        'label' => esc_html__( 'تایپوگرافی متای دسته بندی', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-category',
      ]
    );
    $this->add_control(
      'beficonsizekarenblogsinglemeta',
      [
        'label' => esc_html__( 'سایز آیکون قبل از متای دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 200,
            'step' => 1,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-category .item i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'marginbeficonmenukarenblogsinglemeta',
      [
        'label' => esc_html__( 'فاصله خارجی آیکون قبل از متای دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-category .item i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'marginmenukarenblogsinglemeta',
      [
        'label' => esc_html__( 'فاصله خارجی متای دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-category' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'beficoncolorkarenblogsinglemeta',
      [
        'label' => esc_html__( 'رنگ آیکون قبل از متای دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .meta-karen-category .item i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'afticoncolorkarenblogsinglemeta',
      [
        'label' => esc_html__( 'رنگ متن قبل از متای دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .meta-karen-category .item span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
        'title1color1karenblogsinglemeta',
        [
          'label' => esc_html__( 'رنگ متای دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .meta-karen-category' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'title1hovercolor1karenblogsinglemeta',
        [
          'label' => esc_html__( 'رنگ هاور متای دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .meta-karen-category:hover' => 'color: {{VALUE}}',
          ],
        ]
      );
    $this->add_control(
      'iconbgbutkarenblogsinglemeta',
      [
        'label' => esc_html__( 'رنگ پس زمینه متای دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .meta-karen-category' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonradiuskarenblogsinglemeta',
      [
        'label' => esc_html__( 'گوشه خمیده متای دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-category' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'borderkarenblogsinglemeta',
        'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-category',
      ]
    );
    $this->add_control(
      'buttonborderskarenblogsinglemeta',
      [
        'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'condition' => [
          'borderkarenblogsinglemeta!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-category' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadowkarenblogsinglemeta',
        'label' => esc_html__( 'سایه متای دسته بندی', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-category',
      ]
    );
    $this->add_control(
      'paddingmenukarenblogsinglemeta',
      [
        'label' => esc_html__( 'فاصله داخلی متای دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-category' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_tagskarenblogsinglemeta',
      [
        'label' => esc_html__( 'استایل متای برچسب', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titlemenutagskarenblogsinglemeta',
        'label' => esc_html__( 'تایپوگرافی قبل از متای برچسب', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-tag .item span',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title2menutagskarenblogsinglemeta',
        'label' => esc_html__( 'تایپوگرافی متای برچسب', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-tag',
      ]
    );
    $this->add_control(
      'beficonsizetagskarenblogsinglemeta',
      [
        'label' => esc_html__( 'سایز آیکون قبل از متای برچسب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 200,
            'step' => 1,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-tag .item i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'marginbeficonmenutagskarenblogsinglemeta',
      [
        'label' => esc_html__( 'فاصله خارجی آیکون قبل از متای برچسب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-tag .item i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'marginmenutagskarenblogsinglemeta',
      [
        'label' => esc_html__( 'فاصله خارجی متای برچسب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-tag' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'beficoncolortagskarenblogsinglemeta',
      [
        'label' => esc_html__( 'رنگ آیکون قبل از متای برچسب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .meta-karen-tag .item i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'afticoncolortagskarenblogsinglemeta',
      [
        'label' => esc_html__( 'رنگ متن قبل از متای برچسب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .meta-karen-tag .item span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
        'title1color1tagskarenblogsinglemeta',
        [
          'label' => esc_html__( 'رنگ متای برچسب', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .meta-karen-tag' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'title1hovercolor1tagskarenblogsinglemeta',
        [
          'label' => esc_html__( 'رنگ هاور متای برچسب', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .meta-karen-tag:hover' => 'color: {{VALUE}}',
          ],
        ]
      );
    $this->add_control(
      'iconbgbuttagskarenblogsinglemeta',
      [
        'label' => esc_html__( 'رنگ پس زمینه متای برچسب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .meta-karen-tag' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonradiustagskarenblogsinglemeta',
      [
        'label' => esc_html__( 'گوشه خمیده متای برچسب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-tag' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'bordertagskarenblogsinglemeta',
        'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-tag',
      ]
    );
    $this->add_control(
      'buttonborderstagskarenblogsinglemeta',
      [
        'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'condition' => [
          'bordertagskarenblogsinglemeta!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-tag' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadowtagskarenblogsinglemeta',
        'label' => esc_html__( 'سایه متای برچسب', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-tag',
      ]
    );
    $this->add_control(
      'paddingmenutagskarenblogsinglemeta',
      [
        'label' => esc_html__( 'فاصله داخلی متای برچسب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-tag' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_datekarenblogsinglemeta',
      [
        'label' => esc_html__( 'استایل متای تاریخ', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titlemenudatekarenblogsinglemeta',
        'label' => esc_html__( 'تایپوگرافی قبل از متای تاریخ', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-date .item span',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title2menudatekarenblogsinglemeta',
        'label' => esc_html__( 'تایپوگرافی متای تاریخ', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-date',
      ]
    );
    $this->add_control(
      'beficonsizedatekarenblogsinglemeta',
      [
        'label' => esc_html__( 'سایز آیکون قبل از متای تاریخ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 200,
            'step' => 1,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-date .item i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'marginbeficonmenudatekarenblogsinglemeta',
      [
        'label' => esc_html__( 'فاصله خارجی آیکون قبل از متای تاریخ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-date .item i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'marginmenudatekarenblogsinglemeta',
      [
        'label' => esc_html__( 'فاصله خارجی متای تاریخ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'beficoncolordatekarenblogsinglemeta',
      [
        'label' => esc_html__( 'رنگ آیکون قبل از متای تاریخ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .meta-karen-date .item i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'afticoncolordatekarenblogsinglemeta',
      [
        'label' => esc_html__( 'رنگ متن قبل از متای تاریخ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .meta-karen-date .item span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
        'title1color1datekarenblogsinglemeta',
        [
          'label' => esc_html__( 'رنگ متای تاریخ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .meta-karen-date' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'title1hovercolor1datekarenblogsinglemeta',
        [
          'label' => esc_html__( 'رنگ هاور متای تاریخ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .meta-karen-date:hover' => 'color: {{VALUE}}',
          ],
        ]
      );
    $this->add_control(
      'iconbgbutdatekarenblogsinglemeta',
      [
        'label' => esc_html__( 'رنگ پس زمینه متای تاریخ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .meta-karen-date' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonradiusdatekarenblogsinglemeta',
      [
        'label' => esc_html__( 'گوشه خمیده متای تاریخ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-date' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'borderdatekarenblogsinglemeta',
        'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-date',
      ]
    );
    $this->add_control(
      'buttonbordersdatekarenblogsinglemeta',
      [
        'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'condition' => [
          'borderdatekarenblogsinglemeta!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-date' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadowdatekarenblogsinglemeta',
        'label' => esc_html__( 'سایه متای تاریخ', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-date',
      ]
    );
    $this->add_control(
      'paddingmenudatekarenblogsinglemeta',
      [
        'label' => esc_html__( 'فاصله داخلی متای تاریخ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_commentkarenblogsinglemeta',
      [
        'label' => esc_html__( 'استایل متای نظرات', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titlemenucommentkarenblogsinglemeta',
        'label' => esc_html__( 'تایپوگرافی قبل از متای نظرات', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-comment .item span',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title2menucommentkarenblogsinglemeta',
        'label' => esc_html__( 'تایپوگرافی متای نظرات', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-comment',
      ]
    );
    $this->add_control(
      'beficonsizecommentkarenblogsinglemeta',
      [
        'label' => esc_html__( 'سایز آیکون قبل از متای نظرات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 200,
            'step' => 1,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-comment .item i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'marginbeficonmenucommentkarenblogsinglemeta',
      [
        'label' => esc_html__( 'فاصله خارجی آیکون قبل از متای نظرات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-comment .item i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'marginmenucommentkarenblogsinglemeta',
      [
        'label' => esc_html__( 'فاصله خارجی متای نظرات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-comment' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'beficoncolorcommentkarenblogsinglemeta',
      [
        'label' => esc_html__( 'رنگ آیکون قبل از متای نظرات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .meta-karen-comment .item i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'afticoncolorcommentkarenblogsinglemeta',
      [
        'label' => esc_html__( 'رنگ متن قبل از متای نظرات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .meta-karen-comment .item span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
        'title1color1commentkarenblogsinglemeta',
        [
          'label' => esc_html__( 'رنگ متای نظرات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .meta-karen-comment' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'title1hovercolor1commentkarenblogsinglemeta',
        [
          'label' => esc_html__( 'رنگ هاور متای نظرات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .meta-karen-comment:hover' => 'color: {{VALUE}}',
          ],
        ]
      );
    $this->add_control(
      'iconbgbutcommentkarenblogsinglemeta',
      [
        'label' => esc_html__( 'رنگ پس زمینه متای نظرات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .meta-karen-comment' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonradiuscommentkarenblogsinglemeta',
      [
        'label' => esc_html__( 'گوشه خمیده متای نظرات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-comment' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'bordercommentkarenblogsinglemeta',
        'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-comment',
      ]
    );
    $this->add_control(
      'buttonborderscommentkarenblogsinglemeta',
      [
        'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'condition' => [
          'bordercommentkarenblogsinglemeta!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-comment' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadowcommentkarenblogsinglemeta',
        'label' => esc_html__( 'سایه متای نظرات', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-comment',
      ]
    );
    $this->add_control(
      'paddingmenucommentkarenblogsinglemeta',
      [
        'label' => esc_html__( 'فاصله داخلی متای نظرات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-comment' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_authorkarenblogsinglemeta',
      [
        'label' => esc_html__( 'استایل متای نویسنده', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'titlemenuauthorkarenblogsinglemeta',
        'label' => esc_html__( 'تایپوگرافی قبل از متای نویسنده', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-author .writer-name span',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title2menuauthorkarenblogsinglemeta',
        'label' => esc_html__( 'تایپوگرافی متای نویسنده', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-author .writer-name',
      ]
    );
    $this->add_control(
      'beficonsizeauthorkarenblogsinglemeta',
      [
        'label' => esc_html__( 'سایز آیکون قبل از متای نویسنده', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 200,
            'step' => 1,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-author i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    
    $this->add_control(
      'marginbeficonmenuauthorkarenblogsinglemeta',
      [
        'label' => esc_html__( 'فاصله خارجی آیکون قبل از متای نویسنده', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-author i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .AZ-post-page-medical .writer-img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'befavatarsizeauthorkarenblogsinglemeta',
      [
        'label' => esc_html__( 'عرض آواتار نویسنده', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 200,
            'step' => 1,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .AZ-post-page-medical .writer-img' => 'width: {{SIZE}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->add_control(
      'avatarradiusauthorkarenblogsinglemeta',
      [
        'label' => esc_html__( 'گوشه خمیده آواتار نویسنده', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .AZ-post-page-medical .writer-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'marginmenuauthorkarenblogsinglemeta',
      [
        'label' => esc_html__( 'فاصله خارجی متای نویسنده', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-author' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'beficoncolorauthorkarenblogsinglemeta',
      [
        'label' => esc_html__( 'رنگ آیکون قبل از متای نویسنده', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .meta-karen-author i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'afticoncolorauthorkarenblogsinglemeta',
      [
        'label' => esc_html__( 'رنگ متن قبل از متای نویسنده', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .meta-karen-author .writer-name span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
        'title1color1authorkarenblogsinglemeta',
        [
          'label' => esc_html__( 'رنگ متای نویسنده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .meta-karen-author .writer-name' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'title1hovercolor1authorkarenblogsinglemeta',
        [
          'label' => esc_html__( 'رنگ هاور متای نویسنده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .meta-karen-author .writer-name:hover' => 'color: {{VALUE}}',
          ],
        ]
      );
    $this->add_control(
      'iconbgbutauthorkarenblogsinglemeta',
      [
        'label' => esc_html__( 'رنگ پس زمینه متای نویسنده', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .meta-karen-author' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'buttonradiusauthorkarenblogsinglemeta',
      [
        'label' => esc_html__( 'گوشه خمیده متای نویسنده', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-author' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'borderauthorkarenblogsinglemeta',
        'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-author',
      ]
    );
    $this->add_control(
      'buttonbordersauthorkarenblogsinglemeta',
      [
        'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'condition' => [
          'borderauthorkarenblogsinglemeta!' => '',
        ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-author' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadowauthorkarenblogsinglemeta',
        'label' => esc_html__( 'سایه متای نویسنده', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .meta-karen-author',
      ]
    );
    $this->add_control(
      'paddingmenuauthorkarenblogsinglemeta',
      [
        'label' => esc_html__( 'فاصله داخلی متای نویسنده', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .meta-karen-author' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }



  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <?php if (is_single()): ?>
      <div class="AZ-blog-section-hosting AZ-post-page-hosting AZ-post-page-medical AZ-post-page-marketing d-block">
        <div
          class="d-flex align-items-start align-items-lg-center <?php echo esc_html($settings['text_alignkarenblogsinglemeta']); ?>">
          <div class="post-details-box">
            <div class="d-flex align-items-center gap-4 flex-column flex-sm-row">
                <?php
                if ( $settings['tabsboxkarenblogsinglemeta'] ) {
                foreach (  $settings['tabsboxkarenblogsinglemeta'] as $item ) {
                ?>
                 <?php if( 'author' !== $item['typeofkarenblogsinglemeta']){ ?>
                <div class="category-post  d-flex align-items-center gap-2 <?php if( 'categories' === $item['typeofkarenblogsinglemeta'] ){ ?>meta-karen-category<?php }elseif( 'tags' === $item['typeofkarenblogsinglemeta'] ){ ?>meta-karen-tag<?php }elseif( 'date' === $item['typeofkarenblogsinglemeta'] ){ ?>meta-karen-date<?php }elseif( 'comment' === $item['typeofkarenblogsinglemeta'] ){ ?>meta-karen-comment<?php } ?>">
                <p class="item d-flex align-items-center gap-1"> <i class="<?php echo esc_html($item['iconskarenblogsinglemeta']['value']); ?> text-default-80 fs-16 me-1"></i> 
                <span><?php echo esc_html($item['titleboxcol1karenblogsinglemeta']); ?> </span></p>
                <?php if( 'categories' === $item['typeofkarenblogsinglemeta']){ ?>
                <?php
                $categories = get_the_category();

                if ( ! empty( $categories ) ) {
                    $separator = ', ';
                    $output = '';
                    foreach ( $categories as $category ) {
                        $output .= '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '">' . esc_html( $category->name ) . '</a>' . $separator;
                    }
                    // Trim the final separator
                    echo rtrim( $output, $separator );
                }
                ?>
                <?php }elseif( 'tags' === $item['typeofkarenblogsinglemeta'] ){ ?>
                  <?php
                  $tags = get_the_tags();

                  if ( ! empty( $tags ) ) {
                      $separator = ', ';
                      $output = '';
                      foreach ( $tags as $tag ) {
                          $output .= '<a href="' . esc_url( get_tag_link( $tag->term_id ) ) . '">' . esc_html( $tag->name ) . '</a>' . $separator;
                      }
                      // Trim the final separator
                      echo rtrim( $output, $separator );
                  }
                  ?>
                <?php }elseif( 'date' === $item['typeofkarenblogsinglemeta'] ){ ?>
                <?php $formatdate = esc_html($item['dateformatkarenblogsinglemeta']); ?>
                <?php the_date($formatdate) ?>
                <?php }elseif( 'comment' === $item['typeofkarenblogsinglemeta'] ){ ?>
                  <?php $commentnum = get_comments_number();?>
                  <?php if($commentnum == 0){echo $item['zerocommentboxcol1karenblogsinglemeta'];}else{ echo $commentnum; ?><span><?php echo esc_html($item['aftercommentboxcol1karenblogsinglemeta']); ?> </span><?php }  ?> 
                
                  <?php } ?>
                <?php }else{ ?>

              <div class="writer-info d-flex align-items-center gap-2 meta-karen-author">
                  <?php $avatar_url = get_avatar_url(get_the_author_meta('email'), array('size' => 46)); ?>
                  <?php if( 'avatar' === $item['showauthorimgkarenblogsinglemeta']){ ?>
                  <div class="writer-img AZ-img-container">
                    <div class="AZ-img-container-inner AZ-img-cover">
                      <img src="<?php echo $avatar_url; ?>" alt="<?php echo get_the_author_meta('nickname'); ?>">
                   </div>
                </div>
                  <?php }elseif( 'icon' === $item['showauthorimgkarenblogsinglemeta']){ ?>
                  <i class="<?php echo esc_html($item['iconskarenblogsinglemeta']['value']); ?> text-default-80 fs-16 me-1"></i> 
                  <?php }else{ ?>
                  <?php } ?>
                <div>
                  <div class="writer-name"><span><?php echo esc_html($item['titleboxcol1karenblogsinglemeta']); ?> </span> <?php the_author(); ?></div>
                <?php } ?>
              </div>
                <?php 
                    }
                  }
                ?>  

            </div>
          </div>
        </div>
      </div>
      <style>
        p.item.d-flex.align-items-center.gap-1 {
          margin-bottom: 0;
        }
      </style>
    <?php endif; ?>

    <?php
  }

}


