<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
  exit;
} // Exit if accessed directly

class KavehBlogSingleimage extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'kavehblogsingleimage';
  }

  public function get_title()
  {
    return esc_html__('المان تصویر شاخص پست تکی', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['blogsingleelements'];
  }

  protected function register_controls()
  {
    $this->start_controls_section(
      'content1karenblogsingleimage',
      [
        'label' => esc_html__( 'محتوا', 'kaveh-core' ),
    
       'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    
    $this->add_control(
      'imgreskarenblogsingleimage',
      [
        'label' => esc_html__( 'کیفیت عکس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'default' => 'full',
        'options' => [
          'full'  => esc_html__( 'اندازه کامل', 'kaveh-core' ),
          'large'  => esc_html__( 'Large 1024*1024', 'kaveh-core' ),
          'medium'  => esc_html__( 'Medium 300*300', 'kaveh-core' ),
          'thumbnail'  => esc_html__( 'Thumbnail 150*150', 'kaveh-core' ),
        ],
      ]
      ); 
    $this->end_controls_section();
    $this->start_controls_section(
      'style_karenblogsingleimage',
      [
        'label' => esc_html__( 'استایل', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'text_alignkarenblogsingleimage',
      [
        'label' => esc_html__( 'چیدمان عکس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::CHOOSE,
        'default'   => 'justify-content-center',
        'options' => [
          'justify-content-end' => [
            'title' => esc_html__('چپ چین', 'kaveh-core'),
            'icon' => 'eicon-h-align-left',
          ],
          'justify-content-center' => [
            'title' => esc_html__('وسط چین', 'kaveh-core'),
            'icon' => 'eicon-h-align-center',
          ],
          'justify-content-start' => [
            'title' => esc_html__('راست چین', 'kaveh-core'),
            'icon' => 'eicon-h-align-right',
          ],
        ],
        'toggle' => true,
      ]
    );
    
    $this->add_control(
      'imagewidth1karenblogsingleimage',
      [
        'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'size_units' => [ 'px' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 2000,
            'step' => 1,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .post-image-thumb' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'imagemaxheight1karenblogsingleimage',
      [
        'label' => esc_html__( 'حداکثر ارتفاع تصویر', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],

        'size_units' => [ 'px' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 2000,
            'step' => 1,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .post-image-thumb' => 'max-height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'imageheight1karenblogsingleimage',
      [
        'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px' ],
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 2000,
            'step' => 1,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .post-image-thumb' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'imgr2eskarenblogsingleimage',
      [
        'label' => esc_html__( 'نوع نمایش تصویر عکس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'one',
        'options' => [
          'unset'  => esc_html__( 'پیش فرض', 'kaveh-core' ),
          'cover'  => esc_html__( 'پوشیده', 'kaveh-core' ),
          'contain'  => esc_html__( 'شامل', 'kaveh-core' ),
        ],
            'selectors' => [
          '{{WRAPPER}} .post-image-thumb' => 'object-fit: {{value}};',
        ],
      ]
      ); 
    $this->add_control(
      'imgbgradiuskarenblogsingleimage',
      [
        'label' => esc_html__( 'گوشه خمیده تصویر', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .post-image-thumb' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

  }


  
  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <?php if (is_single()): ?>
      <?php $res = esc_html($settings['imgreskarenblogsingleimage']); ?>
      <?php $title = get_the_title(); ?>
      <?php $thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), $res ); ?>
      <?php if ($thumbnail_url): // Check if there's a thumbnail ?>
        <div class="d-flex <?php echo esc_attr($settings['text_alignkarenblogsingleimage']); ?>">
          <img class="post-image-thumb" src="<?php echo esc_url($thumbnail_url); ?>" alt="<?php echo esc_attr($title); ?>">
        </div>
      <?php endif; ?>
    <?php endif; ?>
    <?php
  }

}


