<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
  exit;
} // Exit if accessed directly

class KavehBlogSinglecontent extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'kavehblogsinglecontent';
  }

  public function get_title()
  {
    return esc_html__('المان محتوای پست تکی', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['blogsingleelements'];
  }

  protected function register_controls()
  {
    $this->start_controls_section(
      'style_karenblogsinglecontent',
      [
        'label' => esc_html__( 'استایل', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'text_alignkarenblogsinglecontent',
      [
        'label' => esc_html__( 'چیدمان متن', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::CHOOSE,
        'default'   => 'text-start',
        'options' => [
          'text-end' => [
            'title' => esc_html__( 'چپ چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-left',
          ],
          'text-center' => [
            'title' => esc_html__( 'وسط چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-center',
          ],
          'text-start' => [
            'title' => esc_html__( 'راست چین', 'kaveh-core' ),
            'icon' => 'eicon-text-align-right',
          ],
        ],
        'toggle' => true,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title1typekarenblogsinglecontent',
        'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .post-content-style',
      ]
    );
    $this->add_control(
      'title1color1karenblogsinglecontent',
      [
        'label' => esc_html__( 'رنگ متن', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .post-content-style' => 'color: {{VALUE}} !important',
        ],
      ]
    );
    $this->end_controls_section();

  }



  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

    <?php if (is_single()): ?>
      <div class="post-content-style <?php echo esc_attr($settings['text_alignkarenblogsinglecontent']); ?>">
        <?php the_content(); ?>
      </div>
    <?php endif; ?>

    <?php
  }

}


