<?php
class kaveh_Story_Widget extends \Elementor\Widget_Base {

public function get_name() {
    return 'kaveh-story-widget';
}

public function get_title() {
    return __( 'استوری ساز کاوه', 'ag-story' );
}

public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

protected function _register_controls() {
    $this->start_controls_section(
        'story_section',
        [
            'label' => __( 'Stories', 'ag-story' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
    );

    $repeater = new \Elementor\Repeater();

    $repeater->add_control(
        'story_title',
        [
            'label' => __( 'عنوان استوری', 'ag-story' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __( 'Story Title', 'ag-story' ),
            'label_block' => true,
        ]
    );
    $repeater->add_control(
        'story_link',
        [
            'label' => __( 'لینک استوری', 'ag-story' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __( 'Story link', 'ag-story' ),
            'label_block' => true,
        ]
    );
    $repeater->add_control(
        'story_link_text',
        [
            'label' => __( 'متن لینک استوری', 'ag-story' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __( 'بزن بریم', 'ag-story' ),
            'label_block' => true,
        ]
    );
    

    // Image upload controls
    $repeater->add_control(
        'image_1',
        [
            'label' => __( 'عکس شاخص استوری', 'ag-story' ),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'label_block' => true,
        ]
    );

    $repeater->add_control(
        'image_2',
        [
            'label' => __( 'عکس استوری دسکتاپ', 'ag-story' ),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'label_block' => true,
        ]
    );

    $repeater->add_control(
        'image_3',
        [
            'label' => __( 'عکس استوری موبایل', 'ag-story' ),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'label_block' => true,
        ]
    );

    $this->add_control(
        'story_list',
        [
            'label' => __( 'لیست استوری ها', 'ag-story' ),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'story_title' => __( 'Story 1', 'ag-story' ),
                    'story_link' => __( '#', 'ag-story' ),
                    'story_link_text' => __( 'Lets Go', 'ag-story' ),
                ],
            ],
        ]
    );

    $this->end_controls_section();
}

protected function render() {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    if ($settings['story_list']) {
        ?>

      

            
            
    <div class="story-shop">
      <div class="container">
        <!-- Start Carousel -->
        <div class="swiper swiper-story-shop overflow-hidden" >
          <div class="swiper-wrapper">
          <?php foreach ($settings['story_list'] as $story) {
                    $story_title = $story['story_title'];
                    $story_link = $story['story_link'];
                    ?>
            <!-- Start Slide -->
            <div class="swiper-slide">
              <div class="story-shop-item">
                <div class="image">
                  <img src="<?php echo $story['image_1']['url']; ?>" alt="story" width="75" height="75">
                </div>
                <span class="title"> <?php echo $story_title; ?> </span>
              </div>
            </div>
            <!-- End Slide -->
            <?php
                     }
                     ?>
          </div>
        </div>
        <!-- End Carousel -->
      </div>
    </div>

    <!-- Start Carousel -->
    <div class="story-shop-carousel">
      <div class="backdrop"></div>
      <div class="content">
        <div class="box">
          <button class="close"> &times; </button>
          <div class="swiper swiper-story-shop-modal">
            <div class="swiper-wrapper">
            <?php foreach ($settings['story_list'] as $story) {
                    $story_title = $story['story_title'];
                    $story_link = $story['story_link'];
                    ?>
              <!-- Start Slide -->
              <div class="swiper-slide">
                <div class="story-shop-item-lg">
                  <a href="<?php echo $story_link; ?>">
                  <picture class="w-100">
                            <source srcset="<?php echo $story['image_2']['url']; ?>" media="(min-width: 768px)">
                            <source srcset="<?php echo $story['image_3']['url']; ?>" media="(min-width: 320px)">
                            <img src="<?php echo $story['image_2']['url']; ?>" alt="story" width="720" height="405"
                                class="d-block">
                            </picture>
                  </a>
                  <div class="info">
                    <img src="<?php echo $story['image_1']['url']; ?>" alt="image" width="42" height="42">
                    <div class="title"> <?php echo $story_title; ?> </div>
                  </div>
                  <a href="<?php echo $story_link; ?>" class="read-more">
                    <?php echo $story['story_link_text']; ?></a>
                </div>
              </div>
              <!-- End Slide -->
              <?php
                     }
                     ?>
            </div>
            <!-- Start Progress -->
            <div class="progress___bar">
              <span></span>
            </div>
            <!-- End Progress -->
            <!-- Start Button -->
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
            <!-- End Button -->
          </div>
        </div>
      </div>
    </div>
    <!-- End Carousel -->


            <style>
            .story-shop {
            margin:0;
            }
            .story-shop .swiper {
            overflow: visible;
            }
            .story-shop-item {
            width: auto;
            cursor: pointer;
            max-width: -moz-fit-content;
            max-width: fit-content;
            text-align: center;
            margin: 0 auto;
            }
            .story-shop-item .image {
            padding: 3px;
            border: 3px solid #ed1b34;
            max-width: -moz-fit-content;
            max-width: fit-content;
            transition: all 0.3s linear;
            border-radius: 50%;
            margin: 0 auto;
			overflow: hidden;
            }
            .story-shop-item .image img {
            width: 75px;
            height: 75px;
            display: block;
            border-radius: 50%;
            }
            .story-shop-item .title {
            font-size: 13px;
            line-height: 20px;
            text-align: center;
            margin-top: 8px;
            font-weight: 700;
            display: block;
            }
            .story-shop-item:active .image {
            transform: scale(0.7);
            }
            .story-shop-item.see .image {
            border-color: #ddd;
            }
            .story-shop-item-lg {
            position: relative;
            width: 100%;
            }
            .story-shop-item-lg a:first-child {
            width: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            }
            .story-shop-item-lg picture {
            width: 100%;
            }
            .story-shop-item-lg picture img {
            width: 100%;
            }
            .story-shop-item-lg .info {
            top: 16px;
            right: 12px;
            left: 32px;
            display: flex;
            align-items: center;
            position: absolute;
            }
            .story-shop-item-lg .info img {
            border: 1px solid rgba(0, 0, 0, 0.1);
            border-radius: 50%;
            }
            .story-shop-item-lg .info .title {
            margin-right: 4px;
            color: #fff;
            }
            .story-shop-item-lg .read-more {
            color: #333;
            font-size: 14px;
            font-weight: 600;
            line-height: 22px;
            z-index: 100;
            bottom: 32px;
            text-align: center;
            border-radius: 20px;
            position: absolute;
            background-color: #fff;
            left: 50%;
            transform: translateX(-50%);
            padding: 6px 12px;
            display: none;
            }
            .story-shop-carousel {
            transition: all 0.3s linear;
            z-index: 10000;
            width: 100vw;
            min-height: 100vh;
            opacity: 0;
            visibility: hidden;
            overflow: hidden;
            max-width: 100%;
            position: fixed;
            top: 0;
            left: 0;
            display: flex;
            }
            .story-shop-carousel.show {
            opacity: 1;
            visibility: visible;
            }
            .story-shop-carousel .backdrop {
            background-color: rgba(0, 0, 0, 0.6);
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            position: fixed;
            }
            .story-shop-carousel .close {
            top: 20px;
            left: 20px;
            right:unset !important;
            z-index: 20;
            font-size: 24px;
            line-height: 1;
            color: #fff;
            position: absolute;
            padding: 0;
            background:transparent;
            }
            .story-shop-carousel .content {
            min-height: calc(100vh - 24px);
            margin: 12px;
            max-width: calc(100% - 24px);
            display: flex;
            align-items: center;
            justify-content: center;
            width: 100%;
            height: 100%;
            }
            .story-shop-carousel .content .box {
            max-width: 720px;
            transform: scale(0);
            transition: all 0.3s linear;
            width: 100%;
            position: relative;
            }
            .story-shop-carousel.show .content .box {
            transform: scale(1);
            }
            .story-shop-carousel .swiper {
            width: 100%;
            margin: 0 auto;
            }
            .story-shop-carousel .swiper .progress___bar {
            height: 2px;
            background-color: rgba(255, 255, 255, 0.2);
            border-radius: 2px;
            top: 6px;
            right: 6px;
            left: 6px;
            z-index: 4;
            position: absolute;
            }
            .story-shop-carousel .swiper .progress___bar span {
            width: 0%;
            background-color: #fff;
            border-radius: 2px;
            position: absolute;
            top: 0;
            left: 0;
            height: 100%;
            }
			.story-shop-carousel .swiper-button-next, .story-shop-carousel .swiper-button-prev {
				display: flex;
			}
            .story-shop-carousel .swiper-button-next::after, .story-shop-carousel .swiper-button-prev::after {
            font-size: 20px;
            line-height: 1;
            color: #fff;
            }
            .story-shop-carousel .swiper-button-next.swiper-button-disabled, .story-shop-carousel .swiper-button-prev.swiper-button-disabled {
            opacity: 1;
            cursor: pointer;
            }
            .story-shop-carousel .swiper-button-next {
            transform: translateX(-38px);
            left: 0;
            }
            .story-shop-carousel .swiper-button-prev {
            transform: translateX(38px);
            right: 0;
            }
            @media only screen and (max-width: 991px) {
            .story-shop-carousel .content .box {
                max-width: 640px;
            }
            .story-shop-carousel .swiper-button-next, .story-shop-carousel .swiper-button-prev {
                display: none;
            }
            }
            @media only screen and (max-width: 767px) {
            .story-shop-carousel {
                background-color: #333;
            }
            .story-shop-carousel.show {
                top: 0;
            }
            .story-shop-carousel .content {
                margin: 3px 0 0;
                max-width: 100%;
                min-height: 100vh;
            }
            .story-shop-carousel .content .box {
                height: 100%;
            }
            .story-shop-carousel .swiper {
                height: 100%;
                max-height: 100vh;
                min-height: 100vh;
            }
            .story-shop-carousel .swiper-wrapper, .story-shop-carousel .swiper-slide {
                height: 100%;
            }
            .story-shop-carousel .swiper-button-next, .story-shop-carousel .swiper-button-prev {
                transform: unset;
                width: 50%;
                top: 0;
                bottom: 72px;
                height: auto;
                pointer-events: all;
                margin: 0;
            }
            .story-shop-carousel .swiper-button-next::after, .story-shop-carousel .swiper-button-prev::after {
                content: none;
            }
            .story-shop-item-lg {
                height: 100%;
                display: flex;
                align-items: center;
                justify-content: center;
                max-height: 100vh;
            }
            .story-shop-item-lg img {
                max-height: 100vh;
                height: 100%;
            }
            .story-shop-item-lg .read-more {
                display: block;
            }
            }
            @media only screen and (max-width: 575px) {
            .story-shop .swiper-slide {
                width: auto;
            }
            .story-shop .swiper-slide:not(:last-child) {
                margin-left: 20px;
            }
				.story-shop-item-lg .info img {
					width: 42px;
				}
            }
            </style>
              <?php if( \Elementor\Plugin::$instance->editor->is_edit_mode() ) : ?>
                <script>
                const swiperStory = document.querySelector(".swiper-story-shop-modal");

if (swiperStory) {
  const slideAppend = () => {
    storyItem.forEach((story, index) => {
      if (story.classList.contains("see")) {
        const index = getIndex(
          story.parentElement,
          document.querySelectorAll(".swiper-story-shop .swiper-slide")
        );

        swiperStory.appendSlide(story.parentElement);
        swiper.appendSlide(swiper.slides[index]);

        setTimeout(() => {
          swiper.autoplay.resume();
        }, 300);
      }
    });

    const see = [],
      unSee = [];

    storyItem.filter((st, index) => {
      if (st.classList.contains("see")) {
        see.push(st);
      } else {
        unSee.push(st);
      }
    });

    storyItem.splice(0, 100);

    storyItem.push(...unSee, ...see);
	  
	  storyItem.forEach(story => {
      story.style.padding = '0.1px';

      setTimeout(() => {
        story.removeAttribute('style');
      }, 5);
    })
  };

  const storyItem = Array.from(document.querySelectorAll(".story-shop-item")),
    storyItemLg = Array.from(document.querySelectorAll(".story-shop-item-lg")),
    modal = document.querySelector(".story-shop-carousel"),
    modalBackdrop = document.querySelector(".story-shop-carousel .backdrop"),
    modalClose = document.querySelector(".story-shop-carousel .close");

  const progressEl = document.querySelector(".progress___bar span");

  let disabledNext2 = false;

  let swiper = new Swiper(".swiper-story-shop-modal", {
    slidesPerView: 1,
    spaceBetween: 0,
    effect: "cube",
    grabCursor: true,
    cubeEffect: {
      shadow: false,
      slideShadows: false,
      shadowScale: 0.94,
    },
    autoplay: {
      delay: 5000,
      disableOnInteraction: false,
    },
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    observer: true,
    breakpoints: {
      768: {
        allowTouchMove: false,
      },
    },
    on: {
      autoplayTimeLeft(s, time, progress) {
        progressEl.style.width = (1 - progress) * 100 + "%";
      },
      slideChange: (s) => {
        const { nextEl } = s.navigation;

        if (disabledNext2) {
          modal.classList.remove("show");
        }

        if (modal.classList.contains("show")) {
          storyItem[s.realIndex].classList.add("see");
        }

        disabledNext2 = nextEl.classList.contains("swiper-button-disabled");
      },
    },
  });

  let swiperStory = new Swiper(".swiper-story-shop", {
    breakpoints: {
      320: {
        slidesPerView: "auto",
        spaceBetween: 0,
      },
      576: {
        slidesPerView: 5,
        spaceBetween: 0,
      },
      768: {
        slidesPerView: 7,
        spaceBetween: 0,
      },
      992: {
        slidesPerView: 8,
        spaceBetween: 0,
      },
    },
  });

  const getIndex = (target, list) => Array.prototype.indexOf.call(list, target);

  window.addEventListener("click", (ev) => {
    const el = ev.target;

    if (el.closest(".swiper-story-shop")) {
      const index = getIndex(
        el.closest(".swiper-slide"),
        el.closest(".swiper-story-shop").firstElementChild.children
      );

      modal.classList.add("show");

      el.closest(".story-shop-item").classList.add("see");

      swiper.slideTo(index, 0);

      setTimeout(() => {
        swiper.autoplay.resume();
      }, 300);
    }
  });

  if (modalBackdrop) {
    modalBackdrop.addEventListener("click", () => {
      modal.classList.remove("show");

      slideAppend();
    });
  }

  const btnReadMore = document.querySelectorAll(
    ".story-shop-item-lg .read-more"
  );

  if (btnReadMore.length > 0) {
    btnReadMore.forEach((btn) => {
      btn.addEventListener("click", (ev) => {
        modal.classList.remove("show");

        slideAppend();
      });
    });
  }

  if (modalClose) {
    modalClose.addEventListener("click", () => {
      modal.classList.remove("show");

      slideAppend();
    });
  }

  if (window.outerWidth < 768) {
    storyItemLg.forEach((item) => {
      item.firstElementChild.addEventListener("click", (ev) =>
        ev.preventDefault()
      );
    });
  }

  window.addEventListener("click", (ev) => {
    const el = ev.target;

    if (window.outerWidth < 768 && el.closest(".swiper-story-shop-modal")) {
      const widthDevice = Math.ceil(window.outerWidth / 2);

      if (ev.pageX > widthDevice) {
        if (swiper.realIndex === 0) {
          modal.classList.remove("show");
          slideAppend();
        } else {
          swiper.slideTo(swiper.realIndex - 1);
        }
      } else {
        if (swiper.realIndex === swiper.slides.length - 1) {
          modal.classList.remove("show");
          slideAppend();
        } else {
          swiper.slideTo(swiper.realIndex + 1);
        }
      }
    }
  });
}

            
           </script>
            <?php else: ?>
              <script>
              document.addEventListener("DOMContentLoaded", function() {
                const swiperStory = document.querySelector(".swiper-story-shop-modal");

if (swiperStory) {
  const slideAppend = () => {
    storyItem.forEach((story, index) => {
      if (story.classList.contains("see")) {
        const index = getIndex(
          story.parentElement,
          document.querySelectorAll(".swiper-story-shop .swiper-slide")
        );

        swiperStory.appendSlide(story.parentElement);
        swiper.appendSlide(swiper.slides[index]);

        setTimeout(() => {
          swiper.autoplay.resume();
        }, 300);
      }
    });

    const see = [],
      unSee = [];

    storyItem.filter((st, index) => {
      if (st.classList.contains("see")) {
        see.push(st);
      } else {
        unSee.push(st);
      }
    });

    storyItem.splice(0, 100);

    storyItem.push(...unSee, ...see);
	  
	  storyItem.forEach(story => {
      story.style.padding = '0.1px';

      setTimeout(() => {
        story.removeAttribute('style');
      }, 5);
    })
  };

  const storyItem = Array.from(document.querySelectorAll(".story-shop-item")),
    storyItemLg = Array.from(document.querySelectorAll(".story-shop-item-lg")),
    modal = document.querySelector(".story-shop-carousel"),
    modalBackdrop = document.querySelector(".story-shop-carousel .backdrop"),
    modalClose = document.querySelector(".story-shop-carousel .close");

  const progressEl = document.querySelector(".progress___bar span");

  let disabledNext2 = false;

  let swiper = new Swiper(".swiper-story-shop-modal", {
    slidesPerView: 1,
    spaceBetween: 0,
    effect: "cube",
    grabCursor: true,
    cubeEffect: {
      shadow: false,
      slideShadows: false,
      shadowScale: 0.94,
    },
    autoplay: {
      delay: 5000,
      disableOnInteraction: false,
    },
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    observer: true,
    breakpoints: {
      768: {
        allowTouchMove: false,
      },
    },
    on: {
      autoplayTimeLeft(s, time, progress) {
        progressEl.style.width = (1 - progress) * 100 + "%";
      },
      slideChange: (s) => {
        const { nextEl } = s.navigation;

        if (disabledNext2) {
          modal.classList.remove("show");
        }

        if (modal.classList.contains("show")) {
          storyItem[s.realIndex].classList.add("see");
        }

        disabledNext2 = nextEl.classList.contains("swiper-button-disabled");
      },
    },
  });

  let swiperStory = new Swiper(".swiper-story-shop", {
    breakpoints: {
      320: {
        slidesPerView: "auto",
        spaceBetween: 0,
      },
      576: {
        slidesPerView: 5,
        spaceBetween: 0,
      },
      768: {
        slidesPerView: 7,
        spaceBetween: 0,
      },
      992: {
        slidesPerView: 8,
        spaceBetween: 0,
      },
    },
  });

  const getIndex = (target, list) => Array.prototype.indexOf.call(list, target);

  window.addEventListener("click", (ev) => {
    const el = ev.target;

    if (el.closest(".swiper-story-shop")) {
      const index = getIndex(
        el.closest(".swiper-slide"),
        el.closest(".swiper-story-shop").firstElementChild.children
      );

      modal.classList.add("show");

      el.closest(".story-shop-item").classList.add("see");

      swiper.slideTo(index, 0);

      setTimeout(() => {
        swiper.autoplay.resume();
      }, 300);
    }
  });

  if (modalBackdrop) {
    modalBackdrop.addEventListener("click", () => {
      modal.classList.remove("show");

      slideAppend();
    });
  }

  const btnReadMore = document.querySelectorAll(
    ".story-shop-item-lg .read-more"
  );

  if (btnReadMore.length > 0) {
    btnReadMore.forEach((btn) => {
      btn.addEventListener("click", (ev) => {
        modal.classList.remove("show");

        slideAppend();
      });
    });
  }

  if (modalClose) {
    modalClose.addEventListener("click", () => {
      modal.classList.remove("show");

      slideAppend();
    });
  }

  if (window.outerWidth < 768) {
    storyItemLg.forEach((item) => {
      item.firstElementChild.addEventListener("click", (ev) =>
        ev.preventDefault()
      );
    });
  }

  window.addEventListener("click", (ev) => {
    const el = ev.target;

    if (window.outerWidth < 768 && el.closest(".swiper-story-shop-modal")) {
      const widthDevice = Math.ceil(window.outerWidth / 2);

      if (ev.pageX > widthDevice) {
        if (swiper.realIndex === 0) {
          modal.classList.remove("show");
          slideAppend();
        } else {
          swiper.slideTo(swiper.realIndex - 1);
        }
      } else {
        if (swiper.realIndex === swiper.slides.length - 1) {
          modal.classList.remove("show");
          slideAppend();
        } else {
          swiper.slideTo(swiper.realIndex + 1);
        }
      }
    }
  });
}

            
              });
           </script>
            <?php endif; ?>
     
          <?php
    }
}

}
