<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Imageboxstkaveh extends Widget_Base{

  public function get_name(){
    return 'imageboxstkaveh';
  }

  public function get_title(){
    return esc_html__( 'تصویر باکس', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentimageboxstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );

      $this->add_control(
        'brandlogoimageboxstkaveh',
        [
          'label' => esc_html__( 'تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
        );
        $this->add_control(
          'titleimageboxstkaveh',
          [
              'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'فروشگاه کاوه', 'kaveh-core' ),   
          ]
      );
    $this->add_control(
      'tagheading1imageboxstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان اصلی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H2',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
        $this->add_control(
          'linkimageboxstkaveh',
          [
              'label' => esc_html__( 'لینک', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( '#', 'kaveh-core' ),
      
          ]
      );

    $this->add_control(
      'pti2imageboxstkavehh',
      [
          'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXTAREA,
          'default' => esc_html__( 'تا ۷ روز برای احترام به انتخاب مشتریان کالای خریداری شده برگردانده می‌شود.', 'kaveh-core' ),
  
      ]
  );

       $this->end_controls_section();

      $this->start_controls_section(
        'style0_imageboxstkaveh',
        [
          'label' => esc_html__( 'استایل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'catimg1widthimageboxstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .options-bani-item img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1height2imageboxstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 500,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .options-bani-item img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'textcolor1imageboxstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .options-bani-item .content .title' => 'color: {{VALUE}} !important',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlety1_imageboxstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .options-bani-item .content .title',
        ]
      );
      $this->add_control(
        'ptextcolor1imageboxstkaveh',
        [
          'label' => esc_html__( 'رنگ متن', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .options-bani-item .content p' => 'color: {{VALUE}} !important',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'ptitlety1_imageboxstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .options-bani-item .content p',
        ]
      );
      $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
           <div class="options-bani-item position-relative">
              <a href="<?php echo  esc_html($settings['linkimageboxstkaveh']); ?>" class="stretched-link" aria-label="name"></a>
              <img src="<?php echo esc_url($settings['brandlogoimageboxstkaveh']['url']); ?>" alt="" width="100" height="98"
                class="d-block mx-auto">
              <div class="content">
                <<?php echo  esc_attr($settings['tagheading1imageboxstkaveh']); ?> class="title fw-bold w-100 mt-3 mb-2 mx-auto text-center"> <?php echo  esc_attr($settings['titleimageboxstkaveh']); ?></<?php echo  esc_attr($settings['tagheading1imageboxstkaveh']); ?>>
                <p class="mx-auto mb-0 w-100 text-center d-none d-lg-block"> <?php echo  esc_attr($settings['pti2imageboxstkavehh']); ?> </p>
              </div>
            </div>
            <style>
              .options-bani-item img {
                max-height: unset;
                object-fit: contain;
            }
            </style>

    <?php
  }


}
