<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Iconboxtwothstkaveh extends Widget_Base{

  public function get_name(){
    return 'iconboxtwothstkaveh';
  }

  public function get_title(){
    return esc_html__( 'آیکون باکس سبک دو', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contenticonboxtwothstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'iconbutticonboxtwothstkaveh',
        [
          'label' => esc_html__( 'آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::ICONS,
          'skin' => 'inline',

          'exclude_inline_options' => [ 'svg' ],
          'default' => [
            'value' => 'icon-direct',
          ],
        ]
      );
      $this->add_control(
        'ftagti1iconboxtwothstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'div',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'fwigti2iconboxtwothstkaveh',
        [
          'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => 'Our product categories',
        ]
      );
      $this->add_control(
        'tagti1iconboxtwothstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'div',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'widgtiiconboxtwothstkaveh',
        [
          'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => 'دسته بندی های',
  
        ]
      );
      $this->add_control(
        'wigti2iconboxtwothstkaveh',
        [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => 'پر فروش',
        ]
      );
      $this->add_control(
        'wigp2iconboxtwothstkaveh',
        [
          'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXTAREA,
          'default' => 'همواره، قرار گرفتن در شرایطی که برای اولین بار تجربه‌اش می‌کنیم، در ما ایجاد استرس و اضطراب می‌کند؛',
  
        ]
      );

       $this->end_controls_section();

       $this->start_controls_section(
        'stylet_iconboxtwothstkaveh',
        [
          'label' => esc_html__( 'استایل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'iconsizenchbiconboxtwothstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-teen .icon' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'textbutton1coloriconboxtwothstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-teen .icon' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'catimg1widthiconboxtwothstkaveh',
        [
          'label' => esc_html__( 'عرض پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-teen .icon' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1height2iconboxtwothstkaveh',
        [
          'label' => esc_html__( 'ارتفاع پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-teen .icon' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'textbg1coloriconboxtwothstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-teen .icon' => 'background-image: linear-gradient(180deg, {{VALUE}} 0%, rgb(255 255 255 / 19%) 47.7%, rgba(253, 231, 229, 0) 100%)',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusiconboxtwothstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-teen .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .section-heading-teen .icon::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

          ],
        ]
      );
      
      $this->add_control(
        'bordercolor21iconboxtwothstkaveh',
        [
          'label' => esc_html__( 'رنگ بردر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-teen .icon::after' => 'background: linear-gradient(180deg, {{VALUE}} 0%, {{VALUE}}02 49.83%, rgba(0, 0, 0, 0) 100%) border-box',
            
          ],
        ]
      );
      $this->add_control(
        'hr1iconboxtwothstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'ftextcolorticonboxtwothstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-teen-title-en' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'ftitletyt_iconboxtwothstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-teen-title-en',
        ]
      );
      $this->add_control(
        'textcolortboliconboxtwothstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-teen-title b' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'btitletyt_iconboxtwothstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان بولد', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-teen-title b',
        ]
      );
      $this->add_control(
        'textcolorticonboxtwothstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-teen-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletyt_iconboxtwothstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-teen-title',
        ]
      );
      $this->add_control(
        'textcolortpiconboxtwothstkaveh',
        [
          'label' => esc_html__( 'رنگ توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-teen p' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titletytp_iconboxtwothstkaveh',
          'label' => esc_html__( 'تایپوگرافی توضیحات', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-teen p',
        ]
      );
      $this->end_controls_section();


        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
      <div class="section-heading-teen w-100 mx-auto text-center">
        <i class="icon <?php echo esc_attr($settings['iconbutticonboxtwothstkaveh']['value']); ?> d-flex align-items-center justify-content-center position-relative mx-auto"></i>
        <<?php echo  esc_attr($settings['ftagti1iconboxtwothstkaveh']); ?> class="section-heading-teen-title-en"> <?php echo esc_html($settings['fwigti2iconboxtwothstkaveh']); ?> </<?php echo  esc_attr($settings['ftagti1iconboxtwothstkaveh']); ?>>
        <<?php echo  esc_attr($settings['tagti1iconboxtwothstkaveh']); ?> class="section-heading-teen-title position-relative mx-auto mb-4"> <b>  <?php echo esc_html($settings['widgtiiconboxtwothstkaveh']); ?></b> <?php echo esc_html($settings['wigti2iconboxtwothstkaveh']); ?></<?php echo  esc_attr($settings['tagti1iconboxtwothstkaveh']); ?>>
        <p class="mb-0"> <?php echo esc_html($settings['wigp2iconboxtwothstkaveh']); ?></p>
      </div>
    <?php
  }


}
