<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Iconboxthreethstkaveh extends Widget_Base{

  public function get_name(){
    return 'iconboxthreethstkaveh';
  }

  public function get_title(){
    return esc_html__( 'آیکون باکس سبک سه', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contenticonboxthreethstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'iconbutticonboxthreethstkaveh',
        [
          'label' => esc_html__( 'آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::ICONS,
          'skin' => 'inline',

          'exclude_inline_options' => [ 'svg' ],
          'default' => [
            'value' => 'icon-suport-2',
          ],
        ]
      );
      $this->add_control(
        'fwigti2iconboxthreethstkaveh',
        [
          'label' => esc_html__( 'پیش عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => 'پشتیبانی',
        ]
      );
      $this->add_control(
        'widgtiiconboxthreethstkaveh',
        [
          'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => '۲۴ ساعته',
  
        ]
      );
      $this->add_control(
        'tagti1iconboxthreethstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'div',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
       $this->end_controls_section();

       $this->start_controls_section(
        'stylet_iconboxthreethstkaveh',
        [
          'label' => esc_html__( 'استایل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'iconsizenchbiconboxthreethstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .options-website-item i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'textbutton1coloriconboxthreethstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .options-website-item i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'catimg1widthiconboxthreethstkaveh',
        [
          'label' => esc_html__( 'عرض پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .options-website-item i' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'catimg1height2iconboxthreethstkaveh',
        [
          'label' => esc_html__( 'ارتفاع پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .options-website-item i' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'textbg1coloriconboxthreethstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .options-website-item i' => 'background-image:  -webkit-gradient(linear, left top, left bottom, from({{VALUE}}), color-stop(62.25%, {{VALUE}}), to(rgba(253, 231, 229, 0)))',
          ],
        ]
      ); 
     
      $this->add_control(
        'buttonradiusiconboxthreethstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .options-website-item i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );

      $this->add_control(
        'hr1iconboxthreethstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'ftextcolorticonboxthreethstkaveh',
        [
          'label' => esc_html__( 'رنگ پیش عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .options-website-item .tit' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'ftitletyt_iconboxthreethstkaveh',
          'label' => esc_html__( 'تایپوگرافی پیش عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .options-website-item .tit',
        ]
      );
      $this->add_control(
        'textcolortboliconboxthreethstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .options-website-item span' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'btitletyt_iconboxthreethstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان بولد', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .options-website-item span',
        ]
      );
      $this->end_controls_section();


        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <div class="options-website-item d-flex align-items-center">
      <i class="<?php echo esc_attr($settings['iconbutticonboxthreethstkaveh']['value']); ?> d-flex align-items-center justify-content-center"></i>
      <<?php echo  esc_attr($settings['tagti1iconboxthreethstkaveh']); ?> class="tit">
      <?php echo  esc_html($settings['fwigti2iconboxthreethstkaveh']); ?><span> <?php echo  esc_html($settings['widgtiiconboxthreethstkaveh']); ?> </span>
      </<?php echo  esc_attr($settings['tagti1iconboxthreethstkaveh']); ?>>
    </div>
    <style>
    .options-website-item span {
    font-weight: 900;
    color: #de027a;
    }
    .options-website-item .tit {
    font-size: 15px;
    line-height: 23px;
    color: #000;
}
    </style>
    <?php
  }


}
