<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Iconboxkaveh extends Widget_Base{

  public function get_name(){
    return 'iconboxkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان آیکون باکس', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['headerfooterkavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contenticonboxkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );

        $this->add_control(
          'beforetitleiconboxkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'شماره تماس', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'titleiconboxkaveh',
        [
            'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( '1234567' , 'kaveh-core' ),
    
        ]
    ); 
    $this->add_control(
      'aftertitleiconboxkaveh',
      [
          'label' => esc_html__( 'پس از عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '021', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'iconiconboxkaveh',
    [
      'label' => esc_html__( 'آیکون', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::ICONS,
      'skin' => 'inline',
      'exclude_inline_options' => [ 'svg' ],
      'default' => [
        'value' => 'icon-phone',
      ],
    ]
  ); 

        $this->end_controls_section();
        $this->start_controls_section(
          'style_iconboxkaveh',
          [
            'label' => esc_html__( 'استایل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        );
        $this->add_control(
          'iconsize1iconboxkaveh',
          [
            'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-contact i' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'iconbgwidthiconboxkaveh',
          [
            'label' => esc_html__( 'عرض پس زمینه آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-contact i' => 'width: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'iconbgheighticonboxkaveh',
          [
            'label' => esc_html__( 'ارتفاع پس زمینه آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-contact i' => 'height: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'iconcolor1iconboxkaveh',
          [
            'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .footer-contact i' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_control(
          'iconbg1iconboxkaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .footer-contact i' => 'background-color: {{VALUE}}',
            ],
          ]
        );
        $this->add_control(
          'titlecolor1iconboxkaveh',
          [
            'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .footer-contact .detail .title' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'titletypeiconboxkaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .footer-contact .detail .title',
          ]
        );
        $this->add_control(
          'titlecolor2iconboxkaveh',
          [
            'label' => esc_html__( 'رنگ عنوان بولد', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .footer-contact .detail .sub-title' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'titletype2iconboxkaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان بولد', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .footer-contact .detail .sub-title',
          ]
        );
        $this->add_control(
          'titlecolor3iconboxkaveh',
          [
            'label' => esc_html__( 'رنگ پس از عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .footer-contact .detail .sub-title span' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'titletype3iconboxkaveh',
            'label' => esc_html__( 'تایپوگرافی پس از عنوان', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .footer-contact .detail .sub-title span',
          ]
        );
        $this->end_controls_section();
          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
  
?>
            <div class="footer-contact d-flex align-items-center">
              <i class="<?php echo  esc_attr($settings['iconiconboxkaveh']['value']); ?>"></i>
              <div class="detail">
                <div class="title"><?php echo  esc_html($settings['beforetitleiconboxkaveh']); ?></div>
                <div class="sub-title">
                  <span><?php echo  esc_html($settings['aftertitleiconboxkaveh']); ?></span><?php echo  esc_html($settings['titleiconboxkaveh']); ?>
                </div>
              </div>
            </div>
    <?php
  }


}
