<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Headingwtbuttonkaveh extends Widget_Base{

  public function get_name(){
    return 'headingwtbuttonkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان هدینگ با دکمه', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentheadingwtbuttonkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
        $this->add_control(
          'beforetitleheadingwtbuttonkaveh',
          [
              'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'tagheading1headingwtbuttonkaveh',
        [
          'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H6',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'titlebheadingwtbuttonkaveh',
        [
            'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'عنوان اصلی' , 'kaveh-core' ),
    
        ]
    );
      $this->add_control(
        'titleheadingwtbuttonkaveh',
        [
            'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'عنوان اصلی' , 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheading2headingwtbuttonkaveh',
      [
        'label' => esc_html__( 'تگ عنوان اصلی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );

    $this->add_control(
      'buttons2headingwtbuttonkaveh',
      [
          'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'محصولات', 'kaveh-core' ),

      ]
    );
    $this->add_control(
    'iconbutts2headingwtbuttonkaveh',
    [
      'label' => esc_html__( 'آیکون', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::ICONS,
      'skin' => 'inline',
      'exclude_inline_options' => [ 'svg' ],
      'default' => [
        'value' => 'icon-arrow-left-2',
      ],
    ]
    );
    $this->add_control(
    'linkbuttons2headingwtbuttonkaveh',
    [
        'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
    );

        $this->end_controls_section();
        $this->start_controls_section(
          'styleheadingwtbuttonkaveh',
          [
            'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'title1_headingwtbuttonkaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .section-heading-nine .title-en',
          ]
        );
        $this->add_control(
          't1colorheadingwtbuttonkaveh',
          [
            'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .section-heading-nine .title-en' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_control(
          't2colorbheadingwtbuttonkaveh',
          [
            'label' => esc_html__( 'رنگ عنوان بولد', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .section-heading-nine .title b' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'title2headingwtbuttonkaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .section-heading-nine .title',
          ]
        );
        $this->add_control(
          't2colorheadingwtbuttonkaveh',
          [
            'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .section-heading-nine .title' => 'color: {{VALUE}}',
            ],
          ]
        );


        $this->end_controls_section();
        $this->start_controls_section(
          'styleb_headingwtbuttonkaveh',
          [
            'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'button_nchbheadingwtbuttonkaveh',
            'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .section-heading-nine a',
          ]
        );
        $this->add_control(
          'iconsizenchbheadingwtbuttonkaveh',
          [
            'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .section-heading-nine a i' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Text_Shadow::get_type(),
          [
            'name' => 'text_shadownchbheadingwtbuttonkaveh',
            'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .section-heading-nine a',
          ]
        );
        $this->start_controls_tabs(
          'style_tabsnchbheadingwtbuttonkaveh'
        );
        
        $this->start_controls_tab(
          'style_normal_tabnchbheadingwtbuttonkaveh',
          [
            'label' => esc_html__( 'عادی', 'kaveh-core' ),
          ]
        );
        $this->add_control(
          'textbuttoncolornchbheadingwtbuttonkaveh',
          [
            'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .section-heading-nine a' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'iconcolornchbheadingwtbuttonkaveh',
          [
            'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .section-heading-nine a i' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'buttoncolornchbheadingwtbuttonkaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .section-heading-nine a::before' => 'background-color: {{VALUE}}',
  
            ],
          ]
        ); 
        
        $this->end_controls_tab();
        $this->start_controls_tab(
          'style_hove_tabnchbheadingwtbuttonkaveh',
          [
            'label' => esc_html__( 'هاور', 'kaveh-core' ),
          ]
        );
        $this->add_control(
          'textbuttoncolorhovernchbheadingwtbuttonkaveh',
          [
            'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .section-heading-nine a:hover' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'iconcolorhovernchbheadingwtbuttonkaveh',
          [
            'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .section-heading-nine a:hover i' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'buttoncolorhovernchbheadingwtbuttonkaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .section-heading-nine a:hover::before' => 'background-color: {{VALUE}}',
            ],
          ]
        ); 
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
          'hr1nchbheadingwtbuttonkaveh',
          [
            'type' => \Elementor\Controls_Manager::DIVIDER,
          ]
        );
        $this->add_control(
          'buttonpaddingnchbheadingwtbuttonkaveh',
          [
            'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .section-heading-nine a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
  
        $this->end_controls_section();

        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
  
?>

        <div class="section-heading-nine mx-auto w-100 text-center">
          <<?php echo  esc_attr($settings['tagheading1headingwtbuttonkaveh']); ?> class="title-en"> <?php echo  esc_html($settings['beforetitleheadingwtbuttonkaveh']); ?> </<?php echo  esc_attr($settings['tagheading1headingwtbuttonkaveh']); ?>>
          <<?php echo  esc_attr($settings['tagheading2headingwtbuttonkaveh']); ?> class="title">
            <b> <?php echo  esc_html($settings['titlebheadingwtbuttonkaveh']); ?></b>
            <?php echo  esc_html($settings['titleheadingwtbuttonkaveh']); ?>
          </<?php echo  esc_attr($settings['tagheading2headingwtbuttonkaveh']); ?>>
          <a href="<?php echo  esc_url($settings['linkbuttons2headingwtbuttonkaveh']); ?>" class="position-relative d-flex align-items-center">
            <?php echo  esc_html($settings['buttons2headingwtbuttonkaveh']); ?>
            <i class="<?php echo  esc_html($settings['iconbutts2headingwtbuttonkaveh']['value']); ?> ms-2"></i>
          </a>
        </div>

<style>
  <?php echo '.elementor-element-' . $clsid . ''; ?> .footer-name-shop::after {
    margin-top: 22px;
    }
</style> 
    <?php
  }


}
