<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Featureshopgridkaveh extends Widget_Base{

  public function get_name(){
    return 'featureshopgridkaveh';
  }

  public function get_title(){
    return esc_html__( 'ویژگی های فروشگاه', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentfeatureshopgridkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
  $repeater = new \Elementor\Repeater();
  $repeater->add_control(
    'linksfeatureshopgridkaveh',
    [
        'label' => esc_html__( 'لینک باکس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',

    ]
); 
  $repeater->add_control(
    'fsfeatureshopgridkaveh',
    [
      'label' => esc_html__( 'آیکون یا تصویر؟', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'image',
      'options' => [
        'icon'  => esc_html__( 'آیکون', 'kaveh-core' ),
        'image'  => esc_html__( 'تصویر', 'kaveh-core' ),

      ],
    ]
    );
    $repeater->add_control(
      'ffeatureshopgridkaveh',
      [
        'label' => esc_html__( 'آیکون ویژگی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'condition' => [
          'fsfeatureshopgridkaveh' => 'icon',
        ],
        'default' => [
          'value' => 'isax isax-box',
        ],
      ]
    ); 
    $repeater->add_control(
      'imgfeatureshopgridkaveh',
      [
        'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'condition' => [
          'fsfeatureshopgridkaveh' => 'image',
        ],
      ]
    );
    $repeater->add_control(
      'ftitlefeatureshopgridkaveh',
      [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'تحویل اکسپرس', 'kaveh-core' ),
  
      ]
  ); 
  $repeater->add_control(
    'tagheadingfeatureshopgridkaveh',
    [
      'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'H3',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
        'span' => esc_html__( 'span', 'kaveh-core' ),
      ],
    ]
  );
  $this->add_control(
    'listfeatureshopgridkaveh',
    [
      'label' => esc_html__( 'ویژگی ها', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::REPEATER,
      'fields' => $repeater->get_controls(),
      'default' => [
        [
          'ffeatureshopgridkaveh' => esc_html__( 'isax isax-box', 'kaveh-core' ),
          'tagheadingfeatureshopgridkaveh' => esc_html__( 'H3', 'kaveh-core' ),
          'ftitlefeatureshopgridkaveh' => esc_html__( 'تحویل اکسپرس', 'kaveh-core' ),
        ],
    ]
    ]
  
  );

       $this->end_controls_section();
       $this->start_controls_section(
        'style2_featureshopgridkaveh',
        [
          'label' => esc_html__( 'استایل آیکون', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'iconsizefeatureshopgridkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' =>50,
          ],
          'selectors' => [
            '{{WRAPPER}} .options-site ul li i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconcolorfeatureshopgridkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .options-site ul li i' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'bgcolorfeatureshopgridkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .options-site ul li i::after' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbgsizefeatureshopgridkaveh',
        [
          'label' => esc_html__( 'سایز پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_featureshopgridkaveh',
        [
          'label' => esc_html__( 'استایل تصویر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'imgsizefeatureshopgridkaveh',
        [
          'label' => esc_html__( 'سایز تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' =>50,
          ],
          'selectors' => [
            '{{WRAPPER}} .options-site ul li img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'imgbgsizefeatureshopgridkaveh',
        [
          'label' => esc_html__( 'سایز پس زمینه تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
        ]
      );
      $this->add_control(
        'bgcolor1featureshopgridkaveh',
        [
          'label' => esc_html__( 'رنگ اول پس زمینه تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
        ]
      );
      $this->add_control(
        'bgcolor2featureshopgridkaveh',
        [
          'label' => esc_html__( 'رنگ دوم پس زمینه تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style4_featureshopgridkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_featureshopgridkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .featt1',
        ]
      );
      $this->add_control(
        'tccolorfeatureshopgridkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .featt1' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'tcmtfeatureshopgridkaveh',
        [
          'label' => esc_html__( 'فاصله از بالا  عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => -300,
              'max' => 300,
              'step' => 1,
            ],
            '%' => [
              'min' => -50,
              'max' => 50,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' =>15,
          ],
          'selectors' => [
            '{{WRAPPER}} .featt1' => 'margin-top: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      
      
          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
<div class="options-site options-site-two">
      <div class="container">
        <ul class="d-flex align-items-center flex-wrap options-site-forteen-items">
        <?php
              if ( $settings['listfeatureshopgridkaveh'] ) {
              foreach (  $settings['listfeatureshopgridkaveh'] as $item ) {
              ?>
          <li>
            <a href="<?php echo $item['linksfeatureshopgridkaveh']; ?>">
            <?php if('icon'===$item['fsfeatureshopgridkaveh']){ ?>
            <i class="<?php echo  esc_attr($item['ffeatureshopgridkaveh']['value']); ?> d-block position-relative"></i>
            <<?php echo  esc_attr($item['tagheadingfeatureshopgridkaveh']); ?> class="featt1"> <?php echo  esc_html($item['ftitlefeatureshopgridkaveh']); ?> </<?php echo  esc_attr($item['tagheadingfeatureshopgridkaveh']); ?>>
            <?php }elseif('image'===$item['fsfeatureshopgridkaveh']){?>
            <img src="<?php echo esc_url($item['imgfeatureshopgridkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['imgfeatureshopgridkaveh'] )); ?>" class="d-block mx-auto" />
            <<?php echo  esc_attr($item['tagheadingfeatureshopgridkaveh']); ?> class="mb-0 position-relative featt1 fim"><?php echo  esc_html($item['ftitlefeatureshopgridkaveh']); ?></<?php echo  esc_attr($item['tagheadingfeatureshopgridkaveh']); ?>>
            <?php } ?>
            </a>
          </li>
          <?php 
            }
              }
            ?>
        </ul>
      </div>
    </div>
    <style>
      <?php echo '.elementor-element-' . $clsid . ''; ?> .options-site-forteen-items li .fim::before {
    background-image: -webkit-linear-gradient(top, <?php echo  esc_attr($settings['bgcolor1featureshopgridkaveh']); ?>, <?php echo  esc_attr($settings['bgcolor2featureshopgridkaveh']); ?>);
    background-image: -moz-linear-gradient(top, <?php echo  esc_attr($settings['bgcolor1featureshopgridkaveh']); ?>, <?php echo  esc_attr($settings['bgcolor2featureshopgridkaveh']); ?>);
    background-image: -o-linear-gradient(top, <?php echo  esc_attr($settings['bgcolor1featureshopgridkaveh']); ?>, <?php echo  esc_attr($settings['bgcolor2featureshopgridkaveh']); ?>);
    background-image: linear-gradient(to bottom, <?php echo  esc_attr($settings['bgcolor1featureshopgridkaveh']); ?>, <?php echo  esc_attr($settings['bgcolor2featureshopgridkaveh']); ?>);
    width: <?php echo  esc_html($settings['imgbgsizefeatureshopgridkaveh']['size']); echo  esc_html($settings['imgbgsizefeatureshopgridkaveh']['unit']);?> !important;
    height: <?php echo  esc_html($settings['imgbgsizefeatureshopgridkaveh']['size']);echo  esc_html($settings['imgbgsizefeatureshopgridkaveh']['unit']);?> !important;
    z-index: -1;
}
<?php echo '.elementor-element-' . $clsid . ''; ?> .options-site ul li i::after {
    width: <?php echo  esc_html($settings['iconbgsizefeatureshopgridkaveh']['size']); echo  esc_html($settings['iconbgsizefeatureshopgridkaveh']['unit']);?> !important;
    height: <?php echo  esc_html($settings['iconbgsizefeatureshopgridkaveh']['size']);echo  esc_html($settings['iconbgsizefeatureshopgridkaveh']['unit']);?> !important;
}
    </style>
    <?php
  }


}
